/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.client.DEditClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.DListClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.DataBaseIClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IControlModeEditUIProxy;
import com.kingdee.eas.basedata.framework.client.IControlModeListUIProxy;
import com.kingdee.eas.basedata.framework.client.IControlModeUIProxy;
import com.kingdee.eas.basedata.framework.client.S1ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.S2ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.S3ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.S4ClientControlStrategy;
import com.kingdee.eas.common.client.SysContext;

public abstract class ClientControlStrategy
implements IClientControlStrategy {
    public static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    public static final String ACTION_DELETE = "ACTION_DELETE";
    public static final String ACTION_MODIFY = "ACTION_MODIFY";
    protected static final String CONTROLTYPE_S1 = "S1";
    protected static final String CONTROLTYPE_S2 = "S2";
    protected static final String CONTROLTYPE_S3 = "S3";
    protected static final String CONTROLTYPE_S4 = "S4";
    protected static final String CONTROLTYPE_I = "I";
    protected static final String CONTROLTYPE_D = "D";
    protected static final String FILTERFIELD_CUID = "CU.id";
    protected static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
    private String currentCUID = null;
    protected IControlModeUIProxy _ui = null;

    public ClientControlStrategy() {
    }

    public ClientControlStrategy(IControlModeUIProxy ui) {
        this._ui = ui;
    }

    public static IClientControlStrategy create(BOSObjectType bizType, CoreUIObject ui) throws BOSException {
        String type = ControlTypeUtil.getControlType(bizType);
        ClientControlStrategy stategy = ClientControlStrategy.create(type, ui);
        return stategy;
    }

    public static ClientControlStrategy create(String controlType, CoreUIObject ui) {
        ClientControlStrategy ccStrategy = null;
        if (controlType.equals(CONTROLTYPE_I)) {
            ccStrategy = new DataBaseIClientControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S1)) {
            ccStrategy = new S1ClientControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S2)) {
            ccStrategy = new S2ClientControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S3)) {
            ccStrategy = new S3ClientControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S4)) {
            ccStrategy = new S4ClientControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_D)) {
            if (ui instanceof IControlModeListUIProxy) {
                ccStrategy = new DListClientControlStrategy((IControlModeListUIProxy)ui);
            } else if (ui instanceof IControlModeEditUIProxy) {
                ccStrategy = new DEditClientControlStrategy((IControlModeEditUIProxy)ui);
            }
        }
        return ccStrategy;
    }

    public void addUIComponent() {
    }

    public void initUIComponent() {
    }

    public void checkCanAdd() throws Exception {
    }

    public void checkCanUpdate(String sltedKeyValue) throws Exception {
    }

    public void checkCanDelete(String sltedKeyValue) throws Exception {
    }

    public abstract String getControlType();

    public void checkPermission(String action, String bizObjCUID) throws Exception {
        if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase(CONTROLTYPE_S3) || this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCUID().equals(bizObjCUID)) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    protected String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return this.currentCUID;
    }

    public void setCurrentCUID(String currentCUID) {
        this.currentCUID = currentCUID;
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    @Override
    public abstract FilterInfo getDefaultFilterForControlType();

    @Override
    public FilterInfo getCommonPromptBoxDefaultFilterForControlType(String uiOprState) {
        return this.getDefaultFilterForControlType();
    }

    @Override
    public FilterInfo getGeneralBoxDefaultFilterForControlType(String uiOprState) {
        return this.getDefaultFilterForControlType();
    }
}

