/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.OrgDataBaseDService;
import com.kingdee.eas.basedata.framework.client.AbstractControlModeEditUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.client.IControlModeEditUIProxy;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class ControlModeEditUI
extends AbstractControlModeEditUI
implements IControlModeEditUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(ControlModeEditUI.class);
    private ClientControlStrategy ccStrategy = null;
    private String controlType = null;

    public ControlModeEditUI() throws Exception {
        this.initStrategy();
        this.disableMovingButtonsWhenTypeS();
    }

    private void initStrategy() {
        this.initControlType();
        this.ccStrategy = ClientControlStrategy.create(this.controlType, (CoreUIObject)this);
    }

    private void initControlType() {
        try {
            if (this.controlType == null) {
                this.controlType = ControlTypeUtil.getControlType(this.getBizType());
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void disableMovingButtonsWhenTypeS() {
        if (this.controlType.equals("S1") || this.controlType.equals("S2") || this.controlType.equals("S3") || this.controlType.equals("S4")) {
            this.btnFirst.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnPre.setVisible(false);
        }
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public BOSObjectType getBizObjectType1() {
        return this.editData.getBOSType();
    }

    @Override
    public IObjectPK getBizCUPK1() {
        return this.getBizCUPK();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanUpdate(this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanDelete(this.editData.getId().toString());
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.controlType.equals("D")) {
            if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
                this.ccStrategy.checkCanAdd();
            } else if (OprtState.EDIT.equals(this.getOprtState())) {
                this.ccStrategy.checkCanUpdate(this.editData.getId().toString());
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected IObjectValue getOrgDataBaseDInfo(BOSObjectType objectType, IObjectPK bizOrgPK) throws EASBizException, BOSException {
        OrgDataBaseDService service = new OrgDataBaseDService(objectType);
        return service.getOrgDataBaseDInfo(this.getOrgDataBaseDSelectors(objectType), bizOrgPK);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        return sic;
    }

    protected SelectorItemCollection getOrgDataBaseDSelectors(BOSObjectType objectType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected IObjectPK submitOrgDataBaseDInfo(IObjectValue value) throws EASBizException, BOSException {
        OrgDataBaseDService service = new OrgDataBaseDService(value.getBOSType());
        return service.submitOrgDataBaseDInfo(value);
    }
}

