/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseControlMode;
import com.kingdee.eas.basedata.framework.client.AbstractControlModeListUI;
import com.kingdee.eas.basedata.framework.client.AssignDestinationUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.client.DataBaseDReferenceUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI2;
import com.kingdee.eas.basedata.framework.client.DatabaseDUtil;
import com.kingdee.eas.basedata.framework.client.IControlModeListUIProxy;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ControlModeListUI
extends AbstractControlModeListUI
implements IControlModeListUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(ControlModeListUI.class);
    private boolean isReferDataBaseDChkBoxVisble = false;
    private ClientControlStrategy ccStrategy = null;
    private MetaDataPK pkQuery = null;
    private QueryInfo qiQuery = null;
    private String sqlQuery = null;

    public ControlModeListUI() throws Exception {
        this.initStrategy();
        if (this.ccStrategy != null) {
            this.ccStrategy.initUIComponent();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.ccStrategy.addUIComponent();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initStrategy() {
        String controlType = this.getControlType();
        this.ccStrategy = ClientControlStrategy.create(controlType, (CoreUIObject)this);
    }

    protected String getControlType() {
        try {
            return ControlTypeUtil.getControlType(this.getBizType());
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.ccStrategy.checkCanDelete(this.getSelectedKeyValue());
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.ccStrategy.checkCanUpdate(this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected BOSObjectType getBizObjectType() {
        BOSObjectType type = null;
        try {
            ICoreBase bizInterface = this.getBizInterface();
            if (bizInterface != null) {
                type = bizInterface.getType();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error has occured in getBizInterface()!");
        }
        return type;
    }

    protected String getAdminCUFieldName() {
        return "CU.id";
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public BOSObjectType getBizObjectType1() {
        return this.getBizObjectType();
    }

    @Override
    public IObjectPK getBizCUPK1() {
        return this.getBizCUPK();
    }

    @Override
    public String getKeyFieldName1() {
        return this.getKeyFieldName();
    }

    @Override
    public String getAdminCUFieldName1() {
        return this.getAdminCUFieldName();
    }

    @Override
    public int getUpgradeMode() {
        return 0;
    }

    @Override
    public KDWorkButton getBtnAssignDataBaseD() {
        return this.btnAssignDataBaseD;
    }

    @Override
    public KDWorkButton getBtnReferDataBaseD() {
        return this.btnReferDataBaseD;
    }

    @Override
    public KDWorkButton getBtnUpgrade() {
        return this.btnUpgrade;
    }

    @Override
    public KDWorkButton getBtnViewAssigned() {
        return this.btnViewAssignDestination;
    }

    @Override
    public KDMenuItem getMenuAssignDataBaseD() {
        return this.menuAssignDataBaseD;
    }

    @Override
    public KDMenuItem getMenuReferDataBaseD() {
        return this.menuReferDataBaseD;
    }

    @Override
    public KDMenuItem getMenuBatchAssign() {
        return this.menuBatchAssign;
    }

    @Override
    public KDMenuItem getMenuUpgrade() {
        return this.menuUpgrade;
    }

    @Override
    public KDMenuItem getMenuViewAssigned() {
        return this.menuViewAssign;
    }

    @Override
    public void actionAssignDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK[] assignCUPKs;
        super.actionAssignDataBaseD_actionPerformed(e);
        this.checkSelected();
        ObjectUuidPK dataBaseDPK = new ObjectUuidPK(this.getSelectedKeyValue());
        CtrlF7 ctrlF7 = new CtrlF7((IUIObject)this);
        ctrlF7.disablePerm();
        ctrlF7.setRootUnitID(this.getBizCUPK().toString());
        ctrlF7.show();
        if (!ctrlF7.isCanceled() && (assignCUPKs = DatabaseDUtil.getAssignCUs(ctrlF7.getData())) != null) {
            ((IDataBaseControlMode)this.getBizInterface()).assign(this.getBizCUPK(), (IObjectPK)dataBaseDPK, (IObjectPK)assignCUPKs[0]);
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("assignSuccess"));
        }
    }

    private String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.framework.DataBaseDResources", (String)key);
    }

    @Override
    public void actionReferDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        this.showUI(DataBaseDReferenceUI.class.getName());
    }

    protected void setReferDataBaseDChkBoxVisble(boolean isVisable) {
        this.isReferDataBaseDChkBoxVisble = isVisable;
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        ICoreBase bizInterface;
        if (this.pkQuery == null && (bizInterface = this.getBizInterface()) != null) {
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bizInterface.getType());
            assert (eoi.containsExtendedPropertyKey("defaultF7Query"));
            String queryName = eoi.getExtendedProperty("defaultF7Query");
            this.pkQuery = new MetaDataPK(queryName);
        }
        return this.pkQuery;
    }

    private QueryInfo getQueryInfoFromQueryPK() throws Exception {
        if (this.qiQuery == null) {
            this.qiQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)this.getQueryPKFromEntity());
        }
        return this.qiQuery;
    }

    private String getQuerySqlFromQueryPK() throws Exception {
        if (this.sqlQuery == null) {
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPKFromEntity());
            this.sqlQuery = qe.getSQL();
        }
        return this.sqlQuery;
    }

    private void showUI(String uiname) throws Exception {
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"QueryPK", (Object)this.getQueryPKFromEntity());
        uictx.put((Object)"QueryInfo", (Object)this.getQueryInfoFromQueryPK());
        uictx.put((Object)"QuerySql", (Object)this.getQuerySqlFromQueryPK());
        uictx.put((Object)"BizInterface", (Object)this.getBizInterface());
        uictx.put((Object)"isReferDataBaseDChkBoxVisble", (Object)new Boolean(this.isReferDataBaseDChkBoxVisble));
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.ccStrategy.getDefaultFilterForControlType();
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        this.setReferDataBaseDChkBoxVisble(false);
        if (this.getUpgradeMode() == 1) {
            this.showUI(DataBaseDUpgradeUI.class.getName());
        } else {
            this.showUI(DataBaseDUpgradeUI2.class.getName());
        }
    }

    @Override
    public void actionViewAssignDestination_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK objectPK = new ObjectUuidPK(this.getSelectedKeyValue());
        ICoreBase bizInterface = this.getBizInterface();
        DataBaseDInfo dataBaseDInfo = new DataBaseDInfo();
        if (bizInterface != null) {
            dataBaseDInfo = (DataBaseDInfo)bizInterface.getValue((IObjectPK)objectPK);
        }
        if (dataBaseDInfo != null && dataBaseDInfo.getCU() != null && dataBaseDInfo.getCU().getId() != null && !dataBaseDInfo.getCU().getId().toString().equals(this.getBizCUPK().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("cannotviewassigned"));
            return;
        }
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"bosType", (Object)dataBaseDInfo.getBOSType().toString());
        uictx.put((Object)"adminCUID", (Object)dataBaseDInfo.getCU().getId().toString());
        uictx.put((Object)"databaseDID", (Object)dataBaseDInfo.getId().toString());
        this.showViewAssignDestUI(AssignDestinationUI.class.getName(), uictx);
    }

    private void showViewAssignDestUI(String uiname, UIContext uictx) throws Exception {
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }
}

