/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.AbstractControlModeTreeListUI;
import com.kingdee.eas.basedata.framework.client.AssignDestinationUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.client.DataBaseDAssignmentUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDReferenceUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI2;
import com.kingdee.eas.basedata.framework.client.DatabaseDUtil;
import com.kingdee.eas.basedata.framework.client.IControlModeListUIProxy;
import com.kingdee.eas.basedata.framework.client.MyCtrlF7;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ControlModeTreeListUI
extends AbstractControlModeTreeListUI
implements IControlModeListUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(ControlModeTreeListUI.class);
    private ClientControlStrategy cStrategy = null;
    private BOSObjectType currentBOSObjectType = null;
    protected CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private boolean isSubordinateAssign = false;
    private boolean isReferDataBaseDChkBoxVisble = false;
    private String controlTypeOfTreeEntity;
    private MetaDataPK pkQuery = null;
    private QueryInfo qiQuery = null;
    private String sqlQuery = null;

    public ControlModeTreeListUI() throws Exception {
        this.initStrategy();
        if (this.cStrategy != null) {
            this.cStrategy.initUIComponent();
        }
    }

    private void initStrategy() {
        String controlType = this.getControlType();
        this.cStrategy = ClientControlStrategy.create(controlType, (CoreUIObject)this);
    }

    private String getIDFromCurrentCU() {
        return this.currentCtrlUnit.getId().toString();
    }

    public void onLoad() throws Exception {
        CUBDControlInfo ctrlInfo;
        if (this.currentCtrlUnit == null) {
            this.currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        String bosType = null;
        if (this.getBizObjectType() != null) {
            bosType = this.getBizObjectType().toString();
        }
        if (this.cStrategy.getDefaultFilterForControlType() != null && bosType != null && (ctrlInfo = CUBDControlFactory.getRemoteInstance().getBDCtrlInfo(bosType, this.getIDFromCurrentCU())) != null) {
            this.isSubordinateAssign = ctrlInfo.isIsSubordinateAssign();
        }
        super.onLoad();
        this.cStrategy.addUIComponent();
    }

    protected String getControlType() {
        try {
            return ControlTypeUtil.getControlType(this.getBizType());
        }
        catch (Exception e) {
            return "";
        }
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getControlTypeOfTreeEntity() throws Exception {
        ITreeBase treeInterface;
        if (this.controlTypeOfTreeEntity == null && (treeInterface = this.getTreeInterface()) != null) {
            BOSObjectType bostype = treeInterface.getType();
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bostype);
            this.controlTypeOfTreeEntity = "";
            if (eoi.containsExtendedPropertyKey("controlType")) {
                this.controlTypeOfTreeEntity = eoi.getExtendedProperty("controlType");
            }
        }
        return this.controlTypeOfTreeEntity;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.cStrategy.checkCanDelete(this.getSelectedKeyValue());
        super.actionRemove_actionPerformed(e);
    }

    private void checkCanAssign(DataBaseDInfo dataBaseDInfo) throws Exception {
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getBizCUPK().toString()) && !this.isSubordinateAssign) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("cannotviewassigned"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAssignDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK[] assignCUPKs;
        super.actionAssignDataBaseD_actionPerformed(e);
        this.checkSelected();
        ObjectUuidPK dataBaseDPK = new ObjectUuidPK(this.getSelectedKeyValue());
        ICoreBase bizInterface = this.getBizInterface();
        if (bizInterface != null) {
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)bizInterface.getValue((IObjectPK)dataBaseDPK);
            this.checkCanAssign(dataBaseDInfo);
        }
        MyCtrlF7 ctrlF7 = new MyCtrlF7((IUIObject)this);
        ctrlF7.setNeedAddOrgRange(false);
        ctrlF7.setRootUnitID(this.getBizCUPK().toString());
        ctrlF7.show();
        if (!ctrlF7.isCanceled() && (assignCUPKs = DatabaseDUtil.getAssignCUs(ctrlF7.getData())) != null && bizInterface != null) {
            ((IDataBaseD)bizInterface).assign(this.getBizCUPK(), (IObjectPK)dataBaseDPK, (IObjectPK)assignCUPKs[0]);
        }
    }

    @Override
    public void actionBathAssign_actionPerformed(ActionEvent e) throws Exception {
        this.showUI(DataBaseDAssignmentUI.class.getName());
    }

    @Override
    public void actionReferDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        this.showUI(DataBaseDReferenceUI.class.getName());
    }

    protected void setReferDataBaseDChkBoxVisble(boolean isVisable) {
        this.isReferDataBaseDChkBoxVisble = isVisable;
    }

    private void showUI(String uiname) throws Exception {
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"QueryPK", (Object)this.getQueryPKFromEntity());
        uictx.put((Object)"QueryInfo", (Object)this.getQueryInfoFromQueryPK());
        uictx.put((Object)"QuerySql", (Object)this.getQuerySqlFromQueryPK());
        uictx.put((Object)"BizInterface", (Object)this.getBizInterface());
        uictx.put((Object)"CurrentCtrlUnit", (Object)this.currentCtrlUnit);
        uictx.put((Object)"isSubordinateAssign", (Object)new Boolean(this.isSubordinateAssign));
        uictx.put((Object)"isReferDataBaseDChkBoxVisble", (Object)new Boolean(this.isReferDataBaseDChkBoxVisble));
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        ICoreBase bizInterface;
        if (this.pkQuery == null && (bizInterface = this.getBizInterface()) != null) {
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bizInterface.getType());
            assert (eoi.containsExtendedPropertyKey("defaultF7Query"));
            String queryName = eoi.getExtendedProperty("defaultF7Query");
            this.pkQuery = new MetaDataPK(queryName);
        }
        return this.pkQuery;
    }

    private QueryInfo getQueryInfoFromQueryPK() throws Exception {
        if (this.qiQuery == null) {
            this.qiQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)this.getQueryPKFromEntity());
        }
        return this.qiQuery;
    }

    private String getQuerySqlFromQueryPK() throws Exception {
        if (this.sqlQuery == null) {
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPKFromEntity());
            this.sqlQuery = qe.getSQL();
        }
        return this.sqlQuery;
    }

    protected String getSelectedTreeNodeObjectID() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String objID = "";
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            objID = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
        }
        return objID;
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = EntityControlTypeUtil.hasPermissionToMaintainTree(this.getControlTypeOfTreeEntity(), this.getBizCUPK().toString(), this.getSelectedTreeNodeObjectID(), "ACTION_ADDNEW_TREE");
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADDTREE);
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = EntityControlTypeUtil.hasPermissionToMaintainTree(this.getControlTypeOfTreeEntity(), this.getBizCUPK().toString(), this.getSelectedTreeNodeObjectID(), "ACTION_MODIFY_TREE");
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MODIFYTREE);
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = EntityControlTypeUtil.hasPermissionToMaintainTree(this.getControlTypeOfTreeEntity(), this.getBizCUPK().toString(), this.getSelectedTreeNodeObjectID(), "ACTION_ADDNEW_TREE");
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADDTREE);
        }
        super.actionImportData_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = EntityControlTypeUtil.hasPermissionToMaintainTree(this.getControlTypeOfTreeEntity(), this.getBizCUPK().toString(), this.getSelectedTreeNodeObjectID(), "ACTION_MOVE_TREE");
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MOVETREE);
        }
        super.actionGroupMoveTree_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = EntityControlTypeUtil.hasPermissionToMaintainTree(this.getControlTypeOfTreeEntity(), this.getBizCUPK().toString(), this.getSelectedTreeNodeObjectID(), "ACTION_DELETE_TREE");
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_REMOVETREE);
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.cStrategy.checkCanUpdate(this.getSelectedKeyValue());
        super.actionMoveTree_actionPerformed(e);
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        this.setReferDataBaseDChkBoxVisble(false);
        if (this.getUpgradeMode() == 1) {
            this.showUI(DataBaseDUpgradeUI.class.getName());
        } else {
            this.showUI(DataBaseDUpgradeUI2.class.getName());
        }
    }

    protected boolean isApplyDetfaultTreeFilter() {
        boolean canItBeDisplayed = false;
        try {
            canItBeDisplayed = this.getControlTypeOfTreeEntity().equalsIgnoreCase("S4") && this.canUpgradedDataBeDisplayedInUpperGroup();
        }
        catch (Exception ex) {
            logger.debug((Object)"getControlTypeOfTreeEntity() raise some exception", (Throwable)ex);
        }
        return !canItBeDisplayed;
    }

    protected boolean canUpgradedDataBeDisplayedInUpperGroup() {
        return false;
    }

    @Override
    public void actionViewAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK objectPK = new ObjectUuidPK(this.getSelectedKeyValue());
        ICoreBase bizInterface = this.getBizInterface();
        if (bizInterface != null) {
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)bizInterface.getValue((IObjectPK)objectPK);
            this.checkCanAssign(dataBaseDInfo);
            UIContext uictx = new UIContext((Object)this);
            uictx.put((Object)"bosType", (Object)dataBaseDInfo.getBOSType().toString());
            uictx.put((Object)"adminCUID", (Object)dataBaseDInfo.getCU().getId().toString());
            uictx.put((Object)"databaseDID", (Object)dataBaseDInfo.getId().toString());
            this.showViewAssignDestUI(AssignDestinationUI.class.getName(), uictx);
        }
    }

    private void showViewAssignDestUI(String uiname, UIContext uictx) throws Exception {
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }

    private String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.framework.DataBaseDResources", (String)key);
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fi = null;
        try {
            if (this.getControlTypeOfTreeEntity().equalsIgnoreCase("S4")) {
                CtrlUnitInfo cui = SysContext.getSysContext().getCurrentCtrlUnit();
                String cuID = cui.getId().toString();
                String cuLongNumber = cui.getLongNumber();
                fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4(cuID, cuLongNumber);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception:getControlTypeOfTreeEntity()");
        }
        return fi;
    }

    protected BOSObjectType getBizObjectType() {
        if (this.currentBOSObjectType == null) {
            try {
                this.currentBOSObjectType = this.getBizType();
            }
            catch (Exception e) {
                logger.error((Object)"Error has occured in getBizInterface()!");
            }
        }
        return this.currentBOSObjectType;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    @Override
    public String getKeyFieldName1() {
        return null;
    }

    @Override
    public KDWorkButton getBtnAssignDataBaseD() {
        return this.btnAssignDataBaseD;
    }

    @Override
    public KDWorkButton getBtnReferDataBaseD() {
        return this.btnReferDataBaseD;
    }

    @Override
    public KDWorkButton getBtnUpgrade() {
        return this.btnUpgrade;
    }

    @Override
    public KDWorkButton getBtnViewAssigned() {
        return this.btnViewAssigned;
    }

    @Override
    public KDMenuItem getMenuAssignDataBaseD() {
        return this.menuAssignDataBaseD;
    }

    @Override
    public KDMenuItem getMenuReferDataBaseD() {
        return this.menuReferDataBaseD;
    }

    @Override
    public KDMenuItem getMenuBatchAssign() {
        return this.menuBatchAssign;
    }

    @Override
    public KDMenuItem getMenuUpgrade() {
        return this.menuUpgrade;
    }

    @Override
    public KDMenuItem getMenuViewAssigned() {
        return this.menuViewAssigned;
    }

    @Override
    public int getUpgradeMode() {
        return 0;
    }

    protected String getAdminCUFieldName() {
        return "CU.id";
    }

    @Override
    public String getAdminCUFieldName1() {
        return this.getAdminCUFieldName();
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public BOSObjectType getBizObjectType1() {
        return this.getBizObjectType();
    }

    @Override
    public IObjectPK getBizCUPK1() {
        return this.getBizCUPK();
    }
}

