/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IControlModeUIProxy;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class DClientControlStrategy
extends ClientControlStrategy {
    private static final Logger logger = CoreUIObject.getLogger(DClientControlStrategy.class);

    public DClientControlStrategy(IControlModeUIProxy ui) {
        super(ui);
    }

    @Override
    public String getControlType() {
        return "D";
    }

    @Override
    public FilterInfo getDefaultFilterForControlType() {
        return null;
    }

    @Override
    public void checkCanAdd() throws Exception {
        this.checkAddPolicy(this._ui.getBizCUPK1(), this._ui.getBizObjectType1());
    }

    @Override
    public void checkCanUpdate(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this._ui.getBizCUPK1().toString())) {
            this.checkUpdatePolicy(this._ui.getBizCUPK1(), this._ui.getBizObjectType1());
        }
    }

    @Override
    public void checkCanDelete(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this._ui.getBizCUPK1().toString())) {
            this.checkDelPolicy(this._ui.getBizCUPK1(), this._ui.getBizObjectType1());
        }
    }

    private static SimpleEntity getEntity(Context ctx, BOSObjectType type) throws BOSException {
        EntitySelect select = new EntitySelect(type);
        select.selectAttribute("alias").extendPropertySelect().select(new String[]{"OrgType"});
        if (ctx != null) {
            return MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        return MetaDataAccessFactory.getRemoteInstance().select(select);
    }

    public static String getClassAlias(CoreBaseInfo dataBaseInfo) {
        if (dataBaseInfo == null) {
            return "";
        }
        String name = null;
        try {
            SimpleEntity entity = DClientControlStrategy.getEntity(null, dataBaseInfo.getBOSType());
            if (entity == null || entity.getAlias() == null) {
                IMetaDataPK pk = MDContextFactory.getRemoteInstance().entityMapping.getProperty(dataBaseInfo.getBOSType());
                if (pk != null) {
                    name = pk.getFullName();
                }
            } else {
                name = entity.getAlias();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return name;
    }

    protected void checkAddPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this._ui.getBizCUPK1().toString());
        boolean flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        SimpleEntity entity = DClientControlStrategy.getEntity(null, objectType);
        String name = null;
        if (entity == null || entity.getAlias() == null) {
            IMetaDataPK pk = MDContextFactory.getRemoteInstance().entityMapping.getProperty(objectType);
            if (pk != null) {
                name = pk.getFullName();
            }
        } else {
            name = entity.getAlias();
        }
        Object[] currentName = new String[]{name};
        if (!flag && ("37C67DFC".equals(objectType.toString()) || "4409E7F0".equals(objectType.toString()) || "BF0C040E".equals(objectType.toString()))) {
            throw new DataBaseDException(DataBaseDException.CANNOTADDFORSOMESTRATEGY, currentName);
        }
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this._ui.getBizCUPK1().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    protected void checkDelPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this._ui.getBizCUPK1().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }
}

