/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DatabaseDCanInfo;
import com.kingdee.eas.basedata.framework.IDataBaseControlMode;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.DClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.DataBaseDTreeDetailListUI;
import com.kingdee.eas.basedata.framework.client.IControlModeListUIProxy;
import com.kingdee.eas.basedata.framework.client.IControlModeUIProxy;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DListClientControlStrategy
extends DClientControlStrategy {
    private static final Logger logger = CoreUIObject.getLogger(DListClientControlStrategy.class);
    private DatabaseDCanInfo canInfo = null;
    private Map filterCache = new HashMap();

    public DListClientControlStrategy(IControlModeListUIProxy ui) {
        super(ui);
    }

    @Override
    public void addUIComponent() {
        this.setStatus();
        this.addPopupMenu();
    }

    @Override
    public void initUIComponent() {
        this.initIcon((IControlModeListUIProxy)this._ui);
    }

    private void initIcon(IControlModeListUIProxy ui) {
        ui.getBtnAssignDataBaseD().setIcon(EASResource.getIcon((String)"imgTbtn_distributebatch"));
        ui.getMenuAssignDataBaseD().setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        ui.getMenuBatchAssign().setIcon(EASResource.getIcon((String)"imgTbtn_distributebatch"));
        ui.getBtnReferDataBaseD().setIcon(EASResource.getIcon((String)"imgTbtn_adduction"));
        ui.getMenuReferDataBaseD().setIcon(EASResource.getIcon((String)"imgTbtn_adduction"));
        ui.getBtnUpgrade().setIcon(EASResource.getIcon((String)"imgTbtn_upgrade"));
        ui.getMenuUpgrade().setIcon(EASResource.getIcon((String)"imgTbtn_upgrade"));
        ui.getBtnViewAssigned().setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
        ui.getMenuViewAssigned().setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
    }

    private void canBeAssignedOrUpOrAssign() {
        try {
            ICoreBase cb = this._ui.getBizInterface1();
            if (cb instanceof IDataBaseD) {
                this.canInfo = this.useBatchResult() ? (DatabaseDCanInfo)((DataBaseDTreeDetailListUI)this._ui).getBatchCallResult().get("canInfo") : ((IDataBaseD)this._ui.getBizInterface1()).allCan(this.getBizObjectType(this._ui), this._ui.getBizCUPK1());
            } else if (cb instanceof IDataBaseControlMode) {
                this.canInfo = ((IDataBaseControlMode)this._ui.getBizInterface1()).allCan(this.getBizObjectType(this._ui), this._ui.getBizCUPK1());
            }
        }
        catch (Exception e) {
            this._ui.handUIException(e);
            return;
        }
    }

    public void setStatus() {
        this.canBeAssignedOrUpOrAssign();
        boolean canBeAssigned = this.canBeAssigned();
        ((IControlModeListUIProxy)this._ui).getBtnAssignDataBaseD().setVisible(canBeAssigned);
        ((IControlModeListUIProxy)this._ui).getMenuBatchAssign().setVisible(canBeAssigned);
        ((IControlModeListUIProxy)this._ui).getMenuAssignDataBaseD().setVisible(canBeAssigned);
        ((IControlModeListUIProxy)this._ui).getBtnViewAssigned().setVisible(canBeAssigned);
        ((IControlModeListUIProxy)this._ui).getMenuViewAssigned().setVisible(canBeAssigned);
        boolean canBeRefered = this.canBeRefered();
        ((IControlModeListUIProxy)this._ui).getBtnReferDataBaseD().setVisible(canBeRefered);
        ((IControlModeListUIProxy)this._ui).getMenuReferDataBaseD().setVisible(canBeRefered);
        boolean canBeUpgrade = this.isUpgradeDisplayed();
        ((IControlModeListUIProxy)this._ui).getBtnUpgrade().setVisible(canBeUpgrade);
        ((IControlModeListUIProxy)this._ui).getMenuUpgrade().setVisible(canBeUpgrade);
    }

    private boolean isUpgradeDisplayed() {
        if (((IControlModeListUIProxy)this._ui).getUpgradeMode() == 1) {
            return this.canBeUpgraded();
        }
        return this.canUpgradeSubordinate();
    }

    private boolean canUpgradeSubordinate() {
        boolean can = false;
        try {
            String longNumber = SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber();
            String bosType = this.getBizObjectType(this._ui).toString();
            StringBuffer oql = new StringBuffer(100);
            oql.append("where id in (").append("select a.FID from T_ORG_CtrlUnit a inner join T_ORG_CUBDControl b ").append("on a.FID=b.FControlUnitID where a.FLongNumber like '").append(longNumber).append("!%' ").append("and b.FBDBOSType='").append(bosType).append("' and b.FIsSubordinateUpgradable=1").append(")");
            if (FullOrgUnitFactory.getRemoteInstance().exists(oql.toString())) {
                can = true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        return can;
    }

    protected BOSObjectType getBizObjectType(IControlModeUIProxy _ui) {
        return _ui.getBizObjectType1();
    }

    private boolean canBeUpgraded() {
        return this.canInfo.isCanUpgrade();
    }

    private boolean canBeAssigned() {
        return this.canInfo.isCanAssign();
    }

    private boolean canBeRefered() {
        return this.canInfo.isCanRefer();
    }

    private boolean canReferenceSuperior() {
        return this.canInfo.isCanRefer();
    }

    private void addPopupMenu() {
        KDTMenuManager tm = ((IControlModeListUIProxy)this._ui).getMenuManager(((IControlModeListUIProxy)this._ui).getTableForBOTP());
        if (tm != null && tm.getMenu() != null) {
            tm.getMenu().addSeparator();
            tm.getMenu().add((JMenuItem)((IControlModeListUIProxy)this._ui).getMenuViewAssigned());
        }
    }

    @Override
    public FilterInfo getDefaultFilterForControlType() {
        FilterInfo fi = null;
        try {
            fi = this.getDataBaseDFilter();
        }
        catch (Exception e) {
            logger.error((Object)"EXCEPION", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        return fi;
    }

    private FilterInfo getDataBaseDFilter() throws Exception {
        IObjectPK bizCUPK1 = this._ui.getBizCUPK1();
        Object object = this.filterCache.get(bizCUPK1);
        if (object != null) {
            return (FilterInfo)((FilterInfo)object).clone();
        }
        ICoreBase cb = this._ui.getBizInterface1();
        if (cb instanceof IDataBaseD) {
            FilterInfo databaseDFilter = null;
            databaseDFilter = this.useBatchResult() ? (FilterInfo)((DataBaseDTreeDetailListUI)this._ui).getBatchCallResult().get("databaseDFilter") : ((IDataBaseD)this._ui.getBizInterface1()).getDatabaseDFilter(bizCUPK1, ((IControlModeListUIProxy)this._ui).getKeyFieldName1(), ((IControlModeListUIProxy)this._ui).getAdminCUFieldName1());
            this.filterCache.put(bizCUPK1, databaseDFilter.clone());
            return databaseDFilter;
        }
        if (cb instanceof IDataBaseControlMode) {
            FilterInfo databaseDFilter = ((IDataBaseControlMode)this._ui.getBizInterface1()).getDatabaseDFilter(bizCUPK1, ((IControlModeListUIProxy)this._ui).getKeyFieldName1(), ((IControlModeListUIProxy)this._ui).getAdminCUFieldName1());
            this.filterCache.put(bizCUPK1, databaseDFilter.clone());
            return databaseDFilter;
        }
        return new FilterInfo();
    }

    private boolean useBatchResult() {
        if (this._ui instanceof DataBaseDTreeDetailListUI) {
            DataBaseDTreeDetailListUI dataBaseDTreeDetailListUI = (DataBaseDTreeDetailListUI)this._ui;
            return dataBaseDTreeDetailListUI.getBatchCallResult() != null && dataBaseDTreeDetailListUI.getBatchCallResult().size() > 0 && dataBaseDTreeDetailListUI.isInOnload();
        }
        return false;
    }
}

