/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.OrgDataBaseDService;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseDEditUI;
import com.kingdee.eas.basedata.framework.client.DEditClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IControlModeEditUIProxy;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class DataBaseDEditUI
extends AbstractDataBaseDEditUI
implements IControlModeEditUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseDEditUI.class);
    private DEditClientControlStrategy cStrategy = new DEditClientControlStrategy(this);
    private boolean isCheckCanUpdateByAdminCUID = true;
    protected CtrlUnitInfo curCtrlUnitInfo;

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void setIsCheckCanUpdateByAdminCUID(boolean isCheckCanUpdateByAdminCUID) {
        this.isCheckCanUpdateByAdminCUID = isCheckCanUpdateByAdminCUID;
    }

    protected IObjectPK getBizCUPK() {
        CtrlUnitInfo currentBizOrg;
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        Object object2 = currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        if (currentBizOrg == null || currentBizOrg.getCU() == null) {
            try {
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                FullOrgUnitInfo fullOrgInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId()));
                return new ObjectUuidPK(fullOrgInfo.getCU().getId());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) && this.isCheckCanUpdateByAdminCUID) {
            this.cStrategy.checkCanUpdateByAdminCUID(this.editData.getCU().getId().toString());
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected IObjectValue getOrgDataBaseDInfo(BOSObjectType objectType, IObjectPK bizOrgPK) throws EASBizException, BOSException {
        OrgDataBaseDService service = new OrgDataBaseDService(objectType);
        return service.getOrgDataBaseDInfo(this.getOrgDataBaseDSelectors(objectType), bizOrgPK);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    protected SelectorItemCollection getOrgDataBaseDSelectors(BOSObjectType objectType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected IObjectPK submitOrgDataBaseDInfo(IObjectValue value) throws EASBizException, BOSException {
        OrgDataBaseDService service = new OrgDataBaseDService(value.getBOSType());
        return service.submitOrgDataBaseDInfo(value);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.cStrategy.checkCanAdd();
        } else if (OprtState.EDIT.equals(this.getOprtState()) && this.isCheckCanUpdateByAdminCUID) {
            this.cStrategy.checkCanUpdateByAdminCUID(this.editData.getCU().getId().toString());
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public BOSObjectType getBizObjectType1() {
        return this.editData.getBOSType();
    }

    @Override
    public IObjectPK getBizCUPK1() {
        return this.getBizCUPK();
    }
}

