/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseDListUI;
import com.kingdee.eas.basedata.framework.client.AssignDestinationUI;
import com.kingdee.eas.basedata.framework.client.DListClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.DataBaseDAssignmentUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDReferenceUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI2;
import com.kingdee.eas.basedata.framework.client.DatabaseDUtil;
import com.kingdee.eas.basedata.framework.client.IControlModeListUIProxy;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class DataBaseDListUI
extends AbstractDataBaseDListUI
implements IControlModeListUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseDListUI.class);
    private DListClientControlStrategy cStrategy = new DListClientControlStrategy(this);
    private boolean isSubordinateAssign = false;
    private boolean isReferDataBaseDChkBoxVisble = false;
    private String sqlQueryOnlySelectID = null;
    protected CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private MetaDataPK pkQuery = null;
    private QueryInfo qiQuery = null;
    private String sqlQuery = null;

    public DataBaseDListUI() throws Exception {
        this.cStrategy.initUIComponent();
    }

    private String getIDFromCurrentCU() {
        return this.currentCtrlUnit.getId().toString();
    }

    public void onLoad() throws Exception {
        CUBDControlInfo ctrlInfo;
        if (this.currentCtrlUnit == null) {
            this.currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        String bosType = null;
        if (this.getBizObjectType() != null) {
            bosType = this.getBizObjectType().toString();
        }
        if (this.cStrategy.getDefaultFilterForControlType() != null && bosType != null && (ctrlInfo = CUBDControlFactory.getRemoteInstance().getBDCtrlInfo(bosType, this.getIDFromCurrentCU())) != null) {
            this.isSubordinateAssign = ctrlInfo.isIsSubordinateAssign();
        }
        super.onLoad();
        this.cStrategy.addUIComponent();
    }

    private void checkCanAssign(DataBaseDInfo dataBaseDInfo) throws Exception {
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getBizCUPK().toString()) && !this.isSubordinateAssign) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("cannotviewassigned"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAssignDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK[] assignCUPKs;
        super.actionAssignDataBaseD_actionPerformed(e);
        this.checkSelected();
        ObjectUuidPK dataBaseDPK = new ObjectUuidPK(this.getSelectedKeyValue());
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this.getBizInterface().getValue((IObjectPK)dataBaseDPK);
        this.checkCanAssign(dataBaseDInfo);
        NewCtrlF7 ctrlF7 = new NewCtrlF7((IUIObject)this);
        ctrlF7.setNeedAddOrgRange(false);
        ctrlF7.setRootUnitID(this.getBizCUPK().toString());
        ctrlF7.show();
        if (!ctrlF7.isCanceled() && (assignCUPKs = DatabaseDUtil.getAssignCUs(ctrlF7.getData())) != null) {
            ((IDataBaseD)this.getBizInterface()).assign(this.getBizCUPK(), (IObjectPK)dataBaseDPK, (IObjectPK)assignCUPKs[0]);
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("assignSuccess"));
        }
    }

    private String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.framework.DataBaseDResources", (String)key);
    }

    @Override
    public void actionBatchAssign_actionPerformed(ActionEvent e) throws Exception {
        this.showUI(DataBaseDAssignmentUI.class.getName());
    }

    protected BOSObjectType getBizObjectType() {
        BOSObjectType type = null;
        try {
            type = this.getBizInterface().getType();
        }
        catch (Exception e) {
            logger.error((Object)"Error has occured in getBizInterface()!");
        }
        return type;
    }

    @Override
    public BOSObjectType getBizObjectType1() {
        return this.getBizObjectType();
    }

    protected String getAdminCUFieldName() {
        return "CU.id";
    }

    @Override
    public String getAdminCUFieldName1() {
        return this.getAdminCUFieldName();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.cStrategy.checkCanUpdate(this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.cStrategy.checkCanDelete(this.getSelectedKeyValue());
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectPK getBizCUPK() {
        CtrlUnitInfo currentBizOrg;
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        Object object2 = currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        if (object != null) {
            return new ObjectUuidPK(currentBizOrg.getCU().getId());
        }
        return new ObjectUuidPK(currentBizOrg.getId());
    }

    @Override
    public IObjectPK getBizCUPK1() {
        return this.getBizCUPK();
    }

    @Override
    public void actionReferDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        this.showUI(DataBaseDReferenceUI.class.getName());
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        if (this.pkQuery == null) {
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizInterface().getType());
            assert (eoi.containsExtendedPropertyKey("defaultF7Query"));
            String queryName = eoi.getExtendedProperty("defaultF7Query");
            this.pkQuery = new MetaDataPK(queryName);
        }
        return this.pkQuery;
    }

    private QueryInfo getQueryInfoFromQueryPK() throws Exception {
        if (this.qiQuery == null) {
            this.qiQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)this.getQueryPKFromEntity());
        }
        return this.qiQuery;
    }

    private String getQuerySqlFromQueryPK() throws Exception {
        if (this.sqlQuery == null) {
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPKFromEntity());
            this.sqlQuery = qe.getSQL();
        }
        return this.sqlQuery;
    }

    protected void setReferDataBaseDChkBoxVisble(boolean isVisable) {
        this.isReferDataBaseDChkBoxVisble = isVisable;
    }

    private void showUI(String uiname) throws Exception {
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"QueryPK", (Object)this.getQueryPKFromEntity());
        uictx.put((Object)"pkQueryOnlySltID", (Object)this.getQueryPKOnlySltID());
        uictx.put((Object)"QueryInfo", (Object)this.getQueryInfoFromQueryPK());
        uictx.put((Object)"QuerySql", (Object)this.getQuerySqlFromQueryPK());
        uictx.put((Object)"QuerySqlOnlySltID", (Object)this.getQuerySqlOnlySltID());
        uictx.put((Object)"BizInterface", (Object)this.getBizInterface());
        uictx.put((Object)"isSubordinateAssign", (Object)new Boolean(this.isSubordinateAssign));
        uictx.put((Object)"isReferDataBaseDChkBoxVisble", (Object)new Boolean(this.isReferDataBaseDChkBoxVisble));
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.cStrategy.getDefaultFilterForControlType();
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        this.setReferDataBaseDChkBoxVisble(false);
        if (this.getUpgradeMode() == 1) {
            this.showUI(DataBaseDUpgradeUI.class.getName());
        } else {
            this.showUI(DataBaseDUpgradeUI2.class.getName());
        }
    }

    @Override
    public int getUpgradeMode() {
        return 0;
    }

    @Override
    public void actionViewAssignDestination_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK objectPK = new ObjectUuidPK(this.getSelectedKeyValue());
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this.getBizInterface().getValue((IObjectPK)objectPK);
        this.checkCanAssign(dataBaseDInfo);
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"bosType", (Object)dataBaseDInfo.getBOSType().toString());
        uictx.put((Object)"adminCUID", (Object)dataBaseDInfo.getCU().getId().toString());
        uictx.put((Object)"databaseDID", (Object)dataBaseDInfo.getId().toString());
        this.showViewAssignDestUI(AssignDestinationUI.class.getName(), uictx);
    }

    private void showViewAssignDestUI(String uiname, UIContext uictx) throws Exception {
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx);
    }

    public String getSelectedKeyValue1() {
        return this.getSelectedKeyValue();
    }

    @Override
    public String getKeyFieldName1() {
        return this.getKeyFieldName();
    }

    @Override
    public KDWorkButton getBtnAssignDataBaseD() {
        return this.btnAssignDataBaseD;
    }

    @Override
    public KDWorkButton getBtnReferDataBaseD() {
        return this.btnReferDataBaseD;
    }

    @Override
    public KDWorkButton getBtnUpgrade() {
        return this.btnUpgrade;
    }

    @Override
    public KDWorkButton getBtnViewAssigned() {
        return this.btnViewAssignDestination;
    }

    @Override
    public KDMenuItem getMenuAssignDataBaseD() {
        return this.menuAssignDataBaseD;
    }

    @Override
    public KDMenuItem getMenuReferDataBaseD() {
        return this.menuReferDataBaseD;
    }

    @Override
    public KDMenuItem getMenuBatchAssign() {
        return this.menuBatchAssign;
    }

    @Override
    public KDMenuItem getMenuUpgrade() {
        return this.menuUpgrade;
    }

    @Override
    public KDMenuItem getMenuViewAssigned() {
        return this.menuViewAssign;
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    private String getQuerySqlOnlySltID() throws Exception {
        if (this.sqlQueryOnlySelectID == null) {
            MetaDataPK pk = this.getQueryPKOnlySltID();
            if (pk == null) {
                return null;
            }
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            this.sqlQueryOnlySelectID = qe.getSQL();
        }
        return this.sqlQueryOnlySelectID;
    }

    protected MetaDataPK getQueryPKOnlySltID() throws Exception {
        return null;
    }
}

