/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.framework.FailInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseDReferenceUI;
import com.kingdee.eas.basedata.framework.util.UserCUOrgRangeUtil;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class DataBaseDReferenceUI
extends AbstractDataBaseDReferenceUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseDReferenceUI.class);
    protected static final String STATUS_ALL = "STATUS_ALL";
    protected static final String STATUS_IMPORTED = "STATUS_IMPORTED";
    protected static final String STATUS_UNIMPORTED = "STATUS_UNIMPORTED";
    protected EntityViewInfo eviCommonFilting;
    protected FilterInfo fiRadioButtonsRelated;
    private boolean allSelFlagForAssigned;
    private boolean allClrFlagForAssigned;
    private HashMap selItemsForAssigned = new HashMap();
    private HashMap clrItemsForAssigned = new HashMap();
    protected boolean allSelFlagForUnassigned;
    protected boolean allClrFlagForUnassigned;
    protected HashMap selItemsForUnassigned = new HashMap();
    protected HashMap clrItemsForUnassigned = new HashMap();
    protected HashMap groupItemsForUpgrade = new HashMap();
    private boolean hasDoneSomething = false;
    private CtrlUnitInfo curCtrlUnitInfo;
    private boolean isAssignByOrgRangeCU = false;
    private boolean isQueryAssignByOrgRangeCU = false;
    private boolean isReferDataBaseDChkBoxVisble = false;
    public static final String IS_COMMON_QUERY_FILTER = "isCommonQueryFilter";
    private String oldDataSearchCondition = "";

    public CtrlUnitInfo getCurCtrlUnitInfo() {
        return this.curCtrlUnitInfo;
    }

    public DataBaseDReferenceUI() throws Exception {
        this.initCtrls();
    }

    public void onLoad() throws Exception {
        Boolean ChkBoxVisble;
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if ((ChkBoxVisble = (Boolean)this.getUIContext().get("isReferDataBaseDChkBoxVisble")) != null) {
            this.isReferDataBaseDChkBoxVisble = ChkBoxVisble;
        }
        this.chkReferAssist.setVisible(this.isReferDataBaseDChkBoxVisble);
        super.onLoad();
        CtrlUnitInfo parentCU = this.getDirectParentCUOfCurrentCU();
        if (parentCU != null) {
            this.kDBizPromptBox1.setText(parentCU.getName());
        }
        this.kDBizPromptBox1.setData((Object)parentCU);
        this.kDBizPromptBox1.setSelector((KDPromptSelector)this.prepareCtrlF7());
        this.kDBizPromptBox1.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                DataBaseDReferenceUI.this.onChangeForCU();
            }
        });
        this.initTable();
        this.setInitialStatus();
        this.fillFilterFields();
        this.oldDataSearchCondition = this.searchItem.getSelectedItem() + this.searchValue.getText();
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForBtnDataSearch();
            }
        });
    }

    private boolean isDisplayCUByOrgRange() {
        if (!this.isQueryAssignByOrgRangeCU) {
            this.isAssignByOrgRangeCU = UserCUOrgRangeUtil.isDisplayCUByOrgRange();
            this.isQueryAssignByOrgRangeCU = true;
        }
        return this.isAssignByOrgRangeCU;
    }

    protected void setChkReferAssist() {
        String assignAssist = "false";
        try {
            assignAssist = ParamManager.getParamValue(null, null, (String)"assignAssist");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (assignAssist != null && assignAssist.equals("true")) {
            this.chkReferAssist.setSelected(true);
        }
    }

    private NewCtrlF7 prepareCtrlF7() throws ParserException {
        String currentCUID = this.curCtrlUnitInfo.getId().toString();
        String longNumber = this.curCtrlUnitInfo.getLongNumber();
        NewCtrlF7 f7 = new NewCtrlF7((IUIObject)this);
        f7.setNeedAddOrgRange(false);
        StringBuffer excludeCurrentCU = new StringBuffer();
        excludeCurrentCU.append("\"BASEUNIT\"").append(".FID <> '").append(currentCUID).append("' AND ").append("\"STRUCTURE\"").append(".FLongNumber NOT LIKE '").append(longNumber).append("!%'");
        f7.setExtraTreeFilters(excludeCurrentCU.toString());
        FilterInfo tableFilterInfo = new FilterInfo();
        tableFilterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)currentCUID, CompareType.NOTEQUALS));
        tableFilterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.NOTLIKE));
        f7.setOuterFilterInfo(tableFilterInfo);
        if (this.isDisplayCUByOrgRange()) {
            String orgRangeSQL = UserCUOrgRangeUtil.getSqlOfCurrentCUOrgRange();
            f7.setExtraTreeFilters(new StringBuffer("\"BASEUNIT\"").append(".FID IN (").append(orgRangeSQL).append(")").toString());
            FilterInfo rangeFilter = new FilterInfo("unit.id in (" + orgRangeSQL + ")");
            f7.setOuterFilterInfo(rangeFilter);
        }
        return f7;
    }

    protected void initCtrls() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForRefresh();
            }
        });
        this.btnAllSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForBtnAllSel();
            }
        });
        this.btnAllClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForBtnAllClr();
            }
        });
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForFilter();
            }
        });
        this.kDRadioButton1.setActionCommand(STATUS_ALL);
        this.kDRadioButton2.setActionCommand(STATUS_IMPORTED);
        this.kDRadioButton3.setActionCommand(STATUS_UNIMPORTED);
        this.kDRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.kDRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.kDRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.kDButtonGroup1.add((AbstractButton)this.kDRadioButton1);
        this.kDButtonGroup1.add((AbstractButton)this.kDRadioButton2);
        this.kDButtonGroup1.add((AbstractButton)this.kDRadioButton3);
        this.kDButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataBaseDReferenceUI.this.onClickForButton1();
                }
                catch (Exception ex) {
                    DataBaseDReferenceUI.this.setCursorOfDefault();
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.kDButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataBaseDReferenceUI.this.onClickForButton2();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    private void initTable() {
        QueryFieldInfo field;
        SelectorInfo selector = this.getQueryInfoFromUIContext().getSelector();
        int size = selector.getFields().size();
        String[] bindContents = new String[size + 1];
        Map exProperties = this.getQueryInfoFromUIContext().getExtendedProperties();
        this.kDTable1.getIndexColumn().getStyleAttributes().setHided(true);
        this.kDTable1.addColumn(0).setWidth(30);
        for (int i = 1; i < size + 1; ++i) {
            IColumn col = this.kDTable1.addColumn(i);
            col.getStyleAttributes().setLocked(true);
            field = (QueryFieldInfo)selector.getFields().get(i - 1);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object visible = exProperties.get("isVisibleForKDTable");
            if (visible instanceof Boolean) {
                col.getStyleAttributes().setHided((Boolean)visible == false);
            } else if (visible instanceof String) {
                col.getStyleAttributes().setHided(!KDCommonPromptDialog.stringToboolean((String)((String)visible)));
            }
            Object colWidth = exProperties.get("ColWidthInKDTable");
            if (colWidth == null) {
                colWidth = exProperties.get("colWidthInKDTable");
            }
            if (colWidth instanceof Integer) {
                col.setWidth(((Integer)colWidth).intValue());
                continue;
            }
            if (!(colWidth instanceof String)) continue;
            col.setWidth(KDCommonPromptDialog.stringToint((String)((String)colWidth)));
        }
        this.kDTable1.putBindContents("query", bindContents);
        this.kDTable1.setFormatXml("");
        this.kDTable1.checkParsed(true);
        IRow row = this.kDTable1.addHeadRow();
        for (int i = 1; i < size + 1; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i - 1);
            String displayName = field.getDisplayName(SysContext.getSysContext().getOriginLocale());
            row.getCell(i).setValue((Object)displayName);
        }
        this.kDTable1.getDataRequestManager().setDataRequestMode(1);
        this.kDTable1.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    DataBaseDReferenceUI.this.onRequestRowSetForTable(e);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.kDTable1.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                DataBaseDReferenceUI.this.onAfterTableFilledData(e.getFirstRow(), e.getLastRow());
            }
        });
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                DataBaseDReferenceUI.this.onEditValueChangedForKDTable(e);
            }
        });
    }

    private CtrlUnitInfo getDirectParentCUOfCurrentCU() {
        CtrlUnitInfo parentCU = null;
        try {
            ICtrlUnit icu = CtrlUnitFactory.getRemoteInstance();
            if (this.curCtrlUnitInfo.getParent() != null) {
                ObjectUuidPK parentCUID = new ObjectUuidPK(this.curCtrlUnitInfo.getParent().getId());
                parentCU = (CtrlUnitInfo)icu.getValue((IObjectPK)parentCUID);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return parentCU;
    }

    protected String getCurrentCUID() {
        return this.curCtrlUnitInfo.getId().toString();
    }

    private IObjectPK getReferCUPK() {
        return new ObjectUuidPK(this.curCtrlUnitInfo.getId());
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    protected IRowSet getRowSet(int start, int length) throws Exception {
        EntityViewInfo viewInfo = this.buildEntityViewInfo();
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)this.getQueryPKFromUIContext(), viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnoreOrder = viewInfo != null && viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0;
        if (exec != null) {
            logger.info((Object)("getRowSet ,sql is: " + exec.getSQL()));
        }
        try {
            QueryInfo query = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)this.getQueryPKFromUIContext());
            SubObjectInfo mainEntity = query.getMainObject();
            EntityObjectInfo entityObjInfo = (EntityObjectInfo)mainEntity.get("entityRef");
            CacheServiceFactory.getInstance().discardType(entityObjInfo.getType());
        }
        catch (Exception e) {
            logger.info((Object)"DataBaseDReferenceUI,clear client Cache err!", (Throwable)e);
        }
        return exec.executeQuery(start, length);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    protected IRowSet getRSAll(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = null;
        return this.getRowSet(start, length);
    }

    protected IRowSet getRSImported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.INNER);
        return this.getRowSet(start, length);
    }

    protected IRowSet getRSUnimported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.NOTINNER);
        return this.getRowSet(start, length);
    }

    private FilterInfo getFIRadioButtonsRelated(CompareType ct) throws Exception {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)this.getSqlForAllAssigned(), ct));
        return fi;
    }

    protected String getUpperCUIDFromCtrlF7() {
        String cuid = "";
        Object o = this.kDBizPromptBox1.getData();
        if (o != null && o instanceof CtrlUnitInfo) {
            CtrlUnitInfo cui = (CtrlUnitInfo)o;
            assert (cui.getId() != null);
            cuid = cui.getId().toString();
        }
        return cuid;
    }

    private String getSqlForAllAssigned() {
        String sql = "select distinct FDataBaseDID from T_BD_DataBaseDAssign where FAssignCUID='" + this.getCurrentCUID() + "' and FBOSObjectType='" + this.getBizInterfaceFromUIContext().getType().toString() + "'";
        return sql;
    }

    protected IDataBaseD getBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("BizInterface");
        assert (o != null);
        return (IDataBaseD)o;
    }

    protected IDataBase getGroupBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("GroupBizInterface");
        assert (o != null);
        if (this.getQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
            return (IMaterialGroup)o;
        }
        return (ICSSPGroup)o;
    }

    private MetaDataPK getQueryPKFromUIContext() {
        Object o = this.getUIContext().get("QueryPK");
        assert (o != null);
        return (MetaDataPK)o;
    }

    private QueryInfo getQueryInfoFromUIContext() {
        Object o = this.getUIContext().get("QueryInfo");
        assert (o != null);
        return (QueryInfo)o;
    }

    protected QueryInfo getUIQueryInfoFromUIContext() {
        Object o = this.getUIContext().get("QueryInfo");
        assert (o != null);
        return (QueryInfo)o;
    }

    protected MetaDataPK getUIQueryPKFromUIContext() {
        Object o = this.getUIContext().get("QueryPK");
        assert (o != null);
        return (MetaDataPK)o;
    }

    protected String getStatusIndentifier() {
        return this.kDButtonGroup1.getSelection().getActionCommand();
    }

    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.framework.DataBaseDResources", (String)key);
    }

    private void onEditValueChangedForKDTable(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        String rowID = this.kDTable1.getRow(rowIndex).getCell("id").getValue().toString();
        String groupMessage = "";
        if (this.kDTable1.getRow(rowIndex).getCell("number") != null && this.kDTable1.getRow(rowIndex).getCell("number").getValue() != null) {
            groupMessage = groupMessage + this.kDTable1.getRow(rowIndex).getCell("number").getValue().toString() + this.getMultiLangString("UpgradeErrorGroup");
        }
        if (this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
            if (this.kDTable1.getRow(rowIndex).getCell("materialGroup.name") != null && this.kDTable1.getRow(rowIndex).getCell("materialGroup.name").getValue() != null) {
                groupMessage = groupMessage + this.kDTable1.getRow(rowIndex).getCell("materialGroup.name").getValue().toString() + this.getMultiLangString("CuNoVisiableGroup");
            }
        } else if (this.kDTable1.getRow(rowIndex).getCell("browseGroup.name") != null && this.kDTable1.getRow(rowIndex).getCell("browseGroup.name").getValue() != null) {
            groupMessage = groupMessage + this.kDTable1.getRow(rowIndex).getCell("browseGroup.name").getValue().toString() + this.getMultiLangString("CuNoVisiableGroup");
        }
        boolean selected = (Boolean)e.getValue();
        if (e.getColIndex() == 0) {
            if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
                if (this.allSelFlagForAssigned) {
                    if (!selected) {
                        this.clrItemsForAssigned.put(rowIndex + "", rowID);
                    } else if (this.clrItemsForAssigned.containsKey(rowIndex + "")) {
                        this.clrItemsForAssigned.remove(rowIndex + "");
                    }
                } else {
                    assert (this.allClrFlagForAssigned);
                    if (selected) {
                        this.selItemsForAssigned.put(rowIndex + "", rowID);
                    } else if (this.selItemsForAssigned.containsKey(rowIndex + "")) {
                        this.selItemsForAssigned.remove(rowIndex + "");
                    }
                }
            } else if (this.getStatusIndentifier().equals(STATUS_UNIMPORTED)) {
                if (this.allSelFlagForUnassigned) {
                    if (!selected) {
                        this.clrItemsForUnassigned.put(rowIndex + "", rowID);
                        if (this.groupItemsForUpgrade.containsKey(rowIndex + "")) {
                            this.groupItemsForUpgrade.remove(rowIndex + "");
                        }
                    } else {
                        this.groupItemsForUpgrade.put(rowIndex + "", groupMessage);
                        if (this.clrItemsForUnassigned.containsKey(rowIndex + "")) {
                            this.clrItemsForUnassigned.remove(rowIndex + "");
                        }
                    }
                } else {
                    assert (this.allClrFlagForUnassigned);
                    if (selected) {
                        this.selItemsForUnassigned.put(rowIndex + "", rowID);
                        this.groupItemsForUpgrade.put(rowIndex + "", groupMessage);
                    } else {
                        if (this.selItemsForUnassigned.containsKey(rowIndex + "")) {
                            this.selItemsForUnassigned.remove(rowIndex + "");
                        }
                        if (this.groupItemsForUpgrade.containsKey(rowIndex + "")) {
                            this.groupItemsForUpgrade.remove(rowIndex + "");
                        }
                    }
                }
            }
        }
    }

    private void onClickForBtnAllSel() {
        if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            this.setAllSelStatusForAssigned();
        } else if (this.getStatusIndentifier().equals(STATUS_UNIMPORTED)) {
            this.setAllSelStatusForUnassigned();
        }
        this.refreshRowsInTable();
    }

    private void onClickForBtnAllClr() {
        if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            this.setAllClrStatusForAssigned();
        } else if (this.getStatusIndentifier().equals(STATUS_UNIMPORTED)) {
            this.setAllClrStatusForUnassigned();
        }
        this.refreshRowsInTable();
    }

    private void setAllSelStatusForAssigned() {
        this.allSelFlagForAssigned = true;
        this.allClrFlagForAssigned = false;
        this.selItemsForAssigned.clear();
        this.clrItemsForAssigned.clear();
        this.groupItemsForUpgrade.clear();
    }

    private void setAllClrStatusForAssigned() {
        this.allSelFlagForAssigned = false;
        this.allClrFlagForAssigned = true;
        this.selItemsForAssigned.clear();
        this.clrItemsForAssigned.clear();
        this.groupItemsForUpgrade.clear();
    }

    private void setAllSelStatusForUnassigned() {
        this.allSelFlagForUnassigned = true;
        this.allClrFlagForUnassigned = false;
        this.selItemsForUnassigned.clear();
        this.clrItemsForUnassigned.clear();
        this.groupItemsForUpgrade.clear();
    }

    private void setAllClrStatusForUnassigned() {
        this.allSelFlagForUnassigned = false;
        this.allClrFlagForUnassigned = true;
        this.selItemsForUnassigned.clear();
        this.clrItemsForUnassigned.clear();
        this.groupItemsForUpgrade.clear();
    }

    private void onClickForFilter() {
        CommonQueryDialog cqd = new CommonQueryDialog();
        cqd.setOwner((Component)((Object)this));
        cqd.setQueryObjectPK((IMetaDataPK)this.getQueryPKFromUIContext());
        cqd.setShowToolbar(false);
        cqd.setWidth(640);
        cqd.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        if (this.eviCommonFilting != null) {
            cqd.setEntityViewInfo(this.eviCommonFilting);
        }
        if (cqd.show()) {
            this.eviCommonFilting = cqd.getEntityViewInfoResult();
            this.refreshRowsInTable();
        }
    }

    private void onClickForRefresh() {
        this.eviCommonFilting = null;
        this.refreshRowsInTable();
    }

    protected void onAfterTableFilledData(int firstRow, int lastRow) {
        Boolean trueValue = new Boolean(true);
        Boolean falseValue = new Boolean(false);
        Boolean value = null;
        if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            if (this.allSelFlagForAssigned) {
                value = trueValue;
                for (int i = firstRow; i <= lastRow; ++i) {
                    value = this.clrItemsForAssigned.containsKey(i + "") ? falseValue : trueValue;
                    this.kDTable1.getCell(i, 0).setValue((Object)value);
                }
            } else {
                assert (this.allClrFlagForAssigned);
                value = falseValue;
                for (int i = firstRow; i <= lastRow; ++i) {
                    value = this.selItemsForAssigned.containsKey(i + "") ? trueValue : falseValue;
                    this.kDTable1.getCell(i, 0).setValue((Object)value);
                }
            }
        } else if (this.getStatusIndentifier().equals(STATUS_UNIMPORTED)) {
            if (this.allSelFlagForUnassigned) {
                value = trueValue;
                for (int i = firstRow; i <= lastRow; ++i) {
                    String groupMessage = "";
                    if (this.kDTable1.getRow(i).getCell("number") != null && this.kDTable1.getRow(i).getCell("number").getValue() != null) {
                        groupMessage = groupMessage + this.kDTable1.getRow(i).getCell("number").getValue().toString() + this.getMultiLangString("UpgradeErrorGroup");
                    }
                    if (this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
                        if (this.kDTable1.getRow(i).getCell("materialGroup.name") != null && this.kDTable1.getRow(i).getCell("materialGroup.name").getValue() != null) {
                            groupMessage = groupMessage + this.kDTable1.getRow(i).getCell("materialGroup.name").getValue().toString() + this.getMultiLangString("CuNoVisiableGroup");
                        }
                    } else if (this.kDTable1.getRow(i).getCell("browseGroup.name") != null && this.kDTable1.getRow(i).getCell("browseGroup.name").getValue() != null) {
                        groupMessage = groupMessage + this.kDTable1.getRow(i).getCell("browseGroup.name").getValue().toString() + this.getMultiLangString("CuNoVisiableGroup");
                    }
                    if (this.clrItemsForUnassigned.containsKey(i + "")) {
                        value = falseValue;
                        if (this.groupItemsForUpgrade.containsKey(i + "")) {
                            this.groupItemsForUpgrade.remove(i + "");
                        }
                    } else {
                        value = trueValue;
                        this.groupItemsForUpgrade.put(i + "", groupMessage);
                    }
                    this.kDTable1.getCell(i, 0).setValue((Object)value);
                }
            } else {
                assert (this.allClrFlagForUnassigned);
                value = falseValue;
                for (int i = firstRow; i <= lastRow; ++i) {
                    value = this.selItemsForUnassigned.containsKey(i + "") ? trueValue : falseValue;
                    this.kDTable1.getCell(i, 0).setValue((Object)value);
                }
            }
        }
        this.setButtonsEnabled();
    }

    private void onClickForButton1() throws Exception {
        if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            this.doUnimport();
        } else {
            this.doImport();
        }
        this.hasDoneSomething = true;
    }

    private void onClickForButton2() throws Exception {
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        Object obj;
        boolean result = super.destroyWindow();
        if (this.hasDoneSomething && (obj = this.getUIContext().get("Owner")) instanceof ListUI) {
            try {
                ((ListUI)obj).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                logger.debug((Object)"Exception:", (Throwable)e);
            }
        }
        return result;
    }

    private String[] listToStringArr(List list) {
        String[] strArr = new String[list.size()];
        Object[] oArr = list.toArray();
        for (int i = 0; i < oArr.length; ++i) {
            strArr[i] = (String)oArr[i];
        }
        return strArr;
    }

    protected void doImport() throws Exception {
        this.setCursorOfWair();
        ArrayList al = this.getIDsOfRowsToImport();
        this.checkSelected(al);
        IDataBaseD idbd = this.getBizInterfaceFromUIContext();
        String[] dataIds = this.listToStringArr(al);
        FailInfo fail = null;
        if (this.chkReferAssist.isSelected()) {
            logger.info((Object)"DataBaseDReferenceUI batchReferBaseAndAssist begin!");
            fail = idbd.batchReferReturnFail((IObjectPK)new ObjectUuidPK(this.getUpperCUIDFromCtrlF7()), dataIds, (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()), true);
            logger.info((Object)"DataBaseDReferenceUI batchReferBaseAndAssist end!");
        } else {
            logger.info((Object)"DataBaseDReferenceUI batchRefer begin!");
            fail = idbd.batchReferReturnFail((IObjectPK)new ObjectUuidPK(this.getUpperCUIDFromCtrlF7()), dataIds, (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()), false);
            logger.info((Object)"DataBaseDReferenceUI batchRefer end!");
        }
        this.setCursorOfDefault();
        if (fail != null && fail.getMainMsg() != null) {
            if (fail.getDetailMsg() != null && !"".equals(fail.getDetailMsg())) {
                MsgBox.showConfirm3a((String)fail.getMainMsg(), (String)fail.getDetailMsg());
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)fail.getMainMsg());
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("ImportingFinished"));
        }
        this.setAllClrStatusForUnassigned();
        this.refreshRowsInTable();
    }

    protected ArrayList getIDsOfRowsToImport() throws Exception {
        if (this.allSelFlagForUnassigned) {
            this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.NOTINNER);
            return this.getIDsByExecutingQuery(this.clrItemsForUnassigned.values());
        }
        assert (this.allClrFlagForUnassigned);
        return new ArrayList(this.selItemsForUnassigned.values());
    }

    private void doUnimport() throws Exception {
        this.setCursorOfWair();
        ArrayList al = this.getIDsOfRowsToUnimport();
        String[] dataIds = al.toArray(new String[0]);
        this.checkSelected(al);
        long beginTime = System.currentTimeMillis();
        IDataBaseD idbd = this.getBizInterfaceFromUIContext();
        Map map = idbd.batchUnAssignReturnFail(dataIds, new String[]{this.getReferCUPK().toString()});
        long endTime = System.currentTimeMillis();
        logger.info((Object)("DataBaseDReferenceUI->doUnimport cost:" + (endTime - beginTime) + "ms."));
        this.setCursorOfDefault();
        String info = this.getMultiLangString("UnimportingFinished");
        if (map != null && map.size() != 0) {
            info = "\u53cd\u5f15\u7528\u6210\u529f\uff0c\u90e8\u5206\u8d44\u6599\u56e0\u4e3a\u5df2\u7ecf\u88ab\u5f15\u7528\u4e0d\u4f5c\u5904\u7406\uff01";
        }
        MsgBox.showInfo((Component)((Object)this), (String)info);
        this.setAllClrStatusForAssigned();
        this.refreshRowsInTable();
    }

    private ArrayList getIDsOfRowsToUnimport() throws Exception {
        if (this.allSelFlagForAssigned) {
            this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.INNER);
            return this.getIDsByExecutingQuery(this.clrItemsForAssigned.values());
        }
        assert (this.allClrFlagForAssigned);
        return new ArrayList(this.selItemsForAssigned.values());
    }

    protected ArrayList getIDsByExecutingQuery(Collection excludedIDs) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPKFromUIContext());
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo evi = this.buildEntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.clear();
        sic.add(new SelectorItemInfo("id"));
        exec.setObjectView(evi);
        IRowSet rs = exec.executeQuery();
        ArrayList<String> al = new ArrayList<String>();
        while (rs.next()) {
            String aID = rs.getString("id");
            if (excludedIDs.contains(aID)) continue;
            al.add(aID);
        }
        return al;
    }

    protected void checkSelected(ArrayList al) {
        if (al.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void onChangeForCU() {
        this.setInitialStatus();
    }

    private void onClickForRadioButtons() {
        this.setStatus();
    }

    private void onRequestRowSetForTable(RequestRowSetEvent e) throws Exception {
        this.setCursorOfWair();
        IRowSet rsToSet = null;
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        if (this.getStatusIndentifier().equals(STATUS_ALL)) {
            rsToSet = this.getRSAll(start, length);
        } else if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            rsToSet = this.getRSImported(start, length);
        } else {
            rsToSet = this.getRSUnimported(start, length);
            if (rsToSet != null) {
                logger.info((Object)("after getRSUnimported rsToSet size:" + rsToSet.size()));
            }
        }
        e.setRowSet(rsToSet);
        this.setCursorOfDefault();
    }

    private void refreshRowsInTable() {
        this.kDTable1.removeRows();
    }

    protected EntityViewInfo buildEntityViewInfo() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("adminCU.id", (Object)this.getUpperCUIDFromCtrlF7()));
        if (this.fiRadioButtonsRelated != null) {
            fi.mergeFilter(this.fiRadioButtonsRelated, "and");
        }
        if (this.eviCommonFilting != null) {
            FilterInfo fii = this.eviCommonFilting.getFilter();
            if (fi != null && fii.getFilterItems() != null && fii.getFilterItems().size() != 0) {
                fi.mergeFilter(fii, "and");
            }
            SorterItemCollection sicc = this.eviCommonFilting.getSorter();
            SorterItemCollection sic = evi.getSorter();
            if (sicc != null && sicc.size() != 0) {
                int size = sicc.size();
                for (int i = 0; i < size; ++i) {
                    sic.add(sicc.get(i));
                }
            }
        }
        FilterInfo filter = new FilterInfo();
        if (this.searchValue.getText() != null && !"".equals(this.searchValue.getText()) && this.searchItem.getSelectedItem() != null) {
            String filterField = ((FilterFieldItem)this.searchItem.getSelectedItem()).ffiName;
            String searchText = "%" + this.searchValue.getText() + "%";
            filter.getFilterItems().add(new FilterItemInfo(filterField, (Object)searchText, CompareType.LIKE));
        }
        if (fi == null || fi.getFilterItems().size() == 0) {
            evi.setFilter(fi);
        } else {
            filter.mergeFilter(fi, "and");
            evi.setFilter(filter);
        }
        this.fiRadioButtonsRelated = null;
        return evi;
    }

    protected void setButtonsEnabled() {
        boolean isEnabled = this.kDTable1.getRowCount3() > 0 && !this.getStatusIndentifier().equals(STATUS_ALL);
        this.btnAllSelect.setEnabled(isEnabled);
        this.btnAllClear.setEnabled(isEnabled);
        this.kDButton1.setEnabled(isEnabled);
    }

    protected void setStatus() {
        this.setAllClrStatusForUnassigned();
        this.setAllClrStatusForAssigned();
        this.refreshRowsInTable();
        this.setLookOfButton1();
        this.setFirstColumnLocked();
    }

    private void setInitialStatus() {
        this.kDButtonGroup1.setSelected(this.kDRadioButton3.getModel(), true);
        this.setStatus();
    }

    protected void setLookOfButton1() {
        if (this.getStatusIndentifier().equals(STATUS_ALL)) {
            this.kDButton1.setVisible(false);
            this.chkReferAssist.setVisible(false);
        } else if (this.getStatusIndentifier().equals(STATUS_IMPORTED)) {
            this.kDButton1.setVisible(true);
            this.kDButton1.setText(new StringBuffer(EASResource.getString((String)"cancel")).append(this.resHelper.getString("kDButton1.text")).toString());
            this.chkReferAssist.setVisible(false);
        } else {
            this.kDButton1.setVisible(true);
            this.kDButton1.setText(this.resHelper.getString("kDButton1.text"));
            this.chkReferAssist.setVisible(this.isReferDataBaseDChkBoxVisble);
        }
    }

    protected void setFirstColumnLocked() {
        boolean isLocked = false;
        if (this.getStatusIndentifier().equals(STATUS_ALL)) {
            isLocked = true;
        }
        this.kDTable1.getColumn(0).getStyleAttributes().setLocked(isLocked);
    }

    private void fillFilterFields() {
        this.searchItem.removeAllItems();
        if (this.getDataFilterFields().length == 0) {
            QueryInfo queryPK = this.getQueryInfoFromUIContext();
            String fullName = queryPK.toString();
            this.handUIExceptionAndAbort((Exception)((Object)new BOSException("At least one filter item is required in [" + fullName + "]")));
        }
        this.searchItem.addItems((Object[])this.getDataFilterFields());
    }

    protected FilterFieldItem[] getDataFilterFields() {
        QueryInfo queryPK = this.getQueryInfoFromUIContext();
        ArrayList filterCondition = DataBaseDReferenceUI.getConditionList(queryPK);
        FilterFieldItem[] ffis = new FilterFieldItem[filterCondition.size()];
        for (int i = 0; i < filterCondition.size(); ++i) {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)filterCondition.get(i);
            String displayName = DataBaseDReferenceUI.getQueryFieldAlias(queryFieldInfo);
            ffis[i] = new FilterFieldItem(queryFieldInfo.getName(), displayName, ConstDataType.STRING);
        }
        return ffis;
    }

    public static ArrayList getConditionList(QueryInfo queryInfo) {
        ArrayList<QueryFieldInfo> target = new ArrayList<QueryFieldInfo>();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            boolean isFilter = false;
            String temp = queryFieldInfo.getExtendedProperty(IS_COMMON_QUERY_FILTER);
            ConstDataType cdt = null;
            try {
                cdt = queryFieldInfo.getReturnType();
            }
            catch (Exception e) {
                continue;
            }
            if (!ConstDataType.STRING.equals((Object)cdt)) continue;
            if (temp != null && !temp.trim().equalsIgnoreCase("")) {
                isFilter = Boolean.valueOf(temp);
            }
            if (!isFilter) continue;
            target.add(queryFieldInfo);
        }
        return target;
    }

    public static String getQueryFieldAlias(QueryFieldInfo fieldInfo) {
        String displayName = fieldInfo.getDisplayName();
        if (fieldInfo.getDisplayName() == null || fieldInfo.getDisplayName().trim().equalsIgnoreCase("")) {
            displayName = fieldInfo.getName();
        }
        return displayName;
    }

    private void onClickForBtnDataSearch() {
        String text = this.searchValue.getText();
        String newCondition = this.searchItem.getSelectedItem().toString() + text;
        if (!newCondition.equals(this.oldDataSearchCondition)) {
            this.oldDataSearchCondition = newCondition;
            this.kDTable1.removeRows();
            this.refreshRowsInTable();
        }
    }

    protected FilterInfo getDataFilterFromUIContext() {
        Object o = this.getUIContext().get("defaultDataFilter");
        if (o != null && o instanceof FilterInfo) {
            return (FilterInfo)o;
        }
        return null;
    }

    protected FilterInfo getDefaultDataFilter() {
        if (this.getDataFilterFromUIContext() != null) {
            return this.getDataFilterFromUIContext();
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getIDFromCurrentCU()));
        return fi;
    }

    private String getIDFromCurrentCU() {
        return this.curCtrlUnitInfo.getId().toString();
    }

    public class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        public FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }
}

