/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.DataBaseDCollection;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.DataTableNameGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.DataBaseDUpgradeUI;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class DataBaseDUpgradeUI2
extends DataBaseDUpgradeUI {
    private String sqlForAllUpgradableSubordinateCUIDs = "";
    private FilterInfo fiAll;
    private FilterInfo fiImported;
    private FilterInfo fiUnimported;
    private List groupId = new ArrayList();
    private CtrlUnitInfo curCtrlUnitInfo;
    private Map idmap = new HashMap();

    @Override
    protected void initCtrls() {
        super.initCtrls();
        this.kDBizPromptBox1.setVisible(false);
        this.kDLabelContainer1.setBoundLabelUnderline(false);
        this.kDLabelContainer1.setBoundLabelLength(this.kDLabelContainer1.getBoundLabelLength() * 3);
        this.kDLabelContainer1.setBoundLabelText(this.getMultiLangString("UpgradeHeadLabel"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.rebuildUIBecauseAComponentHasBeenHiden();
    }

    private void rebuildUIBecauseAComponentHasBeenHiden() {
        this.kDLabelContainer1.setVisible(false);
        this.searchItem.setVisible(false);
        this.searchValue.setVisible(false);
        this.btnSearch.setVisible(false);
        int x = 0;
        int y = 0;
        Component[] comps = this.getComponents();
        int n = comps.length;
        for (int i = 0; i < n; ++i) {
            x = (int)comps[i].getLocation().getX();
            y = (int)comps[i].getLocation().getY();
            comps[i].setLocation(x, y - 20);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(width, height - 20);
    }

    @Override
    protected IRowSet getRSAll(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiAll();
        return this.getRowSet(start, length);
    }

    @Override
    protected IRowSet getRSImported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiImported();
        return this.getRowSet(start, length);
    }

    @Override
    protected IRowSet getRSUnimported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiUnimported();
        return this.getRowSet(start, length);
    }

    @Override
    protected void doImport() throws Exception {
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"upgradeConfirm"));
        if (!MsgBox.isYes((int)result)) {
            SysUtil.abort();
            return;
        }
        IDataBase igroup = this.getGroupBizInterfaceFromUIContext();
        if (igroup != null && igroup instanceof IDataBase) {
            this.doCheckImport();
        } else {
            this.setCursorOfWair();
            ArrayList al = this.getIDsOfRowsToImport();
            this.checkSelected(al);
            Hashtable cuIDs = this.getCUIDsByDataIDs(al);
            if (cuIDs == null || cuIDs.isEmpty()) {
                this.setCursorOfDefault();
                MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("OperationErrorNoDataRight"));
                this.setStatus();
                return;
            }
            IDataBaseD idbd = this.getBizInterfaceFromUIContext();
            String dataID = null;
            int size = al.size();
            for (int i = 0; i < size; ++i) {
                dataID = al.get(i).toString();
                idbd.upgrade((IObjectPK)new ObjectUuidPK(dataID), (IObjectPK)new ObjectUuidPK(cuIDs.get(dataID).toString()), (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
            }
            this.setCursorOfDefault();
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("UpgradingFinished"));
            this.setStatus();
        }
    }

    @Override
    protected ArrayList getIDsOfRowsToImport() throws Exception {
        if (this.allSelFlagForUnassigned) {
            this.fiRadioButtonsRelated = this.getFiUnimported();
            return this.getIDsByExecutingQuery(this.clrItemsForUnassigned.values());
        }
        assert (this.allClrFlagForUnassigned);
        return new ArrayList(this.selItemsForUnassigned.values());
    }

    private Hashtable getCUIDsByDataIDs(ArrayList dataIDs) throws Exception {
        Hashtable<String, String> cuIDs = new Hashtable<String, String>();
        String oql = this.getOQLForDataIDsAndCUIDs(dataIDs);
        DataBaseDCollection dbdc = this.getBizInterfaceFromUIContext().getDataBaseDCollection(oql);
        DataBaseDInfo dbdi = null;
        int n = dbdc.size();
        for (int i = 0; i < n; ++i) {
            dbdi = dbdc.get(i);
            cuIDs.put(dbdi.getId().toString(), dbdi.getCU().getId().toString());
        }
        return cuIDs;
    }

    private String getOQLForDataIDsAndCUIDs(ArrayList dataIDs) {
        StringBuffer oql = new StringBuffer("select id,CU.id where ");
        int groupCount = 50;
        ArrayList idGroup = new ArrayList();
        boolean handledAGroup = false;
        boolean firstGroup = true;
        int n = dataIDs.size();
        for (int i = 0; i < n; ++i) {
            handledAGroup = false;
            idGroup.add(dataIDs.get(i));
            if (i == 0 || i % 50 != 0) continue;
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
            handledAGroup = true;
            firstGroup = false;
            idGroup.clear();
        }
        if (!handledAGroup) {
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
        }
        return oql.toString();
    }

    private String getGroupOQL(ArrayList idGroup) {
        StringBuffer oql = new StringBuffer();
        oql.append("id in ('").append(idGroup.get(0).toString()).append("'");
        int n = idGroup.size();
        for (int i = 1; i < n; ++i) {
            oql.append(",'").append(idGroup.get(i).toString()).append("'");
        }
        oql.append(")");
        return oql.toString();
    }

    private FilterInfo getFiAll() {
        if (this.fiAll != null) {
            return this.fiAll;
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)this.getSQLForAllUpgradableSubordinateCUIDs(), CompareType.INNER));
        this.fiAll = fi;
        return this.fiAll;
    }

    private FilterInfo getFiImported() {
        if (this.fiImported != null) {
            return this.fiImported;
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("adminCU.id", (Object)this.getCurrentCUID()));
        fic.add(new FilterItemInfo("CU.id", (Object)this.getSQLForAllUpgradableSubordinateCUIDs(), CompareType.INNER));
        this.fiImported = fi;
        return this.fiImported;
    }

    private FilterInfo getFiUnimported() throws Exception {
        if (this.fiUnimported != null) {
            return this.fiUnimported;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where id in (").append(this.getSQLForAllIDsWhoseAdminCUEqualsToCU()).append(") and adminCU.id in (").append(this.getSQLForAllUpgradableSubordinateCUIDs()).append(")");
        EntityViewInfo evi = new EntityViewInfo(oql.toString());
        this.fiUnimported = evi.getFilter();
        return this.fiUnimported;
    }

    private String getSQLForAllIDsWhoseAdminCUEqualsToCU() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ").append(DataTableNameGetterFacadeFactory.getRemoteInstance().getTableName(this.getBizInterfaceFromUIContext().getType().toString())).append(" where FAdminCUID=FControlUnitID");
        return sql.toString();
    }

    private String getSQLForAllUpgradableSubordinateCUIDs() {
        if (this.sqlForAllUpgradableSubordinateCUIDs.length() != 0) {
            return this.sqlForAllUpgradableSubordinateCUIDs;
        }
        String longNumber = this.getCurCtrlUnitInfo().getLongNumber();
        String bosType = this.getBizInterfaceFromUIContext().getType().toString();
        StringBuffer sql = new StringBuffer(100);
        sql.append("select a.FID from T_ORG_CtrlUnit a inner join T_ORG_CUBDControl b ").append("on a.FID=b.FControlUnitID where a.FLongNumber like '").append(longNumber).append("!%' ").append("and b.FBDBOSType='").append(bosType).append("' and b.FIsSubordinateUpgradable=1");
        this.sqlForAllUpgradableSubordinateCUIDs = sql.toString();
        return this.sqlForAllUpgradableSubordinateCUIDs;
    }

    private boolean checkGroupVisiable(String dataBaseName, String groupName, String dataBaseId) {
        boolean isGroupVisiable = false;
        String cuLongNumber = this.getCurCtrlUnitInfo().getLongNumber();
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select c.flongnumber from " + dataBaseName + " a");
        if (dataBaseName.equals("t_bd_material")) {
            sql.append(" inner join " + groupName + " b on a.FMaterialGroupID = b.fid");
        } else {
            sql.append(" inner join " + groupName + " b on a.FBrowseGroupID = b.fid");
        }
        sql.append(" inner join t_org_ctrlunit c on b.fcontrolunitid = c.fid");
        sql.append(" where  charindex(c.flongnumber,'" + cuLongNumber + "')<=0 and a.fid='" + dataBaseId + "'");
        try {
            ISQLExecutor srs = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rs = srs.executeSQL();
            while (rs.next()) {
                isGroupVisiable = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isGroupVisiable;
    }

    protected boolean confirmUpgrade(Component comp, String error, String errorDetail, int msgType) {
        return MsgBox.isYes((int)MsgBox.showConfirm3a((Component)comp, (String)error, (String)errorDetail));
    }

    public Map getGroupInfoID(String id) {
        try {
            MaterialGroupInfo csspInfo;
            if (this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
                csspInfo = (MaterialGroupInfo)this.getGroupInfo(id);
                if (csspInfo.getParent() != null) {
                    this.getGroupInfoID(csspInfo.getParent().getId().toString());
                }
            } else {
                csspInfo = (CSSPGroupInfo)this.getGroupInfo(id);
                if (((CSSPGroupInfo)csspInfo).getParent() != null) {
                    this.getGroupInfoID(((CSSPGroupInfo)csspInfo).getParent().getId().toString());
                }
            }
            this.idmap.put(csspInfo.getId().toString(), csspInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.idmap;
    }

    public DataBaseInfo getGroupInfo(String id) throws BOSException, EASBizException {
        String longNumber = this.getCurCtrlUnitInfo().getLongNumber();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,parent.name,parent.number,parent.CU.id,level,isLeaf,longNumber,CU.id,CU.name,CU.longNumber");
        oql.append(" where deletedStatus=1 ");
        oql.append(" and CU.longNumber like '");
        oql.append(longNumber + "!%' and id ='" + id + "'");
        DataBaseInfo csspCol = this.getGroupBizInterfaceFromUIContext().getDataBaseInfo(oql.toString());
        return csspCol;
    }

    @Override
    public CtrlUnitInfo getCurCtrlUnitInfo() {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return this.curCtrlUnitInfo;
    }

    protected ArrayList getAllSelectedGroupInfo(Collection excludedIDs) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        this.fiRadioButtonsRelated = this.getFiUnimported();
        EntityViewInfo viewInfo = this.buildEntityViewInfo();
        String messageInfo = "";
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)this.getUIQueryPKFromUIContext(), viewInfo);
        IRowSet rowSet = exec.executeQuery();
        String groupName = "";
        groupName = this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0 ? "materialGroup.name" : "browseGroup.name";
        while (rowSet.next()) {
            String aID = rowSet.getString("id");
            if (excludedIDs.contains(aID)) continue;
            messageInfo = rowSet.getString("number") + this.getMultiLangString("UpgradeErrorGroup") + rowSet.getString(groupName) + this.getMultiLangString("CuNoVisiableGroup");
            list.add(messageInfo);
        }
        return list;
    }

    private void doCheckImport() throws Exception {
        int i;
        this.setCursorOfWair();
        ArrayList al = this.getIDsOfRowsToImport();
        ArrayList grouplist = null;
        grouplist = this.allSelFlagForUnassigned ? this.getAllSelectedGroupInfo(this.clrItemsForUnassigned.values()) : new ArrayList(this.groupItemsForUpgrade.values());
        this.checkSelected(al);
        Hashtable cuIDs = this.getCUIDsByDataIDs(al);
        IDataBaseD idbd = this.getBizInterfaceFromUIContext();
        IDataBase igroup = this.getGroupBizInterfaceFromUIContext();
        String dataID = null;
        StringBuffer errorDetail = new StringBuffer();
        String tableName = "";
        String groupName = "";
        if (cuIDs == null || cuIDs.isEmpty()) {
            this.setCursorOfDefault();
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("OperationErrorNoDataRight"));
            this.setStatus();
            return;
        }
        if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Customer") >= 0) {
            tableName = "t_bd_customer";
            groupName = "t_bd_csspGroup";
        } else if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Supplier") >= 0) {
            tableName = "t_bd_supplier";
            groupName = "t_bd_csspGroup";
        } else if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
            tableName = "t_bd_material";
            groupName = "t_bd_materialGroup";
        } else {
            tableName = "t_bd_customer";
            groupName = "t_bd_csspGroup";
        }
        int size = al.size();
        for (int i2 = 0; i2 < size; ++i2) {
            CustomerInfo customerInfo;
            dataID = al.get(i2).toString();
            if (!this.checkGroupVisiable(tableName, groupName, dataID)) continue;
            errorDetail.append(grouplist.get(i2).toString() + "\r\n");
            if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Customer") >= 0) {
                customerInfo = (CustomerInfo)idbd.getDataBaseDInfo((IObjectPK)new ObjectUuidPK(dataID));
                this.groupId.add(customerInfo.getBrowseGroup().getId().toString());
                continue;
            }
            if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Supplier") >= 0) {
                SupplierInfo supplierInfo = (SupplierInfo)idbd.getDataBaseDInfo((IObjectPK)new ObjectUuidPK(dataID));
                this.groupId.add(supplierInfo.getBrowseGroup().getId().toString());
                continue;
            }
            if (this.getUIQueryInfoFromUIContext() != null && this.getUIQueryInfoFromUIContext().toString().indexOf("Material") >= 0) {
                MaterialInfo materialInfo = (MaterialInfo)idbd.getDataBaseDInfo((IObjectPK)new ObjectUuidPK(dataID));
                this.groupId.add(materialInfo.getMaterialGroup().getId().toString());
                continue;
            }
            customerInfo = (CustomerInfo)idbd.getDataBaseDInfo((IObjectPK)new ObjectUuidPK(dataID));
            this.groupId.add(customerInfo.getBrowseGroup().getId().toString());
        }
        boolean isDataUpgrade = false;
        if (!StringUtils.isEmpty((String)errorDetail.toString())) {
            if (this.confirmUpgrade((Component)((Object)this), this.getMultiLangString("PartDataUpgradeError"), errorDetail.toString(), 3)) {
                int count = this.groupId.size();
                for (i = 0; i < count; ++i) {
                    this.getGroupInfoID(this.groupId.get(i).toString());
                }
            } else {
                isDataUpgrade = true;
            }
        }
        if (!isDataUpgrade) {
            int size2 = al.size();
            for (i = 0; i < size2; ++i) {
                dataID = al.get(i).toString();
                idbd.upgrade((IObjectPK)new ObjectUuidPK(dataID), (IObjectPK)new ObjectUuidPK(cuIDs.get(dataID).toString()), (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
            }
            for (String idkey : this.idmap.keySet()) {
                if (igroup instanceof IMaterialGroup) {
                    ((IMaterialGroup)igroup).upgrade((IObjectPK)new ObjectUuidPK(idkey), null, (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
                    continue;
                }
                ((ICSSPGroup)igroup).upgrade((IObjectPK)new ObjectUuidPK(idkey), null, (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
            }
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("UpgradingFinished"));
        }
        this.setCursorOfDefault();
        this.setStatus();
        this.groupId.clear();
        this.idmap.clear();
    }
}

