/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.client.DataBaseGroupUpgradeUI;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DataBaseMaterialGroupUpgradeUI
extends DataBaseGroupUpgradeUI {
    private static final long serialVersionUID = -6954047335531424538L;
    private static final Logger logger = CoreUIObject.getLogger(DataBaseGroupUpgradeUI.class);
    private CtrlUnitInfo curCtrlUnitInfo;
    protected EntityViewInfo eviCommonFilting;
    protected HashMap selItemsForUnassigned = new HashMap();
    private String sqlForAllUpgradableSubordinateCUIDs = "";
    private FilterInfo fiUnimported;
    protected FilterInfo fiRadioButtonsRelated;
    HashMap groupUpgradeCols = new HashMap();

    @Override
    protected void initCtrls() {
        this.kDButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataBaseMaterialGroupUpgradeUI.this.doImport();
                }
                catch (Exception ex) {
                    DataBaseMaterialGroupUpgradeUI.this.setCursorOfDefault();
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.kDButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataBaseMaterialGroupUpgradeUI.this.onClickForButton2();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    @Override
    protected void doImport() throws Exception {
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"groupUpgradeConfirm"));
        if (!MsgBox.isYes((int)result)) {
            SysUtil.abort();
            return;
        }
        this.setCursorOfWair();
        this.storeGroupUpgrade();
        ArrayList al = new ArrayList(this.selItemsForUnassigned.values());
        this.groupUpgradeCols.size();
        IMaterialGroup idbd = (IMaterialGroup)this.getBizInterfaceFromUIContext();
        this.checkSelected(al);
        Hashtable cuIDs = this.getCUIDsByDataIDs(al);
        String dataID = null;
        int size = al.size();
        for (int i = 0; i < size; ++i) {
            dataID = al.get(i).toString();
            idbd.upgrade((IObjectPK)new ObjectUuidPK(dataID), (IObjectPK)new ObjectUuidPK(cuIDs.get(dataID).toString()), (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
        }
        MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("UpgradingFinished"));
        this.setCursorOfDefault();
        this.selItemsForUnassigned.clear();
        this.loadGroupForUpgradeed();
    }

    @Override
    protected void storeGroupUpgrade() {
        int count = this.kDTable1.getRowCount();
        for (int i = 0; i < count; ++i) {
            MaterialGroupInfo csspInfo;
            IRow row = this.kDTable1.getRow(i);
            if (row.getStyleAttributes().isHided() || !((Boolean)row.getCell("selected").getValue()).booleanValue() || this.selItemsForUnassigned.containsValue((csspInfo = (MaterialGroupInfo)((MaterialGroupInfo)row.getCell("csspgroup").getUserObject()).clone()).getId().toString())) continue;
            this.selItemsForUnassigned.put(String.valueOf(row.getRowIndex()), csspInfo.getId().toString());
        }
    }

    @Override
    public CtrlUnitInfo getCurCtrlUnitInfo() {
        return this.curCtrlUnitInfo;
    }

    @Override
    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    KDTable tblAccount = (KDTable)e.getSource();
                    IRow row = tblAccount.getRow(e.getRowIndex());
                    MaterialGroupInfo csspInfo = (MaterialGroupInfo)row.getCell("csspgroup").getUserObject();
                    if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                        DataBaseMaterialGroupUpgradeUI.this.setCSSPSelected(row, csspInfo);
                    } else {
                        row.getCell("selected").setValue((Object)Boolean.FALSE);
                        row.getCell("level").setValue((Object)new Integer(csspInfo.getLevel()));
                        DataBaseMaterialGroupUpgradeUI.this.setCSSPDisSelected(row, csspInfo);
                    }
                    DataBaseMaterialGroupUpgradeUI.this.kDTable1.requestFocus();
                }
            }
        });
        this.loadGroupForUpgradeed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void refreshRowsInTable() {
        this.kDTable1.removeRows();
    }

    @Override
    protected IDataBase getBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("GroupBizInterface");
        assert (o != null);
        return (IDataBase)o;
    }

    @Override
    public void loadFields() {
        try {
            this.loadGroupForUpgradeed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void loadGroupForUpgradeed() throws Exception {
        StringBuffer oql = new StringBuffer(200);
        String longNumber = this.getCurCtrlUnitInfo().getLongNumber();
        oql.append("select id,name,number,parent.name,parent.number,level,isLeaf,longNumber,groupStandard.id,groupStandard.name,groupStandard.number,CU.id,CU.name");
        oql.append(" where deletedStatus=1  and  groupStandard.standardType=1");
        oql.append(" and CU.longNumber like '").append(longNumber + "!%' order by longNumber");
        CoreBaseCollection csspCol = this.getBizInterfaceFromUIContext().getCollection(oql.toString());
        if (csspCol != null) {
            this.kDTable1.checkParsed();
            this.kDTable1.removeRows();
            int count = csspCol.size();
            for (int i = 0; i < count; ++i) {
                Object obj;
                IRow row = this.kDTable1.addRow();
                MaterialGroupInfo csspInfo = (MaterialGroupInfo)csspCol.get(i);
                if (csspInfo.getParent() != null && (obj = this.groupUpgradeCols.get(csspInfo.getParent().getId().toString())) != null) {
                    MaterialGroupUpgradeInfo parent = (MaterialGroupUpgradeInfo)obj;
                    parent.addChild(row);
                }
                MaterialGroupUpgradeInfo acctAssignInfo = new MaterialGroupUpgradeInfo();
                acctAssignInfo.setSelfRow(row);
                this.groupUpgradeCols.put(csspInfo.getId().toString(), acctAssignInfo);
                row.getCell("selected").setValue((Object)false);
                row.getCell("csspgroup").setValue((Object)csspInfo.getNumber());
                row.getCell("csspgroup").setUserObject((Object)csspInfo);
                row.getCell("groupName").setValue((Object)csspInfo.getName());
                row.getCell("level").setValue((Object)new Integer(csspInfo.getLevel()));
                row.getCell("CU").setValue((Object)csspInfo.getCU().getName());
                if (csspInfo.getParent() != null && csspInfo.getParent().getName() != null) {
                    row.getCell("superGroupName").setValue((Object)csspInfo.getParent().getName());
                    row.getCell("superGroupNumber").setValue((Object)csspInfo.getParent().getNumber());
                    continue;
                }
                row.getCell("superGroupName").setValue((Object)"");
                row.getCell("superGroupNumber").setValue((Object)"");
            }
        }
    }

    @Override
    protected EntityViewInfo buildEntityViewInfo() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo(this.fiRadioButtonsRelated.toString());
        evi.setFilter(fi);
        return evi;
    }

    private void onClickForButton2() throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    @Override
    protected String getCurrentCUID() {
        return this.curCtrlUnitInfo.getId().toString();
    }

    @Override
    protected void checkSelected(ArrayList al) {
        if (al.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private Hashtable getCUIDsByDataIDs(ArrayList dataIDs) throws Exception {
        Hashtable<String, String> cuIDs = new Hashtable<String, String>();
        String oql = this.getOQLForDataIDsAndCUIDs(dataIDs);
        DataBaseCollection dbdc = this.getBizInterfaceFromUIContext().getDataBaseCollection(oql);
        DataBaseInfo dbdi = null;
        int n = dbdc.size();
        for (int i = 0; i < n; ++i) {
            dbdi = dbdc.get(i);
            cuIDs.put(dbdi.getId().toString(), dbdi.getCU().getId().toString());
        }
        return cuIDs;
    }

    private String getOQLForDataIDsAndCUIDs(ArrayList dataIDs) {
        StringBuffer oql = new StringBuffer("select id,CU.id where ");
        int groupCount = 50;
        ArrayList idGroup = new ArrayList();
        boolean handledAGroup = false;
        boolean firstGroup = true;
        int n = dataIDs.size();
        for (int i = 0; i < n; ++i) {
            handledAGroup = false;
            idGroup.add(dataIDs.get(i));
            if (i == 0 || i % 50 != 0) continue;
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
            handledAGroup = true;
            firstGroup = false;
            idGroup.clear();
        }
        if (!handledAGroup) {
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
        }
        return oql.toString();
    }

    private String getGroupOQL(ArrayList idGroup) {
        StringBuffer oql = new StringBuffer();
        oql.append("id in ('").append(idGroup.get(0).toString()).append("'");
        int n = idGroup.size();
        for (int i = 1; i < n; ++i) {
            oql.append(",'").append(idGroup.get(i).toString()).append("'");
        }
        oql.append(")");
        return oql.toString();
    }

    @Override
    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.framework.DataBaseDResources", (String)key);
    }

    protected void setCSSPSelected(IRow row, MaterialGroupInfo csspInfo) {
        row.getCell("level").setValue((Object)new Integer(csspInfo.getLevel()));
        this.selectCSSPFromUpper(row, csspInfo);
    }

    protected void setCSSPDisSelected(IRow row, MaterialGroupInfo csspInfo) {
        this.disSelectCSSPFromUpper(row, csspInfo);
    }

    protected void disSelectCSSPFromUpper(IRow row, MaterialGroupInfo csspInfo) {
        this.setDisSelectChildren(csspInfo);
    }

    protected void setDisSelectChildren(MaterialGroupInfo csspInfo) {
        if (csspInfo != null) {
            MaterialGroupUpgradeInfo acctAssignInfo = (MaterialGroupUpgradeInfo)this.groupUpgradeCols.get(csspInfo.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                IRow child = (IRow)children.get(i);
                child.getCell("selected").setValue((Object)Boolean.FALSE);
                MaterialGroupInfo childAcctInfo = (MaterialGroupInfo)child.getCell("csspgroup").getUserObject();
                child.getCell("level").setValue((Object)new Integer(childAcctInfo.getLevel()));
                this.setDisSelectChildren(childAcctInfo);
            }
        }
    }

    @Override
    protected void setSelectedStatusWithAccountFromUpper(IRow row) {
        if (row != null) {
            MaterialGroupInfo acct = (MaterialGroupInfo)row.getCell("csspgroup").getUserObject();
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            row.getCell("level").setValue((Object)new Integer(acct.getLevel()));
            MaterialGroupUpgradeInfo acctAssignInfo = (MaterialGroupUpgradeInfo)this.groupUpgradeCols.get(acct.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                this.setSelectedStatusWithAccountFromUpper((IRow)children.get(i));
            }
        }
    }

    protected void selectCSSPFromUpper(IRow row, MaterialGroupInfo csspInfo) {
        String parentAcctId;
        MaterialGroupUpgradeInfo acctAssignInfo;
        IRow currentRow = row;
        MaterialGroupInfo acct = csspInfo;
        try {
            if (acct.getParent() == null) {
                currentRow.getCell("selected").setValue((Object)Boolean.FALSE);
                currentRow.getCell("level").setValue((Object)new Integer(acct.getLevel()));
                acct = (MaterialGroupInfo)currentRow.getCell("csspgroup").getUserObject();
                currentRow.getCell("selected").setValue((Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        while (acct.getParent() != null && (acctAssignInfo = (MaterialGroupUpgradeInfo)this.groupUpgradeCols.get(parentAcctId = acct.getParent().getId().toString())) != null) {
            currentRow = acctAssignInfo.getSelfRow();
            acct = (MaterialGroupInfo)currentRow.getCell("csspgroup").getUserObject();
            currentRow.getCell("selected").setValue((Object)Boolean.TRUE);
            this.setAcctCtrlLevel(acctAssignInfo);
        }
    }

    protected void setAcctCtrlLevel(MaterialGroupUpgradeInfo acctAssignInfo) {
        if (acctAssignInfo == null || acctAssignInfo.getSelfRow() == null) {
            return;
        }
        IRow row = acctAssignInfo.getSelfRow();
        MaterialGroupInfo acctInfo = (MaterialGroupInfo)row.getCell("csspgroup").getUserObject();
        ArrayList children = acctAssignInfo.getChildren();
        int count = children.size();
        boolean hasSelected = false;
        for (int i = 0; i < count; ++i) {
            IRow child = (IRow)children.get(i);
            if (!((Boolean)child.getCell("selected").getValue()).booleanValue()) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            row.getCell("level").setValue((Object)new Integer(acctInfo.getLevel()));
        } else {
            row.getCell("level").setValue((Object)new Integer(acctInfo.getLevel() + 1));
        }
    }

    @Override
    protected void setDisSelectChildren(AccountViewInfo acctInfo) {
        if (acctInfo != null) {
            MaterialGroupUpgradeInfo acctAssignInfo = (MaterialGroupUpgradeInfo)this.groupUpgradeCols.get(acctInfo.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                IRow child = (IRow)children.get(i);
                child.getCell("selected").setValue((Object)Boolean.FALSE);
                AccountViewInfo childAcctInfo = (AccountViewInfo)child.getCell("csspgroup").getUserObject();
                child.getCell("level").setValue((Object)new Integer(childAcctInfo.getGLevel()));
                this.setDisSelectChildren(childAcctInfo);
            }
        }
    }

    protected class MaterialGroupUpgradeInfo {
        IRow selfRow = null;
        ArrayList children = new ArrayList();

        public IRow getSelfRow() {
            return this.selfRow;
        }

        public void setSelfRow(IRow row) {
            this.selfRow = row;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public void addChild(IRow child) {
            this.children.add(child);
        }
    }
}

