/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseSIEditUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class DataBaseSIEditUI
extends AbstractDataBaseSIEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseSIEditUI.class);
    protected ClientControlStrategy ccStrategy = null;
    private String controlType = null;
    private String currentCUID = null;
    private static final String CONTROL_TYPE_NAME = "controlType";

    public DataBaseSIEditUI() throws Exception {
        this.initStrategy();
        this.disableMovingButtonsWhenTypeS();
    }

    private void initStrategy() {
        String controlType = this.getControlType();
        this.ccStrategy = ClientControlStrategy.create(controlType, null);
    }

    private void disableMovingButtonsWhenTypeS() {
        if (this.getControlType().equals("S1") || this.getControlType().equals("S2") || this.getControlType().equals("S3") || this.getControlType().equals("S4")) {
            this.btnFirst.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnPre.setVisible(false);
        }
    }

    private String getControlType() {
        try {
            if (this.controlType == null) {
                this.controlType = ControlTypeUtil.getControlType(this.getBizType());
            }
            return this.controlType;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanAdd();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanAdd();
        super.actionCopy_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.ccStrategy.checkCanUpdate(this.editData.getId().toString());
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.ccStrategy.checkCanDelete(this.editData.getId().toString());
        }
        super.actionRemove_actionPerformed(e);
    }
}

