/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseSIListUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class DataBaseSIListUI
extends AbstractDataBaseSIListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseSIListUI.class);
    private ClientControlStrategy cStrategy = null;
    private String controlType = null;

    private ClientControlStrategy getStrategy() {
        if (this.cStrategy != null) {
            return this.cStrategy;
        }
        String controlType = this.getControlType();
        this.cStrategy = ClientControlStrategy.create(controlType, null);
        return this.cStrategy;
    }

    protected String getControlType() {
        try {
            if (this.controlType == null) {
                this.controlType = ControlTypeUtil.getControlType(this.getBizType());
            }
            return this.controlType;
        }
        catch (Exception e) {
            return "";
        }
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private String getCUIDFromBizobject() throws Exception {
        this.checkSelected();
        return this.getICGF().getCUID(this.getSelectedKeyValue());
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = null;
        fi = this.getControlType() != null && !this.getControlType().equals("") ? this.getStrategy().getDefaultFilterForControlType() : super.getDefaultFilterForQuery();
        return fi;
    }

    protected void checkPermission(String action, String cuID) throws Exception {
        this.getStrategy().checkPermission(action, cuID);
    }

    public void setCurrentCUID(String currentCUID) {
        this.getStrategy().setCurrentCUID(currentCUID);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_DELETE", this.getCUIDFromBizobject());
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_MODIFY", this.getCUIDFromBizobject());
        super.actionEdit_actionPerformed(e);
    }
}

