/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseSITreeDetailListUI;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public abstract class DataBaseSITreeDetailListUI
extends AbstractDataBaseSITreeDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseSITreeDetailListUI.class);
    private static final String CONTROL_TYPE_NAME = "controlType";
    private String controlType = null;
    private String controlTypeOfTree = null;
    private String currentCUID = null;
    private static final String FILTERFIELD_CUID = "CU.id";
    private static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
    private static final String CONTROLTYPE_S1 = "S1";
    private static final String CONTROLTYPE_S2 = "S2";
    private static final String CONTROLTYPE_S3 = "S3";
    private static final String CONTROLTYPE_S4 = "S4";
    private static final String CONTROLTYPE_I = "I";
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_MODIFY = "ACTION_MODIFY";
    private static final String ACTION_MOVEDATA = "ACTION_MOVEDATA";
    private static final String ACTION_ADDNEW_TREE = "ACTION_ADDNEW_TREE";
    private static final String ACTION_DELETE_TREE = "ACTION_DELETE_TREE";
    private static final String ACTION_MODIFY_TREE = "ACTION_MODIFY_TREE";
    private static final String ACTION_MOVE_TREE = "ACTION_MOVE_TREE";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getControlType() {
        if (this.controlType == null) {
            try {
                this.controlType = this.getControlTypeInnerly(this.getBizInterface());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return this.controlType;
    }

    protected String getControlTypeOfTree() {
        if (this.controlTypeOfTree == null) {
            try {
                this.controlTypeOfTree = this.getControlTypeInnerly((ICoreBase)this.getTreeInterface());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return this.controlTypeOfTree;
    }

    private String getControlTypeInnerly(ICoreBase icb) {
        String controlType = "";
        EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(icb.getType());
        if (eoi.containsExtendedPropertyKey(CONTROL_TYPE_NAME)) {
            controlType = eoi.getExtendedProperty(CONTROL_TYPE_NAME);
        }
        return controlType;
    }

    protected String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = this.getCurrentCU().getId().toString();
        }
        return this.currentCUID;
    }

    protected CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private String getCUIDFromBizobject() throws Exception {
        this.checkSelected();
        return this.getICGF().getCUID(this.getSelectedKeyValue());
    }

    private String getCUIDFromBizobjectOfTree(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        String treeNodeObjID = this.getSelectedTreeNodeObjectID();
        String cuid = "";
        if (!treeNodeObjID.equals("")) {
            cuid = this.getICGF().getCUID(treeNodeObjID);
        }
        return cuid;
    }

    private String getSelectedTreeNodeObjectID() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String objID = "";
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            objID = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
        }
        return objID;
    }

    private FilterInfo getDefaultFilterForControlTypeI() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)this.getCurrentCUID(), CompareType.EQUALS));
        return fi;
    }

    private FilterInfo getDefaultFilterForControlTypeS4() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)this.getCurrentCUID()));
        CtrlUnitInfo cui = this.getCurrentCU();
        String ln = cui.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo(FILTERFIELD_CULONGNUMBER, lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = null;
        if (this.getControlType() != null && !this.getControlType().equals("")) {
            if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_I)) {
                fi = this.getDefaultFilterForControlTypeI();
            } else if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) {
                fi = this.getDefaultFilterForControlTypeS4();
            }
        } else {
            fi = super.getDefaultFilterForQuery();
        }
        return fi;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fi = null;
        try {
            if (this.getControlTypeOfTree().equalsIgnoreCase(CONTROLTYPE_S4)) {
                CtrlUnitInfo cui = this.getCurrentCU();
                String cuID = cui.getId().toString();
                String cuLongNumber = cui.getLongNumber();
                fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4(cuID, cuLongNumber);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception:getControlTypeOfTreeEntity()");
        }
        return fi;
    }

    private void checkPermission(String action) throws Exception {
        if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase(CONTROLTYPE_S3) || this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCUID().equals(this.getCUIDFromBizobject())) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private void checkPermissionOfTree(String action, ActionEvent e) throws Exception {
        String cuid;
        if (this.getControlTypeOfTree().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if (!(!this.getControlTypeOfTree().equalsIgnoreCase(CONTROLTYPE_S3) && !this.getControlTypeOfTree().equalsIgnoreCase(CONTROLTYPE_S4) || action.equals(ACTION_ADDNEW_TREE) || (cuid = this.getCUIDFromBizobjectOfTree(e)).equals("") || this.getCurrentCUID().equals(cuid))) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (action.equals(ACTION_MOVEDATA)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (action.equals(ACTION_ADDNEW_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADDTREE);
        }
        if (action.equals(ACTION_DELETE_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_REMOVETREE);
        }
        if (action.equals(ACTION_MODIFY_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MODIFYTREE);
        }
        if (action.equals(ACTION_MOVE_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MOVETREE);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_ADDNEW);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_DELETE);
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_MODIFY);
        super.actionEdit_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_MOVEDATA);
        super.actionMoveTree_actionPerformed(e);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermissionOfTree(ACTION_ADDNEW_TREE, e);
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermissionOfTree(ACTION_DELETE_TREE, e);
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermissionOfTree(ACTION_MODIFY_TREE, e);
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermissionOfTree(ACTION_MOVE_TREE, e);
        super.actionGroupMoveTree_actionPerformed(e);
    }
}

