/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.framework.client.AbstractDataBaseSITreeListUI;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class DataBaseSITreeListUI
extends AbstractDataBaseSITreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBaseSITreeListUI.class);
    private String currentCUID = null;
    private static final String ACTION_MOVEDATA = "ACTION_MOVEDATA";
    private ClientControlStrategy ccStrategy = null;
    private String controlTypeOfTree = null;

    public DataBaseSITreeListUI() throws Exception {
        this.initStrategy();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initStrategy() {
        String controlType = this.getControlType();
        this.ccStrategy = ClientControlStrategy.create(controlType, null);
    }

    protected String getControlType() {
        try {
            return ControlTypeUtil.getControlType(this.getBizType());
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return this.currentCUID;
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private String getCUIDFromBizobject() throws Exception {
        this.checkSelected();
        return this.getICGF().getCUID(this.getSelectedKeyValue());
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = null;
        fi = this.getControlType() != null && !this.getControlType().equals("") ? this.ccStrategy.getDefaultFilterForControlType() : super.getDefaultFilterForQuery();
        return fi;
    }

    private void checkPermission(String action, String cuID) throws Exception {
        this.ccStrategy.checkPermission(action, cuID);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_DELETE", this.getCUIDFromBizobject());
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_MODIFY", this.getCUIDFromBizobject());
        super.actionEdit_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_MOVEDATA, null);
        super.actionMoveTree_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fi = null;
        try {
            if (this.getControlTypeOfTree().equalsIgnoreCase("S4")) {
                CtrlUnitInfo cui = SysContext.getSysContext().getCurrentCtrlUnit();
                String cuID = cui.getId().toString();
                String cuLongNumber = cui.getLongNumber();
                fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4(cuID, cuLongNumber);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception:getControlTypeOfTreeEntity()");
        }
        return fi;
    }

    protected String getControlTypeOfTree() {
        try {
            return ControlTypeUtil.getControlType(this.getTreeInterface().getType());
        }
        catch (Exception e) {
            return "";
        }
    }
}

