/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.ControlTypeEnum;
import com.kingdee.eas.basedata.framework.EntityControlTypeCollection;
import com.kingdee.eas.basedata.framework.EntityControlTypeFactory;
import com.kingdee.eas.basedata.framework.EntityControlTypeInfo;
import com.kingdee.eas.basedata.framework.IEntityControlType;
import com.kingdee.eas.basedata.framework.client.AbstractEntityControlTypeListUI;
import com.kingdee.eas.basedata.framework.client.ControlModeListUI;
import com.kingdee.eas.basedata.framework.client.ControlModeTreeListUI;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.client.DataBaseDListUI;
import com.kingdee.eas.basedata.framework.client.DataBaseDTreeDetailListUI;
import com.kingdee.eas.basedata.framework.client.DataBaseSIListUI;
import com.kingdee.eas.basedata.framework.client.EntityControlTypeEditUI;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class EntityControlTypeListUI
extends AbstractEntityControlTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityControlTypeListUI.class);
    public static final String ENTITYSYSNAME = "com_kingdee_eas_base_subsystemEntity";
    private EntityControlTypeCollection coll = null;

    public EntityControlTypeListUI() throws Exception {
        this.initUI();
        this.getEntityControlTypeColl();
        this.initEntityTree();
        this.addTreeListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initUI() {
        this.actionAddNew.setEnabled(false);
        this.actionQuery.setVisible(false);
    }

    private void initEntityTree() {
        DefaultKingdeeTreeNode rootNode = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)ENTITYSYSNAME)));
        this.treeEntity.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
    }

    private void removeNotControlModeEntity(DefaultKingdeeTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            MetaDataBriefInfo entity = (MetaDataBriefInfo)childNode.getUserObject();
            if (childNode.getChildCount() != 0 || this.isControlTypeInfo(entity)) continue;
            this.treeEntity.removeNodeFromParent((MutableTreeNode)childNode);
            --i;
        }
    }

    private void addTreeListener() {
        MyTreeListener listener = new MyTreeListener();
        this.treeEntity.addTreeSelectionListener((TreeSelectionListener)listener);
        this.treeEntity.addTreeExpansionListener((TreeExpansionListener)listener);
    }

    private void displaySltNodeData(DefaultKingdeeTreeNode sltNode) {
        MetaDataBriefInfo entity = (MetaDataBriefInfo)sltNode.getUserObject();
        String bosType = entity.getBOType().toString();
        try {
            EntityControlTypeInfo info = null;
            info = this.getEntityControlTypeFromDB(bosType);
            if (info == null) {
                info = this.getEntityControlType(entity);
            }
            this.setUIActionStatus(info != null);
            this.displayDataOnTable(info);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private EntityControlTypeInfo getEntityControlTypeFromDB(String bosType) throws Exception {
        EntityControlTypeInfo info = null;
        IEntityControlType ect = (IEntityControlType)this.getBizInterface();
        EntityControlTypeCollection coll = ect.getEntityControlTypeCollection(" where entityObjectType = '" + bosType + "'");
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
            String listUIName = this.getListUIFromExtendsProp(BOSObjectType.create((String)bosType));
            info.setListUIName(listUIName);
            String implementMode = this.getImplementMode(listUIName);
            info.setImpleMode(implementMode);
        }
        return info;
    }

    private boolean isControlTypeInfo(MetaDataBriefInfo entity) {
        if (entity == null || entity.getBOType() == null) {
            return false;
        }
        String bosType = entity.getBOType().toString();
        Object info = null;
        boolean isControlType = false;
        boolean hasControlType = false;
        try {
            String listUIName = this.getListUIFromExtendsProp(entity.getBOType());
            String implementMode = this.getImplementMode(listUIName);
            if (!StringUtils.isEmpty((String)implementMode)) {
                isControlType = true;
            }
        }
        catch (Exception e) {
            info = null;
        }
        return isControlType;
    }

    private void setUIActionStatus(boolean enable) {
        this.actionEdit.setEnabled(enable);
        this.actionRemove.setEnabled(enable);
    }

    private boolean isSelectedLeaf() {
        if (this.treeEntity.getSelectionPath() == null) {
            return false;
        }
        DefaultKingdeeTreeNode sltNode = (DefaultKingdeeTreeNode)this.treeEntity.getSelectionPath().getLastPathComponent();
        if (sltNode == null) {
            return false;
        }
        return sltNode.isLeaf();
    }

    private void displayDataOnTable(EntityControlTypeInfo info) {
        this.tblMain.removeRows();
        if (info == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)info.getId());
        row.getCell("entityObjectType").setValue((Object)info.getEntityObjectType());
        row.getCell("entityName").setValue((Object)info.getEntityName());
        row.getCell("controlType").setValue((Object)info.getControlType());
        row.getCell("listUIName").setValue((Object)info.getListUIName());
        row.getCell("listUIDesc").setValue((Object)info.getListUIDesc());
        row.setUserObject((Object)info);
        this.tblMain.getSelectManager().select(0, 0);
    }

    private void getEntityControlTypeColl() throws Exception {
        IEntityControlType ect = (IEntityControlType)this.getBizInterface();
        this.coll = ect.getEntityControlTypeCollection();
    }

    private EntityControlTypeInfo getEntityControlType(MetaDataBriefInfo entity) throws Exception {
        EntityControlTypeInfo info = new EntityControlTypeInfo();
        String type = ControlTypeUtil.getControlType(entity.getBOType());
        if (StringUtils.isEmpty((String)type)) {
            return null;
        }
        info.setControlType(ControlTypeEnum.getEnum(type));
        info.setEntityObjectType(entity.getBOType().toString());
        info.setEntityName(entity.getAlias(new Locale("l1")), new Locale("l1"));
        info.setEntityName(entity.getAlias(new Locale("l2")), new Locale("l2"));
        info.setEntityName(entity.getAlias(new Locale("l3")), new Locale("l3"));
        String listUIName = this.getListUIFromExtendsProp(entity.getBOType());
        info.setListUIName(listUIName);
        String implementMode = this.getImplementMode(listUIName);
        info.setImpleMode(implementMode);
        return info;
    }

    private String getListUIFromExtendsProp(BOSObjectType type) throws Exception {
        String listUIName = ControlTypeUtil.getListUIName(type);
        if (StringUtils.isEmpty((String)listUIName)) {
            return null;
        }
        return listUIName;
    }

    private String getImplementMode(String listUIName) throws Exception {
        if (listUIName == null) {
            return null;
        }
        Class<?> uiClass = Class.forName(listUIName);
        String implementsMode = "NOMODE";
        if (DataBaseSIListUI.class.isAssignableFrom(uiClass)) {
            implementsMode = "SIMODE";
        } else if (DataBaseDListUI.class.isAssignableFrom(uiClass) || DataBaseDTreeDetailListUI.class.isAssignableFrom(uiClass)) {
            implementsMode = "DMODE";
        } else if (ControlModeListUI.class.isAssignableFrom(uiClass) || ControlModeTreeListUI.class.isAssignableFrom(uiClass)) {
            implementsMode = "ALLMODE";
        } else {
            return null;
        }
        return implementsMode;
    }

    private EntityControlTypeInfo getEntityControlTypeFromColl(String bosType) throws Exception {
        EntityControlTypeInfo info = null;
        if (this.coll != null) {
            for (int i = 0; i < this.coll.size(); ++i) {
                EntityControlTypeInfo tmpInfo = this.coll.get(i);
                if (tmpInfo == null || !tmpInfo.getEntityObjectType().equals(bosType)) continue;
                info = tmpInfo;
            }
        }
        return info;
    }

    protected String getEditUIName() {
        return EntityControlTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EntityControlTypeFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        if (this.getSelectedKeyValue() == null) {
            if (!this.isSelectedLeaf()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.framework.FRAMEWORKAutoGenerateResource", (String)"12_EntityControlTypeListUI"));
                return;
            }
            this.actionAddNew_actionPerformed(e);
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        if (this.tblMain.getRow(selectIndex) != null) {
            uiContext.put((Object)"controlTypeInfo", this.tblMain.getRow(selectIndex).getUserObject());
        }
        if (this.getSelectedKeyValue() == null) {
            uiContext.put((Object)"isAddnew", (Object)Boolean.TRUE);
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.displaySltNodeData((DefaultKingdeeTreeNode)this.treeEntity.getSelectionPath().getLastPathComponent());
    }

    private class MyTreeListener
    implements TreeSelectionListener,
    TreeExpansionListener {
        private MyTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultKingdeeTreeNode sltNode = null;
            if (e.getNewLeadSelectionPath() != null) {
                sltNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            }
            if (sltNode == null) {
                return;
            }
            if (!sltNode.isLeaf()) {
                EntityControlTypeListUI.this.tblMain.removeRows();
                return;
            }
            EntityControlTypeListUI.this.displaySltNodeData(sltNode);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            DefaultKingdeeTreeNode sltNode = null;
            if (e.getPath() != null) {
                sltNode = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
            }
            if (sltNode == null) {
                return;
            }
            if (!sltNode.isLeaf()) {
                EntityControlTypeListUI.this.removeNotControlModeEntity(sltNode);
                return;
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

