/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.basedata.framework.client.AbstractMasterDataAttributeListUIHelper;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.client.MaterialPlanListUI;
import com.kingdee.eas.basedata.master.material.util.commonUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.service.TableSelectionHelper;
import com.kingdee.eas.framework.client.ListUI;
import java.awt.Color;
import java.util.HashMap;

public class MaterialPlanUIHelper
extends AbstractMasterDataAttributeListUIHelper {
    private static final Color UNAPPROVEColor = new Color(255, 255, 193);
    private static final Color freezeColor = new Color(232, 232, 227);
    private OrgUnitInfo[] permOrgs = null;
    TableSelectionHelper tableSelectionHelper;

    public MaterialPlanUIHelper(OrgType mainOrgType) {
        super(mainOrgType);
    }

    protected ListUI createListUI() throws Exception {
        this.ui = new MaterialPlanListUI();
        this.permOrgs = this.getAuthorizedBizOrgUnits(this.mainOrgType);
        return this.ui;
    }

    public void initCtrl(ListUI listUI) {
        listUI.getMainTable().addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                MaterialPlanUIHelper.this.setPlanDynPrecision(e.getFirstRow(), e.getLastRow());
                MaterialPlanUIHelper.this.setTreeDisplayStyle(e.getFirstRow(), e.getLastRow());
            }
        });
        this.setPlanStaticPrecision(listUI.getMainTable());
    }

    private void setPlanDynPrecision(int begin, int last) {
        KDTable tblMain = this.ui.getMainTable();
        String[] unitPrecisionColumns = new String[]{"materialPlan.fixationBatchQty", "materialPlan.maxBatchQty", "materialPlan.minBatchQty", "materialPlan.batchIncQty"};
        for (int rowIndex = begin; rowIndex < last + 1; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < unitPrecisionColumns.length; ++columnIndex) {
                Integer unitPrecision = (Integer)tblMain.getRow(rowIndex).getCell("unitPrecision").getValue();
                ICell cell = tblMain.getRow(rowIndex).getCell(unitPrecisionColumns[columnIndex]);
                if (cell == null || unitPrecision == null) continue;
                cell.getStyleAttributes().setNumberFormat(commonUtils.getNumberFormat((int)unitPrecision, (boolean)true));
            }
        }
    }

    private void setTreeDisplayStyle(int begin, int last) {
        KDTable tblMain = this.ui.getMainTable();
        for (int rowIndex = begin; rowIndex < last + 1; ++rowIndex) {
            IRow row = tblMain.getRow(rowIndex);
            if (row.getCell("materialPlan.status") == null) continue;
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("materialPlan.status").getValue();
            if (state != null && state.getInt() == 2) {
                row.getStyleAttributes().setBackground(freezeColor);
            }
            if (state == null || state.getInt() != 0) continue;
            row.getStyleAttributes().setBackground(UNAPPROVEColor);
        }
    }

    private void setPlanStaticPrecision(KDTable talbe) {
        IColumn column;
        int columnIndex;
        String[] rateColumns = new String[]{"materialPlan.yield", "materialPlan.scrapRate", "materialPlan.issInHightLimit", "materialPlan.issInLowLimit", "materialPlan.rptInHightLimit", "materialPlan.rptInLowLimit", "materialPlan.rcvInHightLimit", "materialPlan.rcvInLowLimit"};
        String[] qtyColumns = new String[]{"materialPlan.reBookQty", "materialPlan.consumeSpeed", "materialPlan.roundUpMulitpleQty"};
        for (columnIndex = 0; columnIndex < rateColumns.length; ++columnIndex) {
            column = talbe.getColumn(rateColumns[columnIndex]);
            column.getStyleAttributes().setNumberFormat(commonUtils.getNumberFormat((int)2, (boolean)true));
        }
        for (columnIndex = 0; columnIndex < qtyColumns.length; ++columnIndex) {
            column = talbe.getColumn(qtyColumns[columnIndex]);
            column.getStyleAttributes().setNumberFormat(commonUtils.getNumberFormat((int)4, (boolean)true));
        }
    }

    public String getOnloadPermItemName() {
        return "bd_materialPlan_view";
    }

    public String getNumberColumns() {
        String sColumns = "materialPlan.isDemandAssign,materialPlan.check,materialPlan.keyPart,materialPlan.firstCheck,materialPlan.isProductLinePlan,materialPlan.isMergeSign,materialPlan.isBackFlush,materialPlan.isQuotaControl,materialPlan.isConfigable,materialPlan.isStockAllot,materialPlan.isCentralizedPar,materialPlan.isReportingLimit,materialPlan.isStorageLimit";
        return sColumns;
    }

    public Class getClzIBizFactory(ActionLevelEnum actionLevel) {
        return MaterialPlanFactory.class;
    }

    public ITableSelectionHelper getTableSelectionHelper() {
        if (this.tableSelectionHelper == null) {
            this.tableSelectionHelper = new TableSelectionHelper(this.ui);
            this.tableSelectionHelper.setTableProperty(this.getMainListUI(), this.getMainListUI().getMainQueryPK(), this.getMainListUI().getMainTable(), "assid", null, "number", null, "CU.id");
            HashMap<String, String> col2query = new HashMap<String, String>();
            col2query.put("assid", "materialPlan.id");
            this.tableSelectionHelper.setColMapQueryName(col2query);
        }
        return this.tableSelectionHelper;
    }

    public String getActionMethod(BatchActionEnum actionEnum) {
        if (actionEnum.equals((Object)BatchActionEnum.AUDIT)) {
            return "approve";
        }
        if (actionEnum.equals((Object)BatchActionEnum.UNAUDIT)) {
            return "unApprove";
        }
        if (actionEnum.equals((Object)BatchActionEnum.DISABLE)) {
            return "freeze";
        }
        if (actionEnum.equals((Object)BatchActionEnum.ENABLE)) {
            return "unFreeze";
        }
        return null;
    }
}

