/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialCheckInfoEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.QuotaPeriodEnum;
import com.kingdee.eas.basedata.master.material.QuotaPolicyCollection;
import com.kingdee.eas.basedata.master.material.QuotaPolicyFactory;
import com.kingdee.eas.basedata.master.material.QuotaPolicyInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialPurchasingUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.master.material.util.MaterialStringUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialPurchasingUI
extends AbstractMaterialPurchasingUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialPurchasingUI.class);
    private HashMap parentCTX = null;
    private String materialID = null;
    EventsListener event = new EventsListener();
    private MaterialInfo material = null;
    private int pricePrecision = 0;
    PurchaseOrgUnitInfo purOrg = null;
    ItemChangeListener itemListener = new ItemChangeListener();
    private boolean tag = false;
    private CtrlUnitInfo curCtrlUnitInfo;

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.purOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.purOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        MaterialClientTools.addCloseButton((KDToolBar)this.toolBar, (EditUI)this);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.purOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.purOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
        this.tag = false;
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        this.loadPurCheckEnum();
        super.loadFields();
        this.addEventsListener();
        MaterialClientTools.setF7MeasureUnit((KDBizPromptBox)this.prmtUnit, (String)this.materialID);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtPrice, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.pricePrecision);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtPriceTop, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.pricePrecision);
        this.setSubmitSaveButton();
        this.setMinDivisionQtyPrecisionByPurUnit();
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtReceiveTopRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.MAXVAL_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)0, (Number)new Integer(this.editData.getReceiveTopRatio()));
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtReceiveBottomRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)0, (Number)new Integer(this.editData.getReceiveBottomRatio()));
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtChangePriceProportion, (boolean)true, (boolean)true, (Comparable)MaterialStringUtils.MAXVAL_BigDecimal_ChangePriceProportion, (Comparable)MaterialStringUtils.MINVAL_BigDecimal_ChangePriceProportion, (int)4);
        if (this.txtChangePriceProportion.getNumberValue() == null) {
            this.txtChangePriceProportion.setNumberValue((Number)new BigDecimal("0"));
        }
        this.txtChangePriceProportion.setRemoveingZeroInDispaly(true);
        if (this.editData != null) {
            this.setPurGroupFilter(this.editData.getOrgUnit());
        }
        try {
            this.setComboQuotaPolicyValue();
            this.storeFields();
            FullOrgUnitInfo org = null;
            if (this.editData != null) {
                org = this.editData.getOrgUnit();
            }
            MaterialUtil.setQualityOrgF7((KDBizPromptBox)this.prmtQualityOrg, (OrgUnitInfo)org, (int)3, (int)32);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    private void IsPurchaseCheck_stateChanged() {
        if (this.chkIsPurchaseCheck.isSelected()) {
            this.prmtQualityOrg.setRequired(true);
        } else {
            this.prmtQualityOrg.setRequired(false);
        }
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private void doInit() throws Exception {
        NewPurchaseF7 purOrgF7 = new NewPurchaseF7();
        purOrgF7.setMultiSelect(false);
        purOrgF7.setIsCUFilter(true, false);
        purOrgF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)purOrgF7);
        this.prmtAppointPurOrgUnit.setSelector((KDPromptSelector)purOrgF7);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)purOrgF7);
        this.prmtOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtAppointPurOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaydAhead, (int)0, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaysDelay, (int)0, (int)-1);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtReceiveTopRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.MAXVAL_INT, (Comparable)new Integer(this.editData.getReceiveTopRatio()), (int)0, (Number)MaterialClientTools.ZERO_INT);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtReceiveBottomRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)new Integer(this.editData.getReceiveBottomRatio()), (int)0, (Number)MaterialClientTools.ZERO_INT);
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
        selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtSupplier, (Component)new F7SupplierTreeDetailListUI(), (Object)this, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQueryWithDefaultStandard", "browseGroup.id");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (null != this.purOrg) {
            filterInfo.getFilterItems().add(new FilterItemInfo("purChaseOrgUnit.id", (Object)this.purOrg.getId().toString(), CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        this.prmtSupplier.setEntityViewInfo(entityViewInfo);
        this.prmtSupplier.setSelector((KDPromptSelector)selectorLisenterSupplier);
        this.prmtSupplier.addSelectorListener((SelectorListener)selectorLisenterSupplier);
    }

    private void loadPurCheckEnum() {
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentPurchaseUnit() != null && SysContext.getSysContext().getCurrentPurchaseUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.purOrg = SysContext.getSysContext().getCurrentPurchaseUnit();
        } else if (curCtrlUnitInfo.isIsPurchaseOrgUnit()) {
            this.purOrg = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public void onLoad() throws Exception {
        if (this.editData == null) {
            this.parentCTX = MaterialClientTools.getParentCTX((EditUI)this);
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.parentCTX.get("CurrentCtrlUnit");
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.initDefaultOrgUnit(this.curCtrlUnitInfo);
            this.getMaterialID();
            this.getDefaultPurchaseInfo();
            MaterialClientTools.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"material"));
        }
        this.setPurGroupFilter(this.purOrg);
        this.setPrintEnable();
        this.initQuotaPolicy();
        super.onLoad();
        try {
            this.doInit();
            if (this.isFirstOnload()) {
                this.initInFirstOnload();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtOrgUnit.setEnabled(true);
        this.prmtOrgUnit.setAccessAuthority(0);
        this.pkCreateTime.setDatePattern("yyyy-MM-dd");
        this.pkLastUpdateTime.setDatePattern("yyyy-MM-dd");
        this.chkUseSupplyPrice.setEnabled(false);
        this.chkUseSupplyPrice.setVisible(false);
        this.comboQuotaPeriod.removeItem((Object)QuotaPeriodEnum.NULL);
    }

    protected void prmtPurchaseGroup_dataChanged() throws Exception {
        PurchaseGroupInfo purGroupInfo = (PurchaseGroupInfo)this.prmtPurchaseGroup.getValue();
        if (purGroupInfo != null && purGroupInfo.getId() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(" select FPersonID from T_BD_PurchasePerson where FDeletedStatus = 1 ");
            sb.append("  and FPurGroupID = '").append(purGroupInfo.getId().toString()).append("'");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
            viewInfo.setFilter(filterInfo);
            this.prmtPurPerson.setEntityViewInfo(viewInfo);
        } else {
            this.prmtPurPerson.setEntityViewInfo(null);
        }
    }

    private void getDefaultPurchaseInfo() throws BOSException {
        if (this.materialID != null) {
            MaterialPurchasingInfo purInfo = null;
            MaterialPurchasingCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.materialID));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("orgunit.id"));
            colls = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(viewInfo);
            if (this.purOrg != null && this.purOrg.getId() != null) {
                purInfo = this.getPurInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)this.purOrg.getId().toString(), (String)"material.id", (String)this.materialID));
            }
            if (colls != null) {
                RealModeIDList idLists = new RealModeIDList();
                int currentPKIndex = -1;
                for (int i = 0; i < colls.size(); ++i) {
                    MaterialPurchasingInfo info = colls.get(i);
                    idLists.add(i, info.getId().toString());
                    if (purInfo == null || !info.getOrgUnit().getId().toString().equals(purInfo.getOrgUnit().getId().toString())) continue;
                    currentPKIndex = i;
                    this.getUIContext().put("ID", purInfo.getId().toString());
                    this.tag = false;
                }
                if (currentPKIndex == -1 && idLists != null && idLists.size() != 0) {
                    currentPKIndex = 0;
                }
                idLists.setCurrentIndex(currentPKIndex);
                this.getUIContext().put("IDList", idLists);
            }
            if (purInfo == null) {
                purInfo = (MaterialPurchasingInfo)this.createNewData();
            }
            this.getUIContext().put("InitDataObject", purInfo);
        }
    }

    private MaterialPurchasingInfo getPurInfoByFilter(FilterInfo filterinfo) throws BOSException {
        MaterialPurchasingInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        Iterator t = this.getMergedSelector().iterator();
        while (t.hasNext()) {
            selectors.add((SelectorItemInfo)t.next());
        }
        MaterialPurchasingCollection con = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            info = con.get(0);
        }
        return info;
    }

    private void getMaterialID() {
        if (this.parentCTX == null) {
            MaterialClientTools.getParentCTX((EditUI)this);
        }
        if (this.parentCTX != null) {
            this.materialID = this.parentCTX.get("ID").toString();
            this.material = (MaterialInfo)this.parentCTX.get("MATERIAL_DATA");
            String t = (String)this.parentCTX.get("PRICE_PRECISION");
            if (t != null && t.length() > 0) {
                this.pricePrecision = Integer.parseInt(t);
            }
        }
    }

    private void addEventsListener() {
        this.prmtOrgUnit.addChangeListener((ChangeListener)this.event);
        this.chkIsPurchaseCheck.addChangeListener((ChangeListener)this.event);
        this.prmtPurchaseGroup.addChangeListener((ChangeListener)this.event);
        this.prmtUnit.addChangeListener((ChangeListener)this.event);
        this.comboQuotaPolicy.addItemListener((ItemListener)this.itemListener);
    }

    private void removeEventsListerner() {
        this.prmtOrgUnit.removeChangeListener((ChangeListener)this.event);
        this.chkIsPurchaseCheck.removeChangeListener((ChangeListener)this.event);
        this.prmtUnit.removeChangeListener((ChangeListener)this.event);
        this.comboQuotaPolicy.removeItemListener((ItemListener)this.itemListener);
    }

    public void prmtPurOrg_stateChanged(ChangeEvent e) throws BOSException {
        PurchaseOrgUnitInfo purOrg = (PurchaseOrgUnitInfo)this.prmtOrgUnit.getValue();
        MaterialPurchasingInfo info = null;
        if (purOrg != null) {
            info = this.getPurInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)purOrg.getId().toString(), (String)"material.id", (String)this.materialID));
            this.tag = false;
        }
        if (info == null) {
            info = (MaterialPurchasingInfo)this.createNewData();
            if (purOrg != null) {
                info.setOrgUnit(purOrg.castToFullOrgUnitInfo());
            }
            this.tag = true;
        }
        this.setPurGroupFilter(purOrg);
        this.prmtPurchaseGroup.setValue(null);
        this.setDataObject((IObjectValue)info);
        this.loadFields();
    }

    public void setPurGroupFilter(PurchaseOrgUnitInfo purchOrg) {
        if (purchOrg != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purchOrg.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            this.prmtPurchaseGroup.setEntityViewInfo(viewInfo);
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            this.prmtPurchaseGroup.setEntityViewInfo(viewInfo);
        }
    }

    public void setPurGroupFilter(FullOrgUnitInfo purchOrg) {
        if (purchOrg != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purchOrg.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            this.prmtPurchaseGroup.setEntityViewInfo(viewInfo);
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            this.prmtPurchaseGroup.setEntityViewInfo(viewInfo);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialPurchasingInfo purInfo = new MaterialPurchasingInfo();
        purInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        purInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        purInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        if (this.material != null) {
            purInfo.setMaterial(this.material);
            purInfo.setUnit(this.material.getBaseUnit());
        }
        purInfo.setIsReturn(true);
        purInfo.setCreateTime(new Timestamp(new Date().getTime()));
        purInfo.setReceiveTopRatio(0);
        purInfo.setReceiveBottomRatio(0);
        purInfo.setPurchaseCheck(MaterialCheckInfoEnum.NO_CHECK);
        purInfo.setIsNotControlQty(false);
        purInfo.setIsNotControlTime(false);
        purInfo.setQuotaPeriod(QuotaPeriodEnum.season);
        purInfo.setMinDivisionQty(BigDecimal.ZERO);
        try {
            purInfo.setQuotaPolicy(QuotaPolicyFactory.getRemoteInstance().getQuotaPolicyInfo("where number='005'"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return purInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialPurchasingFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selects = super.getSelectors();
        selects.add("effectedStatus");
        selects.add("status");
        selects.add("material.*");
        return selects;
    }

    private void setSubmitSaveButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
                int vostatus = this.editData.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            return;
        }
        if (this.material != null && this.material.getStatus() == UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (!this.btnRemove.isVisible()) {
                this.menuItemRemove.setEnabled(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setEnabled(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            return;
        }
        this.btnAddNew.setEnabled(true);
        if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
            int vostatus = this.editData.getInt("status");
            if (vostatus == 0) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            }
            this.setActionButtonVisible(vostatus);
            if (this.material != null && this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                this.btnApprove.setEnabled(false);
            }
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            } else if (this.editData != null) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
        }
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setSubmitSaveButton();
        this.doFieldPermission();
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherPurchasing(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherPurchasing(1);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherPurchasing(2);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherPurchasing(3);
    }

    private void doActionOtherPurchasing(int actionenumvalue) throws Exception {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            IMaterialPurchasing ipur = (IMaterialPurchasing)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            MaterialClientTools.doActionOtherProperty((int)actionenumvalue, (MaterialPropertyBaseInfo)this.editData, (IMaterialPropertyBase)ipur, (IObjectPK)pk, (MaterialInfo)this.material);
            IObjectValue newValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("InitDataObject", newValue);
            this.setDataObject(newValue);
            this.loadFields();
        }
    }

    protected void loadData() throws Exception {
        if (this.parentCTX != null && this.materialID != null && !this.materialID.equalsIgnoreCase(this.parentCTX.get("ID").toString())) {
            this.getMaterialID();
            this.getDefaultPurchaseInfo();
        }
        this.getMaterialID();
        if ("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.unLockUI();
        }
        super.loadData();
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)pk, this.getMergedSelector());
            this.setDataObject((IObjectValue)info);
            this.loadFields();
        }
        this.tag = false;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.refreshNotControlQty();
        this.refreshNotControlTime();
    }

    @Override
    public void setOprtState(String oprtType) {
        if (!oprtType.equalsIgnoreCase(this.getOprtState())) {
            super.setOprtState(oprtType);
            if (this.parentCTX != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.parentCTX.put("MATERIAL_UI_STATUS", oprtType);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strMsg = null;
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        if (this.editData.getOrgUnit() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"PurOU_NOT_NULL");
            this.prmtOrgUnit.requestFocus();
            MaterialClientTools.showError((String)strMsg);
        }
        if (e.getSource().equals(this.btnSubmit) || e.getSource().equals(this.menuItemSubmit)) {
            if (this.editData.getUnit() == null) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"PurUnit_NOT_NULL");
                this.prmtUnit.requestFocus();
                MaterialClientTools.showError((String)strMsg);
            }
            if (this.editData.getPrice() == null) {
                this.editData.setPrice(MaterialClientTools.ZERO_BigDecimal);
            }
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("InitDataObject", this.editData);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tag) {
            this.loadData();
        } else {
            super.actionRemove_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() == null) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", null);
        }
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    @Override
    protected void chkIsNotControlQty_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsNotControlQty_stateChanged(e);
        this.refreshNotControlQty();
    }

    private void refreshNotControlQty() {
        this.txtReceiveTopRatio.setEnabled(!this.chkIsNotControlQty.isSelected());
        this.txtReceiveBottomRatio.setEnabled(!this.chkIsNotControlQty.isSelected());
        if (this.chkIsNotControlQty.isSelected()) {
            this.txtReceiveTopRatio.setMinimumValue((Comparable)MaterialClientTools.ZERO_INT);
            this.txtReceiveBottomRatio.setMinimumValue((Comparable)MaterialClientTools.ZERO_INT);
            this.txtReceiveTopRatio.setValue((Object)MaterialClientTools.ZERO_INT);
            this.txtReceiveBottomRatio.setValue((Object)MaterialClientTools.ZERO_INT);
        }
    }

    private void refreshNotControlTime() {
        this.spDaydAhead.setEnabled(!this.chkIsNotControlTime.isSelected());
        this.spDaysDelay.setEnabled(!this.chkIsNotControlTime.isSelected());
        if (this.chkIsNotControlTime.isSelected()) {
            this.spDaydAhead.setValue((Object)MaterialClientTools.ZERO_INT);
            this.spDaysDelay.setValue((Object)MaterialClientTools.ZERO_INT);
        }
    }

    @Override
    protected void chkIsNotControlTime_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsNotControlTime_stateChanged(e);
        this.refreshNotControlTime();
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public boolean isModify() {
        ArrayList<String> arr1 = new ArrayList<String>();
        arr1.add(new String("tagState"));
        ArrayList<Boolean> arr2 = new ArrayList<Boolean>();
        Boolean boolTag = new Boolean(this.tag);
        arr2.add(0, boolTag);
        this.getUIContext().put(arr1, arr2);
        if (this.prmtOrgUnit.getValue() != null && this.tag) {
            return true;
        }
        return super.isModify();
    }

    protected void addVOChangeListener(IVOChangeListener listener) {
        super.addVOChangeListener(null);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_materialPur_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_materialPur_update";
        }
        return "bd_materialPur_view";
    }

    private void initInFirstOnload() throws Exception {
        this.setMinDivisionQtyPrecisionByPurUnit();
        this.setComboQuotaPeriodEnabledByQuotaPolicy();
    }

    private void initQuotaPolicy() throws Exception {
        QuotaPolicyCollection poc = QuotaPolicyFactory.getRemoteInstance().getQuotaPolicyCollection("order by number");
        if (this.comboQuotaPolicy.getItemCount() <= 0) {
            this.comboQuotaPolicy.addItems(poc.toArray());
        }
    }

    private void setComboQuotaPolicyValue() {
        if (this.editData != null && this.editData.getQuotaPolicy() != null) {
            int index;
            String id = null;
            String currentId = this.editData.getQuotaPolicy().getId().toString();
            int size = this.comboQuotaPolicy.getItemCount();
            for (index = 0; index < size && !currentId.equals(id = ((QuotaPolicyInfo)this.comboQuotaPolicy.getItemAt(index)).get("id").toString()); ++index) {
            }
            this.comboQuotaPolicy.setSelectedIndex(index);
        } else {
            this.comboQuotaPolicy.setSelectedIndex(4);
        }
    }

    private void prmtUnit_dataChanged() {
        this.setMinDivisionQtyPrecisionByPurUnit();
    }

    private void setMinDivisionQtyPrecisionByPurUnit() {
        MeasureUnitInfo purUnit = (MeasureUnitInfo)this.prmtUnit.getValue();
        int precision = 4;
        if (this.materialID != null && purUnit != null && purUnit.getId() != null) {
            try {
                precision = MultiMeasureUnitFactory.getRemoteInstance().getQtyPrecision(this.materialID, purUnit.getId().toString());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (purUnit != null) {
            precision = purUnit.getQtyPrecision();
        }
        this.txtMinDivisionQty.setPrecision(precision);
    }

    private void comboQuotaPolicy_itemChanged(ItemEvent e) {
        this.setComboQuotaPeriodEnabledByQuotaPolicy();
    }

    private void setComboQuotaPeriodEnabledByQuotaPolicy() {
        QuotaPolicyInfo quotaPolicy = (QuotaPolicyInfo)this.comboQuotaPolicy.getSelectedItem();
        if (quotaPolicy != null && "002".equals(quotaPolicy.getNumber())) {
            this.comboQuotaPeriod.setEnabled(true);
        } else {
            this.comboQuotaPeriod.setEnabled(false);
        }
    }

    private class ItemChangeListener
    implements ItemListener {
        private ItemChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (e.getSource().equals(MaterialPurchasingUI.this.comboQuotaPolicy)) {
                    MaterialPurchasingUI.this.comboQuotaPolicy_itemChanged(e);
                }
            }
            catch (Exception ex) {
                MaterialPurchasingUI.this.handUIException(ex);
            }
        }
    }

    private class EventsListener
    implements ChangeListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                if (e.getSource().equals(MaterialPurchasingUI.this.prmtOrgUnit)) {
                    MaterialPurchasingUI.this.prmtPurOrg_stateChanged(e);
                } else if (e.getSource().equals(MaterialPurchasingUI.this.chkIsPurchaseCheck)) {
                    MaterialPurchasingUI.this.IsPurchaseCheck_stateChanged();
                } else if (e.getSource().equals(MaterialPurchasingUI.this.prmtPurchaseGroup)) {
                    MaterialPurchasingUI.this.prmtPurchaseGroup_dataChanged();
                } else if (e.getSource().equals(MaterialPurchasingUI.this.prmtUnit)) {
                    MaterialPurchasingUI.this.prmtUnit_dataChanged();
                }
            }
            catch (Exception ex) {
                MaterialPurchasingUI.this.handUIException(ex);
            }
        }
    }
}

