/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeException;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeFactory;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeInfo;
import com.kingdee.eas.basedata.mm.qm.client.AbstractModifyTypeListUI;
import com.kingdee.eas.basedata.mm.qm.client.KDTableUtils;
import com.kingdee.eas.basedata.mm.qm.client.ModifyTypeEditUI;
import com.kingdee.eas.basedata.mm.qm.utils.QMUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ModifyTypeListUI
extends AbstractModifyTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)ModifyTypeListUI.class);
    private static final String PRECISION_COLUMN = "precision";

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.btnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnUnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.tblMain.setColumnMoveable(true);
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSetForHasQueryPK(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setPrecision();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        viewInfo.setIngorePreOrders(false);
        return exec;
    }

    private void setPrecision() {
        Object o = null;
        int precision = 4;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            o = this.tblMain.getRow(i).getCell(PRECISION_COLUMN).getValue();
            precision = STQMUtils.isNotNull(o) ? new Integer(o.toString()) : 4;
            KDTableUtils.setBigDecimalFieldsPrecision(precision, this.tblMain, i, new String[]{"entries.upper", "entries.lower"});
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setPrecision();
    }

    protected String getEditUIName() {
        return ModifyTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ModifyTypeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ModifyTypeInfo objectValue = new ModifyTypeInfo();
        return objectValue;
    }

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "name", "description", "isUsed", "creator.name", "createTime", "lastUpdateUser.name", "lastUpdateTime"};
    }

    private IObjectPK[] getSelectedListPK() {
        ArrayList listId = this.getSelectedIdValues();
        ObjectStringPK[] ids = new ObjectStringPK[listId.size()];
        if (listId != null && listId.size() > 0) {
            int num = listId.size();
            for (int i = 0; i < num; ++i) {
                ids[i] = new ObjectStringPK(listId.get(i).toString());
            }
        }
        return ids;
    }

    protected boolean isMutexControlOK(String id) {
        if (id == null) {
            return false;
        }
        try {
            this.pubFireVOChangeListener(id);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request"));
            return false;
        }
    }

    protected void releaseMutexControl(String id) {
        try {
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(id);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
    }

    private boolean isUsed(ModifyTypeInfo modifyTypeInfo) {
        boolean isUsed = false;
        if (modifyTypeInfo != null) {
            isUsed = modifyTypeInfo.isIsUsed();
        }
        return isUsed;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK[] pks = this.getSelectedListPK();
        ICoreBase ie = this.getBizInterface();
        ModifyTypeInfo modifyTypeInfo = null;
        if (pks.length > 0 && (modifyTypeInfo = (ModifyTypeInfo)ie.getValue(pks[0])).getId() != null && !this.isMutexControlOK(modifyTypeInfo.getId().toString())) {
            return;
        }
        if (this.isUsed(modifyTypeInfo)) {
            throw new ModifyTypeException(ModifyTypeException.EXC_ENTRY_ISUSED);
        }
        super.actionEdit_actionPerformed(e);
        if (modifyTypeInfo != null && modifyTypeInfo.getId() != null) {
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    public void actionForbid_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        ObjectStringPK[] pks = new ObjectStringPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            Object obj = ids.get(i);
            if (!(obj instanceof String)) continue;
            pks[i] = new ObjectStringPK((String)ids.get(i));
        }
        if (this.tblMain.getSelectManager().size() > 0 && (row = this.tblMain.getRow(this.tblMain.getSelectManager().get().getTop())).getCell("id").getValue() != null && "false".equals(row.getCell("isUsed").getValue().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u5df2\u7981\u7528\u7684\u4fee\u7ea6\u65b9\u5f0f\u4e0d\u80fd\u518d\u6b21\u7981\u7528\uff01");
            return;
        }
        ModifyTypeFactory.getRemoteInstance().forbid((IObjectPK[])pks);
        this.refreshList();
        MsgBox.showInfo((Component)((Object)this), (String)QMUtils.getResource("ModifyTypeForbidOK"));
    }

    public void actionUnForbid_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        ObjectStringPK[] pks = new ObjectStringPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            Object obj = ids.get(i);
            if (!(obj instanceof String)) continue;
            pks[i] = new ObjectStringPK((String)ids.get(i));
        }
        if (this.tblMain.getSelectManager().size() > 0 && (row = this.tblMain.getRow(this.tblMain.getSelectManager().get().getTop())).getCell("id").getValue() != null && "true".equals(row.getCell("isUsed").getValue().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u5df2\u542f\u7528\u7684\u4fee\u7ea6\u65b9\u5f0f\u4e0d\u80fd\u518d\u6b21\u542f\u7528\uff01");
            return;
        }
        ModifyTypeFactory.getRemoteInstance().unForbid((IObjectPK[])pks);
        this.refreshList();
        MsgBox.showInfo((Component)((Object)this), (String)QMUtils.getResource("ModifyTypeUnForbidOK"));
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed(true);
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        SorterItemInfo sortName = new SorterItemInfo("number");
        sortName.setSortType(SortType.ASCEND);
        super.setSortForQuery(sortItem, sortName);
    }
}

