/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client.multif7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.mm.qm.client.multif7.IAutoProcessor;
import com.kingdee.eas.basedata.mm.qm.client.multif7.IMultBaseDataProcessor;
import com.kingdee.eas.basedata.mm.qm.client.multif7.IMultiBaseDataBeforeChangeChecker;
import com.kingdee.eas.basedata.mm.qm.client.multif7.MultiBaseDataAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.util.LongtimeIndicator;
import com.kingdee.eas.st.common.util.STUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class MultiBaseDataProcessor {
    private KDTable entry = null;
    private IMultiBaseDataBeforeChangeChecker beforeDataChangeChecker;
    private DataChangeListener prmtBaseDataListener = null;
    protected IMultBaseDataProcessor iMMP = new MultiBaseDataAdapter();
    protected IColumn multiBaseDataColumn = null;
    protected HashMap processorMap = new HashMap();
    public String[] autoFilledColumnName = null;
    KDBizPromptBox bizBaseDataBox = null;

    protected MultiBaseDataProcessor(KDTable entry) {
        this.entry = entry;
        if (entry != null) {
            entry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    if (MultiBaseDataProcessor.this.bizBaseDataBox != null) {
                        if (MultiBaseDataProcessor.this.prmtBaseDataListener != null) {
                            MultiBaseDataProcessor.this.bizBaseDataBox.removeDataChangeListener(MultiBaseDataProcessor.this.prmtBaseDataListener);
                        }
                        MultiBaseDataProcessor.this.bizBaseDataBox.setValue(null);
                        if (MultiBaseDataProcessor.this.prmtBaseDataListener != null) {
                            MultiBaseDataProcessor.this.bizBaseDataBox.addDataChangeListener(MultiBaseDataProcessor.this.prmtBaseDataListener);
                        }
                    }
                }
            });
        }
    }

    protected boolean registerBizMultiBaseDataF7() throws Exception {
        boolean isSuccessful = false;
        if (null != this.entry && null != this.multiBaseDataColumn) {
            Component component = null;
            ICellEditor editor = this.multiBaseDataColumn.getEditor();
            if (editor != null) {
                component = editor.getComponent();
            }
            this.bizBaseDataBox = component instanceof KDBizPromptBox ? (KDBizPromptBox)component : new KDBizPromptBox();
            this.registerDealMultiBaseDataInfo(this.bizBaseDataBox, this.multiBaseDataColumn.getKey());
            this.setBizF7(this.bizBaseDataBox);
            this.multiBaseDataColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizBaseDataBox));
            isSuccessful = true;
        }
        return isSuccessful;
    }

    protected abstract void setBizF7(KDBizPromptBox var1);

    private void registerDealMultiBaseDataInfo(final KDBizPromptBox promptBox, String fieldName) throws Exception {
        final String baseDataFieldname = fieldName;
        if (STUtils.isNotNull((Object)this.prmtBaseDataListener)) {
            promptBox.removeDataChangeListener(this.prmtBaseDataListener);
        }
        this.prmtBaseDataListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    boolean isValid = true;
                    if (MultiBaseDataProcessor.this.beforeDataChangeChecker != null) {
                        isValid = MultiBaseDataProcessor.this.beforeDataChangeChecker.checkBeforeDataChange(baseDataFieldname, e);
                    }
                    if (isValid) {
                        MultiBaseDataProcessor.this.baseDataChanged(baseDataFieldname, e);
                    } else {
                        promptBox.removeDataChangeListener(MultiBaseDataProcessor.this.prmtBaseDataListener);
                        promptBox.setValue((Object)this.getOldValue(e));
                        promptBox.addDataChangeListener(MultiBaseDataProcessor.this.prmtBaseDataListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private DataBaseInfo getOldValue(DataChangeEvent e) {
                if (e.getOldValue() == null) {
                    return null;
                }
                if (e.getOldValue() instanceof Object[]) {
                    for (int i = 0; i < ((Object[])e.getOldValue()).length; ++i) {
                        if (!(((Object[])e.getOldValue())[i] instanceof DataBaseInfo)) continue;
                        return (DataBaseInfo)((Object[])e.getOldValue())[i];
                    }
                    return null;
                }
                if (e.getOldValue() instanceof DataBaseInfo) {
                    return (DataBaseInfo)e.getOldValue();
                }
                return null;
            }
        };
        promptBox.addDataChangeListener(this.prmtBaseDataListener);
    }

    private void baseDataChanged(final String baseDataFieldname, DataChangeEvent e) throws Exception {
        final KDBizPromptBox bizBaseDataBox = (KDBizPromptBox)e.getSource();
        KDTable tb = this.getEntry();
        KDTSelectBlock selected = tb.getSelectManager().get();
        if (selected == null) {
            return;
        }
        final int selectedRow = selected.getBeginRow();
        DataBaseInfo[] dataBaseInfos = null;
        if (bizBaseDataBox.getValue() instanceof DataBaseInfo[]) {
            dataBaseInfos = (DataBaseInfo[])bizBaseDataBox.getValue();
        } else if (bizBaseDataBox.getValue() instanceof DataBaseInfo) {
            Object o;
            ICell cell;
            dataBaseInfos = new DataBaseInfo[]{(DataBaseInfo)bizBaseDataBox.getValue()};
            if (selected != null && selectedRow >= 0 && (cell = tb.getRow(selectedRow).getCell(baseDataFieldname)) != null && (o = cell.getValue()) != null && o instanceof DataBaseInfo && dataBaseInfos[0].getId().toString().equals(((DataBaseInfo)o).getId().toString())) {
                return;
            }
        } else if (bizBaseDataBox.getValue() instanceof Object[]) {
            Object[] objects = (Object[])bizBaseDataBox.getValue();
            if (objects.length == 0) {
                return;
            }
            if (objects[0] == null) {
                return;
            }
            dataBaseInfos = new DataBaseInfo[objects.length];
            System.arraycopy(objects, 0, dataBaseInfos, 0, objects.length);
        } else {
            return;
        }
        if (dataBaseInfos.length >= 5) {
            LongtimeIndicator waiting = new LongtimeIndicator();
            final DataBaseInfo[] DataBaseInfosFinal = dataBaseInfos;
            waiting.letMeDo(new ILongTimeTask(){

                public Object exec() throws Exception {
                    MultiBaseDataProcessor.this.doBaseDataChanged(bizBaseDataBox, DataBaseInfosFinal, selectedRow, baseDataFieldname);
                    return new Boolean(true);
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            waiting.doJob();
        } else {
            this.doBaseDataChanged(bizBaseDataBox, dataBaseInfos, selectedRow, baseDataFieldname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBaseDataChanged(KDBizPromptBox bizBaseDataBox, DataBaseInfo[] dataBaseInfos, int selectedRow, String baseDataFieldName) throws Exception {
        HashMap dataMap = new HashMap();
        if (dataBaseInfos == null || dataBaseInfos.length == 0) {
            bizBaseDataBox.setValue(null);
            return;
        }
        KDTable table = this.getEntry();
        HashMap<DataBaseInfo, Exception> beforeExceptionMap = new HashMap<DataBaseInfo, Exception>();
        HashMap afterExceptionMap = new HashMap();
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(baseDataFieldName);
        bizBaseDataBox.removeDataChangeListener(this.prmtBaseDataListener);
        int length = dataBaseInfos.length;
        if (length > 0) {
            IRow curRow2 = null;
            DataBaseInfo db = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.insertLine(beginRow + insertedRowCount);
                    needInsert = false;
                }
                db = dataBaseInfos[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (insertedRowCount > 0) {
                    this.beforeInsertEntries(table, beginRow + insertedRowCount);
                }
                if (dataBaseInfos[i] == null) {
                    curRow2.getCell(curCol).setValue((Object)db);
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                try {
                    curRow2.getCell(curCol).setValue((Object)db);
                }
                catch (Exception ex) {
                    curRow2.getCell(curCol).setValue((Object)db);
                    curRow2.getCell(curCol).setValue(null);
                    beforeExceptionMap.put(db, ex);
                    continue;
                }
                needInsert = true;
                ++insertedRowCount;
            }
            if (beforeExceptionMap != null && beforeExceptionMap.size() > 0) {
                this.handleBeforeInsertRowException(beforeExceptionMap);
            }
            if (afterExceptionMap != null && afterExceptionMap.size() > 0) {
                this.handleAfterInsertRowException(afterExceptionMap);
            }
            this.afterInsertEntries(table, beginRow, dataBaseInfos, dataMap);
        } else {
            curRow.getCell(curCol).setValue(null);
        }
        bizBaseDataBox.addDataChangeListener(this.prmtBaseDataListener);
    }

    private KDTable getEntry() {
        return this.entry;
    }

    private void setEntry(KDTable entry) {
        this.entry = entry;
    }

    protected void showExceptionMessage(HashMap exceptionMap) {
        if (exceptionMap != null && exceptionMap.size() > 0) {
            StringBuffer exMsg = new StringBuffer();
            Iterator keyIt = exceptionMap.keySet().iterator();
            DataBaseInfo dateBaseInfo = null;
            Exception ex = null;
            boolean isFirst = true;
            while (keyIt.hasNext()) {
                if (!isFirst) {
                    exMsg.append("\n");
                } else {
                    isFirst = false;
                }
                dateBaseInfo = (DataBaseInfo)keyIt.next();
                ex = (Exception)exceptionMap.get(dateBaseInfo);
                exMsg.append(dateBaseInfo.getName()).append(":").append(ex.getMessage());
            }
            if (exMsg.length() > 0) {
                MsgBox.showInfo((String)exMsg.toString());
            }
        }
    }

    protected void handleAfterInsertRowException(HashMap afterExceptionMap) {
        this.showExceptionMessage(afterExceptionMap);
    }

    protected void handleBeforeInsertRowException(HashMap beforeExceptionMap) {
        this.showExceptionMessage(beforeExceptionMap);
    }

    private void insertLine(int row) {
        KDTable kdtEntries = this.getEntry();
        if (kdtEntries == null) {
            return;
        }
        kdtEntries.addRow(row);
    }

    protected abstract void beforeInsertEntries(KDTable var1, int var2) throws Exception;

    protected abstract void afterInsertEntries(KDTable var1, int var2, DataBaseInfo[] var3, Map var4) throws Exception;

    protected abstract void clearFillColumnData(int var1) throws BOSException, EASBizException;

    public final void addAfterInsertEntryListener(IMultBaseDataProcessor mp) {
        this.iMMP = mp;
    }

    public final void setAutoFilledColumnName(int columnIndex, String columnName) {
        if (columnIndex >= this.autoFilledColumnName.length || columnIndex < 0) {
            return;
        }
        this.autoFilledColumnName[columnIndex] = columnName;
    }

    public final void setAutoFilledColumnName(int columnIndex, String columnName, IAutoProcessor processor) {
        this.setAutoFilledColumnName(columnIndex, columnName);
        this.processorMap.put(new Integer(columnIndex), processor);
    }

    public IMultiBaseDataBeforeChangeChecker getBeforeDataChangeChecker() {
        return this.beforeDataChangeChecker;
    }

    public void setBeforeDataChangeChecker(IMultiBaseDataBeforeChangeChecker beforeDataChangeChecker) {
        this.beforeDataChangeChecker = beforeDataChangeChecker;
    }
}

