/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.qiItemGroupUtils;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.basedata.mm.qm.ProjectAttributeEnum;
import com.kingdee.eas.basedata.mm.qm.ValueTypeEnum;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public abstract class DefaultValueUtils {
    private static final Color NECESSARYCOLOR = new Color(252, 255, 206);
    private static final Color NOT_NECESSARYCOLOR = new Color(255, 255, 255);

    public static KDTDefaultCellEditor getDefaultValue(ValueTypeEnum valueType, String defaultValue) {
        KDTDefaultCellEditor editor = null;
        if (valueType.equals((Object)ValueTypeEnum.ENUM)) {
            KDComboBox comboValue = new KDComboBox();
            List enumList = DefaultValueUtils.parseEnumString(defaultValue);
            comboValue.addItems(enumList.toArray());
            editor = new KDTDefaultCellEditor((JComboBox)comboValue);
        } else if (valueType.equals((Object)ValueTypeEnum.NUMBER)) {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(4);
            colTxtField.setHorizontalAlignment(4);
            colTxtField.setSupportedEmpty(true);
            colTxtField.setRemoveingZeroInDispaly(false);
            editor = new KDTDefaultCellEditor((JTextField)colTxtField);
        }
        return editor;
    }

    public static boolean isEnumString(String str) {
        if (str == null) {
            return true;
        }
        String unProcessStr = str;
        while (unProcessStr.length() > 0) {
            int index1 = unProcessStr.indexOf(",");
            int index2 = unProcessStr.indexOf("\uff0c");
            int index = -1;
            if (index1 >= 0 && index2 >= 0) {
                index = index1 < index2 ? index1 : index2;
            } else if (index1 >= 0) {
                index = index1;
            } else if (index2 >= 0) {
                index = index2;
            } else {
                return true;
            }
            if (StringUtils.isEmpty((String)unProcessStr.substring(0, index))) {
                return false;
            }
            unProcessStr = unProcessStr.substring(index + 1);
        }
        return true;
    }

    public static List parseEnumString(String str) {
        ArrayList<CharSequence> enumList = new ArrayList<CharSequence>();
        if (str == null) {
            return enumList;
        }
        String unProcessStr = str;
        while (unProcessStr.length() > 0) {
            int index1 = unProcessStr.indexOf(",");
            int index2 = unProcessStr.indexOf("\uff0c");
            int index = -1;
            index = index1 >= 0 && index2 >= 0 ? (index1 < index2 ? index1 : index2) : (index1 >= 0 ? index1 : (index2 >= 0 ? index2 : -1));
            if (index == -1) {
                enumList.add(unProcessStr);
                unProcessStr = "";
                continue;
            }
            enumList.add(unProcessStr.subSequence(0, index));
            unProcessStr = unProcessStr.substring(index + 1);
        }
        return enumList;
    }

    public static void setEditorByValueType(KDTable kdtEntries, ValueTypeEnum valueType, ProjectAttributeEnum projectAttribut, int rowIndex, int qiPrecision, String defaultValue, String qiResult, String qiResultName, String qiValueName, String judgeName, boolean isRequiredForCheck) {
        DefaultValueUtils.setEditorByValueType(kdtEntries, valueType, projectAttribut, rowIndex, qiPrecision, defaultValue, qiResult, qiResultName, qiValueName, judgeName, isRequiredForCheck, false);
    }

    public static void setEditorByValueType(KDTable kdtEntries, ValueTypeEnum valueType, ProjectAttributeEnum projectAttribut, int rowIndex, int qiPrecision, String defaultValue, String qiResult, String qiResultName, String qiValueName, String judgeName, boolean isRequiredForCheck, boolean isConditionEntry) {
        if (valueType == null || kdtEntries == null || qiResultName == null || qiValueName == null) {
            return;
        }
        ICell qiResultCell = kdtEntries.getCell(rowIndex, qiResultName);
        ICell qiValueCell = kdtEntries.getCell(rowIndex, qiValueName);
        ICell judgeCell = null;
        if (judgeName != null) {
            judgeCell = kdtEntries.getCell(rowIndex, judgeName);
        }
        KDTDefaultCellEditor editor = null;
        if (valueType != null && qiResultCell != null && qiValueCell != null) {
            if (valueType.equals((Object)ValueTypeEnum.FORMULA) || valueType.equals((Object)ValueTypeEnum.NUMBER)) {
                KDFormattedTextField colTxtField = new KDFormattedTextField();
                colTxtField.setDataType(1);
                colTxtField.setPrecision(qiPrecision);
                colTxtField.setHorizontalAlignment(4);
                colTxtField.setSupportedEmpty(true);
                colTxtField.setRemoveingZeroInDispaly(false);
                editor = new KDTDefaultCellEditor((JTextField)colTxtField);
                kdtEntries.getCell(rowIndex, "qiResult").setEditor((ICellEditor)editor);
                kdtEntries.getCell(rowIndex, "qiResult").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qiPrecision));
                kdtEntries.getCell(rowIndex, "qiResult").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (valueType.equals((Object)ValueTypeEnum.NUMBER) && qiResult != null) {
                    kdtEntries.getCell(rowIndex, "qiResult").setValue((Object)new BigDecimal(qiResult));
                    kdtEntries.getCell(rowIndex, "qiValue").setValue((Object)new BigDecimal(qiResult));
                }
            } else if (valueType.equals((Object)ValueTypeEnum.ENUM)) {
                editor = DefaultValueUtils.getDefaultValue(valueType, defaultValue);
                kdtEntries.getCell(rowIndex, "qiResult").setValue((Object)qiResult);
            } else {
                KDTextField txtInput = new KDTextField();
                txtInput.setMaxLength(200);
                editor = new KDTDefaultCellEditor((JTextField)txtInput);
                kdtEntries.getCell(rowIndex, "qiResult").setValue((Object)qiResult);
            }
        } else {
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(200);
            editor = new KDTDefaultCellEditor((JTextField)txtInput);
        }
        if (judgeCell != null) {
            if (projectAttribut != null && (projectAttribut.equals((Object)ProjectAttributeEnum.TEST) || projectAttribut.equals((Object)ProjectAttributeEnum.JUDGE))) {
                judgeCell.getStyleAttributes().setLocked(true);
                judgeCell.setValue(null);
                judgeCell.getStyleAttributes().setBackground(NOT_NECESSARYCOLOR);
            } else {
                judgeCell.getStyleAttributes().setLocked(false);
                if (isRequiredForCheck) {
                    judgeCell.getStyleAttributes().setBackground(NECESSARYCOLOR);
                } else {
                    judgeCell.getStyleAttributes().setBackground(NOT_NECESSARYCOLOR);
                }
            }
        }
        if (!isConditionEntry && qiResultCell != null) {
            kdtEntries.getCell(rowIndex, "qiResult").setEditor((ICellEditor)editor);
            if (projectAttribut != null && (projectAttribut.equals((Object)ProjectAttributeEnum.TEST) || projectAttribut.equals((Object)ProjectAttributeEnum.JUDGE))) {
                kdtEntries.getCell(rowIndex, "qiResult").getStyleAttributes().setLocked(true);
            } else if (valueType.equals((Object)ValueTypeEnum.FORMULA)) {
                kdtEntries.getCell(rowIndex, "qiResult").getStyleAttributes().setLocked(true);
            } else {
                kdtEntries.getCell(rowIndex, "qiResult").getStyleAttributes().setLocked(false);
            }
        }
    }

    public static KDTDefaultCellEditor getEditorForStandardValue(ValueTypeEnum valueType, String defaultValue, int qiPrecision) {
        if (valueType == null) {
            return null;
        }
        KDTDefaultCellEditor editor = null;
        if (valueType != null) {
            if (valueType.equals((Object)ValueTypeEnum.FORMULA) || valueType.equals((Object)ValueTypeEnum.NUMBER)) {
                KDFormattedTextField colTxtField = new KDFormattedTextField();
                colTxtField.setDataType(1);
                colTxtField.setPrecision(qiPrecision);
                colTxtField.setHorizontalAlignment(4);
                colTxtField.setSupportedEmpty(true);
                colTxtField.setRemoveingZeroInDispaly(false);
                editor = new KDTDefaultCellEditor((JTextField)colTxtField);
            } else if (valueType.equals((Object)ValueTypeEnum.ENUM)) {
                editor = DefaultValueUtils.getDefaultValue(valueType, defaultValue);
            } else {
                KDTextField txtInput = new KDTextField();
                txtInput.setMaxLength(200);
                editor = new KDTDefaultCellEditor((JTextField)txtInput);
            }
        } else {
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(200);
            editor = new KDTDefaultCellEditor((JTextField)txtInput);
        }
        return editor;
    }
}

