/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.qiItemGroupUtils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.formula.engine.FormulaEngine;
import com.kingdee.bos.service.formula.engine.RunFormulaException;
import com.kingdee.eas.basedata.mm.qm.IQIStandardEntry;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryCollection;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardInfo;
import com.kingdee.eas.basedata.mm.qm.utils.NumericUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaUtils {
    public static String getVarNameByNumber(String qiItemNumber) {
        String number = "var_";
        if (qiItemNumber != null) {
            number = number + qiItemNumber.replace('.', '_');
        }
        return number;
    }

    public static String getVarNameByName(String qiItemName) {
        String name = qiItemName.replace('.', '_');
        return name;
    }

    public static String[] parseQIItemNumber(String formulaString) {
        ArrayList<String> ls = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)formulaString)) {
            Pattern pt = Pattern.compile("(var_name=var_)(.+)(\\|var_type=\\|var_scope=in\\|var_alias=.+\\|var_desc=)(.+)(})");
            Matcher matcher = pt.matcher(formulaString);
            String itemNumber = null;
            while (matcher.find()) {
                if (matcher != null && matcher.group(4) != null) {
                    itemNumber = matcher.group(4).toString();
                }
                if (StringUtils.isEmpty(itemNumber)) continue;
                ls.add(itemNumber);
            }
        }
        String[] result = null;
        if (ls.size() > 0) {
            result = new String[ls.size()];
            ls.toArray(result);
        }
        return result;
    }

    public static String extirpateVariableString(String formulaString) {
        String result = formulaString;
        if (!StringUtils.isEmpty((String)formulaString)) {
            result = formulaString.replaceAll("var var_.+; \\/\\/\\{bos_formula_comments_var:var_name=var_.+\\|var_type=\\|var_scope=in\\|var_alias=.+\\|var_desc=.+\\}", "");
        }
        return result;
    }

    public static void setAllFormulaResultValue(Context ctx, CoreBillBaseInfo billObject, String tableName, String entryName) throws BOSException, EASBizException {
        String formula = null;
        String key = null;
        HashMap<String, Object> context = new HashMap<String, Object>();
        QIItemInfo qiItemInfo = null;
        Object o = null;
        IObjectValue info = null;
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, String> expressionMap = null;
        HashMap<String, String> precisionMap = null;
        AbstractObjectCollection aAbstractObjectCollection = (AbstractObjectCollection)billObject.get(entryName);
        int count = aAbstractObjectCollection.size();
        for (int i = 0; i < count; ++i) {
            info = aAbstractObjectCollection.getObject(i);
            o = info.get("qiItem");
            if (o instanceof QIItemInfo) {
                qiItemInfo = (QIItemInfo)o;
                context.put(FormulaUtils.getVarNameByNumber(qiItemInfo.getNumber()), info.get("qiValue"));
            } else {
                qiItemInfo = null;
            }
            if (qiItemInfo == null) {
                keys.add("0");
                continue;
            }
            keys.add(qiItemInfo.getId().toString());
        }
        QIStandardInfo qiStandardInfo = null;
        expressionMap = new HashMap<String, String>();
        precisionMap = new HashMap<String, String>();
        o = billObject.get("qiStandard");
        if (o instanceof QIStandardInfo) {
            qiStandardInfo = (QIStandardInfo)o;
        }
        if (qiStandardInfo == null) {
            return;
        }
        QIStandardEntryCollection eCollection = qiStandardInfo.getQIStandardEntry();
        QIStandardEntryInfo qiStandardEntryInfo = null;
        IQIStandardEntry iQIStandardEntry = QIStandardEntryFactory.getLocalInstance(ctx);
        int pfLength = eCollection.size();
        try {
            for (int j = 0; j < pfLength; ++j) {
                qiStandardEntryInfo = iQIStandardEntry.getQIStandardEntryInfo((IObjectPK)new ObjectStringPK(eCollection.get(j).getId().toString()));
                if (qiStandardEntryInfo.getQiItem() == null || qiStandardEntryInfo.getExpression() == null) continue;
                expressionMap.put(qiStandardEntryInfo.getQiItem().getId().toString(), qiStandardEntryInfo.getExpression());
                precisionMap.put(qiStandardEntryInfo.getQiItem().getId().toString(), Integer.toString(qiStandardEntryInfo.getPrecision()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer sqlString = new StringBuffer();
        int count2 = aAbstractObjectCollection.size();
        for (int i = 0; i < count2; ++i) {
            info = aAbstractObjectCollection.getObject(i);
            key = ((QIItemInfo)info.get("qiItem")).getId().toString();
            int precision = 4;
            formula = expressionMap.containsKey(key) ? expressionMap.get(key).toString() : null;
            if (precisionMap.containsKey(key)) {
                precision = new BigDecimal(precisionMap.get(key).toString()).intValue();
            }
            Object result = null;
            BigDecimal bigResult = null;
            if (formula == null) continue;
            try {
                result = FormulaEngine.runFormula((String)formula, context);
                if (result != null) {
                    bigResult = NumericUtils.toBigDecimal(result.toString());
                    bigResult = bigResult.setScale(precision, 4);
                }
            }
            catch (RunFormulaException e) {
                // empty catch block
            }
            if (!(bigResult instanceof BigDecimal)) continue;
            sqlString.setLength(0);
            Object[] params = new Object[]{bigResult, bigResult};
            sqlString.append("UPDATE ").append(tableName).append(" SET FQiValue = ?").append(", FQiResult = ?").append(" WHERE FID =  '").append(info.get("id")).append("'");
            DbUtil.execute((Context)ctx, (String)sqlString.toString(), (Object[])params);
        }
    }

    public static void main(String[] args) {
        String s = "var formula_result; //{bos_formula_comments_var:var_name=formula_result|var_type=|var_scope=return|var_alias=\u516c\u5f0f\u7ed3\u679c|var_desc=\u516c\u5f0f\u8fd4\u56de\u7ed3\u679c} \nvar var_Z25003; //{bos_formula_comments_var:var_name=var_Z25003|var_type=|var_scope=in|var_alias=Z253d2} \nvar var_Z25002; //{bos_formula_comments_var:var_name=var_Z25002|var_type=|var_scope=in|var_alias=Z253d1|var_desc=Z25002} \nvar var_Z25001; //{bos_formula_comments_var:var_name=var_Z25001|var_type=|var_scope=in|var_alias=Z253d0|var_desc=Z25001} \nformula_result =(1 -power( (var_Z25002 +var_Z25003 ),2) /power( var_Z25001,2 )) *100; \nreturn formula_result;";
        String[] selectedQIItemNumbers = FormulaUtils.parseQIItemNumber(s);
        System.out.println(selectedQIItemNumbers[0]);
        System.out.println(selectedQIItemNumbers[1]);
        System.out.println(selectedQIItemNumbers[2]);
    }
}

