/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IJobCategory;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.JobSystemFactory;
import com.kingdee.eas.basedata.org.JobSystemInfo;
import com.kingdee.eas.basedata.org.client.tree.JobCategoryNodeInfo;
import com.kingdee.eas.basedata.org.helper.HRBaseCommonUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class JobCategoryTreeBuilder {
    private int initalLevel;
    private int expandLevel;
    private boolean isShowDisableJob = false;
    private String resClass = "com.kingdee.eas.basedata.org.client.JobCategoryResource.";
    private String curCUID = null;
    int groupModel = 0;
    private Set cuSet = null;

    public JobCategoryTreeBuilder(JobSystemInfo jobSystemInfo, int initalLevel, int expandLevel) throws Exception {
        this(jobSystemInfo, initalLevel, expandLevel, null);
    }

    public JobCategoryTreeBuilder(JobSystemInfo jobSystemInfo, int initalLevel, int expandLevel, String cuId) throws Exception {
        this(jobSystemInfo, initalLevel, expandLevel, cuId, false);
    }

    public JobCategoryTreeBuilder(JobSystemInfo jobSystemInfo, int initalLevel, int expandLevel, String cuId, boolean isShowDisableJob) throws Exception {
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.curCUID = cuId;
        this.isShowDisableJob = isShowDisableJob;
    }

    public JobCategoryTreeBuilder(JobSystemInfo jobSystemInfo, int initalLevel, int expandLevel, String cuId, Set cuSet) throws Exception {
        this(jobSystemInfo, initalLevel, expandLevel, cuId, cuSet, false);
    }

    public JobCategoryTreeBuilder(JobSystemInfo jobSystemInfo, int initalLevel, int expandLevel, String cuId, Set cuSet, boolean isShowDisableJob) throws Exception {
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.curCUID = cuId;
        this.cuSet = cuSet;
        this.isShowDisableJob = isShowDisableJob;
    }

    public JTree buildTree(final JTree tree, JobCategoryNodeInfo parentNodeInfo) throws Exception {
        this.groupModel = JobSystemFactory.getRemoteInstance().getJobSystemScheme();
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode((Object)EASResource.getString((String)(this.resClass + "JOBCATEGORY_MAIN_LIST_TITLE")));
            rootNode.setCustomIcon(EASResource.getIcon((String)"imgTbtn_businesssystem"));
            tree.setRootVisible(true);
        }
        IRowSet rows = this.getChildrenRowSet(parentNodeInfo, this.initalLevel);
        if (rows != null && rows.size() == 1) {
            tree.putClientProperty("JTree.lineStyle", "None");
        } else {
            tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.buildChildrenByRowSet(rootNode, rows, this.initalLevel);
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                try {
                    JobCategoryTreeBuilder.this.getChildren((KDTreeNode)event.getPath().getLastPathComponent());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    JobCategoryTreeBuilder.this.getChildren((KDTreeNode)e.getPath().getLastPathComponent());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, null);
    }

    private void getChildren(KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            JobCategoryNodeInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof JobCategoryNodeInfo) {
                treeNodeInfo = (JobCategoryNodeInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            treeNode.removeAllChildren();
            this.buildChildrenByRowSet(treeNode, this.getChildrenRowSet(treeNodeInfo, this.expandLevel), this.expandLevel);
        }
    }

    private void buildChildrenByRowSet(KDTreeNode parentNode, IRowSet rows, int level) throws Exception {
        KDTreeNode beforeTreeNode = parentNode;
        JobCategoryInfo treeNodeInfo = null;
        JobCategoryNodeInfo nodeInfo = null;
        KDTreeNode treeNode = null;
        if (rows != null) {
            while (rows.next()) {
                treeNodeInfo = this.createJobCatInfo2(rows);
                nodeInfo = new JobCategoryNodeInfo(treeNodeInfo);
                treeNode = new KDTreeNode((Object)nodeInfo);
                treeNode.setCustomIcon(EASResource.getIcon((String)"imgTbtn_business"));
                if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                    treeNode.setVirtual(false);
                } else {
                    treeNode.setVirtual(true);
                    treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
                }
                if (beforeTreeNode.getLevel() == 0) {
                    beforeTreeNode.add((MutableTreeNode)treeNode);
                } else {
                    int curLevel = treeNodeInfo.getLevel();
                    for (int beforeLevel = ((JobCategoryNodeInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                        beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                    }
                    beforeTreeNode.add((MutableTreeNode)treeNode);
                }
                beforeTreeNode = treeNode;
            }
        }
    }

    public void refreshTreeNode(KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(treeNode);
    }

    public IRowSet getChildrenRowSet(JobCategoryNodeInfo parentNodeInfo, int level) throws Exception {
        return this.getChildrenRowSet(parentNodeInfo, level, this.isShowDisableJob);
    }

    public IRowSet getChildrenRowSet(JobCategoryNodeInfo parentNodeInfo, int level, boolean isShowDisableJobCategory) throws Exception {
        Set set;
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return null;
        }
        IJobCategory iJob = JobCategoryFactory.getRemoteInstance();
        JobCategoryCollection jobCol = iJob.getJobCategoryCollection("select level order by level desc");
        JobCategoryInfo jobInfo = jobCol.get(0);
        if (jobInfo != null) {
            level = jobInfo.getLevel() + 1;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (parentNodeInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)parentNodeInfo.getLevel(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)(parentNodeInfo.getLevel() + level), CompareType.LESS_EQUALS));
            if (this.curCUID == null) {
                if (this.groupModel == 0) {
                    filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId(), CompareType.EQUALS));
                }
                filter.setMaskString("#0 and #1 and #2 and #3");
            } else {
                set = this.getCuSet(this.curCUID, this.cuSet);
                filter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)level, CompareType.LESS_EQUALS));
            if (this.curCUID == null) {
                if (this.groupModel == 0) {
                    filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId(), CompareType.EQUALS));
                }
            } else {
                set = this.getCuSet(this.curCUID, this.cuSet);
                filter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 ");
            }
        }
        if (!isShowDisableJobCategory) {
            FilterInfo _filter = new FilterInfo();
            _filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            filter.mergeFilter(_filter, "and");
        }
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.JobCategoryQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    private Set getCuSet(String CUID, Set cuSet) throws Exception {
        Set<CtrlUnitInfo> set = new HashSet();
        if (this.cuSet == null || this.cuSet.size() == 0) {
            CtrlUnitInfo cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(CUID));
            set.add(cu);
        } else {
            set = cuSet;
        }
        return HRBaseCommonUtil.getParentCU(set);
    }

    public static int getTableColumns(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return 0;
        }
        if (root.isLeaf()) {
            return 1;
        }
        int count = 0;
        int children = root.getChildCount();
        for (int i = 0; i < children; ++i) {
            count += JobCategoryTreeBuilder.getTableColumns((DefaultKingdeeTreeNode)root.getChildAt(i));
        }
        return count;
    }

    public DefaultKingdeeTreeNode buildJobSystemNode(JobCategoryInfo rootInfo, boolean includeJob) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.JobCategoryQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        fi = HRBaseCommonUtil.getS4FilterByMulCu("CU.number", this.cuSet);
        DefaultKingdeeTreeNode rootNode = null;
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 and #1");
            rootNode = new DefaultKingdeeTreeNode((Object)rootInfo);
        } else {
            JobCategoryInfo jobCatInfo = new JobCategoryInfo();
            if (includeJob) {
                jobCatInfo.setName(EASResource.getString((String)(this.resClass + "JOB_MAIN_LIST_TITLE")));
            } else {
                jobCatInfo.setName(EASResource.getString((String)(this.resClass + "JOBCATEGORY_MAIN_LIST_TITLE")));
            }
            rootNode = new DefaultKingdeeTreeNode((Object)jobCatInfo);
        }
        if (!this.isShowDisableJob) {
            FilterInfo isShowDisableJobFilter = new FilterInfo();
            isShowDisableJobFilter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            fi.mergeFilter(isShowDisableJobFilter, "and");
        }
        viewInfo.setFilter(fi);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        this.buildTreeNodeByRows(rootNode, rows);
        if (includeJob) {
            queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.JobQuery");
            queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            viewInfo = new EntityViewInfo();
            fi = new FilterInfo();
            fi = JobFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuInfo.getId()), "id", "adminCU.id");
            if (!this.isShowDisableJob) {
                FilterInfo isShowDisableJobFilter = new FilterInfo();
                isShowDisableJobFilter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
                fi.mergeFilter(isShowDisableJobFilter, "and");
            }
            viewInfo.setFilter(fi);
            queryExcu.setObjectView(viewInfo);
            rows = queryExcu.executeQuery();
            this.buildTableHead(rootNode, rows);
        } else {
            this.buildTableHead(rootNode);
        }
        return rootNode;
    }

    private void buildTableHead(DefaultKingdeeTreeNode rootNode) throws Exception {
        JobCategoryInfo obj = (JobCategoryInfo)rootNode.getUserObject();
        if (rootNode.isLeaf()) {
            obj.setLevel(1);
        } else {
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                this.buildTableHead((DefaultKingdeeTreeNode)rootNode.getChildAt(i));
            }
            int size = 0;
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
                JobCategoryInfo jobCatInfo = (JobCategoryInfo)childNode.getUserObject();
                size += jobCatInfo.getLevel();
            }
            obj.setLevel(size);
        }
    }

    private void buildTableHead(DefaultKingdeeTreeNode rootNode, IRowSet rows) throws Exception {
        JobCategoryInfo obj = (JobCategoryInfo)rootNode.getUserObject();
        String catId = null;
        if (rootNode.isLeaf() && obj.getId() != null) {
            catId = obj.getId().toString();
            rows.beforeFirst();
            while (rows.next()) {
                if (!rows.getString("JobCategory.id").equals(catId)) continue;
                JobInfo jobInfo = this.createJobInfo(rows);
                rootNode.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)jobInfo));
            }
            obj.setLevel(rootNode.getChildCount());
        } else {
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                this.buildTableHead((DefaultKingdeeTreeNode)rootNode.getChildAt(i), rows);
            }
            int size = 0;
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
                JobCategoryInfo jobCatInfo = (JobCategoryInfo)childNode.getUserObject();
                size += jobCatInfo.getLevel();
            }
            obj.setLevel(size);
        }
    }

    private DefaultKingdeeTreeNode buildTreeNodeByRows(DefaultKingdeeTreeNode rootNode, IRowSet rows) throws Exception {
        if (rows == null) {
            return rootNode;
        }
        DefaultKingdeeTreeNode parentNode = null;
        DefaultKingdeeTreeNode subTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        JobCategoryInfo jobCatInfo = (JobCategoryInfo)rootNode.getUserObject();
        if (jobCatInfo.getId() == null) {
            nodeMap.put("Root", rootNode);
        } else {
            nodeMap.put(jobCatInfo.getId().toString(), rootNode);
        }
        while (rows.next()) {
            jobCatInfo = this.createJobCatInfo(rows);
            subTreeNode = new DefaultKingdeeTreeNode((Object)jobCatInfo);
            if (jobCatInfo.getParent() == null) {
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get("Root");
            } else if (nodeMap.containsKey(jobCatInfo.getParent().getId().toString())) {
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(jobCatInfo.getParent().getId().toString());
            }
            parentNode.add((MutableTreeNode)subTreeNode);
            nodeMap.put(jobCatInfo.getId().toString(), subTreeNode);
        }
        return rootNode;
    }

    private JobCategoryInfo createJobCatInfo(IRowSet rows) throws Exception {
        JobCategoryInfo jobInfo = new JobCategoryInfo();
        jobInfo.setId(BOSUuid.read((String)rows.getString("id")));
        jobInfo.setName(rows.getString("name"));
        JobCategoryInfo parent = null;
        if (rows.getString("parent.id") != null) {
            parent = new JobCategoryInfo();
            parent.setId(BOSUuid.read((String)rows.getString("parent.id")));
        }
        jobInfo.setParent(parent);
        return jobInfo;
    }

    private JobCategoryInfo createJobCatInfo2(IRowSet rows) throws Exception {
        JobCategoryInfo jobInfo = new JobCategoryInfo();
        jobInfo.setId(BOSUuid.read((String)rows.getString("id")));
        jobInfo.setName(rows.getString("name"));
        jobInfo.setNumber(rows.getString("number"));
        jobInfo.setLevel(rows.getInt("level"));
        jobInfo.setLongNumber(rows.getString("longNumber"));
        jobInfo.setIsLeaf(rows.getBoolean("isLeaf"));
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)rows.getString("CU.id")));
        jobInfo.setCU(cuInfo);
        jobInfo.setState(DeletedStatusEnum.getEnum((int)rows.getInt("state")));
        return jobInfo;
    }

    private JobInfo createJobInfo(IRowSet rows) throws Exception {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(BOSUuid.read((String)rows.getString("id")));
        jobInfo.setName(rows.getString("name"));
        return jobInfo;
    }
}

