/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AbstractPositionHierarchyInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.client.tree.PositionHierarchyNodeInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class PositionHierarchyTreeBuilder {
    private HierarchyInfo treeInfo = null;
    private IPositionHierarchy iPositionHierarchy = null;
    private boolean isSleapUp = false;
    private HashMap nodeMap = new HashMap();

    public PositionHierarchyTreeBuilder(HierarchyInfo hierarchyInfo, int initalLevel, int expandLevel) throws Exception {
        this.treeInfo = hierarchyInfo;
        this.iPositionHierarchy = PositionHierarchyFactory.getRemoteInstance();
    }

    public PositionHierarchyTreeBuilder(HierarchyInfo hierarchyInfo, int initalLevel, int expandLevel, boolean isSleapUp) throws Exception {
        this.treeInfo = hierarchyInfo;
        this.isSleapUp = isSleapUp;
        this.iPositionHierarchy = PositionHierarchyFactory.getRemoteInstance();
    }

    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, false);
    }

    public JTree buildTree(final JTree tree, final boolean deleteStatus) throws Exception {
        KDTreeNode rootNode = null;
        rootNode = tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode ? (KDTreeNode)tree.getModel().getRoot() : new KDTreeNode((Object)"sample");
        PositionHierarchyCollection col = null;
        col = deleteStatus ? this.getChildren(null, deleteStatus) : this.getChildren(null);
        this.buildChildren(rootNode, col);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        if (col == null || col.size() == 0) {
            tree.setModel(null);
        } else {
            tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        }
        tree.setShowsRootHandles(true);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                try {
                    if (deleteStatus) {
                        PositionHierarchyTreeBuilder.this.getChildrenNode((KDTreeNode)event.getPath().getLastPathComponent(), deleteStatus);
                    } else {
                        PositionHierarchyTreeBuilder.this.getChildrenNode((KDTreeNode)event.getPath().getLastPathComponent());
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    if (deleteStatus) {
                        PositionHierarchyTreeBuilder.this.getChildrenNode((KDTreeNode)e.getPath().getLastPathComponent(), deleteStatus);
                    } else {
                        PositionHierarchyTreeBuilder.this.getChildrenNode((KDTreeNode)e.getPath().getLastPathComponent());
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private void getChildrenNode(KDTreeNode treeNode) throws Exception {
        this.getChildrenNode(treeNode, false);
    }

    private void getChildrenNode(KDTreeNode treeNode, boolean deleteStatus) throws Exception {
        if (treeNode.isVirtual()) {
            PositionHierarchyNodeInfo treeNodeInfo = (PositionHierarchyNodeInfo)treeNode.getUserObject();
            treeNode.setVirtual(false);
            treeNode.removeAllChildren();
            PositionHierarchyCollection col = null;
            col = deleteStatus ? this.getChildren(treeNodeInfo.getPositionInfo().getId().toString(), deleteStatus) : this.getChildren(treeNodeInfo.getPositionInfo().getId().toString());
            this.buildChildren(treeNode, col);
        }
    }

    private void buildChildren(KDTreeNode parentNode, PositionHierarchyCollection col) {
        if (col == null) {
            return;
        }
        Iterator iter = col.iterator();
        PositionHierarchyInfo treeNodeInfo = null;
        PositionHierarchyNodeInfo nodeInfo = null;
        KDTreeNode treeNode = null;
        while (iter.hasNext()) {
            treeNodeInfo = (PositionHierarchyInfo)iter.next();
            nodeInfo = new PositionHierarchyNodeInfo(treeNodeInfo);
            treeNode = new KDTreeNode((Object)nodeInfo);
            if (treeNodeInfo.getChild() != null && treeNodeInfo.getChild().getDeletedStatus() == DeletedStatusEnum.DELETED) {
                treeNode.setTextColor(Color.GRAY);
            }
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_position"));
            if (nodeInfo.getLevel() == 0) {
                parentNode.setUserObject((Object)nodeInfo);
                parentNode.setText(nodeInfo.toString());
                parentNode.setCustomIcon(EASResource.getIcon((String)"imgTree_position"));
                this.nodeMap.put(treeNodeInfo.getChild().getId().toString(), parentNode);
                continue;
            }
            if (treeNodeInfo.isIsLeaf()) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (treeNodeInfo.getParent() == null || !this.nodeMap.containsKey(treeNodeInfo.getParent().getId().toString())) continue;
            ((DefaultKingdeeTreeNode)this.nodeMap.get(treeNodeInfo.getParent().getId().toString())).add((MutableTreeNode)treeNode);
            this.nodeMap.put(treeNodeInfo.getChild().getId().toString(), treeNode);
        }
    }

    public void refreshTreeNode(KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildrenNode(treeNode);
    }

    public PositionHierarchyCollection getChildren(String parentId) throws Exception {
        return this.getChildren(parentId, false);
    }

    public PositionHierarchyCollection getChildren(String parentId, boolean deleteStatus) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("level"));
        viewInfo.getSelector().add(new SelectorItemInfo("isLeaf"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.deletedStatus"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("hierarchy.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("hierarchy.name"));
        viewInfo.getSorter().add(new SorterItemInfo("level"));
        PositionHierarchyCollection result = null;
        AbstractPositionHierarchyInfo info = null;
        FilterInfo filter = null;
        FilterInfo fi = null;
        if (deleteStatus) {
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.NOTEQUALS));
            fi.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("child.deletedStatus", (Object)2, CompareType.NOTEQUALS));
            fi.setMaskString("(#0) or (#1 and #2)");
        }
        if (parentId == null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)this.treeInfo.getId(), CompareType.EQUALS));
            if (this.isSleapUp) {
                filter.getFilterItems().add(new FilterItemInfo("child.adminOrgUnit.isSealup", (Object)0, CompareType.EQUALS));
            }
            filter.mergeFilter(fi, "and");
            viewInfo.setFilter(filter);
            result = this.iPositionHierarchy.getPositionHierarchyCollection(viewInfo);
            if (result == null || result.size() == 0) {
                return null;
            }
            info = result.get(0);
        }
        filter = new FilterInfo();
        if (parentId == null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getChild().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId));
        }
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)this.treeInfo.getId(), CompareType.EQUALS));
        if ("00000000-0000-0000-0000-000000000001396FCAD0".equals(this.treeInfo.getId().toString())) {
            filter.getFilterItems().add(new FilterItemInfo("child.adminOrgUnit.isSealUp", (Object)Boolean.FALSE));
        }
        if (this.isSleapUp) {
            filter.getFilterItems().add(new FilterItemInfo("child.adminOrgUnit.isSealup", (Object)0, CompareType.EQUALS));
        }
        filter.mergeFilter(fi, "and");
        viewInfo.setFilter(filter);
        result = this.iPositionHierarchy.getPositionHierarchyCollection(viewInfo);
        if (parentId == null) {
            if (result == null) {
                result = new PositionHierarchyCollection();
            }
            result.add((PositionHierarchyInfo)info);
        }
        if (deleteStatus) {
            this.convert(result);
        }
        return result;
    }

    private void convert(PositionHierarchyCollection phc) throws Exception {
        int i;
        if (phc == null || phc.size() == 0) {
            return;
        }
        Set phSet = new HashSet<String>();
        int size = phc.size();
        for (i = 0; i < size; ++i) {
            phSet.add(phc.get(i).getId().toString());
        }
        phSet = PositionHierarchyFactory.getRemoteInstance().convert(phSet);
        for (i = phc.size() - 1; i >= 0; --i) {
            if (phSet.contains(phc.get(i).getId().toString())) continue;
            phc.removeObject(i);
        }
    }
}

