/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.IJobCategory;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobException;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.JobSystemFactory;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.client.JobCategoryPromptBox;
import com.kingdee.eas.basedata.org.client.OrgInnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.client.AbstractJobEditUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class JobEditUI
extends AbstractJobEditUI {
    String resClass = "com.kingdee.eas.basedata.org.client.JobCategoryResource.";
    ICodingRuleManager iCodingRuleManager = null;
    boolean isAddview = false;
    boolean isAutoNumber = false;

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtNumber.requestFocusInWindow();
        try {
            this.setCodingRule();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setCodingRule() throws BOSException, EASBizException {
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        String companyId = OrgInnerUtils.getCurCompany();
        this.isAutoNumber = this.iCodingRuleManager.isExist((IObjectValue)this.editData, companyId);
        if (this.isAutoNumber) {
            this.isAddview = this.iCodingRuleManager.isAddView((IObjectValue)this.editData, companyId);
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
            if (this.isAddview && this.getOprtState() == OprtState.ADDNEW) {
                this.txtNumber.setText(this.iCodingRuleManager.readNumber((IObjectValue)this.editData, companyId));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            int groupModel = 0;
            try {
                groupModel = JobSystemFactory.getRemoteInstance().getJobSystemScheme();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            if (groupModel == 0 && !SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.btnAddNew.setVisible(false);
                this.btnCopy.setVisible(false);
                this.btnRemove.setVisible(false);
                this.btnSubmit.setVisible(false);
                this.btnEdit.setVisible(false);
                this.menuItemAddNew.setVisible(false);
                this.menuItemEdit.setVisible(false);
                this.menuItemCopy.setVisible(false);
                this.menuItemSave.setVisible(false);
                this.menuItemSubmit.setVisible(false);
                this.menuItemRemove.setVisible(false);
                this.actionAddNew.setEnabled(false);
                this.actionCopy.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionSubmit.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
        }
    }

    protected IObjectValue createNewData() {
        JobInfo info = new JobInfo();
        if (this.getUIContext().get("JobCategoryInfo") != null) {
            JobCategoryInfo cateInfo = (JobCategoryInfo)this.getUIContext().get("JobCategoryInfo");
            this.bizJobCategory.setValue((Object)cateInfo);
            info.setJobCategory(cateInfo);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return JobFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.bizJobCategory.getValue() == null) {
            this.bizJobCategory.requestFocusInWindow();
            throw new JobException(JobException.NO_SELECT_JOBCATEGORY);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("jobCategory.*"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("NoRoot", "true");
        this.bizJobCategory.setSelector((KDPromptSelector)new JobCategoryPromptBox((IUIObject)this, ctx));
        this.bizJobCategory.setQueryInfo("com.kingdee.eas.basedata.org.app.JobCategoryQuery");
        this.bizJobCategory.setEditFormat("$number");
        this.bizJobCategory.setCommitFormat("$number");
        this.bizJobCategory.setDisplayFormat("$name");
        this.bizJobCategory.setRequired(true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId()));
        evi.setFilter(filter);
        this.bizJobCategory.setEntityViewInfo(evi);
        this.bizJobCategory.setHasCUDefaultFilter(false);
        if (this.getUIContext().get("ID") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            IJob iJob = JobFactory.getRemoteInstance();
            JobInfo jobInfo = iJob.getJobInfo((IObjectPK)pk);
            if (jobInfo.getJobType() != null) {
                // empty if block
            }
            if (jobInfo.getJobCategory() != null) {
                IJobCategory iJobCategory = JobCategoryFactory.getRemoteInstance();
                pk = new ObjectUuidPK(jobInfo.getJobCategory().getId());
                this.bizJobCategory.setValue((Object)iJobCategory.getJobCategoryInfo((IObjectPK)pk));
            }
        }
    }
}

