/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.core.util.OrgStructureUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.hraux.init.HRInitForBaseFactory;
import com.kingdee.eas.basedata.hraux.init.IHRInitForBase;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.AbstractPersonMainListUI2;
import com.kingdee.eas.basedata.person.client.PersonClientUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

public class PersonMainListUI2
extends AbstractPersonMainListUI2 {
    private String resClass = "com.kingdee.eas.basedata.person.client.PersonResource.";
    private boolean isInit = false;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.basedata.person.client.PersonEditUI2";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void onLoad() throws Exception {
        if (this.getMetaDataPK().getFullName().equals(PersonMainListUI2.class.getName())) {
            IHRInitForBase iHR = HRInitForBaseFactory.createInstance(null);
            this.isInit = iHR.isFinishInit();
        }
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.menuBiz.setVisible(true);
        this.menuItemImportData.setVisible(false);
        this.btnAssignPosition.setIcon(EASResource.getIcon((String)"imgTbtn_jobdistribute"));
        this.menuAssignPosition.setIcon(EASResource.getIcon((String)"imgTbtn_jobdistribute"));
        this.btnNoPositionEmpImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnNoPositionEmpExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemNoPositionEmpImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemNoPositionEmpExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.disableBtnBySHR();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (PersonMainListUI2.this.tblMain.getRowCount() != 0) {
                    PersonMainListUI2.this.tblMain.getSelectManager().select(0, 0);
                }
            }
        });
    }

    private void disableBtnBySHR() throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        try {
            boolean isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
            if (isAdmin) {
                filter.getFilterItems().add(new FilterItemInfo("ADMIN.longNumber", (Object)(SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("ADMIN.longNumber", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber()));
                filter.setMaskString("(#0 or #1)");
            } else {
                boolean reValue = Boolean.parseBoolean(ParamManager.getParamValue(null, null, (String)"CU_USERRANGE"));
                if (reValue) {
                    filter.getFilterItems().add(new FilterItemInfo("(admin.id IN(" + PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE) + "))"));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("CU2.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filter;
    }

    protected String getCurRowAdminOrgUnitId() {
        IRow row;
        String adminOrgUnitId = null;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length > 0 && (row = this.tblMain.getRow(rowID[0])) != null && row.getCell("AdminOrgUnit.id") != null && row.getCell("AdminOrgUnit.id").getValue() != null) {
            adminOrgUnitId = row.getCell("AdminOrgUnit.id").getValue().toString();
        }
        return adminOrgUnitId;
    }

    @Override
    public void actionAssignPosition_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInvalid()) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.resClass + "ASSIGN_POSITION_NOT_ALLOW")));
        } else {
            if (this.isInit) {
                throw new PersonException(PersonException.HRINIT_IS_FINISH_2);
            }
            int[] rowID = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            String[] personID = new String[rowID.length];
            if (rowID.length > 0) {
                for (int i = 0; i < rowID.length; ++i) {
                    personID[i] = this.tblMain.getRow(rowID[i]).getCell("id").getValue().toString();
                }
                PositionPromptBox2 pmt = null;
                Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                boolean reValue = HRParamUtil.getParamOfHR(null, (String)"CU_USERRANGE", null);
                boolean isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
                if (isAdmin) {
                    reValue = false;
                }
                if (reValue) {
                    hashMap.put("ADMIN_ORGRANGE", "BaseDataPosition");
                } else {
                    hashMap.put("CUR_CU_ALL_ADMIN", Boolean.TRUE);
                }
                pmt = ownerWindow instanceof Frame ? new PositionPromptBox2((Frame)ownerWindow, hashMap) : (ownerWindow instanceof Dialog ? new PositionPromptBox2((Dialog)ownerWindow, hashMap) : new PositionPromptBox2((Frame)null, hashMap));
                pmt.setModal(true);
                pmt.show();
                if (!pmt.isCanceled()) {
                    IPerson iPerson = PersonFactory.getRemoteInstance();
                    Object[] tt = (Object[])pmt.getData();
                    PositionInfo position = (PositionInfo)tt[0];
                    if (PersonClientUtils.isStartSHR(position)) {
                        MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "ADMIN_START_SHR")));
                        SysUtil.abort();
                    }
                    iPerson.assignPosition(personID, (PositionInfo)tt[0]);
                    MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SUCESS_ASSIGN_POSITION")));
                    this.tblMain.removeRows();
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
            }
        }
    }

    @Override
    public void actionNoPositionEmpExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInit) {
            throw new PersonException(PersonException.HRINIT_IS_FINISH_2);
        }
        this.exportData();
    }

    private void exportData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getExportParam() != null) {
            task.invoke(this.getExportParam(), 1);
        }
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.emp.noPositionEmpInfo";
        param.alias = EASResource.getString((String)(this.resClass + "NO_POSITION_EMP"));
        param.datataskMode = 1;
        Hashtable<String, Object> dataTaskCtx = new Hashtable<String, Object>();
        MetaDataPK exportQuery = new MetaDataPK("com.kingdee.eas.basedata.person.app", "NoPositionPerson");
        dataTaskCtx.put("mainQueryPK", exportQuery);
        dataTaskCtx.put("mainQuery", this.mainQuery);
        param.setContextParam(dataTaskCtx);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionNoPositionEmpImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInit) {
            throw new PersonException(PersonException.HRINIT_IS_FINISH_2);
        }
        super.actionNoPositionEmpImport_actionPerformed(e);
        String strSolutionName = "eas.hr.emp.noPositionEmpInfo";
        this.importData(strSolutionName);
        this.tblMain.removeRows();
    }

    private void importData(String strSolutionName) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam(strSolutionName) != null) {
            task.invoke(this.getImportParam(strSolutionName), 0, true);
        }
    }

    protected ArrayList getImportParam(String strSolutionName) {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = strSolutionName;
        param.alias = EASResource.getString((String)(this.resClass + "NO_POSITION_EMP"));
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInit) {
            throw new PersonException(PersonException.HRINIT_IS_FINISH_2);
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInit) {
            throw new PersonException(PersonException.HRINIT_IS_FINISH_2);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.isInvalid()) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
        } else {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
        }
    }

    private boolean isInvalid() throws Exception {
        int[] rowID;
        if (this.tblMain.getRowCount() > 0 && (rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length > 0) {
            if (this.tblMain.getRow(rowID[0]).getCell("deletedStatus") == null) {
                return false;
            }
            if (this.tblMain.getRow(rowID[0]).getCell("deletedStatus").getValue() == null) {
                return false;
            }
            BizEnumValueInfo enumInfo = (BizEnumValueInfo)this.tblMain.getRow(rowID[0]).getCell("deletedStatus").getValue();
            return Integer.parseInt(enumInfo.getValue().toString()) == 2;
        }
        return false;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        IPerson iPerson = PersonFactory.getRemoteInstance();
        ArrayList idValues = this.getSelectedIdValues();
        HashSet list = new HashSet(idValues);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", list, CompareType.INCLUDE));
        view.setFilter(filter);
        PersonCollection personCollection = iPerson.getPersonCollection(view);
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            AdminOrgUnitInfo gkAdmin = personInfo.getGkAdmin();
            if (gkAdmin == null) continue;
            OrgStructureUtils.checkAdminIsSealup((String)gkAdmin.getId().toString());
        }
        super.actionCancel_actionPerformed(e);
        this.tblMain.removeRows();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        IPerson iPerson = PersonFactory.getRemoteInstance();
        ArrayList idValues = this.getSelectedIdValues();
        HashSet list = new HashSet(idValues);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", list, CompareType.INCLUDE));
        view.setFilter(filter);
        PersonCollection personCollection = iPerson.getPersonCollection(view);
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            AdminOrgUnitInfo gkAdmin = personInfo.getGkAdmin();
            if (gkAdmin == null) continue;
            OrgStructureUtils.checkAdminIsSealup((String)gkAdmin.getId().toString());
        }
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            this.cancelCancel();
        }
        this.tblMain.removeRows();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }
}

