/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.AbstractPersonPositionEditUI;
import com.kingdee.eas.basedata.person.client.PersonClientUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class PersonPositionEditUI
extends AbstractPersonPositionEditUI {
    String resClass = "com.kingdee.eas.basedata.person.client.PersonResource.";
    PersonInfo info = null;
    public boolean isBlankByPerson = false;

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.info != null) {
            this.bizPromptPerson.setValue((Object)this.info.getName());
        }
    }

    @Override
    public void storeFields() {
        this.editData.setPerson(this.info);
        this.editData.setPosition((PositionInfo)this.bizPromptPosition.getData());
        this.editData.setIsPrimary(this.chtIsPrimary.isSelected());
    }

    protected IObjectValue createNewData() {
        return new PositionMemberInfo();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return PositionMemberFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.initWorkButton();
        this.editData = new PositionMemberInfo();
        if (this.getUIContext().get("PersonInfo") != null) {
            this.info = (PersonInfo)this.getUIContext().get("PersonInfo");
            this.bizPromptPerson.setValue((Object)this.info.getName());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        boolean reValue = HRParamUtil.getParamOfHR(null, (String)"CU_USERRANGE", null);
        boolean isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
        if (isAdmin) {
            reValue = false;
        }
        if (reValue) {
            map.put("ADMIN_ORGRANGE", "BaseDataPosition");
        } else {
            map.put("ALL_ADMIN", (String)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        this.bizPromptPosition.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.bizPromptPosition.setEditFormat("$number$");
        this.bizPromptPosition.setDisplayFormat("$name$");
        this.bizPromptPosition.setCommitFormat("$number$");
        this.bizPromptPosition.setQueryInfo("com.kingdee.eas.basedata.org.app.PositionQuery4Fuzzy");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        this.bizPromptPosition.setEntityViewInfo(evi);
        this.bizPromptPosition.setHasCUDefaultFilter(false);
        if (this.getUIContext().get("INDEX") != null) {
            IRow row = null;
            Integer index = (Integer)this.getUIContext().get("INDEX");
            KDTable tblPositionList = (KDTable)this.getUIContext().get("PositionList");
            row = tblPositionList.getRow(index.intValue());
            PositionInfo pInfo = new PositionInfo();
            pInfo.setId(BOSUuid.read((String)row.getCell("Position.id").getValue().toString()));
            pInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(pInfo.getId()));
            this.bizPromptPosition.setValue((Object)pInfo);
            this.txtAdminOrgUnit.setText(row.getCell("Admin.name").getValue().toString());
            if (row.getCell("Job.name") != null && row.getCell("Job.name").getValue() != null) {
                this.txtJob.setText(row.getCell("Job.name").getValue().toString());
            }
            if (row.getCell("isPrimary").getValue().toString().equalsIgnoreCase("1") || row.getCell("isPrimary").getValue().toString().equalsIgnoreCase("true")) {
                this.chtIsPrimary.setSelected(true);
                this.chtIsPrimary.setEnabled(false);
            } else {
                this.chtIsPrimary.setSelected(false);
            }
        }
        if (this.getUIContext().get("primary") != null && ((Boolean)this.getUIContext().get("primary")).booleanValue()) {
            this.chtIsPrimary.setSelected(true);
            this.chtIsPrimary.setEnabled(false);
        }
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
        }
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.verifyInput(e);
        PositionInfo positionInfo = (PositionInfo)this.bizPromptPosition.getData();
        KDTable tblPositionList = (KDTable)this.getUIContext().get("PositionList");
        String positionId = "";
        for (i = 0; i < tblPositionList.getRowCount(); ++i) {
            positionId = tblPositionList.getRow(i).getCell("Position.id").getValue().toString();
            if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState()) && positionId.equals(positionInfo.getId().toString())) {
                throw new PositionException(PositionException.EXIST_POSITION);
            }
            if (!OprtState.EDIT.equalsIgnoreCase(this.getOprtState()) || !positionId.equals(positionInfo.getId().toString()) || (Integer)this.getUIContext().get("INDEX") == i) continue;
            throw new PositionException(PositionException.EXIST_POSITION);
        }
        if (this.chtIsPrimary.isSelected()) {
            for (i = 0; i < tblPositionList.getRowCount(); ++i) {
                boolean isStartSHR;
                if (tblPositionList.getRow(i).getCell("isPrimary").getValue() != null && ((Boolean)tblPositionList.getRow(i).getCell("isPrimary").getValue()).booleanValue() && (isStartSHR = PersonClientUtils.isStartSHRByPositionId(tblPositionList.getRow(i).getCell("Position.id").getValue().toString()))) {
                    throw new PersonException(PersonException.CANNOT_UPDATE_PRAIMARY_POSITION);
                }
                tblPositionList.getRow(i).getCell("isPrimary").setValue((Object)new Boolean(false));
            }
            this.chtIsPrimary.setEnabled(false);
        }
        IRow row = null;
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            row = tblPositionList.addRow();
        } else {
            Integer index = (Integer)this.getUIContext().get("INDEX");
            row = tblPositionList.getRow(index.intValue());
        }
        row.getCell("isPrimary").setValue((Object)new Boolean(this.chtIsPrimary.isSelected()));
        row.getCell("Position.name").setValue((Object)positionInfo.getName());
        row.getCell("Job.name").setValue((Object)this.txtJob.getText());
        row.getCell("Admin.name").setValue((Object)this.txtAdminOrgUnit.getText());
        row.getCell("Admin.id").setValue((Object)positionInfo.getAdminOrgUnit().getId().toString());
        row.getCell("Position.id").setValue((Object)positionInfo.getId());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SUBMIT_SUCESS")));
        this.btnAddNew.setEnabled(true);
        this.actionAddNew_actionPerformed(null);
    }

    @Override
    protected void bizPromptPosition_dataChanged(DataChangeEvent e) throws Exception {
        PositionInfo pInfo = (PositionInfo)this.bizPromptPosition.getData();
        if (pInfo != null) {
            if (PersonClientUtils.isStartSHR(pInfo)) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "ADMIN_START_SHR")));
                this.bizPromptPosition.setText("");
                this.isBlankByPerson = true;
                SysUtil.abort();
            }
            IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(pInfo.getAdminOrgUnit().getId());
            this.txtAdminOrgUnit.setText(iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)pk).getName());
            IJob iJob = JobFactory.getRemoteInstance();
            try {
                if (pInfo.getJob() == null) {
                    return;
                }
                pk = new ObjectUuidPK(pInfo.getJob().getId());
            }
            catch (Exception ef) {
                return;
            }
            this.txtJob.setText(iJob.getJobInfo((IObjectPK)pk).getName());
        } else {
            this.txtJob.setText("");
            this.txtAdminOrgUnit.setText("");
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isBlankByPerson) {
            this.isBlankByPerson = false;
            SysUtil.abort();
        }
        if (this.info == null) {
            throw new PersonException(PersonException.NO_SELECT_POSITION);
        }
        if (this.bizPromptPosition.getData() == null) {
            throw new PersonException(PersonException.NO_SELECT_POSITION);
        }
        PositionInfo position = (PositionInfo)this.bizPromptPosition.getData();
        if (PersonClientUtils.isStartSHR(position)) {
            SysUtil.abort();
        }
    }

    @Override
    protected void chtIsPrimary_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState("ADDNEW");
        this.txtJob.setText("");
        this.txtAdminOrgUnit.setText("");
        this.bizPromptPosition.setData(null);
        this.chtIsPrimary.setEnabled(true);
        this.chtIsPrimary.setSelected(false);
    }
}

