/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client.tree;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AdminPositionTreeBuilder {
    private int initalLevel;
    private int expandLevel;
    private BOSUuid adminTreeID = null;
    private Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private IQueryExecutor queryExcu = null;
    private static HashMap nodeCache = null;
    private static HashMap nodeCache2 = null;
    public static boolean rebuildTree = false;
    private static String oldDSessionId = null;
    private boolean rebuild = false;

    public AdminPositionTreeBuilder(int initalLevel, int expandLevel) throws Exception {
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
    }

    public AdminPositionTreeBuilder(int initalLevel, int expandLevel, boolean rebuild) throws Exception {
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.rebuild = rebuild;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
    }

    private IRowSet getPositionList(AdminOrgUnitInfo adminInfo, boolean includeSealUp, boolean includeChildCU) throws Exception {
        FilterInfo filter;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "%"), CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminInfo.getLongNumber(), CompareType.EQUALS));
        if (includeChildCU) {
            fi.setMaskString("#0 or #1");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("CU2.id", (Object)cuID));
            fi.setMaskString("(#0 or #1) and #2");
        }
        boolean isDistabled = HRParamUtil.getParamOfHR(null, (String)"IS_AFFAIR", null);
        if (!isDistabled) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", null));
            filter.setMaskString("#0 or #1");
            fi.mergeFilter(filter, "and");
        }
        if (!includeSealUp) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.isSealUp", (Object)Boolean.FALSE));
            fi.mergeFilter(filter, "and");
        }
        viewInfo.setFilter(fi);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("index"));
        selector.add(new SelectorItemInfo("AdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("DefaultPosition"));
        selector.add(new SelectorItemInfo("adminOrgUnit.isStartSHR"));
        viewInfo.setSelector(selector);
        this.queryExcu.setObjectView(viewInfo);
        return this.queryExcu.executeQuery();
    }

    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, false);
    }

    public JTree buildTree(JTree tree, boolean includeSealUp) throws Exception {
        return this.buildTree(tree, includeSealUp, false);
    }

    public JTree buildTree(JTree tree, boolean includeSealUp, boolean includeChildCU) throws Exception {
        if (nodeCache == null) {
            nodeCache = new HashMap();
        }
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache.clear();
        }
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        DefaultKingdeeTreeNode rootNode = null;
        String key = oldDSessionId + cuID + includeSealUp;
        if (nodeCache.get(key) != null && !this.rebuild) {
            rootNode = (DefaultKingdeeTreeNode)nodeCache.get(key);
        } else {
            rootNode = this.createRootNode(includeSealUp, includeChildCU);
            nodeCache.put(key, rootNode);
        }
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        return tree;
    }

    public JTree buildAllAdminTree(JTree tree) throws Exception {
        return this.buildAllAdminTree(tree, false);
    }

    public JTree buildAllAdminTree(JTree tree, boolean includeSealUp) throws Exception {
        if (nodeCache2 == null) {
            nodeCache2 = new HashMap();
        }
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache2.clear();
        }
        DefaultKingdeeTreeNode rootNode = null;
        String key = oldDSessionId + includeSealUp;
        if (nodeCache2.get(key) != null) {
            rootNode = (DefaultKingdeeTreeNode)nodeCache2.get(key);
        } else {
            rootNode = this.createAllAdminRootNode(includeSealUp);
            nodeCache2.put(key, rootNode);
        }
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        return tree;
    }

    private DefaultKingdeeTreeNode createRootNode(boolean includeSealUp, boolean includeChildCU) throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        IRowSet rows = AdminPositionTreeBuilder.getAdminRowSet(cuID, null, false, includeSealUp, includeChildCU);
        return this.buildTreeByRowSet(rows, includeSealUp, includeChildCU);
    }

    private DefaultKingdeeTreeNode createAllAdminRootNode(boolean includeSealUp) throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        IRowSet rows = AdminPositionTreeBuilder.getAdminRowSet(cuID, null, true, includeSealUp, false);
        return this.buildTreeByRowSet(rows, includeSealUp);
    }

    private PositionInfo createPositionInfo(IRowSet row) throws Exception {
        PositionInfo info = new PositionInfo();
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        info.setName(row.getString("name"));
        adminInfo.setId(BOSUuid.read((String)row.getString("adminOrgUnit.id")));
        adminInfo.setIsStartSHR(Boolean.valueOf(row.getString("adminOrgUnit.isStartSHR")).booleanValue());
        info.setAdminOrgUnit(adminInfo);
        return info;
    }

    public void refreshTreeNode(KDTreeNode treeNode) throws Exception {
    }

    public DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rows, boolean includeSealUp) throws Exception {
        return this.buildTreeByRowSet(rows, includeSealUp, false);
    }

    public DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rows, boolean includeSealUp, boolean includeChildCU) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        KDTreeNode subTreeNode = null;
        DefaultKingdeeTreeNode childNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        int index = 0;
        AdminOrgUnitInfo adminInfo = null;
        while (rows.next()) {
            adminInfo = AdminPositionTreeBuilder.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(this.groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(this.companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        if (rootTreeNode != null) {
            adminInfo = (AdminOrgUnitInfo)rootTreeNode.getUserObject();
            IRowSet rows2 = this.getPositionList(adminInfo, includeSealUp, includeChildCU);
            String adminID = null;
            PositionInfo positionInfo = null;
            DefaultKingdeeTreeNode positionTreeNode = null;
            index = 0;
            while (rows2.next()) {
                positionInfo = this.createPositionInfo(rows2);
                positionTreeNode = new DefaultKingdeeTreeNode((Object)positionInfo);
                positionTreeNode.setCustomIcon(this.positionIcon);
                adminID = rows2.getString("AdminOrgUnit.id");
                if (!nodeMap.containsKey(adminID)) continue;
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(adminID);
                if (rows2.getBoolean("DefaultPosition")) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                    continue;
                }
                if (parentNode.getChildCount() > 0) {
                    childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(0);
                    index = rows2.getInt("index") + 1;
                    if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() > index && rows2.getString("index") != null && rows2.getInt("index") >= 0) {
                        AdminPositionTreeBuilder.insertPositionNode(parentNode, positionTreeNode, index);
                        continue;
                    }
                    if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() <= index) {
                        AdminPositionTreeBuilder.insertPositionNode(parentNode, positionTreeNode, parentNode.getChildCount());
                        continue;
                    }
                    if (childNode.getUserObject() instanceof PositionInfo) {
                        parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                        continue;
                    }
                    parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                    continue;
                }
                parentNode.add((MutableTreeNode)positionTreeNode);
            }
        }
        return rootTreeNode;
    }

    private static void insertPositionNode(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode child, int index) {
        for (int i = index; i > 0; --i) {
            if (!(((DefaultKingdeeTreeNode)parent.getChildAt(i - 1)).getUserObject() instanceof PositionInfo)) continue;
            parent.insert((MutableTreeNode)child, i);
            return;
        }
        parent.insert((MutableTreeNode)child, 0);
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        adminInfo.setIsStartSHR(row.getBoolean("isStartSHR"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static IRowSet getAdminRowSet(String cuID, AdminOrgUnitInfo rootInfo, boolean isAllAdmin, boolean includeSealUp, boolean includeChildCU) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 and #1");
        }
        if (!isAllAdmin) {
            if (includeChildCU) {
                CtrlUnitInfo cuInfo = StringUtils.isEmpty((String)cuID) ? SysContext.getSysContext().getCurrentCtrlUnit() : CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuID)));
                FilterInfo aFilter = new FilterInfo();
                aFilter.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)cuInfo.getLongNumber()));
                aFilter.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)(cuInfo.getLongNumber() + "!%"), CompareType.LIKE));
                aFilter.setMaskString("#0 or #1 ");
                fi.mergeFilter(aFilter, "and");
            } else {
                FilterInfo aFilter = new FilterInfo();
                aFilter.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
                fi.mergeFilter(aFilter, "and");
            }
        }
        if (!includeSealUp) {
            FilterInfo sFilter = new FilterInfo();
            sFilter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE));
            fi.mergeFilter(sFilter, "and");
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }
}

