/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.LocaleUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class MutiLangeTool {
    private static Locale[] allLocales = null;

    public static void muti2Obj(IObjectValue source, IObjectValue dest, String name) {
        if (source == null || dest == null) {
            return;
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            LanguageInfo info = (LanguageInfo)langList.get(i);
            dest.put(name + "_" + info.getLocale(), source.get(name, info.getLocale()));
            if (!SysContext.getSysContext().getLocale().equals(info.getLocale())) continue;
            dest.put(name, source.get(name, info.getLocale()));
        }
    }

    public static void addValueInfo(IObjectValue source, String name, String value) {
        if (source == null || value == null || value.trim().equals("")) {
            return;
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            LanguageInfo info = (LanguageInfo)langList.get(i);
            source.put(name + "_" + info.getLocale(), (Object)(source.get(name, info.getLocale()) + value));
            if (!SysContext.getSysContext().getLocale().equals(info.getLocale())) continue;
            source.put(name, (Object)(source.get(name, info.getLocale()) + value));
        }
    }

    public static LanguageInfo getDefaultLanguage() {
        return new LanguageInfo(SysContext.getSysContext().getLocale());
    }

    public static synchronized Locale[] getDefinedLocales(Context ctx) {
        if (allLocales == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo solutionInfo = loader.getSolution();
            LanguageCollection languages = solutionInfo.getLanguages();
            int size = languages.size();
            allLocales = new Locale[size];
            for (int i = 0; i < size; ++i) {
                MutiLangeTool.allLocales[i] = languages.get(i).getLocale();
            }
        }
        return (Locale[])allLocales.clone();
    }

    public static void copyMultiLangProperty(Context ctx, IObjectValue origin, IObjectValue dest, String prop) {
        Locale[] defLocales = MutiLangeTool.getDefinedLocales(ctx);
        for (int i = 0; i < defLocales.length; ++i) {
            dest.put(prop, origin.get(prop, defLocales[i]), defLocales[i]);
        }
    }

    public static void loadMultiLangFieldsForMeta(KDMultiLangBox mlb, IObjectValue data, String propertyName) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            Locale l = MutiLangeTool.locale2originLocale(currentLang.getLocale());
            mlb.addItem(currentLang, data.get(propertyName, l));
            if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
            defaultLang = currentLang;
        }
        if (defaultLang != null) {
            mlb.setSelectedLanguage(defaultLang);
        }
    }

    private static Locale locale2originLocale(Locale locale) {
        Locale l = null;
        l = new Locale("l1").equals(locale) ? LocaleUtils.locale_en_US : (new Locale("l2").equals(locale) ? LocaleUtils.locale_zh_CN : (new Locale("l3").equals(locale) ? LocaleUtils.locale_zh_TW : LocaleUtils.locale_zh_CN));
        return l;
    }

    public static void newMuti2Obj(IObjectValue source, IObjectValue dest, String name) {
        if (source == null || dest == null) {
            return;
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            LanguageInfo info = (LanguageInfo)langList.get(i);
            Locale l = MutiLangeTool.locale2originLocale(info.getLocale());
            dest.put(name + "_" + info.getLocale(), source.get(name, l));
            if (!SysContext.getSysContext().getLocale().equals(info.getLocale())) continue;
            dest.put(name, source.get(name, SysContext.getSysContext().getOriginLocale()));
        }
    }
}

