/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.TouchType;
import com.kingdee.eas.base.forewarn.client.AbstractAddFWTempletUI;
import com.kingdee.eas.base.forewarn.client.helper.TreeModelFilterImpl;
import com.kingdee.eas.base.forewarn.utils.TreeModelHelper;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AddFWTempletUI
extends AbstractAddFWTempletUI {
    private static final Logger logger = CoreUIObject.getLogger(AddFWTempletUI.class);
    private ForewarnItemInfo forewarnItemInfo = null;
    private String subSys = "";

    public AddFWTempletUI() throws Exception {
        this.init();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder == null) {
            clientHanlder = UIActionPostman.getInstance((IUIObject)this);
        }
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void init() {
        this.kDButtonGroup1.add((AbstractButton)this.btnSchedule);
        this.kDButtonGroup1.add((AbstractButton)this.btnRightnow);
        this.btnSchedule.setSelected(true);
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.kDScrollPane1.setBorder(LineBorder.createGrayLineBorder());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.forewarnItemInfo = (ForewarnItemInfo)this.getUIContext().get("forewarnInfo");
    }

    public void onLoad() {
        super.onLoad();
        this.loadFields();
        this.kDTree1.setSelectionRow(0);
        this.kDTree1.setNextFocusableComponent((Component)this.btnConfirm);
        this.btnConfirm.setNextFocusableComponent((Component)this.btnCancel);
        this.btnCancel.setNextFocusableComponent((Component)this.btnSchedule);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getSubSysName() {
        return this.subSys;
    }

    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDTree1_valueChanged(e);
    }

    protected void kDTree1_mouseClicked(MouseEvent e) throws Exception {
        if (e.getButton() == 1 && e.getClickCount() == 2 && this.onConfirm()) {
            super.btnConfirm_actionPerformed(null);
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.onConfirm()) {
            super.btnConfirm_actionPerformed(e);
        }
    }

    private boolean onConfirm() {
        TreePath paths = this.kDTree1.getSelectionPath();
        DefaultKingdeeTreeNode treeNode = null;
        if (paths != null) {
            treeNode = (DefaultKingdeeTreeNode)paths.getLastPathComponent();
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)treeNode.getParent();
            if (parentNode != null) {
                MetaDataBriefInfo tmp = (MetaDataBriefInfo)parentNode.getUserObject();
                this.subSys = tmp.getAlias();
            }
        } else {
            return false;
        }
        if (this.btnRightnow.isSelected()) {
            BOSObjectType type;
            this.forewarnItemInfo.setTouchType(TouchType.RIGHTNOW_TYPE);
            treeNode = (DefaultKingdeeTreeNode)paths.getLastPathComponent();
            MetaDataBriefInfo tmp = (MetaDataBriefInfo)treeNode.getUserObject();
            if (tmp != null && (type = tmp.getMetaDataType()) != null && !type.equals((Object)MetaDataTypeList.ENTITY)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"OnlyOnEntity"));
                return false;
            }
        } else if (this.btnSchedule.isSelected()) {
            this.forewarnItemInfo.setTouchType(TouchType.SCHEDULE_TYPE);
            if (!this.isSelectFacadeAndEntity()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"OnlyOnEntityAndFacade"));
                return false;
            }
        }
        return true;
    }

    private boolean isSelectFacadeAndEntity() {
        TreePath paths = this.kDTree1.getSelectionPath();
        if (paths == null) {
            return false;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths.getLastPathComponent();
        MetaDataBriefInfo tmp = (MetaDataBriefInfo)treeNode.getUserObject();
        if (tmp == null || tmp.getMetaDataType() == null) {
            return false;
        }
        BOSObjectType type = tmp.getMetaDataType();
        return type.equals((Object)MetaDataTypeList.ENTITY) || type.equals((Object)MetaDataTypeList.FACADE);
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
    }

    @Override
    protected void btnRightnow_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType[] viewType = new BOSObjectType[]{MetaDataTypeList.ENTITY};
        this.changeUI(viewType);
    }

    private void filterMode(TreeModel treeModel) {
        try {
            TreeModelHelper helper = new TreeModelHelper();
            helper.setITreeModelFilter(new TreeModelFilterImpl());
            helper.filterNode((MutableTreeNode)treeModel.getRoot());
        }
        catch (Exception e) {
            logger.info((Object)"error:", (Throwable)e);
        }
    }

    @Override
    protected void btnSchedule_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType[] viewType = new BOSObjectType[]{MetaDataTypeList.ENTITY, MetaDataTypeList.FACADE};
        this.changeUI(viewType);
    }

    private void changeUI(BOSObjectType[] viewType) {
        this.getUIContext().put("types", viewType);
        this.onLoad();
    }
}

