/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnRunTimeFactory;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.client.AbstractForewarnAdvSetupUI;
import com.kingdee.eas.base.forewarn.client.ForewarnItemEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnItemUI;
import com.kingdee.eas.base.forewarn.client.ForewarnTempletEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SpinnerNumberModel;

public class ForewarnAdvSetupUI
extends AbstractForewarnAdvSetupUI {
    private ForewarnItemInfo forewarnItemInfo = null;
    private String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";

    public int getMaxInstances() {
        return (Integer)this.kDSpinnerMaxInstances.getValue();
    }

    public int getMaxForewarn() {
        return (Integer)this.kDSpinnerMaxForewarn.getValue();
    }

    public int getMaxMsg() {
        return (Integer)this.kDSpinnerMaxMsg.getValue();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.forewarnItemInfo = (ForewarnItemInfo)this.getUIContext().get("forewarnInfo");
        this.init();
        this.setUIProperties();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void init() {
        this.kDSpinnerMaxInstances.setValue((Object)new Integer(this.forewarnItemInfo.getMaxInstanceCount()));
        this.kDSpinnerMaxForewarn.setValue((Object)new Integer(this.forewarnItemInfo.getMaxForewarnCount()));
        this.kDSpinnerMaxMsg.setValue((Object)new Integer(this.forewarnItemInfo.getMaxMessageCount()));
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkAdvSet();
        this.forewarnItemInfo.setMaxForewarnCount(this.getMaxForewarn());
        this.forewarnItemInfo.setMaxInstanceCount(this.getMaxInstances());
        this.forewarnItemInfo.setMaxMessageCount(this.getMaxMsg());
        Object parentUI = this.getUIContext().get("Owner");
        if (parentUI instanceof ForewarnTempletEditUI) {
            ForewarnTempletEditUI editUI = (ForewarnTempletEditUI)parentUI;
            editUI.isForewarnAdvSetupUISubmit = true;
        }
        this.getUIWindow().close();
    }

    private void setUIProperties() {
        this.kDTextAreaAdvSet.setSelectedItemData((Object)EASResource.getString((String)this.forewarnRes, (String)"advNote"));
        this.kDTextAreaAdvSet.setBorder(BorderFactory.createEmptyBorder());
        this.setUITitle(EASResource.getString((String)this.forewarnRes, (String)"advSet"));
        this.btnChcInstCombCount.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        ((SpinnerNumberModel)this.kDSpinnerMaxForewarn.getModel()).setMaximum(new Integer(100000));
        ((SpinnerNumberModel)this.kDSpinnerMaxForewarn.getModel()).setMinimum(new Integer(0));
        ((SpinnerNumberModel)this.kDSpinnerMaxInstances.getModel()).setMaximum(new Integer(100000));
        ((SpinnerNumberModel)this.kDSpinnerMaxInstances.getModel()).setMinimum(new Integer(0));
        ((SpinnerNumberModel)this.kDSpinnerMaxMsg.getModel()).setMaximum(new Integer(100000));
        ((SpinnerNumberModel)this.kDSpinnerMaxMsg.getModel()).setMinimum(new Integer(0));
        if (!this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
                this.kDSpinnerMaxForewarn.setEnabled(false);
                this.kDSpinnerMaxInstances.setEnabled(false);
                this.kDSpinnerMaxMsg.setEnabled(false);
                this.btnChcInstCombCount.setEnabled(false);
            } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
                // empty if block
            }
        }
    }

    private void checkAdvSet() {
        if (this.getMaxInstances() > 10000) {
            String msg = EASResource.getString((String)this.forewarnRes, (String)"maxInstancesWarning") + 10000 + EASResource.getString((String)this.forewarnRes, (String)"maxInstancesWarning1");
            this.kDSpinnerMaxInstances.requestFocus();
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) != 0) {
                SysUtil.abort();
            }
        } else if (this.getMaxForewarn() > 1000) {
            String msg = EASResource.getString((String)this.forewarnRes, (String)"maxForewarnWarning") + 1000 + EASResource.getString((String)this.forewarnRes, (String)"maxForewarnWarning1");
            this.kDSpinnerMaxForewarn.requestFocus();
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) != 0) {
                SysUtil.abort();
            }
        } else if (this.getMaxMsg() > 1000) {
            String msg = EASResource.getString((String)this.forewarnRes, (String)"maxMessageWarning") + 1000 + EASResource.getString((String)this.forewarnRes, (String)"maxMessageWarning1");
            this.kDSpinnerMaxMsg.requestFocus();
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) != 0) {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionChcInstCombCount_actionPerformed(ActionEvent e) throws Exception {
        super.actionChcInstCombCount_actionPerformed(e);
        Object parentUI = this.getUIContext().get("Owner");
        if (parentUI instanceof ForewarnTempletEditUI) {
            ForewarnTempletEditUI editUI = (ForewarnTempletEditUI)parentUI;
            try {
                editUI.checkObjectFilter();
            }
            catch (AbortException e1) {
                return;
            }
            ForewarnObjectCollection objects = editUI.getCurrentForewarnObjects();
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                EntityViewInfo entityViewInfo;
                ForewarnObjectInfo forewarnObject = objects.get(i);
                if (forewarnObject.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY) || !ForewarnUtil.hasDefaultOrg((entityViewInfo = ForewarnUtil.processEntityViewInfo(new EntityViewInfo(forewarnObject.getEntityViewInfo()))).getFilter())) continue;
                MsgBox.showWarning((Component)((Object)this), (String)("\"" + forewarnObject.getAlias() + "\" " + EASResource.getString((String)this.forewarnRes, (String)"filterHasDefaultOrgCombination")));
                return;
            }
            int count = ForewarnRunTimeFactory.getRemoteInstance().getCombinedInstanceCount(objects);
            MsgBox.showInfo((String)(EASResource.getString((String)this.forewarnRes, (String)"checkInstanceCombinationCount") + " " + String.valueOf(count)));
        } else if (parentUI instanceof ForewarnItemEditUI) {
            ForewarnItemEditUI editUI = (ForewarnItemEditUI)parentUI;
            try {
                editUI.checkObjectFilter();
            }
            catch (AbortException e1) {
                return;
            }
            ForewarnObjectCollection objects = this.forewarnItemInfo.getObjects();
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                EntityViewInfo entityViewInfo;
                ForewarnObjectInfo forewarnObject = objects.get(i);
                if (forewarnObject.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY) || !ForewarnUtil.hasDefaultOrg((entityViewInfo = ForewarnUtil.processEntityViewInfo(new EntityViewInfo(forewarnObject.getEntityViewInfo()))).getFilter())) continue;
                ForewarnItemUI forewarnItemUI = (ForewarnItemUI)editUI.getUIContext().get("Owner");
            }
            int count = ForewarnRunTimeFactory.getRemoteInstance().getCombinedInstanceCount(objects);
            MsgBox.showInfo((String)(EASResource.getString((String)this.forewarnRes, (String)"checkInstanceCombinationCount") + " " + String.valueOf(count)));
        }
    }

    protected JButton getDefaultButton() {
        return this.kDButtonConfirm;
    }
}

