/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.forewarn.DataType;
import com.kingdee.eas.base.forewarn.ForewarnConditionInfo;
import com.kingdee.eas.base.forewarn.ForewarnConstant;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnRunTimeFactory;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnThresholdInfo;
import com.kingdee.eas.base.forewarn.ItemState;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.Priority;
import com.kingdee.eas.base.forewarn.client.AbstractForewarnItemEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnAdvSetupUI;
import com.kingdee.eas.base.forewarn.client.ForewarnItemUI;
import com.kingdee.eas.base.forewarn.client.ForewarnProcessor;
import com.kingdee.eas.base.forewarn.client.ForewarnTempletEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.base.forewarn.client.FormulaDialog;
import com.kingdee.eas.base.forewarn.client.IThresholdProvider;
import com.kingdee.eas.base.forewarn.client.ReceiverPartUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ForewarnItemEditUI
extends AbstractForewarnItemEditUI
implements IThresholdProvider {
    private String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";
    Logger logger = Logger.getLogger((String)ForewarnTempletEditUI.class.getName());
    private ForewarnObjectInfo currentForewarnObject = null;
    private BusinessObjectInfo[] businessObjectInfos = null;
    private ForewarnItemInfo bakForewarnItemInfo = null;
    private JButton contentFormula;
    private JButton msgParamFormula;
    private Map filterPanels = null;
    private int currentObjectRowIndex = -1;
    private JButton btnCheckInstanceCount;
    private JButton btnTestMsgBodyScript;
    private JButton btnMsgAttrFormula;
    private KDBizMultiLangArea textAreaCtrlCondition;
    private KDBizMultiLangArea textAreaCtrlMsgContent;
    private ReceiverPartUI receiverPartUI = null;
    private boolean isConfirm = false;
    private boolean isDisplayConditionTab = false;
    private boolean isDisplayMsgTab = false;

    public ForewarnItemEditUI() throws Exception {
        this.init();
    }

    private void init() {
        this.initTables();
        this.initButtons();
        this.initOther();
        this.installListener();
    }

    private void initTables() {
        this.kDTableObject.checkParsed();
        this.kDTableObject.getSelectManager().setSelectMode(2);
        this.kDTableObject.getSelectManager().setSelectMode(2);
        this.kDTableThreshold.checkParsed();
        this.kDTableThreshold.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kDTableThreshold.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void initButtons() {
        this.actionContentFormula.putValue("ShortDescription", EASResource.getString((String)this.forewarnRes, (String)"messageExpEdit"));
        this.actionContentFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_messageexpressionedit"));
        this.actionContentFormula.putValue("Name", "");
        this.contentFormula = this.kDContainerContent.add((Action)((Object)this.actionContentFormula));
        this.actionMsgParamFormula.putValue("ShortDescription", EASResource.getString((String)this.forewarnRes, (String)"paramExpEdit"));
        this.actionMsgParamFormula.putValue("Name", "");
        this.actionMsgParamFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionMsgParamFormula.setEnabled(true);
        this.msgParamFormula = this.kDContainerContent.add((Action)((Object)this.actionMsgParamFormula));
        this.kDWorkButtonAdvSet.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.kDWorkButtonTitle.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnCheckInstanceCount = new KDWorkButton();
        this.btnCheckInstanceCount.setAction((Action)((Object)this.actionCheckInstanceCount));
        this.btnCheckInstanceCount.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"checkInstanceCount"));
        this.btnCheckInstanceCount.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnCheckInstanceCount.setText("");
        this.btnTestMsgTitleScript.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.actionAttrFormula.putValue("ShortDescription", EASResource.getString((String)this.forewarnRes, (String)"attrExpEdit"));
        this.actionAttrFormula.putValue("Name", "");
        this.actionAttrFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnMsgAttrFormula = this.kDContainerAttrVal.add((Action)((Object)this.actionAttrFormula));
        this.btnMsgAttrFormula.setSize(new Dimension(22, 19));
        this.btnMsgAttrFormula.setText("");
        this.btnMsgAttrFormula.setVisible(false);
        this.actionTestMsgBodyScript.putValue("ShortDescription", EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"testMsgBodyScript"));
        this.actionTestMsgBodyScript.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionTestMsgBodyScript.putValue("Name", "");
        this.btnTestMsgBodyScript = this.kDContainerContent.add((Action)((Object)this.actionTestMsgBodyScript));
        this.btnTestMsgBodyScript.setSize(new Dimension(22, 19));
        this.btnConfirm.setEnabled(true);
    }

    private void initOther() {
        this.filterPanels = new HashMap();
        this.kDComboBoxPriority.removeAllItems();
        this.kDComboBoxPriority.addItems(Priority.getEnumList().toArray());
        this.textAreaCtrlCondition = new KDBizMultiLangArea();
        this.textAreaCtrlMsgContent = new KDBizMultiLangArea();
        this.kDScrollPaneCondition = this.textAreaCtrlCondition;
        this.kDScrollPaneMsgContent = this.textAreaCtrlMsgContent;
        this.kDScrollPaneMsgContent.setEditable(false);
        this.kDTextFieldMsgTitle.getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String oldTitleScript;
                if (ForewarnItemEditUI.this.editData.getMessage() != null && ForewarnItemEditUI.this.editData.getMessage().getTitleScript() != null && !(oldTitleScript = ForewarnItemEditUI.this.editData.getMessage().getTitleScript()).equalsIgnoreCase("")) {
                    String newTitle;
                    String oldTitle = ForewarnItemEditUI.this.editData.getMessage().getTitle();
                    String string = newTitle = ForewarnItemEditUI.this.kDTextFieldMsgTitle.getSelectedItem() == null ? "" : StringUtils.cnulls((Object)ForewarnItemEditUI.this.kDTextFieldMsgTitle.getSelectedItem());
                    if (!oldTitle.trim().equalsIgnoreCase(newTitle.trim())) {
                        if (KDOptionPane.showConfirmDialog((Component)((Object)ForewarnItemEditUI.this), (Object)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"modifyComplexTitleWarning")) == 0) {
                            ForewarnItemEditUI.this.editData.getMessage().setTitle(newTitle);
                            ForewarnItemEditUI.this.editData.getMessage().setTitleScript("");
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    }
                }
            }
        });
        this.textAreaCtrlMsgContent.getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String oldBodyScript;
                if (ForewarnItemEditUI.this.textAreaCtrlMsgContent.hasFocus() && ForewarnItemEditUI.this.editData.getMessage() != null && ForewarnItemEditUI.this.editData.getMessage().getBodyScript() != null && !(oldBodyScript = ForewarnItemEditUI.this.editData.getMessage().getBodyScript()).equalsIgnoreCase("")) {
                    String newBody;
                    String oldBody = ForewarnItemEditUI.this.editData.getMessage().getBody();
                    String string = newBody = ForewarnItemEditUI.this.textAreaCtrlMsgContent.getSelectedItem() == null ? "" : StringUtils.cnulls((Object)ForewarnItemEditUI.this.textAreaCtrlMsgContent.getSelectedItem());
                    if (!oldBody.trim().equalsIgnoreCase(newBody)) {
                        if (KDOptionPane.showConfirmDialog((Component)((Object)ForewarnItemEditUI.this), (Object)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"modifyComplexContentWarning")) == 0) {
                            ForewarnItemEditUI.this.editData.getMessage().setBody(newBody);
                            ForewarnItemEditUI.this.editData.getMessage().setBodyScript("");
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    }
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        try {
            this.receiverPartUI = new ReceiverPartUI();
            this.kDPanelMessage.add((Component)((Object)this.receiverPartUI), null);
            this.receiverPartUI.initLayout();
            this.receiverPartUI.setBounds(new Rectangle(8, 25, 680, 60));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onLoad() throws Exception {
        this.setDataObject((IObjectValue)((ForewarnItemInfo)this.getUIContext().get("ForewarnItem")));
        this.display();
        this.setUIProperties();
    }

    private void setUIProperties() {
        block6: {
            block5: {
                this.kDTextAreaAttrKey.setEditable(false);
                this.kDTextAreaAttrVal.setEditable(false);
                this.textAreaCtrlMsgContent.setEditable(false);
                this.textAreaCtrlMsgContent.getEditorComponent().setBackground(ForewarnConstant.UNEDIT_COLOR);
                this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"forewarnItemSetting"));
                this.textAreaCtrlCondition.setEditable(false);
                this.textAreaCtrlCondition.getEditorComponent().setBackground(ForewarnConstant.UNEDIT_COLOR);
                this.kDTableObject.getStyleAttributes().setLocked(true);
                this.kDTableObject.getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                this.kDTableObject.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
                this.kDTableObject.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
                this.kDTableThreshold.getColumn(2).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                this.kDTableThreshold.getColumn(3).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                this.kDTableThreshold.getColumn(5).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                if (!this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) break block5;
                this.kDTextFieldMsgTitle.setEnabled(false);
                this.kDWorkButtonTitle.setVisible(false);
                this.contentFormula.setVisible(false);
                this.msgParamFormula.setVisible(false);
                this.btnMsgAttrFormula.setVisible(false);
                this.kDComboBoxPriority.setEditable(false);
                this.kDComboBoxPriority.setEnabled(false);
                this.receiverPartUI.setComponetEnable(false);
                this.kDTableThreshold.getStyleAttributes().setLocked(true);
                this.kDTableThreshold.getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                Set filterPanelKey = this.filterPanels.keySet();
                Iterator ite = filterPanelKey.iterator();
                while (ite.hasNext()) {
                    CommonEntityFilterPanel panel = (CommonEntityFilterPanel)this.filterPanels.get(ite.next());
                    panel.getKdtTable().getStyleAttributes().setLocked(true);
                    panel.getKdtTable().getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                    panel.getKdtTable().getSelectManager().setSelectMode(2);
                    panel.getAddRowButton().setVisible(false);
                    panel.getDelRowButton().setVisible(false);
                    panel.getClearButton().setVisible(false);
                }
                this.btnCheckInstanceCount.setVisible(false);
                this.btnTestMsgTitleScript.setVisible(false);
                this.btnTestMsgBodyScript.setVisible(false);
                break block6;
            }
            if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW) || !this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) break block6;
            if (this.editData.getState().equals((Object)ItemState.ACTIVE)) {
                this.kDWorkButtonAdvSet.setEnabled(false);
                this.kDTextFieldMsgTitle.setEnabled(false);
                this.kDWorkButtonTitle.setVisible(false);
                this.contentFormula.setVisible(false);
                this.msgParamFormula.setVisible(false);
                this.btnMsgAttrFormula.setVisible(false);
                this.kDComboBoxPriority.setEnabled(false);
                this.receiverPartUI.setComponetEnable(false);
                this.kDTableThreshold.getStyleAttributes().setLocked(true);
                this.kDTableThreshold.getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                Set filterPanelKey = this.filterPanels.keySet();
                Iterator ite = filterPanelKey.iterator();
                while (ite.hasNext()) {
                    CommonEntityFilterPanel panel = (CommonEntityFilterPanel)this.filterPanels.get(ite.next());
                    panel.getKdtTable().getStyleAttributes().setLocked(true);
                    panel.getKdtTable().getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
                    this.kDComboBoxPriority.setEditable(false);
                    panel.getKdtTable().getSelectManager().setSelectMode(2);
                    panel.getAddRowButton().setVisible(false);
                    panel.getDelRowButton().setVisible(false);
                    panel.getClearButton().setVisible(false);
                    this.btnCheckInstanceCount.setVisible(false);
                    this.btnTestMsgTitleScript.setVisible(false);
                    this.btnTestMsgBodyScript.setVisible(false);
                    this.btnMsgAttrFormula.setVisible(false);
                }
            } else {
                this.kDWorkButtonAdvSet.setEnabled(true);
                this.kDTextFieldMsgTitle.setEnabled(true);
                this.kDWorkButtonTitle.setVisible(true);
                this.contentFormula.setVisible(true);
                this.msgParamFormula.setVisible(true);
                this.kDComboBoxPriority.setEditable(true);
                this.receiverPartUI.setComponetEnable(true);
                Set filterPanelKey = this.filterPanels.keySet();
                Iterator ite = filterPanelKey.iterator();
                while (ite.hasNext()) {
                    CommonEntityFilterPanel panel = (CommonEntityFilterPanel)this.filterPanels.get(ite.next());
                    panel.getKdtTable().getStyleAttributes().setLocked(false);
                }
            }
        }
    }

    private void display() throws Exception {
        this.displayObjectTab(this.editData.getObjects());
    }

    private void installListener() {
        this.kDTabbedPaneItem.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ForewarnItemEditUI.this.tabbedpanel_stateChanged(e);
                }
                catch (Exception e1) {
                    ForewarnItemEditUI.this.logger.error((Object)e1);
                }
            }
        });
    }

    private void tabbedpanel_stateChanged(ChangeEvent e) throws Exception {
        KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        switch (selectedIndex) {
            case 1: {
                this.displayConditionTab(this.editData.getCondition());
                break;
            }
            case 2: {
                this.displayMessageTab(this.editData);
            }
        }
    }

    private void displayObjectTab(ForewarnObjectCollection objects) throws Exception {
        if (objects != null && objects.size() > 0) {
            int objSize = objects.size();
            for (int j = 0; j < objSize; ++j) {
                ForewarnObjectInfo forewarnObject = objects.get(j);
                if (forewarnObject.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT)) {
                    this.currentForewarnObject = forewarnObject;
                }
                IRow row = this.kDTableObject.addRow();
                row.getCell(0).setValue((Object)forewarnObject);
                row.getCell(1).setValue((Object)forewarnObject.getName());
                row.getCell(2).setValue((Object)forewarnObject.getAlias());
                KDComboBox kdComboBox = ForewarnUtil.createObjectTypeComboBox();
                kdComboBox.setSelectedItem((Object)forewarnObject.getType());
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                row.getCell(3).setEditor((ICellEditor)cellEditor);
                row.getCell(3).setValue((Object)forewarnObject.getType());
                row.getCell(4).setValue((Object)forewarnObject.getDescription());
                if (!forewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
                CommonEntityFilterPanel filterPanel = new CommonEntityFilterPanel((IMetaDataPK)new MetaDataPK(forewarnObject.getName()), this.getEntityViewInfo(forewarnObject).getFilter(), (IProcessor)new ForewarnProcessor(), 6);
                filterPanel.setUseDateFunc(true);
                this.filterPanels.put(String.valueOf(j), filterPanel);
            }
        }
        this.kDContainerFilter.setVisible(false);
        if (this.currentForewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY)) {
            this.displayObjectAndFilter(0);
        }
        if (this.kDTableObject.getRowCount() > 0) {
            this.tableObjectCliked(0);
        }
    }

    private void displayObjectAndFilter(int rowIndex) throws BOSException {
        this.currentObjectRowIndex = rowIndex;
        this.displayFilter();
        this.kDTableObject.getSelectManager().select(rowIndex, 0);
    }

    private void displayConditionTab(ForewarnConditionInfo condition) {
        if (this.isDisplayConditionTab) {
            return;
        }
        if (condition != null) {
            ForewarnThresholdCollection thresholds = condition.getThresholdCollection();
            if (thresholds != null) {
                int thresholdSize = thresholds.size();
                for (int j = 0; j < thresholdSize; ++j) {
                    ForewarnThresholdInfo threshold = thresholds.get(j);
                    IRow row = this.kDTableThreshold.addRow();
                    row.getCell(0).setValue((Object)threshold);
                    row.getCell(2).setValue((Object)threshold.getAlias());
                    KDComboBox kdComboBox = new KDComboBox(DataType.getEnumList().toArray());
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                    row.getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                    row.getCell(3).setValue((Object)threshold.getDataType());
                    row.getCell(4).setValue((Object)threshold.getValue());
                    row.getCell(5).setValue((Object)threshold.getDescription());
                }
            }
            if (condition.getContentScript() != null) {
                FormulaDialog dialog = new FormulaDialog();
                this.fillFormulaDialog(dialog, this.getConditionScript());
                this.textAreaCtrlCondition.setSelectedItemData((Object)dialog.getFormulaAlias());
            } else {
                this.textAreaCtrlCondition.setSelectedItemData((Object)"");
            }
        }
        this.isDisplayConditionTab = true;
    }

    private void displayMessageTab(ForewarnItemInfo item) throws Exception {
        if (this.isDisplayMsgTab) {
            return;
        }
        this.saveForewarnObject();
        this.receiverPartUI.setForewarnInfo(this.editData);
        this.receiverPartUI.setThresholdProvider(this);
        String touchType = item.getTouchType().getValue();
        if (touchType == "0") {
            this.receiverPartUI.setchkMultipleTimeZoomVisiable();
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.receiverPartUI.loadData(OprtState.VIEW);
        } else {
            this.receiverPartUI.loadData(OprtState.EDIT);
        }
        if (item.getMessage() != null) {
            FormulaDialog dialog;
            if (item.getMessage().getAppendMsg() != null) {
                // empty if block
            }
            if (item.getMessage().getTitleScript() != null) {
                dialog = new FormulaDialog();
                this.fillFormulaDialog(dialog, this.getTitleScript());
                this.kDTextFieldMsgTitle.setSelectedItemData((Object)dialog.getFormulaAliasNoResultStr());
            } else {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDTextFieldMsgTitle, (IObjectValue)item.getMessage(), (String)"title");
            }
            if (item.getMessage().getParamScript() != null) {
                dialog = new FormulaDialog();
                this.fillFormulaDialog(dialog, this.getParamScript());
                this.kDBizMultiLangMsgParam.setSelectedItemData((Object)dialog.getFormulaAliasNoResultStr());
            } else {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDBizMultiLangMsgParam, (IObjectValue)item.getMessage(), (String)"paramScript");
            }
            if (item.getMessage().getBodyScript() != null) {
                dialog = new FormulaDialog();
                List langList = KDBizMultiLangBox.getLanguageList();
                for (LanguageInfo lang : langList) {
                    if (null == item.getMessage().getBodyScript(lang.getLocale())) continue;
                    this.fillFormulaDialog(dialog, item.getMessage().getBodyScript(lang.getLocale()));
                    this.textAreaCtrlMsgContent.setItemData(lang, (Object)dialog.getFormulaAliasNoResultStr());
                }
            } else {
                this.textAreaCtrlMsgContent.setSelectedItemData((Object)"");
            }
            if (item.getMessage().getAttrKeys() == null) {
                this.kDTextAreaAttrKey.setText("\u914d\u7f6e\u5bfc\u51fa\u5b57\u6bb5\u8868\u5934\u540d\u79f0\u7684\u793a\u4f8b\u4e3a\uff1a \u540d\u79f0&&\u51fa\u751f\u65e5\u671f&&\u624b\u673a\u53f7\u7801  \u6ce8: && \u7b26\u53f7\u4e3a\u5206\u9694\u7b26\uff0c\u8868\u5934\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u4e49(\u4e2d\u6587\u3001\u82f1\u6587\u3001\u6570\u5b57\u5305\u62ec\u4e0b\u5212\u7ebf\u548c\u7a7a\u683c\u90fd\u53ef\u4ee5).");
            } else {
                this.kDTextAreaAttrKey.setText(item.getMessage().getAttrKeys());
            }
            if (item.getMessage().getAttrScript() == null) {
                this.kDTextAreaAttrVal.setText("\u914d\u7f6e\u5bfc\u51fa\u5b57\u6bb5\u7684\u793a\u4f8b\u4e3a\uff1a Person.\u540d\u79f0  + \"&&\" + Person.\u51fa\u751f\u65e5\u671f + \"&&\" +  Person.\u624b\u673a\u53f7\u7801 ; \u6ce8: && \u7b26\u53f7\u4e3a\u5206\u9694\u7b26\uff0c\u5176\u524d\u540e\u4e3a\u9884\u8b66\u5bf9\u8c61\u7684\u5c5e\u6027\u5b57\u6bb5.");
            } else {
                dialog = new FormulaDialog();
                this.fillFormulaDialog(dialog, this.getAttrScript());
                this.kDTextAreaAttrVal.setText(dialog.getFormulaAliasNoResultStr());
            }
            if (item.getMessage().getPriority() != null) {
                this.kDComboBoxPriority.setSelectedItem((Object)item.getMessage().getPriority());
            }
        }
        this.isDisplayMsgTab = true;
    }

    @Override
    protected void kDTableObject_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        super.kDTableObject_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1 && (clickCount = e.getClickCount()) == 1) {
            this.tableObjectCliked(rowIndex);
        }
    }

    private void tableObjectCliked(int rowIndex) throws BOSException {
        this.currentForewarnObject = (ForewarnObjectInfo)this.kDTableObject.getRow(rowIndex).getCell(0).getValue();
        this.currentObjectRowIndex = rowIndex;
        if (this.currentForewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY)) {
            this.displayFilter();
        } else if (this.currentForewarnObject.getMetadataType().equals((Object)MetadataType.FACADE)) {
            this.kDContainerFilter.setVisible(false);
        }
    }

    private void displayFilter() throws BOSException {
        this.kDContainerFilter.setVisible(true);
        this.clearFilterCtrl();
        this.addFilterCtrl();
        this.kDSplitPaneObject.setDividerLocation(200);
    }

    private void setTableWidth(CommonEntityFilterPanel filterPanel) {
        for (int i = 0; i < 6; ++i) {
            filterPanel.getKdtTable().getColumn(i).setWidth(ForewarnConstant.FILTER_COLUMN_WIDTHs[i]);
        }
    }

    private void addFilterCtrl() throws BOSException {
        CommonEntityFilterPanel filterPanel = null;
        if (this.filterPanels.containsKey(String.valueOf(this.currentObjectRowIndex))) {
            filterPanel = (CommonEntityFilterPanel)this.filterPanels.get(String.valueOf(this.currentObjectRowIndex));
        } else {
            try {
                filterPanel = new CommonEntityFilterPanel((IMetaDataPK)new MetaDataPK(this.currentForewarnObject.getName()), this.getEntityViewInfo(this.currentForewarnObject).getFilter(), (IProcessor)new ForewarnProcessor(), 6);
            }
            catch (BaseCommonQueryClientException e) {
                throw new BOSException((Throwable)e);
            }
            filterPanel.setUseDateFunc(true);
            this.filterPanels.put(String.valueOf(this.currentObjectRowIndex), filterPanel);
        }
        this.kDContainerFilter.getContentPane().add((Component)filterPanel.getKdtTable(), "Center");
        this.setTableWidth(filterPanel);
        this.kDContainerFilter.addButton((JButton)filterPanel.getAddRowButton());
        this.kDContainerFilter.addButton((JButton)filterPanel.getDelRowButton());
        this.kDContainerFilter.addButton((JButton)filterPanel.getClearButton());
        if (!this.currentForewarnObject.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) && this.currentForewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY)) {
            this.kDContainerFilter.addButton(this.btnCheckInstanceCount);
        }
        filterPanel.getAddRowButton().setSize(22, 19);
        filterPanel.getDelRowButton().setSize(22, 19);
        filterPanel.getClearButton().setSize(22, 19);
    }

    private EntityViewInfo getEntityViewInfo(ForewarnObjectInfo info) {
        if (info.getEntityViewInfo() == null || info.getEntityViewInfo().trim().equalsIgnoreCase("")) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(new FilterInfo());
            return entityViewInfo;
        }
        try {
            return ForewarnUtil.unProcessEntityViewInfo(new EntityViewInfo(info.getEntityViewInfo()));
        }
        catch (ParserException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"parseEntityViewError"));
            return null;
        }
    }

    private void clearFilterCtrl() {
        this.kDContainerFilter.getContentPane().removeAll();
        this.kDContainerFilter.removeAllButton();
    }

    protected IObjectValue createNewData() {
        ForewarnItemInfo forewarnItemInfo = new ForewarnItemInfo();
        return forewarnItemInfo;
    }

    private void saveForewarnItem() {
        this.verify();
        this.saveForewarnCondition();
        this.saveForewarnMessage();
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().equals("");
    }

    protected void verify() {
        if (this.isNull(StringUtils.cnulls((Object)this.textAreaCtrlMsgContent.getSelectedItem())) && (this.editData.getMessage() == null || this.editData.getMessage().getBodyScript() == null)) {
            this.kDTabbedPaneItem.setSelectedIndex(2);
            this.textAreaCtrlMsgContent.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"msgContentIsNull"));
            SysUtil.abort();
        } else if (this.isNull(StringUtils.cnulls((Object)this.kDTextFieldMsgTitle.getSelectedItem())) && (this.editData.getMessage() == null || this.editData.getMessage().getTitleScript() == null && this.editData.getMessage().getTitle() == null)) {
            this.kDTabbedPaneItem.setSelectedIndex(2);
            this.kDTextFieldMsgTitle.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"msgTitleIsNull"));
            this.abort();
        }
        this.checkAppMsgLength();
        this.checkObjectFilter();
    }

    private void saveForewarnCondition() {
        int rowCount = this.kDTableThreshold.getRowCount();
        if (rowCount == 0) {
            return;
        }
        this.editData.getCondition().getThresholdCollection().clear();
        for (int i = 0; i < rowCount; ++i) {
            this.editData.getCondition().getThresholdCollection().add((ForewarnThresholdInfo)this.kDTableThreshold.getRow(i).getCell(0).getValue());
        }
    }

    private void saveForewarnMessage() {
        if (StringUtils.isEmpty((String)this.editData.getMessage().getTitleScript()) && !this.isNull(StringUtils.cnulls((Object)this.kDTextFieldMsgTitle.getSelectedItem()))) {
            UIHelper.storeMultiLangFields((KDMultiLangBox)this.kDTextFieldMsgTitle, (IObjectValue)this.editData.getMessage(), (String)"title");
        }
        if (this.isDisplayMsgTab) {
            this.editData.getMessage().setPriority((Priority)((Object)this.kDComboBoxPriority.getSelectedItem()));
        }
        this.editData.getMessage().setAttrKeys(this.kDTextAreaAttrKey.getText());
    }

    @Override
    protected void kDTableThreshold_editStopped(KDTEditEvent e) throws Exception {
        super.kDTableThreshold_editStopped(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0) {
            ForewarnThresholdInfo forewarnThresholdInfo = (ForewarnThresholdInfo)this.kDTableThreshold.getRow(rowIndex).getCell(0).getValue();
            Object value = this.kDTableThreshold.getRow(rowIndex).getCell(4).getValue();
            if (value != null) {
                if (!ForewarnUtil.validateData(forewarnThresholdInfo.getDataType(), value.toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"thresholdValueWarning"));
                    this.kDTableThreshold.getRow(rowIndex).getCell(4).setValue(null);
                    forewarnThresholdInfo.setValue(null);
                } else {
                    forewarnThresholdInfo.setValue(value.toString());
                }
            } else {
                forewarnThresholdInfo.setValue(null);
            }
            if (this.kDTableThreshold.getRow(rowIndex).getCell(5).getValue() != null) {
                forewarnThresholdInfo.setDescription(this.kDTableThreshold.getRow(rowIndex).getCell(5).getValue().toString());
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ForewarnItemFactory.getRemoteInstance();
    }

    @Override
    public void actionAdvSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdvSet_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"forewarnInfo", (Object)this.editData);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ForewarnAdvSetupUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionSelectReceiver_actionPerformed(ActionEvent e) throws Exception {
    }

    private EntityObjectInfo[] getEntites() {
        EntityObjectInfo[] entities = null;
        int rowCount = this.kDTableObject.getRowCount();
        ForewarnObjectCollection objectCollection = new ForewarnObjectCollection();
        for (int i = 0; i < rowCount; ++i) {
            objectCollection.add((ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue());
        }
        entities = ForewarnUtil.getEntities(objectCollection);
        return entities;
    }

    private String getConditionScript() {
        return this.getScript(ForewarnUtil.getConditionScript(this.editData));
    }

    private String getContentScript() {
        return this.getScript(ForewarnUtil.getContentScript(this.editData));
    }

    private String getContentScript(Locale locale) {
        return this.getScript(ForewarnUtil.getContentScript(this.editData, locale));
    }

    private String getAttrScript() {
        return this.getScript(ForewarnUtil.getAttrScript(this.editData));
    }

    private String getParamScript() {
        return this.getScript(ForewarnUtil.getParamScript(this.editData));
    }

    private String getTitleScript() {
        return this.getScript(ForewarnUtil.getTitleScript(this.editData));
    }

    private String getScript(String script) {
        return ForewarnUtil.processScript(this.getCurrentForewarnObjects(), this.getCurrentForewarnThresholds(), script);
    }

    private void fillFormulaDialog(FormulaDialog formulaDialog, String script) {
        formulaDialog.setFormula(script);
        formulaDialog.setMetaDataObjs(this.getBusinessObjects());
    }

    @Override
    public void actionTitleFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionTitleFormula_actionPerformed(e);
        FormulaDialog formulaDialog = new FormulaDialog((Dialog)((KDDialog)this.getUIWindow()), EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"formulaSysTitle"), true);
        this.fillFormulaDialog(formulaDialog, this.getTitleScript());
        formulaDialog.getAddButton().setVisible(false);
        formulaDialog.getDelButton().setVisible(false);
        formulaDialog.show();
        if (formulaDialog.isConfirm()) {
            if (this.editData.getMessage() == null || this.editData.getMessage().getTitleScript() == null) {
                this.editData.setMessage(new ForewarnMessageInfo());
            }
            this.editData.getMessage().setTitleScript(formulaDialog.getFormula());
            this.kDTextFieldMsgTitle.setSelectedItemData((Object)formulaDialog.getFormulaAliasNoResultStr());
        }
    }

    private BusinessObjectInfo[] getBusinessObjects() {
        int rowCount = this.kDTableObject.getRowCount();
        ForewarnObjectCollection objectCollection = new ForewarnObjectCollection();
        for (int i = 0; i < rowCount; ++i) {
            objectCollection.add((ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue());
        }
        this.businessObjectInfos = ForewarnUtil.getBusinessObjects(objectCollection);
        return this.businessObjectInfos;
    }

    @Override
    public void actionContentFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionContentFormula_actionPerformed(e);
        FormulaDialog formulaDialog = new FormulaDialog((Dialog)((KDDialog)this.getUIWindow()), EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"formulaSysTitle"), true);
        Object item = this.textAreaCtrlMsgContent.getSelectedItem();
        if (item instanceof MultiLangItem) {
            this.fillFormulaDialog(formulaDialog, this.getContentScript(((MultiLangItem)item).getLang().getLocale()));
        } else {
            this.fillFormulaDialog(formulaDialog, this.getContentScript());
        }
        formulaDialog.getAddButton().setVisible(false);
        formulaDialog.getDelButton().setVisible(false);
        formulaDialog.show();
        if (formulaDialog.isConfirm()) {
            if (this.editData.getMessage() == null) {
                this.editData.setMessage(new ForewarnMessageInfo());
            }
            if (item instanceof MultiLangItem) {
                this.editData.getMessage().setBodyScript(formulaDialog.getFormula(), ((MultiLangItem)item).getLang().getLocale());
            } else {
                this.editData.getMessage().setBodyScript(formulaDialog.getFormula());
            }
            this.textAreaCtrlMsgContent.setSelectedItemData((Object)formulaDialog.getFormulaAliasNoResultStr());
        }
    }

    @Override
    public void actionMsgParamFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgParamFormula_actionPerformed(e);
        FormulaDialog formulaDialog = new FormulaDialog((Dialog)((KDDialog)this.getUIWindow()), EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"formulaSysTitle"), true);
        this.fillFormulaDialog(formulaDialog, this.getParamScript());
        formulaDialog.getAddButton().setVisible(false);
        formulaDialog.getDelButton().setVisible(false);
        formulaDialog.setCheck(false);
        formulaDialog.show();
        if (formulaDialog.isConfirm()) {
            if (this.editData.getMessage() == null) {
                this.editData.setMessage(new ForewarnMessageInfo());
            }
            this.editData.getMessage().setParamScript(formulaDialog.getFormula());
            this.kDBizMultiLangMsgParam.setSelectedItemData((Object)formulaDialog.getFormulaAliasNoResultStr());
        }
    }

    @Override
    public void actionAttrFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttrFormula_actionPerformed(e);
        FormulaDialog formulaDialog = new FormulaDialog((Dialog)((KDDialog)this.getUIWindow()), EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"formulaSysTitle"), true);
        this.fillFormulaDialog(formulaDialog, this.getAttrScript());
        formulaDialog.getAddButton().setVisible(false);
        formulaDialog.getDelButton().setVisible(false);
        formulaDialog.setCheck(false);
        formulaDialog.show();
        if (formulaDialog.isConfirm()) {
            ForewarnMessageInfo message = this.editData.getMessage();
            if (message == null) {
                this.editData.setMessage(new ForewarnMessageInfo());
            }
            message.setAttrScript(formulaDialog.getFormula());
            String formulaAliasNoResultStr = formulaDialog.getFormulaAliasNoResultStr();
            this.kDTextAreaAttrVal.setText(formulaAliasNoResultStr);
        }
    }

    protected void checkObjectFilter() {
        int rowCount = this.kDTableObject.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = (ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue();
            if (!forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            CommonEntityFilterPanel filterPanel = (CommonEntityFilterPanel)this.filterPanels.get(String.valueOf(i));
            if (filterPanel != null) {
                if (filterPanel.verify()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = filterPanel.getInnerFilterInfo();
                    if (filterInfo == null || filterInfo.toString().trim().equalsIgnoreCase("")) {
                        EntityViewInfo evi = new EntityViewInfo();
                        evi.setFilter(new FilterInfo());
                        forewarnObjectInfo.setEntityViewInfo(evi.toString());
                        this.kDTableObject.getRow(i).getCell(0).setValue((Object)forewarnObjectInfo);
                        continue;
                    }
                    entityViewInfo.setFilter(filterInfo);
                    forewarnObjectInfo.setEntityViewInfo(ForewarnUtil.processEntityViewInfo(entityViewInfo).toString());
                    this.kDTableObject.getRow(i).getCell(0).setValue((Object)forewarnObjectInfo);
                    continue;
                }
                SysUtil.abort();
                continue;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"objectFilterWarning") + forewarnObjectInfo.getAlias() + EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"objectFilterWarning1"))) == 0) continue;
            this.kDTabbedPaneItem.setSelectedIndex(0);
            SysUtil.abort();
        }
    }

    private void checkAppMsgLength() {
        List listLang = KDBizMultiLangArea.getLanguageList();
        for (LanguageInfo currentLang : listLang) {
            Object data = null;
            if (data == null || data.toString().length() <= 200) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"appMsgLengthWarning"));
            this.kDTabbedPaneItem.setSelectedIndex(2);
            SysUtil.abort();
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isConfirm) {
            return true;
        }
        if (this.getUIContext().get("flag") != null) {
            Map tempMap = (Map)this.getUIContext().get("flag");
            tempMap.put("isNotModify", Boolean.TRUE);
        }
        return true;
    }

    private void saveForewarnObject() {
        int rowCount = this.kDTableObject.getRowCount();
        this.editData.getObjects().clear();
        for (int i = 0; i < rowCount; ++i) {
            this.editData.getObjects().add((ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue());
        }
    }

    private ForewarnObjectCollection getCurrentForewarnObjects() {
        ForewarnObjectCollection collection = new ForewarnObjectCollection();
        int size = this.kDTableObject.getRowCount();
        for (int i = 0; i < size; ++i) {
            collection.add((ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue());
        }
        return collection;
    }

    private ForewarnThresholdCollection getCurrentForewarnThresholds() {
        ForewarnThresholdCollection collection = new ForewarnThresholdCollection();
        int size = this.kDTableThreshold.getRowCount();
        for (int i = 0; i < size; ++i) {
            collection.add((ForewarnThresholdInfo)this.kDTableThreshold.getRow(i).getCell(0).getValue());
        }
        return collection;
    }

    private void beforeTestScript() throws Exception {
        this.checkObjectFilterForTest();
        ForewarnItemUI forewarnItemUI = (ForewarnItemUI)this.getUIContext().get("Owner");
        forewarnItemUI.checkThresholds();
    }

    protected void checkObjectFilterForTest() {
        int rowCount = this.kDTableObject.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = (ForewarnObjectInfo)this.kDTableObject.getRow(i).getCell(0).getValue();
            if (!forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            CommonEntityFilterPanel filterPanel = (CommonEntityFilterPanel)this.filterPanels.get(String.valueOf(i));
            if (filterPanel != null) {
                if (filterPanel.verify()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    FilterInfo currFilterInfo = filterPanel.getFilterInfo();
                    entityViewInfo.setFilter(filterPanel.getFilterInfo());
                    entityViewInfo = ForewarnUtil.processEntityViewInfo(entityViewInfo);
                    if (ForewarnUtil.hasDefaultOrg(entityViewInfo.getFilter())) {
                        ForewarnItemUI forewarnItemUI = (ForewarnItemUI)this.getUIContext().get("Owner");
                    }
                    forewarnObjectInfo.setEntityViewInfo(entityViewInfo.toString().toString());
                    this.kDTableObject.getRow(i).getCell(0).setValue((Object)forewarnObjectInfo);
                    continue;
                }
                SysUtil.abort();
                continue;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"objectFilterWarning") + forewarnObjectInfo.getAlias() + EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"objectFilterWarning1"))) == 0) continue;
            SysUtil.abort();
        }
    }

    protected String getForewarnObjectAlias(int rowIndex) {
        return ((ForewarnObjectInfo)this.kDTableObject.getRow(rowIndex).getCell(0).getValue()).getAlias();
    }

    @Override
    public void actionCheckInstanceCount_actionPerformed(ActionEvent e) throws Exception {
        CommonEntityFilterPanel filterPanel;
        super.actionCheckInstanceCount_actionPerformed(e);
        int index = this.kDTableObject.getSelectManager().getActiveRowIndex();
        if (index != -1 && (filterPanel = (CommonEntityFilterPanel)this.filterPanels.get(String.valueOf(index))).verify()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo currFilterInfo = filterPanel.getFilterInfo();
            entityViewInfo.setFilter(currFilterInfo);
            entityViewInfo = ForewarnUtil.processEntityViewInfo(entityViewInfo);
            if (ForewarnUtil.hasDefaultOrg(entityViewInfo.getFilter())) {
                ForewarnItemUI forewarnItemUI = (ForewarnItemUI)this.getUIContext().get("Owner");
            } else {
                int count = ForewarnRunTimeFactory.getRemoteInstance().getInstanceCount(filterPanel.getEntity().getFullName(), entityViewInfo.toString());
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"objectInstanceCount") + " " + String.valueOf(count)));
            }
        }
    }

    @Override
    public void actionTestMsgBodyScript_actionPerformed(ActionEvent e) throws Exception {
        super.actionTestMsgBodyScript_actionPerformed(e);
        this.beforeTestScript();
        if (this.editData.getMessage() != null) {
            String script;
            String string = script = this.editData.getMessage().getBodyScript() == null ? null : this.editData.getMessage().getBodyScript();
            if (script != null && !script.trim().equalsIgnoreCase("")) {
                String info = ForewarnRunTimeFactory.getRemoteInstance().testScript(script, this.getCurrentForewarnObjects(), this.getCurrentForewarnThresholds());
                MsgBox.showInfo((Component)((Object)this), (String)info);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"expressionScriptIsNull"));
            }
        }
    }

    @Override
    public void actionTestMsgTitleScript_actionPerformed(ActionEvent e) throws Exception {
        super.actionTestMsgTitleScript_actionPerformed(e);
        this.beforeTestScript();
        if (this.editData.getMessage() != null) {
            String script;
            String string = script = this.editData.getMessage().getTitleScript() == null ? null : this.editData.getMessage().getTitleScript();
            if (script != null && !script.trim().equalsIgnoreCase("")) {
                String info = ForewarnRunTimeFactory.getRemoteInstance().testScript(script, this.getCurrentForewarnObjects(), this.getCurrentForewarnThresholds());
                MsgBox.showInfo((Component)((Object)this), (String)info);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"expressionScriptIsNull"));
            }
        }
    }

    public boolean isModify() {
        return false;
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.kDWorkButtonAdvSet);
    }

    @Override
    public ForewarnThresholdCollection getThresholdCollection() {
        return this.getCurrentForewarnThresholds();
    }

    @Override
    public void actionForewarnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW) || this.getOprtState().equalsIgnoreCase(OprtState.EDIT) && this.editData.getState().equals((Object)ItemState.UNACTIVE)) {
            this.saveForewarnItem();
        }
        this.destroyWindow();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

