/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.DefaultTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.eas.base.forewarn.BaseForewarnAppException;
import com.kingdee.eas.base.forewarn.ForewarnConstant;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnScheduleInfo;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnThresholdInfo;
import com.kingdee.eas.base.forewarn.IForewarnItem;
import com.kingdee.eas.base.forewarn.ItemState;
import com.kingdee.eas.base.forewarn.SortRule;
import com.kingdee.eas.base.forewarn.TouchType;
import com.kingdee.eas.base.forewarn.Type;
import com.kingdee.eas.base.forewarn.client.AbstractForewarnItemUI;
import com.kingdee.eas.base.forewarn.client.ForewarnItemEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.base.forewarn.client.FormulaDialog;
import com.kingdee.eas.base.forewarn.client.IThresholdProvider;
import com.kingdee.eas.base.forewarn.client.ReceiverPartUI;
import com.kingdee.eas.base.forewarn.client.SetRightnowForewarnActionUI;
import com.kingdee.eas.base.job.ProcessDefFactory;
import com.kingdee.eas.base.job.ProcessDefInfo;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ForewarnItemUI
extends AbstractForewarnItemUI
implements IThresholdProvider {
    Logger logger = Logger.getLogger((String)ForewarnItemUI.class.getName());
    private static final String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";
    private EASWfServiceClient workflowClient;
    private KDBizMultiLangArea areaCtrlMsgExpression;
    private ReceiverPartUI receiverPartUI = null;
    private boolean isSort = false;
    private String sortFildId = "";
    private String sortFileName = "";
    private SortRule sortRule;
    private boolean modified = false;

    public ForewarnItemUI() throws Exception {
        this.init();
    }

    private void init() {
        this.initTables();
        this.initButtons();
        this.initOther();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            ObjectUuidPK pk = null;
            pk = this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW) ? new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())) : new ObjectUuidPK(this.getUIContext().get("templetID").toString());
            request.put("valueOql", (Object)this.getValueOql(pk.toString()));
            CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
            request.put("ctrlUnit", (Object)ctrlUnit);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private String getValueOql(String pk) {
        return "select *,schedule.*,message.*,objects.*,condition.*,condition.thresholdCollection.*,receivers.*,templet.*,bizOrg.*,touchAction.*,dynReceivers.* where id = '" + pk.toString() + "'";
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void initTables() {
        this.kDTableThreshold.checkParsed();
        this.kDTableThreshold.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kDTableThreshold.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void initButtons() {
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnSetup.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
    }

    private void initOther() {
        this.kDScrollPaneMsgExpression = this.areaCtrlMsgExpression = new KDBizMultiLangArea();
        CompanyF7 companyF7 = new CompanyF7((IUIObject)this);
        companyF7.setCuID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.kDTextFieldItemNumber.setMaxLength(79);
        this.kDTextFieldItemName.setMaxLength(79);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        try {
            this.receiverPartUI = new ReceiverPartUI();
            this.kDPanelMsg.add((Component)((Object)this.receiverPartUI), null);
            this.receiverPartUI.initLayout();
            this.receiverPartUI.setBounds(new Rectangle(8, 30, 680, 60));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private ForewarnObjectCollection getCurrentForewarnObjects() {
        return this.editData.getObjects();
    }

    private ForewarnThresholdCollection getCurrentForewarnThresholds() {
        ForewarnThresholdCollection collection = new ForewarnThresholdCollection();
        int size = this.kDTableThreshold.getRowCount();
        for (int i = 0; i < size; ++i) {
            collection.add((ForewarnThresholdInfo)this.kDTableThreshold.getRow(i).getCell(0).getValue());
        }
        return collection;
    }

    @Override
    public void loadFields() {
        try {
            this.display();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setButtonStatus();
        this.setUIProperties();
        this.setModified(false);
        super.loadFields();
        this.decideItemType();
        this.logger.info((Object)"...... testload ");
    }

    private void decideItemType() {
        String templateTouchType = (String)this.getUIContext().get("OBJECTTYPE");
        if ("1".equals(templateTouchType)) {
            this.btnSchedule.setText(EASResource.getString((String)forewarnRes, (String)"TouchOpr"));
            this.editData.setTouchType(TouchType.RIGHTNOW_TYPE);
        } else {
            this.editData.setTouchType(TouchType.SCHEDULE_TYPE);
        }
    }

    private void setButtonStatus() {
        Object fromTemplateList = this.getUIContext().get("FROM_TEMPLATE_LIST");
        if (fromTemplateList != null) {
            this.btnFirst.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnLast.setVisible(false);
        }
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    private void buttonStateChanged(String oprtState, ItemState itemState) {
        this.btnRemove.setVisible(false);
        if (oprtState.equalsIgnoreCase(OprtState.ADDNEW)) {
            this.btnDisable.setEnabled(false);
            this.btnEnable.setEnabled(false);
            this.btnSubmit.setEnabled(true);
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            if (itemState.equals((Object)ItemState.ACTIVE)) {
                this.btnDisable.setEnabled(true);
                this.btnEnable.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            } else {
                this.btnDisable.setEnabled(false);
                this.btnEnable.setEnabled(true);
                this.btnEdit.setEnabled(true);
                this.btnSubmit.setEnabled(false);
            }
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            if (itemState.equals((Object)ItemState.ACTIVE)) {
                this.btnDisable.setEnabled(false);
                this.btnEnable.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            } else {
                this.btnDisable.setEnabled(false);
                this.btnEnable.setEnabled(true);
                this.btnSubmit.setEnabled(true);
            }
        }
    }

    private void setUIProperties() {
        this.kDTextAreaAttr.setEditable(false);
        this.kDTextAreaAttrKey.setEditable(false);
        this.kDTextFieldItemNumber.setMaxLength(80);
        this.kDTextFieldItemName.setMaxLength(80);
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.setUITitle(EASResource.getString((String)forewarnRes, (String)"forewarnItemAdd"));
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.setUITitle(EASResource.getString((String)forewarnRes, (String)"forewarnItemView"));
            this.kDTextFieldItemNumber.setEnabled(false);
            this.kDTextFieldItemName.setEnabled(false);
            this.receiverPartUI.setComponetEnable(false);
            this.kDBizMultiLangAreaAppendMsg.setEditable(false);
            this.kDBizMultiLangAreaAppendMsg.getEditor().getEditorComponent().setEnabled(false);
            this.kDTableThreshold.getStyleAttributes().setLocked(true);
            this.kDTableThreshold.getColumn(3).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
            this.kDTextFieldMsgTitle.setEditable(false);
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.setUITitle(EASResource.getString((String)forewarnRes, (String)"forewarnItemEdit"));
            if (this.editData.getState().equals((Object)ItemState.ACTIVE)) {
                this.kDTextFieldItemNumber.setEnabled(false);
                this.kDTextFieldItemName.setEnabled(false);
                this.receiverPartUI.setComponetEnable(false);
                this.kDBizMultiLangAreaAppendMsg.setEditable(false);
                this.kDBizMultiLangAreaAppendMsg.getEditor().getEditorComponent().setEnabled(false);
                this.kDTableThreshold.getStyleAttributes().setLocked(true);
                this.kDTableThreshold.getColumn(3).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
            } else {
                this.kDTextFieldItemNumber.setEnabled(true);
                this.kDTextFieldItemName.setEnabled(true);
                this.receiverPartUI.setComponetEnable(true);
                this.kDBizMultiLangAreaAppendMsg.setEditable(true);
                this.kDBizMultiLangAreaAppendMsg.getEditor().getEditorComponent().setEnabled(true);
                this.kDTableThreshold.getColumn(3).getStyleAttributes().setLocked(false);
                this.kDTableThreshold.getColumn(3).getStyleAttributes().setBackground(Color.WHITE);
            }
        }
        this.buttonStateChanged(this.getOprtState(), this.editData.getState());
        this.kDTableThreshold.getColumn(1).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
        this.kDTableThreshold.getColumn(2).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
        this.kDTableThreshold.getColumn(4).getStyleAttributes().setBackground(ForewarnConstant.UNEDIT_COLOR);
        this.areaCtrlMsgExpression.setEditable(false);
        this.areaCtrlMsgExpression.getEditorComponent().setBackground(ForewarnConstant.UNEDIT_COLOR);
    }

    private void displayMessage() {
        FormulaDialog dialog;
        ForewarnMessageInfo message = this.editData.getMessage();
        if (message != null && message.getTitleScript() != null) {
            dialog = new FormulaDialog();
            this.fillFormulaDialog(dialog, this.getTitleScript());
            this.kDTextFieldMsgTitle.setSelectedItemData((Object)dialog.getFormulaAliasNoResultStr());
        } else {
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDTextFieldMsgTitle, (IObjectValue)message, (String)"title");
        }
        if (message != null && this.editData.getMessage().getBodyScript() != null) {
            dialog = new FormulaDialog();
            List langList = KDBizMultiLangBox.getLanguageList();
            for (LanguageInfo lang : langList) {
                if (null == this.editData.getMessage().getBodyScript(lang.getLocale())) continue;
                this.fillFormulaDialog(dialog, this.editData.getMessage().getBodyScript(lang.getLocale()));
                this.areaCtrlMsgExpression.setItemData(lang, (Object)dialog.getFormulaAliasNoResultStr());
            }
        } else {
            this.areaCtrlMsgExpression.setSelectedItemData((Object)"");
        }
        if (message != null && this.editData.getMessage().getParamScript() != null) {
            dialog = new FormulaDialog();
            this.fillFormulaDialog(dialog, this.getParamScript());
            this.kDBizMultiLangMsgParam.setSelectedItemData((Object)dialog.getFormulaAliasNoResultStr());
        } else {
            this.kDBizMultiLangMsgParam.setSelectedItemData((Object)"");
        }
        if (message != null && this.editData.getMessage().getAttrKeys() != null) {
            this.kDTextAreaAttrKey.setText(this.editData.getMessage().getAttrKeys());
        }
        if (message != null && this.editData.getMessage().getAttrScript() != null) {
            dialog = new FormulaDialog();
            this.fillFormulaDialog(dialog, this.getAttrScript());
            this.kDTextAreaAttr.setText(dialog.getFormulaAliasNoResultStr());
        }
        this.chkMergeMessages.setSelected(message.isNeedMergeMessages());
        this.isSort = message.isNeedSortMessages();
        this.sortFildId = message.getSortField();
        this.sortFileName = message.getSortFileName();
        this.sortRule = message.getSortRule();
    }

    private String getParamScript() {
        return this.getScript(ForewarnUtil.getParamScript(this.editData));
    }

    private String getAttrScript() {
        return this.getScript(ForewarnUtil.getAttrScript(this.editData));
    }

    private void fillFormulaDialog(FormulaDialog formulaDialog, String script) {
        formulaDialog.setFormula(script);
        formulaDialog.setMetaDataObjs(this.getBusinessObjects());
    }

    private BusinessObjectInfo[] getBusinessObjects() {
        return ForewarnUtil.getBusinessObjects(this.getCurrentForewarnObjects());
    }

    private void display() throws Exception {
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDBizMultiLangAreaAppendMsg, (IObjectValue)this.editData.getMessage(), (String)"appendMsg");
        this.receiverPartUI.setForewarnInfo(this.editData);
        this.receiverPartUI.setThresholdProvider(this);
        if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.kDTextFieldItemNumber.setAccessAuthority(0);
            this.kDTextFieldItemNumber.setText(this.editData.getNumber());
            this.kDTextFieldItemNumber.setAccessAuthority(1);
            this.kDTextFieldState.setAccessAuthority(0);
            this.kDTextFieldState.setText(this.editData.getState().getAlias());
            this.kDTextFieldState.setAccessAuthority(1);
            this.receiverPartUI.loadData(OprtState.VIEW);
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDTextFieldItemName, (IObjectValue)this.editData, (String)"name");
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.receiverPartUI.loadData(OprtState.ADDNEW);
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.receiverPartUI.loadData(OprtState.EDIT);
            this.kDTextFieldState.setText(this.editData.getState().getAlias());
            this.kDTextFieldItemNumber.setText(this.editData.getNumber());
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDTextFieldItemName, (IObjectValue)this.editData, (String)"name");
        }
        this.fillThresholdTable(this.editData.getCondition().getThresholdCollection());
        this.displayMessage();
    }

    private void fillThresholdTable(ForewarnThresholdCollection collection) {
        this.kDTableThreshold.removeRows();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTableThreshold.addRow();
            ForewarnThresholdInfo forewarnThresholdInfo = collection.get(i);
            row.getCell(0).setValue((Object)forewarnThresholdInfo);
            row.getCell(1).setValue((Object)forewarnThresholdInfo.getAlias());
            row.getCell(2).setValue((Object)forewarnThresholdInfo.getDataType().getAlias());
            row.getCell(3).setValue((Object)forewarnThresholdInfo.getValue());
            row.getCell(4).setValue((Object)forewarnThresholdInfo.getDescription());
        }
    }

    private String getContentScript() {
        return this.getScript(ForewarnUtil.getContentScript(this.editData));
    }

    private String getTitleScript() {
        return this.getScript(ForewarnUtil.getTitleScript(this.editData));
    }

    private String getScript(String script) {
        return ForewarnUtil.processScript(this.getCurrentForewarnObjects(), this.getCurrentForewarnThresholds(), script);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().equals((Object)this.editData.getCU().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"canNotModifyOtherCU"));
            this.abort();
        }
        super.actionEnable_actionPerformed(e);
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"enableItemAlert")) == 0) {
            try {
                this.editData.setState(ItemState.ACTIVE);
                boolean needMultipleTimeZoom = this.editData.isNeedMultipleTimeZoom();
                if (needMultipleTimeZoom) {
                    ProcessDefInfo processDefInfo = ProcessDefFactory.getRemoteInstance().getValue("where processId='a25cbc7c-31d0-4552-adc2-9854009cc67bWFPRCDEF'");
                    ProcessDef pdef = KpdlParser.parseKpdl((String)processDefInfo.getProcessxml());
                    JobUtils.getJobServiceFacade().release(pdef);
                }
                if (!needMultipleTimeZoom && this.editData.getTouchType().equals((Object)TouchType.SCHEDULE_TYPE)) {
                    this.scheduleFwEnable();
                }
                ((IForewarnItem)this.getBizInterface()).update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
                this.save = true;
                this.setSaved(true);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"enableItemSucceed"));
                this.oprtState = OprtState.VIEW;
                this.loadFields();
            }
            catch (Exception e1) {
                this.logger.info((Object)"", (Throwable)e1);
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"enableItemFail"), (Throwable)e1);
            }
        }
    }

    private void scheduleFwEnable() throws Exception {
        BOSUuid jobProcessDefID = this.editData.getProcessDefID();
        if (jobProcessDefID != null) {
            this.getWorkflowClient().updateProcessSchedule(jobProcessDefID.toString(), this.editData.getSchedule().getContent());
            this.getWorkflowClient().setProcessDefEnable(jobProcessDefID.toString(), true);
        } else {
            FunctionObjectInfo function = this.getForewarnFunction();
            OperationCollection operCol = function.getOperation();
            OperationInfo operation = null;
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!operCol.get(i).getName().equalsIgnoreCase("execForewarnItem")) continue;
                operation = operCol.get(i);
                break;
            }
            if (operation == null) {
                throw new Exception("Cannot found METHOD: execForewarnItem");
            }
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("forewarnItemID", this.editData.getId().toString());
            if (this.editData.getSchedule() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"scheduleIsNull"));
                return;
            }
            jobProcessDefID = BOSUuid.read((String)this.getWorkflowClient().createJobProcessDef("forewarn_" + this.editData.getNumber(), function, operation, jobContext, this.editData.getSchedule().getContent(), SysContext.getSysContext().getLocale()));
            this.editData.setProcessDefID(jobProcessDefID);
        }
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().equals((Object)this.editData.getCU().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"canNotModifyOtherCU"));
            this.abort();
        }
        super.actionDisable_actionPerformed(e);
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"disableItemAlert")) == 0) {
            try {
                if (this.editData.getTouchType().equals((Object)TouchType.SCHEDULE_TYPE) && !this.editData.isNeedMultipleTimeZoom()) {
                    if (this.editData.getSchedule() == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"scheduleIsNull"));
                        return;
                    }
                    this.getWorkflowClient().updateProcessSchedule(this.editData.getProcessDefID().toString(), this.editData.getSchedule().getContent());
                    this.getWorkflowClient().setProcessDefEnable(this.editData.getProcessDefID().toString(), false);
                }
                this.editData.setState(ItemState.UNACTIVE);
                ((IForewarnItem)this.getBizInterface()).setItemState((IObjectPK)new ObjectUuidPK(this.editData.getId()), ItemState.UNACTIVE);
                this.save = true;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"disableItemSucceed"));
                this.loadFields();
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"disableItemFail"), (Throwable)e1);
            }
        }
    }

    @Override
    public void actionSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetup_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ForewarnItem", (Object)this.editData);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>();
        tempMap.put("isNotModify", Boolean.FALSE);
        uiContext.put((Object)"flag", tempMap);
        IUIWindow window = uiFactory.create(ForewarnItemEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        this.display();
        Map content = (Map)uiContext.get((Object)"flag");
        boolean isModify = true;
        if (content != null && content.get("isNotModify") != null && Boolean.TRUE == content.get("isNotModify")) {
            isModify = false;
        }
        this.setModified(isModify);
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        String tempSchedule;
        super.actionSchedule_actionPerformed(e);
        if (TouchType.RIGHTNOW_TYPE.equals((Object)this.editData.getTouchType())) {
            this.setRightnowTouch(e);
            return;
        }
        String schedule = "";
        if (this.editData.getSchedule() != null && !this.editData.getSchedule().getContent().trim().equalsIgnoreCase("")) {
            schedule = this.editData.getSchedule().getContent();
        }
        boolean readonly = false;
        if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW) || this.getOprtState().equalsIgnoreCase(OprtState.EDIT) && this.editData.getState().equals((Object)ItemState.ACTIVE)) {
            readonly = true;
        }
        if ((tempSchedule = ProcessSchedulePlan.open((Object)this, (String)schedule, (boolean)readonly)) != null) {
            schedule = tempSchedule;
            this.setModified(true);
        }
        if (this.editData.getSchedule() != null && !this.editData.getSchedule().getContent().trim().equalsIgnoreCase("")) {
            this.editData.getSchedule().setContent(schedule);
        } else {
            ForewarnScheduleInfo scheduleInfo = new ForewarnScheduleInfo();
            scheduleInfo.setContent(schedule);
            this.editData.setSchedule(scheduleInfo);
        }
    }

    private void setRightnowTouch(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        ForewarnItemInfo item = new ForewarnItemInfo();
        this.getUIContext().put("forewarnInfo", item);
        this.getUIContext().put("Owner", this.getUIWindow());
        this.getUIContext().put("onlyView", "true");
        this.getUIContext().put("editData", this.editData);
        IUIWindow window = uiFactory.create(SetRightnowForewarnActionUI.class.getName(), this.getUIContext(), null, this.getOprtState());
        window.show();
    }

    protected IObjectValue createNewData() {
        try {
            this.setDataObject((IObjectValue)this.getNewItem());
            this.decideItemType();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ForewarnItemFactory.getRemoteInstance();
    }

    private ForewarnItemInfo getNewItem() throws Exception {
        int i;
        int size;
        String templetID = this.getUIContext().get("templetID").toString();
        ForewarnItemInfo itemInfo = (ForewarnItemInfo)this.getBizInterface().getValue("select *, schedule.*,message.*,objects.*,condition.*,condition.thresholdCollection.*,receivers.*,templet.*,bizOrg.*,touchAction.*,dynReceivers.* where id = '" + templetID + "'");
        ForewarnItemInfo forewarnTemplet = (ForewarnItemInfo)itemInfo.clone();
        itemInfo.setId(null);
        itemInfo.setName(null);
        itemInfo.setNumber(null);
        if (itemInfo.getSchedule() != null) {
            itemInfo.getSchedule().setId(null);
        }
        if (itemInfo.getTouchAction() != null) {
            size = itemInfo.getTouchAction().size();
            for (i = 0; i < size; ++i) {
                itemInfo.getTouchAction().get(i).setId(null);
                itemInfo.getTouchAction().get(i).setForewarnTemplate(null);
            }
        }
        if (itemInfo.getMessage() != null) {
            itemInfo.getMessage().setId(null);
        }
        if (itemInfo.getObjects() != null) {
            size = itemInfo.getObjects().size();
            for (i = 0; i < size; ++i) {
                itemInfo.getObjects().get(i).setId(null);
                itemInfo.getObjects().get(i).setItem(null);
            }
        }
        if (itemInfo.getCondition() != null) {
            itemInfo.getCondition().setId(null);
            if (itemInfo.getCondition().getThresholdCollection() != null) {
                size = itemInfo.getCondition().getThresholdCollection().size();
                for (i = 0; i < size; ++i) {
                    itemInfo.getCondition().getThresholdCollection().get(i).setId(null);
                    itemInfo.getCondition().getThresholdCollection().get(i).setCondition(null);
                }
            }
        }
        if (itemInfo.getReceivers() != null) {
            size = itemInfo.getReceivers().size();
            for (i = 0; i < size; ++i) {
                itemInfo.getReceivers().get(i).setId(null);
                itemInfo.getReceivers().get(i).setItem(null);
            }
        }
        if (itemInfo.getDynReceivers() != null) {
            size = itemInfo.getDynReceivers().size();
            for (i = 0; i < size; ++i) {
                itemInfo.getDynReceivers().get(i).setId(null);
                itemInfo.getDynReceivers().get(i).setFwItem(null);
            }
        }
        itemInfo.setType(Type.ITEM);
        itemInfo.setTemplet(forewarnTemplet);
        itemInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return itemInfo;
    }

    @Override
    public void actionSelectReceivers_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setUIProperties();
    }

    private EntityObjectInfo[] getEntites() {
        EntityObjectInfo[] entities = null;
        entities = ForewarnUtil.getEntities(this.editData.getObjects());
        return entities;
    }

    private void saveForewarnItem() throws WfException, Exception {
        this.verify();
        this.editData.setNumber(this.kDTextFieldItemNumber.getText());
        this.editData.setName(StringUtils.cnulls((Object)this.kDTextFieldItemName.getSelectedItem()));
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.kDBizMultiLangAreaAppendMsg, (IObjectValue)this.editData.getMessage(), (String)"appendMsg");
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        }
        this.editData.getMessage().setNeedMergeMessages(this.chkMergeMessages.isSelected());
        this.editData.getMessage().setNeedSortMessages(this.isSort);
        this.editData.getMessage().setSortField(this.sortFildId);
        this.editData.getMessage().setSortFileName(this.sortFileName);
        this.editData.getMessage().setSortRule(this.sortRule);
        this.saveThresholds();
    }

    private void saveThresholds() {
        this.editData.getCondition().getThresholdCollection().clear();
        int size = this.kDTableThreshold.getRowCount();
        for (int i = 0; i < size; ++i) {
            ForewarnThresholdInfo thresholdInfo = (ForewarnThresholdInfo)this.kDTableThreshold.getRow(i).getCell(0).getValue();
            thresholdInfo.setValue(this.kDTableThreshold.getRow(i).getCell(3).getValue().toString());
            this.editData.getCondition().getThresholdCollection().add(thresholdInfo);
        }
    }

    public boolean isPrepareActionSubmit() {
        return false;
    }

    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("oprtstate", (Object)this.getOprtState());
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.saveForewarnItem();
            }
            request.put("editData", (Object)this.editData);
            if (OprtState.EDIT.equals(this.getOprtState())) {
                request.put("valueoql", (Object)this.getValueOql(this.editData.getId().toString()));
            }
        }
        return request;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        block6: {
            if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
                this.saveForewarnItem();
                this.setDataObject((IObjectValue)this.editData);
                IForewarnItem iForewarnItem = (IForewarnItem)this.getBizInterface();
                try {
                    iForewarnItem.addnew((CoreBaseInfo)this.editData);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"saveItemSucceed"));
                    this.oprtState = OprtState.EDIT;
                    this.save = true;
                    this.setSaved(true);
                    this.loadFields();
                }
                catch (Exception e1) {
                    if (e1 instanceof BaseForewarnAppException) {
                        ExceptionHandler.handle((Component)((Object)this), (String)(EASResource.getString((String)forewarnRes, (String)"saveItemFail") + ((BaseForewarnAppException)((Object)e1)).getMessage()), (Throwable)e1);
                        break block6;
                    }
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"saveItemFail"), (Throwable)e1);
                }
            } else {
                if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().equals((Object)this.editData.getCU().getId())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"canNotModifyOtherCU"));
                    this.abort();
                }
                this.saveForewarnItem();
                this.setDataObject((IObjectValue)this.editData);
                super.actionSubmit_actionPerformed(e);
                this.setSaved(true);
            }
        }
    }

    private EASWfServiceClient getWorkflowClient() throws BOSException {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    private void setProcessDefEnable(String jobProcessDefID, boolean flag) throws BOSException {
        this.getWorkflowClient().setProcessDefEnable(jobProcessDefID, flag);
    }

    private void releaseProcessDef(String jobProcessDefID, boolean flag) throws WfException, BOSException {
        this.getWorkflowClient().releaseProcessDef(jobProcessDefID, flag);
    }

    private FunctionObjectInfo getForewarnFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.base.forewarn.ForewarnRunTimeFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue("select *, schedule.*,message.*,objects.*,condition.*,condition.thresholdCollection.*,receivers.*,templet.*,bizOrg.*,touchAction.*,dynReceivers.* where id = '" + pk.toString() + "'");
    }

    protected void verify() {
        if (this.isNull(this.kDTextFieldItemNumber.getText())) {
            this.kDTextFieldItemNumber.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"itemNumberIsNull"));
            SysUtil.abort();
        } else if (this.isNull(StringUtils.cnulls((Object)this.kDTextFieldItemName.getSelectedItem()))) {
            this.kDTextFieldItemName.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"itemNameIsNull"));
            SysUtil.abort();
        } else if (this.checkThresholdValueIsNull()) {
            this.kDTableThreshold.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"forewarnThresholdValueIsNull"));
            SysUtil.abort();
        } else if (this.isNull(StringUtils.cnulls((Object)this.kDTextFieldMsgTitle.getSelectedItem()))) {
            this.kDTextFieldMsgTitle.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"msgTitleIsNull"));
            SysUtil.abort();
        } else if (this.isNull(StringUtils.cnulls((Object)this.areaCtrlMsgExpression.getSelectedItem()))) {
            this.areaCtrlMsgExpression.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"msgContentIsNull"));
            SysUtil.abort();
        } else if (this.isNull(StringUtils.cnulls((String)this.receiverPartUI.getReceivers(false)))) {
            this.receiverPartUI.getReceiversComponent(false).requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"receiverIsNull"));
            SysUtil.abort();
        }
        this.checkTouchSet();
        this.checkAppMsgLength();
    }

    private void checkTouchSet() {
        TouchType tt = this.editData.getTouchType();
        if (tt == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"touchTypeIsNull"));
            this.abort();
        }
        if (tt.equals((Object)TouchType.SCHEDULE_TYPE) && (this.editData.getSchedule() == null || this.isNull(this.editData.getSchedule().getContent()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"scheduleIsNull"));
            this.abort();
        }
        if (tt.equals((Object)TouchType.RIGHTNOW_TYPE) && (this.editData.getTouchAction() == null || this.editData.getTouchAction().size() <= 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"rightnowTouchIsNull"));
            this.abort();
        }
    }

    private void checkAppMsgLength() {
        List listLang = KDBizMultiLangArea.getLanguageList();
        for (LanguageInfo currentLang : listLang) {
            Object data = this.kDBizMultiLangAreaAppendMsg.getItemBy(currentLang).getData();
            if (data == null || data.toString().length() <= 500) continue;
            this.kDBizMultiLangAreaAppendMsg.getEditorComponent().requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"appMsgLengthWarning"));
            SysUtil.abort();
        }
    }

    protected void checkThresholds() {
        if (this.checkThresholdValueIsNull()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"forewarnThresholdValueIsNull"));
            SysUtil.abort();
        }
    }

    private boolean checkThresholdValueIsNull() {
        int rowCount = this.kDTableThreshold.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.isNull(this.kDTableThreshold.getRow(i).getCell(3).getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().equalsIgnoreCase("");
    }

    @Override
    protected void kDTableThreshold_editStopped(KDTEditEvent e) throws Exception {
        super.kDTableThreshold_editStopped(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0) {
            ForewarnThresholdInfo forewarnThresholdInfo = (ForewarnThresholdInfo)this.kDTableThreshold.getRow(rowIndex).getCell(0).getValue();
            Object value = this.kDTableThreshold.getRow(rowIndex).getCell(3).getValue();
            if (value != null) {
                if (!ForewarnUtil.validateData(forewarnThresholdInfo.getDataType(), value.toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)forewarnRes, (String)"thresholdValueWarning"));
                    this.kDTableThreshold.getRow(rowIndex).getCell(3).setValue(null);
                    forewarnThresholdInfo.setValue(null);
                } else {
                    forewarnThresholdInfo.setValue(value.toString());
                }
            } else {
                forewarnThresholdInfo.setValue(null);
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean flag) {
        if (!"VIEW".equals(this.getOprtState()) && this.editData.getState().equals((Object)ItemState.UNACTIVE)) {
            this.modified = flag;
        }
    }

    protected void initListener() {
        super.initListener();
        this.kDTextFieldItemName.getEditorComponent().addFocusListener(new MutiValueChangeListener());
        this.kDTextFieldItemNumber.getDocument().addDocumentListener(new DocumentChangeListener());
        this.kDTextFieldMsgTitle.getEditorComponent().addFocusListener(new MutiValueChangeListener());
        this.areaCtrlMsgExpression.getEditorComponent().addFocusListener(new MutiValueChangeListener());
        ((KDTextArea)this.kDBizMultiLangAreaAppendMsg.getEditorComponent()).getDocument().addDocumentListener(new DocumentChangeListener());
        this.kDTableThreshold.addKDTPropertyChangeListener((KDTPropertyChangeListener)new TableChangeListener());
    }

    public boolean checkBeforeWindowClosing() {
        if (!"VIEW".equals(this.getOprtState()) && this.isModified() && !this.editData.getState().equals((Object)ItemState.ACTIVE)) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                return !this.actionSubmit.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    public boolean isRefreshParent() {
        return true;
    }

    public boolean isModify() {
        String tempType = this.editData.getTouchType().getValue();
        this.editData.put("touchType", new Integer(tempType));
        boolean isModi = super.isModify();
        this.editData.put("touchType", tempType);
        return isModi;
    }

    @Override
    public ForewarnThresholdCollection getThresholdCollection() {
        return this.editData.getCondition().getThresholdCollection();
    }

    class TableChangeListener
    implements KDTPropertyChangeListener {
        TableChangeListener() {
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("cellValue")) {
                ForewarnItemUI.this.setModified(true);
            }
        }
    }

    class ComboxChangeListener
    implements PropertyChangeListener {
        ComboxChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ForewarnItemUI.this.setModified(true);
        }
    }

    class MutiValueChangeListener
    implements FocusListener {
        String tempValue;

        MutiValueChangeListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof DefaultTextField) {
                this.tempValue = ((DefaultTextField)e.getSource()).getText();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof DefaultTextField) {
                String leftStr = ((DefaultTextField)e.getSource()).getText();
                if (this.tempValue != null && !this.tempValue.trim().equals(leftStr.trim())) {
                    ForewarnItemUI.this.setModified(true);
                }
            }
        }
    }

    class DocumentChangeListener
    implements DocumentListener {
        DocumentChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ForewarnItemUI.this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ForewarnItemUI.this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ForewarnItemUI.this.setModified(true);
        }
    }
}

