/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.forewarn.ForewarnItemCollection;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.IForewarnItem;
import com.kingdee.eas.base.forewarn.ItemState;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.client.AbstractForewarnTempletListUI;
import com.kingdee.eas.base.forewarn.client.AddFWTempletUI;
import com.kingdee.eas.base.forewarn.client.ForewarnItemUI;
import com.kingdee.eas.base.forewarn.client.ForewarnTempletEditUI;
import com.kingdee.eas.base.forewarn.client.NodeObject;
import com.kingdee.eas.base.forewarn.client.SaveAsUI;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ForewarnTempletListUI
extends AbstractForewarnTempletListUI {
    private String currentForewarnTempletID = "";
    private String currentTemplateTouchType = "";
    private String currentTemplateMainObjectName = "";
    private String currentTemplateMainObjectType = "";
    private String currentMetadata = null;
    private String currentBizSystem = "";
    private MetaDataBriefInfo currentBriefInfo = null;
    private DefaultKingdeeTreeNode root;
    private BOSObjectType currentMetadataType = null;
    public static final String resName = "com.kingdee.eas.base.forewarn.client.Forewarn";
    private JButton btnViewItem;
    private JButton btnAddItem;
    private JButton btnEditItem;
    private JButton btnDelItem;
    private String oldContainerTemplateTitle = "";
    private String oldContainerItemTitle = "";
    private ArrayList metadataNodes = new ArrayList();
    private boolean isAddSuccess = false;

    private void init() {
        this.initTree();
        this.initTable();
        this.initButton();
    }

    private void initButton() {
        this.kDSeparator3.setVisible(false);
        this.menuItemImportData.setVisible(false);
        this.miAddItem.setVisible(false);
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.actionAddItem.putValue("Name", "");
        this.btnAddItem = this.kDContainerItem.add((Action)((Object)this.actionAddItem));
        this.btnAddItem.setSize(new Dimension(22, 10));
        this.btnAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddItem.setToolTipText(EASResource.getString((String)resName, (String)"addItem"));
        this.actionViewItem.putValue("Name", "");
        this.btnViewItem = this.kDContainerItem.add((Action)((Object)this.actionViewItem));
        this.btnViewItem.setSize(new Dimension(22, 20));
        this.btnViewItem.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewItem.setToolTipText(EASResource.getString((String)resName, (String)"viewItem"));
        this.actionEditItem.putValue("Name", "");
        this.btnEditItem = this.kDContainerItem.add((Action)((Object)this.actionEditItem));
        this.btnEditItem.setSize(new Dimension(22, 20));
        this.btnEditItem.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnEditItem.setToolTipText(EASResource.getString((String)resName, (String)"editItem"));
        this.actionDelItem.putValue("Name", "");
        this.btnDelItem = this.kDContainerItem.add((Action)((Object)this.actionDelItem));
        this.btnDelItem.setSize(new Dimension(22, 20));
        this.btnDelItem.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelItem.setToolTipText(EASResource.getString((String)resName, (String)"delItem"));
    }

    private void initTree() {
        this.root = this.createNode();
        this.processTree(this.root);
        this.addPopupMenu(this.kDTree);
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.kDTree.getSelectionModel().setSelectionMode(1);
    }

    private void processTree(DefaultKingdeeTreeNode root) {
        Map templates = this.getTemplates();
        this.processSubSystemNode(root, templates);
        this.removeMetadataNodes(templates);
        this.removeEmptyPackageNode(root);
    }

    private Map getTemplates() {
        HashMap<NodeObject, String> templets = new HashMap<NodeObject, String>();
        try {
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.forewarn.TemplateTreeQuery");
            IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.setMaskString("#0 or #1 ");
            entityViewInfo.setFilter(filter);
            executor.setObjectView(entityViewInfo);
            IRowSet rowSet = executor.executeQuery();
            while (rowSet.next()) {
                NodeObject nodeObject = new NodeObject();
                nodeObject.setTemplateID(rowSet.getString("ID"));
                nodeObject.setTemplateName(rowSet.getString("NAME"));
                nodeObject.setObjectName(rowSet.getString("OBJECTS.NAME"));
                nodeObject.setObjectMetadataType(MetadataType.getEnum(rowSet.getInt("OBJECTS.METADATATYPE")));
                nodeObject.setTouchType(rowSet.getString("TOUCHTYPE"));
                templets.put(nodeObject, nodeObject.getObjectName());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return templets;
    }

    private void processSubSystemNode(DefaultKingdeeTreeNode root, Map templates) {
        Enumeration enum1 = root.breadthFirstEnumeration();
        while (enum1.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enum1.nextElement();
            if (!this.isEntityOrFacade(node)) continue;
            this.addTemplateNodes(node, templates);
        }
    }

    private void addTemplateNodes(DefaultKingdeeTreeNode node, Map templates) {
        if (node.getUserObject() instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo info = (MetaDataBriefInfo)node.getUserObject();
            ArrayList entityTemplateNodes = new ArrayList();
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
                entityTemplateNodes = this.getEntityTemplateNodes(info, templates);
                this.metadataNodes.add(node);
            } else if (info.getMetaDataType().equals((Object)MetaDataTypeList.FACADE)) {
                entityTemplateNodes = this.getFacadeTemplateNodes(info, templates);
                this.metadataNodes.add(node);
            }
            int size = entityTemplateNodes.size();
            for (int i = 0; i < size; ++i) {
                this.kDTree.addNodeInto((MutableTreeNode)((DefaultKingdeeTreeNode)entityTemplateNodes.get(i)), (MutableTreeNode)node);
            }
        }
    }

    private ArrayList getEntityTemplateNodes(MetaDataBriefInfo info, Map templates) {
        ArrayList<DefaultKingdeeTreeNode> templateNodes = new ArrayList<DefaultKingdeeTreeNode>();
        if (templates.containsValue(info.getFullName())) {
            for (NodeObject nodeObject : templates.keySet()) {
                if (!templates.get(nodeObject).equals(info.getFullName()) || !nodeObject.getObjectMetadataType().equals((Object)MetadataType.ENTITY)) continue;
                DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode();
                childNode.setUserObject((Object)nodeObject);
                childNode.setText(nodeObject.getTemplateName());
                templateNodes.add(childNode);
            }
        }
        return templateNodes;
    }

    private ArrayList getFacadeTemplateNodes(MetaDataBriefInfo info, Map templates) {
        ArrayList<DefaultKingdeeTreeNode> templateNodes = new ArrayList<DefaultKingdeeTreeNode>();
        if (templates.containsValue(info.getFullName())) {
            for (NodeObject nodeObject : templates.keySet()) {
                if (!templates.get(nodeObject).equals(info.getFullName()) || !nodeObject.getObjectMetadataType().equals((Object)MetadataType.FACADE)) continue;
                DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode();
                childNode.setUserObject((Object)nodeObject);
                childNode.setText(nodeObject.getTemplateName());
                templateNodes.add(childNode);
            }
        }
        return templateNodes;
    }

    private boolean isEntityOrFacade(DefaultKingdeeTreeNode node) {
        MetaDataBriefInfo childInfo;
        return node.getUserObject() instanceof MetaDataBriefInfo && ((childInfo = (MetaDataBriefInfo)node.getUserObject()).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || childInfo.getMetaDataType().equals((Object)MetaDataTypeList.FACADE));
    }

    private void removeMetadataNodes(Map templates) {
        int size = this.metadataNodes.size();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.metadataNodes.get(i);
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
            if (templates.containsValue(briefInfo.getFullName()) || node.getParent() == null) continue;
            this.kDTree.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private void removeEmptyPackageNode(DefaultKingdeeTreeNode tmpNode) {
        DefaultKingdeeTreeNode node = tmpNode;
        DefaultKingdeeTreeNode tmp = null;
        int nodeCount = node.getChildCount();
        if (nodeCount > 0) {
            for (int i = nodeCount - 1; i >= 0; --i) {
                tmp = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.removeEmptyPackageNode(tmp);
            }
        }
        if (node.getUserObject() instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
            if (node.toString().equals(EASResource.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"12_ForewarnTempletListUI")) || node.toString().equals(EASResource.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"13_ForewarnTempletListUI"))) {
                System.out.println("nodecount:" + node.getChildCount());
            }
            if (node.getChildCount() == 0 && briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE) && node.getParent() != null) {
                this.kDTree.removeNodeFromParent((MutableTreeNode)node);
            }
        } else {
            System.out.println("node:" + node.toString());
        }
    }

    private void addPopupMenu(KDTree tree) {
        JPopupMenu menu = tree.getPopupMenu();
        EventListener[] ls = tree.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            tree.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    TreePath[] treePaths = event.getSelectionPaths();
                    if (treePaths != null) {
                        int treePathLength = treePaths.length;
                        return treePathLength == 1;
                    }
                    return false;
                }
            });
        }
    }

    private void initTable() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent dre) {
                ForewarnTempletListUI.this.afterTableDataFill(dre);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    ForewarnTempletListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    ForewarnTempletListUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.getViewManager().setFreezeView(0, 2);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getPrevSelectBlock() == null) {
            return;
        }
        if (!e.getPrevSelectBlock().equals((Object)e.getSelectBlock()) && e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow()) {
            this.synTreeSltNodeWhenTableSltChanged((TreeNode)this.root, this.currentForewarnTempletID);
        }
    }

    protected void afterTableDataFill(KDTDataRequestEvent dre) {
        try {
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(0, 0);
                this.currentForewarnTempletID = this.tblMain.getRow(0).getCell("id").getValue().toString();
                this.refreshForewarnItems();
            } else {
                this.currentForewarnTempletID = "";
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.forewarn.app.ForewarnTempletListUIHandler");
            request.put("currentForewarnTempletID", (Object)this.currentForewarnTempletID);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.setMaskString("#0 or #1 ");
            entityViewInfo.setFilter(filter);
            request.put("entityViewInfo", (Object)entityViewInfo);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.kDTableItem.checkParsed();
        if (this.mainQuery == null || this.mainQuery.getFilter() == null) {
            this.mainQuery = this.getPackageEntityView(this.root);
            this.kDTree.setSelectionNode(this.root);
        }
        this.oldContainerTemplateTitle = this.kDContainerTemplate.getTitle();
        this.oldContainerItemTitle = this.kDContainerItem.getTitle();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.kDTableItem.getSelectManager().setSelectMode(2);
        this.miAddItem.setText(this.resHelper.getString("miAddItem.text"));
        this.miEditItem.setText(this.resHelper.getString("miEditItem.text"));
        this.miDelItem.setText(this.resHelper.getString("miDelItem.text"));
        this.miViewItem.setText(this.resHelper.getString("miViewItem.text"));
        this.btnViewItem.setVisible(false);
        this.btnAddItem.setVisible(false);
        this.btnEditItem.setVisible(false);
        this.btnDelItem.setVisible(false);
        this.kDTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ForewarnTempletListUI.this.kDTree.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ForewarnTempletListUI.this.refreshQueryData();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ForewarnTempletListUI.this.kDTree.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.refreshForewarnItems();
    }

    protected String getEditUIName() {
        return ForewarnTempletEditUI.class.getName();
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_foreWarn")));
    }

    private void refreshQueryData() throws Exception {
        Object object = this.kDTree.getLastSelectedPathComponent();
        if (!(object instanceof DefaultKingdeeTreeNode)) {
            return;
        }
        Object userObject = ((DefaultKingdeeTreeNode)object).getUserObject();
        if (userObject instanceof NodeObject) {
            NodeObject briefInfo = (NodeObject)userObject;
            if (briefInfo.getObjectMetadataType().equals((Object)MetadataType.ENTITY) || briefInfo.getObjectMetadataType().equals((Object)MetadataType.FACADE)) {
                this.currentMetadata = briefInfo.getObjectName();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                viewInfo.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("objects.name", (Object)this.currentMetadata));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)briefInfo.getTemplateID()));
                filterInfo.setMaskString("#0 and #1");
                this.mainQuery = viewInfo;
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
                } else {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(this.getDefaultFilterForQuery());
                    this.mainQuery = evi;
                }
                this.refresh();
            }
        } else if (userObject instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)userObject;
            if (briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.FACADE)) {
                this.currentMetadata = briefInfo.getFullName();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                viewInfo.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("objects.name", (Object)this.currentMetadata));
                filterInfo.setMaskString("#0");
                this.mainQuery = viewInfo;
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
                } else {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(this.getDefaultFilterForQuery());
                    this.mainQuery = evi;
                }
                this.refresh();
            } else if (briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                this.mainQuery = this.getPackageEntityView((DefaultKingdeeTreeNode)object);
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
                } else {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(this.getDefaultFilterForQuery());
                    this.mainQuery = evi;
                }
                this.refresh();
            }
        }
    }

    @Override
    protected void kDTree_mouseClicked(MouseEvent e) throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 ");
        return filter;
    }

    private void setContainerTemplateTilte() {
        if (this.currentBriefInfo != null) {
            if (this.currentBriefInfo.getAlias() != null) {
                this.kDContainerTemplate.setTitle(this.oldContainerTemplateTitle + " -- " + this.currentBriefInfo.getAlias());
            } else {
                this.kDContainerTemplate.setTitle(this.oldContainerTemplateTitle + " -- " + this.currentBriefInfo.getName());
            }
        } else {
            this.kDContainerTemplate.setTitle(this.oldContainerTemplateTitle);
        }
    }

    private EntityViewInfo getPackageEntityView(DefaultKingdeeTreeNode pack) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        if (!pack.equals(this.root)) {
            Enumeration enum1 = pack.breadthFirstEnumeration();
            int i = 0;
            StringBuffer maskString = new StringBuffer();
            while (enum1.hasMoreElements()) {
                NodeObject briefInfo;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enum1.nextElement();
                if (!(node.getUserObject() instanceof NodeObject) || !(briefInfo = (NodeObject)node.getUserObject()).getObjectMetadataType().equals((Object)MetadataType.ENTITY) && !briefInfo.getObjectMetadataType().equals((Object)MetadataType.FACADE)) continue;
                filterInfo.getFilterItems().add(new FilterItemInfo("objects.name", (Object)briefInfo.getObjectName()));
                maskString.append("#").append(String.valueOf(i)).append(" OR ");
                ++i;
            }
            String strMask = maskString.toString();
            int index = strMask.lastIndexOf("OR");
            if (index != -1) {
                strMask = strMask.substring(0, index).trim();
            }
            if (strMask.trim().length() > 0) {
                strMask = "(" + strMask + ")";
            }
            filterInfo.setMaskString(strMask);
        }
        return entityViewInfo;
    }

    @Override
    protected void kDTableItem_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex;
        if (e.getClickCount() == 1) {
            if (e.getType() == 0) {
                return;
            }
            rowIndex = e.getRowIndex();
            if (this.kDTableItem.getRowCount() > 0 && rowIndex >= 0) {
                ICell cell;
                String displayState;
                ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString()));
                ForewarnItemInfo forewarnItemInfo = ((IForewarnItem)this.getBizInterface()).getForewarnItemInfo((IObjectPK)objectPK);
                String stateInDB = forewarnItemInfo.getState().getAlias();
                if (!stateInDB.equalsIgnoreCase(displayState = (cell = this.kDTableItem.getRow(rowIndex).getCell("state")).getValue().toString())) {
                    cell.setValue((Object)stateInDB);
                }
            }
        }
        if (e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            rowIndex = e.getRowIndex();
            if (this.kDTableItem.getRowCount() > 0 && rowIndex >= 0) {
                String itemID = this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)itemID);
                uiContext.put((Object)"FROM_TEMPLATE_LIST", (Object)"true");
                uiContext.put((Object)"OBJECTTYPE", (Object)this.currentTemplateTouchType);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ForewarnItemUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                this.kDTableItem.refresh();
            }
        }
    }

    private void refresh() {
        this.tblMain.refresh();
        this.refreshForewarnItems();
        this.setContainerTemplateTilte();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
        this.initTree();
    }

    private void SysTreeAfterAddOrDelTemplet(boolean isAdd) {
        KingdeeTreeModel model = (KingdeeTreeModel)this.kDTree.getModel();
        DefaultKingdeeTreeNode oldRootNode = (DefaultKingdeeTreeNode)model.getRoot();
        this.root = this.createNode();
        this.processTree(this.root);
    }

    private void copyNewToOldNode(DefaultKingdeeTreeNode newNode, DefaultKingdeeTreeNode oldNode, boolean isAdd) {
        if (isAdd) {
            int count = newNode.getChildCount();
            for (int i = 0; i < count; ++i) {
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (e.getClickCount() != 1 && e.getClickCount() == 2) {
            super.tblMain_tableClicked(e);
        }
    }

    private boolean synTreeSltNodeWhenTableSltChanged(TreeNode parentNode, String templateID) {
        NodeObject tmpObj;
        DefaultKingdeeTreeNode tmpNode;
        Object o;
        boolean isExpand = false;
        if (parentNode instanceof DefaultKingdeeTreeNode && (o = (tmpNode = (DefaultKingdeeTreeNode)parentNode).getUserObject()) instanceof NodeObject && (tmpObj = (NodeObject)o).getTemplateID().equals(templateID)) {
            this.kDTree.expandAllNodes(false, (TreeNode)this.root);
            this.kDTree.setSelectionNode((DefaultKingdeeTreeNode)parentNode);
            isExpand = true;
        }
        int count = parentNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode node = parentNode.getChildAt(i);
            this.synTreeSltNodeWhenTableSltChanged(node, templateID);
        }
        return false;
    }

    private void refreshForewarnItems() {
        this.forewarnItem = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("ForwarnTemplet.id", (Object)this.currentForewarnTempletID);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.setMaskString(" #0 ");
        this.forewarnItem.setFilter(filterInfo);
        FilterInfo cuFilter = new FilterInfo();
        cuFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        if (this.forewarnItem.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
            try {
                this.forewarnItem.getFilter().mergeFilter(cuFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(cuFilter);
            this.mainQuery = evi;
        }
        this.kDTableItem.refresh();
        this.kDContainerItem.setTitle(this.getContainerItemTitle());
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        if (this.currentForewarnTempletID != null && !this.currentForewarnTempletID.trim().equalsIgnoreCase("")) {
            this.btnViewItem.setVisible(true);
            this.btnAddItem.setVisible(true);
            this.btnEditItem.setVisible(true);
            this.btnDelItem.setVisible(true);
        } else {
            this.btnViewItem.setVisible(false);
            this.btnAddItem.setVisible(false);
            this.btnEditItem.setVisible(false);
            this.btnDelItem.setVisible(false);
        }
    }

    private String getContainerItemTitle() {
        if (this.currentForewarnTempletID != null && !this.currentForewarnTempletID.trim().equalsIgnoreCase("")) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            if (rowIndex != -1) {
                if (this.tblMain.getRow(rowIndex).getCell("name").getValue() != null) {
                    return this.oldContainerItemTitle + " -- " + this.tblMain.getRow(rowIndex).getCell("name").getValue().toString();
                }
                return "";
            }
            return this.oldContainerItemTitle;
        }
        return this.oldContainerItemTitle;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public RequestContext prepareActionAddItem(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionAddItem() {
        return true;
    }

    @Override
    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddItem_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"templetID", (Object)this.currentForewarnTempletID);
        uiContext.put((Object)"OBJECTTYPE", (Object)this.currentTemplateTouchType);
        uiContext.put((Object)"FROM_TEMPLATE_LIST", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ForewarnItemUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            this.refreshForewarnItems();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionDelItem_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentForewarnTempletID != null) {
            int rowIndex = this.kDTableItem.getSelectManager().getActiveRowIndex();
            if (this.kDTableItem.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeItemAlert"));
                return;
            }
            String cuID = this.kDTableItem.getRow(rowIndex).getCell("CU.id").getValue().toString();
            if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals(cuID)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"canNotModifyOtherCU"));
                this.abort();
            }
            ObjectUuidPK delItemPK = new ObjectUuidPK(BOSUuid.read((String)this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString()));
            IForewarnItem forewarnItem = (IForewarnItem)this.getBizInterface();
            if (forewarnItem.getForewarnItemInfo((IObjectPK)delItemPK).getState().equals((Object)ItemState.ACTIVE)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"activeItemCanNotDel"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeItemPrompt")) == 0) {
                try {
                    forewarnItem.delete((IObjectPK)delItemPK);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeItemSucceed"));
                    this.refreshForewarnItems();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeItemFail"), (Throwable)e1);
                }
            }
        }
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("currentForewarnTempletID", (Object)this.currentForewarnTempletID);
        }
        return request;
    }

    public boolean isPrepareActionRemove() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BizEnumValueInfo typeEnum;
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeTempletAlert"));
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String cuID = this.tblMain.getRow(rowIndex).getCell("CU.id").getValue().toString();
        if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals(cuID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"canNotModifyOtherCU"));
            this.abort();
        }
        if (20 == (typeEnum = (BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("type").getValue()).getInt()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"sysTemplateCanNotDel"));
        } else {
            String removeTempletWarning = this.getRemoveTempletWarning();
            if (removeTempletWarning != null) {
                MsgBox.showError((Component)((Object)this), (String)removeTempletWarning);
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeTempletPrompt")) == 0) {
                ObjectUuidPK delItemPK = new ObjectUuidPK(BOSUuid.read((String)this.tblMain.getRow(rowIndex).getCell("id").getValue().toString()));
                try {
                    this.prepareActionRemoveAfterConfirmDelete(null, (IObjectPK)delItemPK);
                    ((IForewarnItem)this.getBizInterface()).delete((IObjectPK)delItemPK);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeTempletSucceed"));
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"removeTempletFail"), (Throwable)e1);
                }
                finally {
                    this.execQuery();
                    this.initTree();
                }
            }
        }
    }

    private void prepareActionRemoveAfterConfirmDelete(IItemAction itemAction, IObjectPK delItemPK) throws Exception {
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("getRemovedPK", (Object)delItemPK);
        request.setMethodName("_handleActionRemoveAfterConfirmDelete");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    private String getRemoveTempletWarning() {
        String warning = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("templet.id", (Object)this.currentForewarnTempletID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("type", (Object)String.valueOf(0));
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString("#0 and #1");
            entityViewInfo.setFilter(filterInfo);
            ForewarnItemCollection forewarnItemCollection = ForewarnItemFactory.getRemoteInstance().getForewarnItemCollection(entityViewInfo);
            if (forewarnItemCollection.size() > 0) {
                warning = EASResource.getString((String)resName, (String)"templetIsUsing");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return warning;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ForewarnItemFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"MetadataName", (Object)this.currentMetadata);
        uiContext.put((Object)"MetadataType", (Object)this.currentMetadataType);
        uiContext.put((Object)"BizSystem", (Object)this.currentBizSystem);
        uiContext.put((Object)"forewarnInfo", this.getUIContext().get("forewarnInfo"));
        super.prepareUIContext(uiContext, e);
    }

    private void prepareBeforeAddNew(IItemAction itemAction) throws Exception {
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        String uiName = "com.kingdee.eas.base.forewarn.client.ReceiverPartUI";
        ObjectMultiPK pk = new ObjectMultiPK();
        pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
        pk.setKeyValue("uiClassName", (Object)uiName);
        request.put("pk", (Object)pk);
        request.setMethodName("_handlePrepareBeforeAddNew");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    private void prepareAddOrDelAfter(IItemAction itemAction) throws Exception {
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("currentForewarnTempletID", (Object)this.currentForewarnTempletID);
        request.setMethodName("_handlePrepareAddOrDelAfter");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    protected boolean isRefreshForModel(IUIWindow uiWindow) {
        if (uiWindow.getUIObject() instanceof EditUI && !((EditUI)uiWindow.getUIObject()).isSaved()) {
            return false;
        }
        this.isAddSuccess = true;
        return false;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.mayAddNewTemplet()) {
            return;
        }
        this.prepareBeforeAddNew(null);
        super.actionAddNew_actionPerformed(e);
        this.refresh(e);
        if (this.isAddSuccess) {
            this.prepareAddOrDelAfter(null);
            this.SysTreeAfterAddOrDelTemplet(true);
            this.refresh();
            this.initTree();
        }
    }

    private boolean mayAddNewTemplet() throws Exception {
        MetaDataBriefInfo[] infos;
        ForewarnItemInfo item = new ForewarnItemInfo();
        this.getUIContext().put("forewarnInfo", item);
        this.getUIContext().put("Owner", this.getUIWindow());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isMultiSelect", new Boolean(false));
        map.put("isMustSelectLeaf", new Boolean(false));
        map.put("types", new BOSObjectType[]{MetaDataTypeList.ENTITY, MetaDataTypeList.FACADE});
        map.put("isRemoveEmptyPackage", new Boolean(true));
        map.put("mdbViewName", "com_kingdee_eas_base_foreWarn");
        map.put("Owner", (Object)this);
        map.put("Title", EASResource.getString((String)resName, (String)"AddTempletTitle"));
        map.put("Owner", this.getUIWindow());
        map.put("forewarnInfo", item);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AddFWTempletUI.class.getName(), map, null, this.getOprtState());
        window.show();
        if (((AddFWTempletUI)window.getUIObject()).getReturnValues() != null && (infos = ((AddFWTempletUI)window.getUIObject()).getReturnValues()) != null && infos.length >= 1) {
            this.currentBizSystem = ((AddFWTempletUI)window.getUIObject()).getSubSysName();
            this.currentMetadata = infos[0].getFullName();
            this.currentMetadataType = infos[0].getMetaDataType();
            return true;
        }
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1) {
            BizEnumValueInfo typeEnum = (BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("type").getValue();
            if (20 == typeEnum.getInt()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"sysTemplateCanNotEdit"));
            } else {
                String cuID = this.tblMain.getRow(rowIndex).getCell("CU.id").getValue().toString();
                super.actionEdit_actionPerformed(e);
                this.tblMain.getSelectManager().select(rowIndex, 0);
                this.currentForewarnTempletID = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                this.refreshForewarnItems();
            }
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    protected void kDTableItem_doRequestRowSet(RequestRowSetEvent e) {
        if (this.forewarnItem != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.forewarnItemPK, this.forewarnItem);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    @Override
    public void actionEditItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditItem_actionPerformed(e);
        if (this.kDTableItem.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"editItemWarning"));
            return;
        }
        int rowIndex = this.kDTableItem.getSelectManager().getActiveRowIndex();
        ObjectUuidPK editItemPK = new ObjectUuidPK(BOSUuid.read((String)this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString()));
        IForewarnItem forewarnItem = (IForewarnItem)this.getBizInterface();
        if (forewarnItem.getForewarnItemInfo((IObjectPK)editItemPK).getState().equals((Object)ItemState.ACTIVE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"activeItemCanNotEdit"));
            return;
        }
        String cuID = this.kDTableItem.getRow(rowIndex).getCell("CU.id").getValue().toString();
        if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals(cuID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"canNotModifyOtherCU"));
            this.abort();
        }
        String itemID = this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)itemID);
        uiContext.put((Object)"OBJECTTYPE", (Object)this.currentTemplateTouchType);
        uiContext.put((Object)"FROM_TEMPLATE_LIST", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ForewarnItemUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            this.kDTableItem.refresh();
        }
    }

    @Override
    public void actionViewItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewItem_actionPerformed(e);
        if (this.kDTableItem.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"viewItemWarning"));
            return;
        }
        int rowIndex = this.kDTableItem.getSelectManager().getActiveRowIndex();
        String itemID = this.kDTableItem.getRow(rowIndex).getCell("id").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)itemID);
        uiContext.put((Object)"OBJECTTYPE", (Object)this.currentTemplateTouchType);
        uiContext.put((Object)"FROM_TEMPLATE_LIST", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ForewarnItemUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.kDTableItem.refresh();
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        if (this.tblMain.getSelectManager().size() > 0) {
            int rowIndex = e.getRowIndex();
            this.currentForewarnTempletID = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            BizEnumValueInfo temp = (BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("touchType").getValue();
            this.currentTemplateTouchType = (String)temp.getValue();
            this.currentTemplateMainObjectName = (String)this.tblMain.getRow(rowIndex).getCell("objects.name").getValue();
            this.currentTemplateMainObjectType = "" + this.tblMain.getRow(rowIndex).getCell("type").getValue();
            this.refreshForewarnItems();
        }
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuEdit);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemAddNew);
        this.menuFile.addSeparator("kDSeparator1");
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintPreview);
        this.menuFile.addSeparator("kDSeparator2");
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuEdit.add((JMenuItem)this.menuItemEdit);
        this.menuEdit.add((JMenuItem)this.menuItemRemove);
        this.menuEdit.addSeparator("kDSeparator4");
        this.menuEdit.add((JMenuItem)this.miEditItem);
        this.menuEdit.add((JMenuItem)this.miDelItem);
        this.menuView.add((JMenuItem)this.menuItemView);
        this.menuView.add((JMenuItem)this.menuItemLocate);
        this.menuView.add((JMenuItem)this.menuItemQuery);
        this.menuView.addSeparator("kDSeparator5");
        this.menuView.add((JMenuItem)this.miViewItem);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.addSeparator("kDSeparator12");
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    @Override
    public void actionSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1) {
            UIContext ctx = new UIContext();
            String itemID = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            ctx.put((Object)"ID", (Object)itemID);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(SaveAsUI.class.getName(), (Map)ctx, null, OprtState.EDIT);
            uiWindow.show();
            Map context = uiWindow.getUIObject().getUIContext();
            Object objPK = context.get("newTempletPK");
            if (objPK != null && !"".equals(objPK.toString())) {
                NodeObject briefInfo;
                this.execQuery();
                this.initTree();
                this.synTreeSltNodeWhenTableSltChanged((TreeNode)this.root, objPK.toString());
                Object object = this.kDTree.getLastSelectedPathComponent();
                Object userObject = ((DefaultKingdeeTreeNode)object).getUserObject();
                if (userObject instanceof NodeObject && ((briefInfo = (NodeObject)userObject).getObjectMetadataType().equals((Object)MetadataType.ENTITY) || briefInfo.getObjectMetadataType().equals((Object)MetadataType.FACADE))) {
                    this.currentMetadata = briefInfo.getObjectName();
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    viewInfo.setFilter(filterInfo);
                    filterInfo.getFilterItems().add(new FilterItemInfo("objects.name", (Object)this.currentMetadata));
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)briefInfo.getTemplateID()));
                    filterInfo.setMaskString("#0 and #1");
                    this.mainQuery = viewInfo;
                    if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                        this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
                    } else {
                        EntityViewInfo evi = new EntityViewInfo();
                        evi.setFilter(this.getDefaultFilterForQuery());
                        this.mainQuery = evi;
                    }
                    this.refresh();
                }
            }
        }
    }
}

