/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.formula.api.FormulaVarInfoParser;
import com.kingdee.bos.service.formula.api.FormulaVarUtil;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.api.VarInfo;
import com.kingdee.eas.base.forewarn.DataType;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnReceiverCollection;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnThresholdInfo;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversInfo;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.ReceiverType;
import com.kingdee.eas.base.forewarn.client.ReceiverObject;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ForewarnUtil {
    private static final String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";

    protected static BusinessObjectInfo[] getBusinessObjects(ForewarnObjectCollection collection) {
        BusinessObjectInfo[] businessObjectInfos = null;
        int size = collection.size();
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = collection.get(i);
            EntityObjectInfo businessObjectInfo = null;
            if (forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) {
                if (forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT)) continue;
                businessObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(forewarnObjectInfo.getName()));
                businessObjectInfo.setAlias(forewarnObjectInfo.getAlias());
                list.add(businessObjectInfo);
                continue;
            }
            if (!forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.FACADE)) continue;
            businessObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFacade((IMetaDataPK)new MetaDataPK(forewarnObjectInfo.getName()));
            businessObjectInfo.setAlias(forewarnObjectInfo.getAlias());
            list.add(businessObjectInfo);
        }
        int listSize = list.size();
        businessObjectInfos = new BusinessObjectInfo[listSize];
        for (int i = 0; i < listSize; ++i) {
            businessObjectInfos[i] = (BusinessObjectInfo)list.get(i);
        }
        return businessObjectInfos;
    }

    protected static EntityObjectInfo[] getEntities(ForewarnObjectCollection collection) {
        EntityObjectInfo[] entities = null;
        int size = collection.size();
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = collection.get(i);
            EntityObjectInfo entityObjectInfo = null;
            if (!forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY) || forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT)) continue;
            entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(forewarnObjectInfo.getName()));
            entityObjectInfo.setAlias(forewarnObjectInfo.getAlias());
            list.add(entityObjectInfo);
        }
        int listSize = list.size();
        entities = new EntityObjectInfo[listSize];
        for (int i = 0; i < listSize; ++i) {
            entities[i] = (EntityObjectInfo)list.get(i);
        }
        return entities;
    }

    protected static IVarInfo[] getVarInfos(String formula) {
        IVarInfo[] infos = null;
        FormulaVarInfoParser formulaVarInfoParser = new FormulaVarInfoParser();
        infos = formulaVarInfoParser.getFormulaVars(formula);
        return infos;
    }

    private static void removeReceivers(ForewarnReceiverCollection receiverCollection, boolean isRemoveCopyReceiver) {
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo frInfo = receiverCollection.get(i);
            if (frInfo.isIsCopyReceiver() && isRemoveCopyReceiver) {
                receiverCollection.remove(frInfo);
                --size;
                --i;
                continue;
            }
            if (frInfo.isIsCopyReceiver() || isRemoveCopyReceiver) continue;
            receiverCollection.remove(frInfo);
            --size;
            --i;
        }
    }

    protected static String getReceiverAlias(ForewarnItemInfo editData, boolean isCopyReceiver) throws Exception {
        ForewarnUserDefineReceiversCollection fdrColl;
        ArrayList positionList;
        ArrayList roleList;
        ArrayList dyList;
        ForewarnReceiverCollection receiverCollection = ForewarnUtil.getReceiverCollection(editData, isCopyReceiver);
        ForewarnObjectCollection objectCollection = editData.getObjects();
        String strReceiverAliases = "";
        ArrayList alias = null;
        if (receiverCollection.size() > 0) {
            alias = ForewarnItemFactory.getRemoteInstance().getStaticReceiverAliases(receiverCollection);
        }
        if (alias == null) {
            alias = new ArrayList();
        }
        if ((dyList = ForewarnUtil.getDynamicReceiverAlias(receiverCollection, objectCollection)) != null && !dyList.isEmpty()) {
            alias.addAll(dyList);
        }
        if ((roleList = ForewarnUtil.getRoleReceiver(receiverCollection)) != null && !roleList.isEmpty()) {
            alias.addAll(roleList);
        }
        if ((positionList = ForewarnUtil.getPositionReceiver(receiverCollection)) != null && !positionList.isEmpty()) {
            alias.addAll(positionList);
        }
        int size = alias.size();
        StringBuffer sbReceiviers = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (alias.get(i) == null) continue;
            sbReceiviers.append(alias.get(i).toString()).append(";");
        }
        if (!isCopyReceiver && (fdrColl = editData.getDynReceivers()) != null && fdrColl.size() > 0) {
            int fdrSize = fdrColl.size();
            for (int i = 0; i < fdrSize; ++i) {
                ForewarnUserDefineReceiversInfo tmp = fdrColl.get(i);
                sbReceiviers.append(tmp.getName()).append(";");
            }
        }
        if ((strReceiverAliases = sbReceiviers.toString()).length() > 0) {
            strReceiverAliases = strReceiverAliases.substring(0, strReceiverAliases.length() - 1);
        }
        return strReceiverAliases;
    }

    protected static ArrayList getRoleReceiver(ForewarnReceiverCollection receiverCollection) throws Exception {
        ArrayList<String> roleRec = new ArrayList<String>();
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!ReceiverType.Role.equals((Object)receiverCollection.get(i).getReceiverType())) continue;
            roleRec.add("'" + receiverCollection.get(i).getValue() + "'");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (roleRec.size() <= 0) {
            return result;
        }
        IRole role = RoleFactory.getRemoteInstance();
        RoleCollection coll = role.getRoleCollection("select name where id in (" + StringUtils.arrayToString((Object[])roleRec.toArray(new String[0]), (String)",") + ")");
        int size2 = coll.size();
        for (int i = 0; i < size2; ++i) {
            result.add(coll.get(i).getName());
        }
        return result;
    }

    protected static ArrayList getPositionReceiver(ForewarnReceiverCollection receiverCollection) throws Exception {
        ArrayList<String> positionRec = new ArrayList<String>();
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!ReceiverType.POSITION.equals((Object)receiverCollection.get(i).getReceiverType())) continue;
            positionRec.add("'" + receiverCollection.get(i).getValue() + "'");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (positionRec.size() <= 0) {
            return result;
        }
        IPosition position = PositionFactory.getRemoteInstance();
        PositionCollection coll = position.getPositionCollection("select name where id in (" + StringUtils.arrayToString((Object[])positionRec.toArray(new String[0]), (String)",") + ")");
        int size2 = coll.size();
        for (int i = 0; i < size2; ++i) {
            result.add(coll.get(i).getName());
        }
        return result;
    }

    protected static RoleCollection getRoleReceiverIDNameMap(ForewarnReceiverCollection receiverCollection) throws Exception {
        ArrayList<String> roleRec = new ArrayList<String>();
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!ReceiverType.Role.equals((Object)receiverCollection.get(i).getReceiverType())) continue;
            roleRec.add("'" + receiverCollection.get(i).getValue() + "'");
        }
        if (roleRec.size() <= 0) {
            return new RoleCollection();
        }
        IRole role = RoleFactory.getRemoteInstance();
        return role.getRoleCollection("select id,name where id in (" + StringUtils.arrayToString((Object[])roleRec.toArray(new String[0]), (String)",") + ")");
    }

    protected static PositionCollection getPositionReceiverIDNameMap(ForewarnReceiverCollection receiverCollection) throws Exception {
        ArrayList<String> positionRec = new ArrayList<String>();
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!ReceiverType.POSITION.equals((Object)receiverCollection.get(i).getReceiverType())) continue;
            positionRec.add("'" + receiverCollection.get(i).getValue() + "'");
        }
        if (positionRec.size() <= 0) {
            return new PositionCollection();
        }
        IPosition position = PositionFactory.getRemoteInstance();
        return position.getPositionCollection("select id,name where id in (" + StringUtils.arrayToString((Object[])positionRec.toArray(new String[0]), (String)",") + ")");
    }

    protected static ArrayList getDynamicReceiverObjects(ForewarnReceiverCollection receiverCollection, ForewarnObjectCollection objectCollection) {
        ArrayList<ReceiverObject> dynamicRecievers = new ArrayList<ReceiverObject>();
        int size = receiverCollection.size();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo receiver = receiverCollection.get(i);
            ReceiverType receiverType = receiverCollection.get(i).getReceiverType();
            if (receiverCollection.get(i).getReceiverType() == null || !receiverType.equals((Object)ReceiverType.DYNAMIC_USER) && !receiverType.equals((Object)ReceiverType.DYNAMIC_ORG) && !receiverType.equals((Object)ReceiverType.DYNAMIC_PEOPLE)) continue;
            String receiverValue = receiver.getValue();
            ReceiverObject receiverObject = ForewarnUtil.parseDynamicReceiver(receiverValue);
            receiverObject.setType(receiverType);
            dynamicRecievers.add(receiverObject);
        }
        return dynamicRecievers;
    }

    private static ReceiverObject parseDynamicReceiver(String str) {
        int leftIndex = str.indexOf("{");
        int rightIndex = str.indexOf("}");
        String strEntityInfo = str.substring(leftIndex + 1, rightIndex);
        int index = strEntityInfo.indexOf(",");
        String entityName = strEntityInfo.substring(0, index);
        String entityAlias = ForewarnUtil.getEntityAlias(ForewarnUtil.getEntity(entityName));
        String receiverAlias = "";
        if (str.length() > rightIndex + 1) {
            String propertyName = str.substring(rightIndex + 1 + 1);
            receiverAlias = ForewarnUtil.getEntityPropertyAlias(ForewarnUtil.getEntity(entityName), propertyName);
            int aliasIndex = receiverAlias.lastIndexOf(".");
            if (aliasIndex != -1) {
                receiverAlias = receiverAlias.substring(0, receiverAlias.lastIndexOf("."));
            }
            receiverAlias = entityAlias + "." + receiverAlias;
        } else {
            receiverAlias = entityAlias;
        }
        ReceiverObject receiverObject = new ReceiverObject();
        receiverObject.setAlias(receiverAlias);
        receiverObject.setValue(str);
        return receiverObject;
    }

    private static EntityObjectInfo getEntity(String entityName) {
        MetaDataPK entityPK = new MetaDataPK(entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity((IMetaDataPK)entityPK);
    }

    private static String getEntityPropertyAlias(EntityObjectInfo mainEntity, String propertyValue) {
        String alias = null;
        EntityObjectInfo currentEntity = mainEntity;
        String currentProperty = propertyValue;
        PropertyCollection propertyCollection = ForewarnUtil.getAllEntityProperties(currentEntity);
        int size = propertyCollection.size();
        int index = currentProperty.indexOf(".");
        String compareProperty = null;
        if (index != -1) {
            compareProperty = currentProperty.substring(0, index);
            currentProperty = currentProperty.substring(index + 1);
        } else {
            compareProperty = currentProperty;
        }
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(compareProperty)) continue;
            alias = alias == null ? ForewarnUtil.getPropertyAlias(propertyInfo) : alias + ForewarnUtil.getPropertyAlias(propertyInfo);
            if (propertyInfo instanceof LinkPropertyInfo) {
                currentEntity = ForewarnUtil.getEntity(currentEntity.getFullName(), (LinkPropertyInfo)propertyInfo);
                alias = alias + "." + ForewarnUtil.getEntityPropertyAlias(currentEntity, currentProperty);
                return alias;
            }
            return alias;
        }
        return compareProperty;
    }

    private static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    private static String getPropertyAlias(PropertyInfo propertyInfo) {
        String alias = propertyInfo.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            alias = propertyInfo.getName();
        }
        return alias;
    }

    private static String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            return entity.getName();
        }
        return alias;
    }

    private static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    protected static ArrayList getDynamicReceiverAlias(ForewarnReceiverCollection receiverCollection, ForewarnObjectCollection objectCollection) {
        ArrayList<String> dynamicRecieverAlias = new ArrayList<String>();
        ArrayList dynamicReceivers = ForewarnUtil.getDynamicReceiverObjects(receiverCollection, objectCollection);
        int size = dynamicReceivers.size();
        for (int i = 0; i < size; ++i) {
            ReceiverObject object = (ReceiverObject)dynamicReceivers.get(i);
            dynamicRecieverAlias.add(object.getAlias());
        }
        return dynamicRecieverAlias;
    }

    protected static KDComboBox createObjectTypeComboBox() {
        KDComboBox comboBox = new KDComboBox(new Object[]{ForewarnObjectType.COLLECTION_OBJECT, ForewarnObjectType.ASSISTANT_OBJECT});
        return comboBox;
    }

    protected static String processScript(ForewarnObjectCollection objects, ForewarnThresholdCollection thresholds, String script) {
        String formula = ForewarnUtil.processObjectScript(objects, script);
        formula = ForewarnUtil.processThresholdScript(thresholds, formula);
        return formula;
    }

    protected static String processObjectScript(ForewarnObjectCollection objects, String script) {
        String formula = script == null ? "" : script;
        Set varName = ForewarnUtil.getVarName(script);
        Map varInfos = ForewarnUtil.getVarInfos(objects);
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo object = objects.get(i);
            if (varName.contains(object.getName())) continue;
            VarInfo varInfo = (VarInfo)varInfos.get(object.getAlias());
            formula = FormulaVarUtil.genVarStr((String)varInfo.getVarName(), (String)varInfo.getVarAlias(), (String)varInfo.getVarType(), null, (String)varInfo.getVarScope(), (String)varInfo.getVarDesc()) + "\n" + formula;
        }
        return formula;
    }

    private static Map getVarInfos(ForewarnObjectCollection objects) {
        HashMap<String, VarInfo> vars = new HashMap<String, VarInfo>();
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            VarInfo varInfo;
            String description;
            String scope;
            String initValue;
            String type;
            String alias;
            String name;
            ForewarnObjectInfo object = objects.get(i);
            if (object.getMetadataType().equals((Object)MetadataType.ENTITY)) {
                EntityObjectInfo entity;
                if (object.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT) || object.getType().equals((Object)ForewarnObjectType.ASSISTANT_OBJECT)) {
                    entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(object.getName()));
                    name = ForewarnUtil.getDifferentName(vars, ForewarnUtil.getName(object.getName()));
                    alias = object.getAlias();
                    type = entity.getObjectValueClass();
                    initValue = null;
                    scope = "local";
                    description = object.getDescription() == null ? "" : object.getDescription();
                    varInfo = new VarInfo(name, alias, type, initValue, scope, description);
                    vars.put(alias, varInfo);
                    continue;
                }
                if (!object.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT)) continue;
                entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(object.getName()));
                name = ForewarnUtil.getDifferentName(vars, ForewarnUtil.getName(object.getName()));
                alias = object.getAlias();
                type = entity.getObjectCollectionClass();
                initValue = null;
                scope = "local";
                description = object.getDescription() == null ? "" : object.getDescription();
                varInfo = new VarInfo(name, alias, type, initValue, scope, description);
                vars.put(alias, varInfo);
                continue;
            }
            if (!object.getMetadataType().equals((Object)MetadataType.FACADE)) continue;
            FacadeInfo facadeInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFacade((IMetaDataPK)new MetaDataPK(object.getName()));
            name = ForewarnUtil.getDifferentName(vars, ForewarnUtil.getName(object.getName()));
            alias = object.getAlias();
            type = facadeInfo.getBusinessInterface();
            initValue = null;
            scope = "local";
            description = object.getDescription() == null ? "" : object.getDescription();
            varInfo = new VarInfo(name, alias, type, initValue, scope, description);
            vars.put(alias, varInfo);
        }
        return vars;
    }

    private static boolean hasSameVarName(Map vars, String name) {
        Collection collection = vars.values();
        for (VarInfo info : collection) {
            if (!info.getVarName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static String getDifferentName(Map vars, String name) {
        while (ForewarnUtil.hasSameVarName(vars, name)) {
            name = name + "1";
        }
        return name;
    }

    protected static String processThresholdScript(ForewarnThresholdCollection thresholds, String script) {
        if (thresholds == null) {
            throw new IllegalArgumentException("thresholds is null");
        }
        if (script == null || script.trim().equalsIgnoreCase("")) {
            return "";
        }
        String formula = script;
        IVarInfo[] varInfos = ForewarnUtil.getVarInfos(formula);
        int size = thresholds.size();
        int length = varInfos.length;
        for (int i = 0; i < size; ++i) {
            ForewarnThresholdInfo thresholdInfo = thresholds.get(i);
            for (int j = 0; j < length; ++j) {
                if (thresholdInfo.getName().equalsIgnoreCase(varInfos[j].getVarName())) continue;
                formula = FormulaVarUtil.genVarStr((String)ForewarnUtil.getName(thresholdInfo.getName()), (String)thresholdInfo.getAlias(), (String)thresholdInfo.getDataType().getName(), null, (String)"in", (String)(thresholdInfo.getDescription() == null ? "" : thresholdInfo.getDescription())) + "\n" + formula;
            }
        }
        return formula;
    }

    protected static String getBizObjectAlias(BusinessObjectInfo info) {
        String alias = info.getAlias();
        if (alias != null && !alias.equalsIgnoreCase("")) {
            return alias;
        }
        return info.getName();
    }

    protected static String getBizObjectAlias(MetaDataBriefInfo info) {
        String alias = info.getAlias();
        if (alias != null && !alias.equalsIgnoreCase("")) {
            return alias;
        }
        return info.getName();
    }

    private static String getName(String name) {
        int index = name.lastIndexOf(".");
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    private static Set getVarName(String script) {
        IVarInfo[] infos = null;
        if (script == null) {
            script = "";
        }
        if (!script.trim().equalsIgnoreCase("")) {
            infos = ForewarnUtil.getVarInfos(script);
        }
        if (infos == null) {
            return new HashSet();
        }
        HashSet<String> set = new HashSet<String>();
        int length = infos.length;
        for (int j = 0; j < length; ++j) {
            set.add(infos[j].getVarName());
        }
        return set;
    }

    protected static boolean validateData(DataType dataType, String value) {
        boolean flag = true;
        if (value != null && !value.trim().equalsIgnoreCase("")) {
            try {
                if (dataType.equals((Object)DataType.INT)) {
                    int n = Integer.parseInt(value);
                } else if (dataType.equals((Object)DataType.LONG)) {
                    long l = Long.parseLong(value);
                } else if (dataType.equals((Object)DataType.DOUBLE)) {
                    double d = Double.parseDouble(value);
                } else if (dataType.equals((Object)DataType.DATE)) {
                    Date date = DateTimeUtils.parseDate((String)value);
                } else if (dataType.equals((Object)DataType.BOOLEAN)) {
                    boolean bl = Boolean.parseBoolean(value);
                } else if (dataType.equals((Object)DataType.BIGDECIMAL)) {
                    BigDecimal bigDecimal = new BigDecimal(value);
                }
            }
            catch (Exception e) {
                flag = false;
            }
        }
        return flag;
    }

    protected static PropertyCollection getEntityProperties(EntityObjectInfo entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        PropertyCollection target = new PropertyCollection();
        PropertyCollection properties = entity.getProperties();
        ForewarnUtil.addProperties(target, entity);
        while (entity.getBaseEntity() != null) {
            if ((entity = entity.getBaseEntity()) != null) {
                ForewarnUtil.addProperties(target, entity);
                continue;
            }
            return target;
        }
        return target;
    }

    private static PropertyCollection addProperties(PropertyCollection result, EntityObjectInfo entity) {
        PropertyCollection properties = entity.getProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            result.add((PropertyInfo)linkPropertyInfo);
        }
        return result;
    }

    protected static boolean isAdminOrgEntity(EntityObjectInfo entity) {
        while (entity != null) {
            if (entity.getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.AdminOrgUnit")) {
                return true;
            }
            entity = entity.getBaseEntity();
        }
        return false;
    }

    protected static boolean isUserEntity(EntityObjectInfo entity) {
        while (entity != null) {
            if (entity.getFullName().equalsIgnoreCase("com.kingdee.eas.base.permission.app.User")) {
                return true;
            }
            entity = entity.getBaseEntity();
        }
        return false;
    }

    protected static boolean isAdminOrgProperty(EntityObjectInfo entity, LinkPropertyInfo linkPropertyInfo) {
        for (EntityObjectInfo linkEntity = ForewarnUtil.getEntity(entity.getFullName(), linkPropertyInfo); linkEntity != null; linkEntity = linkEntity.getBaseEntity()) {
            if (!linkEntity.getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.AdminOrgUnit")) continue;
            return true;
        }
        return false;
    }

    protected static boolean isUserProperty(EntityObjectInfo entity, LinkPropertyInfo linkPropertyInfo) {
        String userName = "com.kingdee.eas.base.permission.app.User";
        return ForewarnUtil.isObjectProperty(entity, linkPropertyInfo, userName);
    }

    protected static boolean isPersonProperty(EntityObjectInfo entity, LinkPropertyInfo linkPropertyInfo) {
        String userName = "com.kingdee.eas.basedata.person.app.Person";
        return ForewarnUtil.isObjectProperty(entity, linkPropertyInfo, userName);
    }

    protected static boolean isObjectProperty(EntityObjectInfo entity, LinkPropertyInfo linkPropertyInfo, String objName) {
        for (EntityObjectInfo linkEntity = ForewarnUtil.getEntity(entity.getFullName(), linkPropertyInfo); linkEntity != null; linkEntity = linkEntity.getBaseEntity()) {
            if (!linkEntity.getFullName().equalsIgnoreCase(objName)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasDefaultOrg(FilterInfo filterInfo) {
        if (filterInfo != null && filterInfo.getFilterItems() != null) {
            int size = filterInfo.getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if (filterItemInfo == null || !"[{defaultOrg}]".equals(filterItemInfo.getCompareValue())) continue;
                return true;
            }
        }
        return false;
    }

    protected static EntityViewInfo processEntityViewInfo(EntityViewInfo entityViewInfo) {
        if (entityViewInfo != null && entityViewInfo.getFilter() != null && entityViewInfo.getFilter().getFilterItems() != null) {
            int size = entityViewInfo.getFilter().getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                FilterItemInfo filterItemInfo = entityViewInfo.getFilter().getFilterItems().get(i);
                if (filterItemInfo.getCompareValue() == null || !filterItemInfo.getCompareValue().equals(EASResource.getString((String)forewarnRes, (String)"defaultOrg"))) continue;
                filterItemInfo.setCompareValue((Object)"[{defaultOrg}]");
            }
            return entityViewInfo;
        }
        return entityViewInfo;
    }

    protected static EntityViewInfo unProcessEntityViewInfo(EntityViewInfo entityViewInfo) {
        if (entityViewInfo != null && entityViewInfo.getFilter() != null && entityViewInfo.getFilter().getFilterItems() != null) {
            int size = entityViewInfo.getFilter().getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                FilterItemInfo filterItemInfo = entityViewInfo.getFilter().getFilterItems().get(i);
                if (filterItemInfo.getCompareValue() == null || !filterItemInfo.getCompareValue().equals("[{defaultOrg}]")) continue;
                filterItemInfo.setCompareValue((Object)EASResource.getString((String)forewarnRes, (String)"defaultOrg"));
            }
            return entityViewInfo;
        }
        return entityViewInfo;
    }

    protected static EntityViewInfo processDefaultOrg(EntityViewInfo orgEntityViewInfo, String orgNumber) {
        if (orgEntityViewInfo.getFilter() != null && orgEntityViewInfo.getFilter().getFilterItems() != null) {
            int size = orgEntityViewInfo.getFilter().getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                FilterItemInfo filterItemInfo = orgEntityViewInfo.getFilter().getFilterItems().get(i);
                if (!filterItemInfo.getCompareValue().equals("[{defaultOrg}]")) continue;
                filterItemInfo.setCompareValue((Object)orgNumber);
            }
            return orgEntityViewInfo;
        }
        return orgEntityViewInfo;
    }

    public static ForewarnReceiverCollection getReceiverCollection(ForewarnItemInfo editData, boolean isCopyReceiver) {
        ForewarnReceiverCollection receiverCollectionall = editData.getReceivers();
        ForewarnReceiverCollection receiverCollection = new ForewarnReceiverCollection();
        int size1 = receiverCollectionall.size();
        for (int i = 0; i < size1; ++i) {
            ForewarnReceiverInfo frInfo = receiverCollectionall.get(i);
            if (frInfo.isIsCopyReceiver() && isCopyReceiver) {
                receiverCollection.add(frInfo);
                continue;
            }
            if (frInfo.isIsCopyReceiver() || isCopyReceiver) continue;
            receiverCollection.add(frInfo);
        }
        return receiverCollection;
    }

    public static String getConditionScript(ForewarnItemInfo editData) {
        String script = null;
        script = editData.getCondition() != null ? editData.getCondition().getContentScript() : "";
        return script;
    }

    public static String getContentScript(ForewarnItemInfo editData) {
        String script = null;
        script = editData.getMessage() != null && editData.getMessage().getBodyScript() != null ? editData.getMessage().getBodyScript() : "";
        return script;
    }

    public static String getContentScript(ForewarnItemInfo editData, Locale locale) {
        String script = null;
        script = editData.getMessage() != null && editData.getMessage().getBodyScript(locale) != null ? editData.getMessage().getBodyScript(locale) : "";
        return script;
    }

    public static String getTitleScript(ForewarnItemInfo editData) {
        String script = null;
        script = editData.getMessage() != null && editData.getMessage().getTitleScript() != null ? editData.getMessage().getTitleScript() : "";
        return script;
    }

    public static String getParamScript(ForewarnItemInfo editData) {
        String script = null;
        script = editData.getMessage() != null && editData.getMessage().getParamScript() != null ? editData.getMessage().getParamScript() : "";
        return script;
    }

    public static String getAttrScript(ForewarnItemInfo editData) {
        String script = null;
        script = editData.getMessage() != null && editData.getMessage().getAttrScript() != null ? editData.getMessage().getAttrScript() : "";
        return script;
    }
}

