/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.service.formula.api.FormulaGrammarVerifier;
import com.kingdee.bos.service.formula.api.FormulaVarInfoParser;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import com.kingdee.eas.base.forewarn.DataType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.swing.JButton;

public class FormulaDialog
extends KDDialog {
    private FormulaBuilderPanelBean panel;
    private static final int CONFIRM_ACTION = 1;
    private static final int CANCEL_ACTION = 0;
    private int closeType = 0;
    private boolean isCheck = true;
    private static final String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";

    public boolean isCheck() {
        return this.isCheck;
    }

    public void setCheck(boolean isCheck) {
        this.isCheck = isCheck;
    }

    public FormulaDialog() {
    }

    public FormulaDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public FormulaDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    protected void dialogInit() {
        super.dialogInit();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)d.width * 0.98), (int)((double)d.height * 0.95));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.panel = new FormulaBuilderPanelBean(false, true);
        this.panel.setAlwaysRefOldVar(true);
        this.panel.setPanelSplitPercetage((int)((double)d.height * 0.95), 0.35);
        KDButton confirmButton = new KDButton();
        KDButton cancelButton = new KDButton();
        confirmButton.setText(EASResource.getString((String)forewarnRes, (String)"confirm"));
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaDialog.this.confirmButton_actionPerformed(e);
            }
        });
        cancelButton.setText(EASResource.getString((String)forewarnRes, (String)"cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaDialog.this.cancelButton_actionPerformed(e);
            }
        });
        KDSeparator separator = new KDSeparator();
        KDPanel dialogPanel = new KDPanel();
        this.getContentPane().add((Component)dialogPanel, "Center");
        dialogPanel.setLayout((LayoutManager)new KDLayout());
        dialogPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 792, 539));
        dialogPanel.add((Component)this.panel, (Object)new KDLayout.Constraints(10, 10, 772, 478, 15));
        dialogPanel.add((Component)separator, (Object)new KDLayout.Constraints(0, 497, 792, 2, 14));
        dialogPanel.add((Component)cancelButton, (Object)new KDLayout.Constraints(709, 508, 73, 21, 10));
        dialogPanel.add((Component)confirmButton, (Object)new KDLayout.Constraints(627, 508, 73, 21, 10));
        this.getRootPane().setDefaultButton((JButton)confirmButton);
    }

    public void show() {
        this.setTableProperties();
        super.show();
    }

    protected void confirmButton_actionPerformed(ActionEvent e) {
        String script = this.panel.getFormulaStr();
        IVarInfo[] varInfos = this.getVarInfos(script);
        if (this.checkVars(varInfos) && this.checkExpression(script) && this.hasReturn(script) && !this.checkSameVarAlias(varInfos)) {
            this.closeType = 1;
            this.dispose();
        }
    }

    private void setTableProperties() {
        KDTable table = this.getTable();
        int rowCount = table.getRowCount();
        table.getColumn(3).getStyleAttributes().setHided(true);
        for (int i = 0; i < rowCount; ++i) {
            String type = table.getRow(i).getCell(4).getValue().toString();
            if (type.equalsIgnoreCase(EASResource.getString((String)forewarnRes, (String)"varReturn"))) {
                table.getRow(i).getStyleAttributes().setLocked(true);
                continue;
            }
            if (type.equalsIgnoreCase(EASResource.getString((String)forewarnRes, (String)"varLocal"))) {
                String dataType = table.getRow(i).getCell(2).getValue().toString();
                if (this.isSimpleVar(dataType)) continue;
                table.getRow(i).getStyleAttributes().setLocked(true);
                continue;
            }
            if (!type.equalsIgnoreCase(EASResource.getString((String)forewarnRes, (String)"varIn"))) continue;
        }
        this.setTableWidth();
    }

    private void setTableWidth() {
        KDTable table = this.getTable();
        int colSize = table.getColumnCount();
        int width = 106;
        table.getColumn(0).setWidth(width);
        table.getColumn(1).setWidth(width);
        table.getColumn(2).setWidth(width * 2 - 20);
        table.getColumn(3).setWidth(0);
        table.getColumn(4).setWidth(width - 40);
        table.getColumn(5).setWidth(width * 2);
    }

    private boolean isSimpleVar(String dataType) {
        return DataType.getEnum(dataType) != null;
    }

    protected void cancelButton_actionPerformed(ActionEvent e) {
        this.closeType = 0;
        this.dispose();
    }

    public String getFormula() {
        return this.panel.getFormulaStr();
    }

    public String getFormulaAlias() {
        return this.panel.getFormulaAliasStr();
    }

    public String getFormulaAliasNoResultStr() {
        return this.getMsgInfoAlias(this.panel.getFormulaAliasStr());
    }

    public IVarInfo[] getVarInfos(String script) {
        return new FormulaVarInfoParser().getFormulaVars(script);
    }

    public boolean isConfirm() {
        return this.closeType == 1;
    }

    public void setFormula(String formula) {
        this.panel.setFormulaStr(formula);
    }

    public void setMetaDataObjs(BusinessObjectInfo[] metaObjs) {
        IMetaDataLoader dataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.panel.setMetaDataObjs(metaObjs, dataLoader);
    }

    protected KDTable getTable() {
        return (KDTable)this.panel.getVarTableComponents()[0];
    }

    protected JButton getAddButton() {
        return (JButton)this.panel.getVarTableComponents()[1];
    }

    protected JButton getDelButton() {
        return (JButton)this.panel.getVarTableComponents()[2];
    }

    private boolean checkVars(IVarInfo[] varInfos) {
        if (varInfos != null) {
            int size = varInfos.length;
            for (int i = 0; i < size; ++i) {
                DataType dataType;
                String varScope = varInfos[i].getVarScope();
                String varAlias = varInfos[i].getVarAlias();
                if (varScope.toLowerCase().equalsIgnoreCase("in") && (dataType = DataType.getEnum(varInfos[i].getVarType())) == null) {
                    String s = EASResource.getString((String)forewarnRes, (String)"simpleDataType");
                    MessageFormat mf = new MessageFormat(s);
                    String result = mf.format(new String[]{varInfos[i].getVarType()});
                    MsgBox.showWarning((Component)((Object)this), (String)result);
                    return false;
                }
                if (varAlias != null && !varAlias.trim().equalsIgnoreCase("")) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"varAliasIsNull"));
                return false;
            }
        }
        return true;
    }

    private boolean hasReturn(String script) {
        FormulaGrammarVerifier verifier = new FormulaGrammarVerifier();
        String expsBlockStr = this.panel.getExpsBlockStr();
        if ("".equals(expsBlockStr) && !this.isCheck) {
            return true;
        }
        if (!verifier.hasSetFormulaResult(script)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"returnFormulaResultWarning"));
            return false;
        }
        return true;
    }

    private boolean checkExpression(String script) {
        FormulaGrammarVerifier verifier = new FormulaGrammarVerifier();
        boolean flag = verifier.isCompatibleWithBOSFormula(script);
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"formulaIsIllegal"));
            return false;
        }
        return flag;
    }

    private boolean checkSameVarAlias(IVarInfo[] varInfos) {
        if (varInfos != null) {
            int size = varInfos.length;
            HashSet<String> setAlias = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                String varAlias = varInfos[i].getVarAlias();
                if (setAlias.contains(varAlias)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"varAliasIsDuplicate"));
                    return true;
                }
                setAlias.add(varAlias);
            }
        }
        return false;
    }

    protected String getMsgInfoAlias(String alias) {
        String formulaResult = EASResource.getString((String)forewarnRes, (String)"formulaResult").trim();
        int index = alias.indexOf(formulaResult = AliasTransformer.propTransform((String)formulaResult));
        if (index == 0) {
            return alias.replaceFirst(formulaResult + "\\s+=", "");
        }
        return alias;
    }
}

