/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.client.AbstractReceiverPartUI;
import com.kingdee.eas.base.forewarn.client.ExtClassPathSetUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.base.forewarn.client.IThresholdProvider;
import com.kingdee.eas.base.forewarn.client.ReceiversListUI;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceiverPartUI
extends AbstractReceiverPartUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiverPartUI.class);
    private ForewarnItemInfo forewarnItemInfo = null;
    private ForewarnReceiverInfo frInfo = null;
    private IThresholdProvider thresholdProvider = null;
    private EntityObjectInfo[] entities = null;

    public ReceiverPartUI() throws Exception {
        this.initUIStatus(false);
        this.initButtons();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void initButtons() {
        this.btnReceiver.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnCopyReceiver.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.kDTextFieldCopyReceiver.setEditable(false);
        this.kDTextFieldReceiver.setEditable(false);
    }

    private void initUIStatus(boolean enable) {
        this.kDTextFieldCopyReceiver.setEditable(enable);
        this.btnCopyReceiver.setEnabled(enable);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeData();
    }

    private void storeData() {
    }

    public void loadData(String state) {
        this.loadReceiver(state);
    }

    private void loadReceiver(String state) {
        if (this.forewarnItemInfo != null && (this.forewarnItemInfo.getReceivers() != null && this.forewarnItemInfo.getReceivers().size() > 0 || this.forewarnItemInfo.getDynReceivers() != null && this.forewarnItemInfo.getDynReceivers().size() > 0)) {
            try {
                if (state.equals(OprtState.VIEW)) {
                    this.kDTextFieldReceiver.setAccessAuthority(0);
                    this.kDTextFieldCopyReceiver.setAccessAuthority(0);
                    this.kDTextFieldReceiver.setText(ForewarnUtil.getReceiverAlias(this.forewarnItemInfo, false));
                    this.kDTextFieldCopyReceiver.setText(ForewarnUtil.getReceiverAlias(this.forewarnItemInfo, true));
                } else {
                    this.kDTextFieldReceiver.setText(ForewarnUtil.getReceiverAlias(this.forewarnItemInfo, false));
                    this.kDTextFieldCopyReceiver.setText(ForewarnUtil.getReceiverAlias(this.forewarnItemInfo, true));
                }
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        if (this.forewarnItemInfo != null) {
            this.chkSendMobile.setSelected(this.forewarnItemInfo.getMessage().isNeedSendMobile());
            this.chkSendEMail.setSelected(this.forewarnItemInfo.getMessage().isNeedSendEMail());
            this.chkSendWeibo.setSelected(this.forewarnItemInfo.getMessage().isNeedSendWeibo());
            this.chkSendCloud.setSelected(this.forewarnItemInfo.getMessage().isNeedSendCloud());
            this.chkMultipleTimeZoom.setSelected(this.forewarnItemInfo.isNeedMultipleTimeZoom());
            boolean isSendEmail = this.chkSendEMail.isSelected();
            this.kDTextFieldCopyReceiver.setEnabled(isSendEmail);
            this.btnCopyReceiver.setEnabled(isSendEmail);
            String touchType = this.forewarnItemInfo.getTouchType().getValue();
            if (touchType == "0") {
                this.chkMultipleTimeZoom.setVisible(true);
            }
        }
        this.kDTextFieldReceiver.setAccessAuthority(1);
        this.kDTextFieldCopyReceiver.setAccessAuthority(1);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadData(OprtState.VIEW);
    }

    protected void initListener() {
        super.initListener();
    }

    @Override
    protected void chkSendMobile_actionPerformed(ActionEvent e) throws Exception {
        this.initMessage();
        this.forewarnItemInfo.getMessage().setNeedSendMobile(this.chkSendMobile.isSelected());
    }

    @Override
    protected void chkSendWeibo_actionPerformed(ActionEvent e) throws Exception {
        this.initMessage();
        this.forewarnItemInfo.getMessage().setNeedSendWeibo(this.chkSendWeibo.isSelected());
    }

    private static String getPersonID(String userID) throws BOSException, EASBizException {
        IUser user = UserFactory.getRemoteInstance();
        SelectorItemCollection sColl = new SelectorItemCollection();
        sColl.add(new SelectorItemInfo("person"));
        UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectStringPK(userID), sColl);
        if (userInfo != null && userInfo.getPerson() != null) {
            return userInfo.getPerson().getId().toString();
        }
        return null;
    }

    @Override
    protected void chkSendEMail_actionPerformed(ActionEvent e) throws Exception {
        boolean isSendEmail = this.chkSendEMail.isSelected();
        this.kDTextFieldCopyReceiver.setEnabled(isSendEmail);
        this.btnCopyReceiver.setEnabled(isSendEmail);
        this.initMessage();
        this.forewarnItemInfo.getMessage().setNeedSendEMail(this.chkSendEMail.isSelected());
    }

    private void initMessage() {
        if (this.forewarnItemInfo.getMessage() == null) {
            ForewarnMessageInfo messageInfo = new ForewarnMessageInfo();
            this.forewarnItemInfo.setMessage(messageInfo);
        }
    }

    @Override
    protected void btnReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.btnReceiver_actionPerformed(e);
        UIContext uiContext = this.getCurrentContext(false);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
        ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
        receiversListUI.setTextFieldReceivers(this.kDTextFieldReceiver);
        window.show();
    }

    private EntityObjectInfo[] getEntites() {
        EntityObjectInfo[] entities1 = null;
        entities1 = this.entities != null ? this.entities : ForewarnUtil.getEntities(this.forewarnItemInfo.getObjects());
        return entities1;
    }

    @Override
    protected void btnCopyReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopyReceiver_actionPerformed(e);
        UIContext uiContext = this.getCurrentContext(true);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
        ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
        receiversListUI.setTextFieldReceivers(this.kDTextFieldCopyReceiver);
        window.show();
    }

    private UIContext getCurrentContext(boolean isCopyReceiver) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"forewarnInfo", (Object)this.forewarnItemInfo);
        uiContext.put((Object)"ENTITIES", (Object)this.getEntites());
        uiContext.put((Object)"NEED_RECEVIER", (Object)"true");
        uiContext.put((Object)"ISCOPYRECEIVER", (Object)new Boolean(isCopyReceiver).toString());
        uiContext.put((Object)"RECEIVER_LIST", (Object)(isCopyReceiver ? this.kDTextFieldCopyReceiver.getText() : this.kDTextFieldReceiver.getText()));
        uiContext.put((Object)"BUSINESS_OBJS", (Object)ForewarnUtil.getBusinessObjects(this.forewarnItemInfo.getObjects()));
        uiContext.put((Object)"CUR_FW_OBJS", (Object)this.forewarnItemInfo.getObjects());
        uiContext.put((Object)"CUR_FW_THRESHOLDS", (Object)this.thresholdProvider.getThresholdCollection());
        return uiContext;
    }

    public void setComponetEnable(boolean enable) {
        this.btnReceiver.setEnabled(enable);
        this.chkSendEMail.setEnabled(enable);
        this.chkSendMobile.setEnabled(enable);
        this.chkSendWeibo.setEnabled(enable);
        this.kDTextFieldReceiver.setAccessAuthority(1);
        this.kDTextFieldCopyReceiver.setAccessAuthority(1);
    }

    public String getReceivers(boolean isCopyReceiver) {
        if (isCopyReceiver) {
            return this.kDTextFieldCopyReceiver.getText();
        }
        return this.kDTextFieldReceiver.getText();
    }

    public KDTextField getReceiversComponent(boolean isCopyReceiver) {
        if (isCopyReceiver) {
            return this.kDTextFieldCopyReceiver;
        }
        return this.kDTextFieldReceiver;
    }

    public void setForewarnInfo(ForewarnItemInfo fitemInfo) {
        this.forewarnItemInfo = fitemInfo;
    }

    public void setEntities(EntityObjectInfo[] entities) {
        this.entities = entities;
    }

    public IThresholdProvider getThresholdProvider() {
        return this.thresholdProvider;
    }

    public void setThresholdProvider(IThresholdProvider thresholdProvider) {
        this.thresholdProvider = thresholdProvider;
    }

    @Override
    public void actionSendCloud_actionPerformed(ActionEvent e) throws Exception {
        this.initMessage();
        this.forewarnItemInfo.getMessage().setNeedSendCloud(this.chkSendCloud.isSelected());
        if (this.chkSendCloud.isSelected()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"forewarnItemInfo", (Object)this.forewarnItemInfo);
            uiContext.put((Object)"openModel", (Object)"frame");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtClassPathSetUI.class.getName(), (Map)uiContext, null, null);
            uiWindow.show();
        }
    }

    @Override
    protected void chkMultipleTimeZoom_actionPerformed(ActionEvent e) throws Exception {
        this.initMessage();
        this.forewarnItemInfo.setNeedMultipleTimeZoom(this.chkMultipleTimeZoom.isSelected());
    }

    protected void setchkMultipleTimeZoomVisiable() {
        this.chkMultipleTimeZoom.setVisible(true);
    }
}

