/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.forewarn.BaseForewarnAppException;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnReceiverCollection;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.ForewarnRunTimeFactory;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversInfo;
import com.kingdee.eas.base.forewarn.IForewarnRunTime;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.forewarn.ReceiverType;
import com.kingdee.eas.base.forewarn.client.AbstractReceiversListUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.base.forewarn.client.ReceiverObject;
import com.kingdee.eas.base.forewarn.client.ReceiverPartUI;
import com.kingdee.eas.base.forewarn.client.RoleUtil;
import com.kingdee.eas.base.forewarn.client.UserDefineReceiversEditUI;
import com.kingdee.eas.base.forewarn.client.UserListDlg;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.client.tree.AdminPositionTreeBuilder;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class ReceiversListUI
extends AbstractReceiversListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiverPartUI.class);
    private static final String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";
    private KDTree treeDyReceivers;
    private Map entities = new Hashtable();
    private ForewarnItemInfo forewarnItemInfo = null;
    private KDTextField tfReceivers = null;
    private String inputText = null;
    private ArrayList treePaths = new ArrayList();
    private String sltedReceiverid = "";
    private HashMap sltedNodeMap = new HashMap();
    private BusinessObjectInfo[] busObjs = null;
    private ForewarnObjectCollection curFWObjs = null;
    private ForewarnThresholdCollection curFWThresholds = null;
    private boolean isCopyReceiver = false;
    private boolean isHasMainOrgProp = false;
    private List<String> searchOrgUser = new ArrayList<String>();
    private int searchCount = 0;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            request.put("forewarnReceiverCollection", (Object)this.getOldReceivers());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private ForewarnReceiverCollection getOldReceivers() {
        Object obj = this.getUIContext().get("forewarnInfo");
        if (obj == null) {
            return null;
        }
        ForewarnItemInfo itemInfo = (ForewarnItemInfo)obj;
        return itemInfo.getReceivers();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.forewarnItemInfo = (ForewarnItemInfo)this.getUIContext().get("forewarnInfo");
        this.busObjs = (BusinessObjectInfo[])this.getUIContext().get("BUSINESS_OBJS");
        this.curFWObjs = (ForewarnObjectCollection)((Object)this.getUIContext().get("CUR_FW_OBJS"));
        this.curFWThresholds = (ForewarnThresholdCollection)((Object)this.getUIContext().get("CUR_FW_THRESHOLDS"));
        this.isCopyReceiver = new Boolean((String)this.getUIContext().get("ISCOPYRECEIVER"));
        this.init();
        this.kDTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReceiversListUI.this.searchOrgUser = new ArrayList();
                ReceiversListUI.this.searchCount = 0;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReceiversListUI.this.searchOrgUser = new ArrayList();
                ReceiversListUI.this.searchCount = 0;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReceiversListUI.this.searchOrgUser = new ArrayList();
                ReceiversListUI.this.searchCount = 0;
            }
        });
    }

    private void init() throws Exception {
        this.initOther();
        this.addTreeExpand();
        this.initStaticReceiversTree();
        this.initDynamicReceivers();
        this.initRoleReceivers();
        this.initPositionReceiversTree();
        this.initSltedReceivers();
        this.initOldData();
        this.intDynReveive();
    }

    private void intDynReveive() {
        if (this.isCopyReceiver) {
            this.btnDynReceivers.setEnabled(false);
            this.btnDynReceivers.setVisible(false);
        }
    }

    private void addTreeExpand() {
        this.treeStaticReceivers.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                if (tmp.getChildCount() > 0) {
                    return;
                }
                try {
                    ReceiversListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode parentNode) throws BaseForewarnAppException, BOSException {
        OrgUserInfo orgUserInfo = (OrgUserInfo)parentNode.getUserObject();
        OrgUserInfo[] infoArray = ForewarnItemFactory.getRemoteInstance().getOrgUserCollection(orgUserInfo.getOrgUserID());
        if (infoArray == null || infoArray.length <= 0) {
            return;
        }
        for (int i = 0; i < infoArray.length; ++i) {
            if (i == 0) continue;
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)infoArray[i]);
            parentNode.add((MutableTreeNode)childNode);
        }
        this.setNodeIcon(parentNode);
    }

    private void initOldData() {
        int i;
        Object tempObj = this.getUIContext().get("RECEIVER_LIST");
        if (tempObj == null) {
            return;
        }
        String tempStr = (String)tempObj;
        String[] namesAry = StringUtils.split((String)tempStr, (String)";");
        Object obj = this.getUIContext().get("forewarnInfo");
        if (obj == null) {
            return;
        }
        ForewarnItemInfo itemInfo = (ForewarnItemInfo)obj;
        if (itemInfo.getReceivers() == null) {
            return;
        }
        ForewarnReceiverCollection recCol = itemInfo.getReceivers();
        ArrayList alias = new ArrayList();
        RoleCollection coll = new RoleCollection();
        PositionCollection pCol = new PositionCollection();
        try {
            alias = ForewarnItemFactory.getRemoteInstance().getStaticReceiverAliases(recCol);
            coll = ForewarnUtil.getRoleReceiverIDNameMap(recCol);
            pCol = ForewarnUtil.getPositionReceiverIDNameMap(recCol);
        }
        catch (Exception e) {
            logger.error((Object)("getStaticReceiverAliases error:" + e));
        }
        HashMap<String, String> aliasid = new HashMap<String, String>();
        for (i = 0; i < alias.size(); ++i) {
            DataObject doj = (DataObject)alias.get(i);
            aliasid.put(doj.getValue(), doj.getName());
        }
        for (i = 0; i < coll.size(); ++i) {
            aliasid.put(coll.get(i).getId().toString(), coll.get(i).getName());
        }
        for (i = 0; i < pCol.size(); ++i) {
            aliasid.put(pCol.get(i).getId().toString(), pCol.get(i).getName());
        }
        int j = 0;
        for (int i2 = 0; i2 < recCol.size(); ++i2) {
            String name;
            ForewarnReceiverInfo recInfo = recCol.get(i2);
            if ((!this.isCopyReceiver || !recInfo.isIsCopyReceiver()) && (this.isCopyReceiver || recInfo.isIsCopyReceiver())) continue;
            if (recInfo != null && (ReceiverType.STATIC_ORG == recInfo.getReceiverType() || ReceiverType.STATIC_USER == recInfo.getReceiverType())) {
                name = (String)aliasid.get(recInfo.getValue());
                name = name == null ? namesAry[j] : name;
                this.initStaticData(recInfo, name);
            } else if (ReceiverType.DYNAMIC_ORG == recInfo.getReceiverType() || ReceiverType.DYNAMIC_PEOPLE == recInfo.getReceiverType() || ReceiverType.DYNAMIC_USER == recInfo.getReceiverType()) {
                this.initDynamicData(recInfo, namesAry[j]);
            } else if (ReceiverType.Role == recInfo.getReceiverType()) {
                name = (String)aliasid.get(recInfo.getValue());
                name = name == null ? namesAry[j] : name;
                this.initRoleData(recInfo, name);
            } else if (ReceiverType.POSITION == recInfo.getReceiverType()) {
                name = (String)aliasid.get(recInfo.getValue());
                name = name == null ? namesAry[j] : name;
                this.initPositionData(recInfo, name);
            }
            ++j;
        }
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        this.treeSltedReceivers.expandPath(new TreePath(tmpNode.getPath()));
        tmpNode = this.getChildOfSltedRecRoot(1);
        this.treeSltedReceivers.expandPath(new TreePath(tmpNode.getPath()));
    }

    private ForewarnReceiverCollection getReceiver(ForewarnItemInfo itemInfo, boolean isCopyRcv) {
        ForewarnReceiverCollection coll = new ForewarnReceiverCollection();
        ForewarnReceiverCollection receivers = itemInfo.getReceivers();
        for (int i = 0; i < receivers.size(); ++i) {
            ForewarnReceiverInfo recInfo = receivers.get(i);
            if (isCopyRcv && recInfo.isIsCopyReceiver()) {
                coll.add(recInfo);
                continue;
            }
            if (isCopyRcv || recInfo.isIsCopyReceiver()) continue;
            coll.add(recInfo);
        }
        return coll;
    }

    private void clearReceiver(ForewarnItemInfo itemInfo, boolean isCopyRcv) {
        ForewarnReceiverCollection receivers = itemInfo.getReceivers();
        int size = receivers.size();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo recInfo = receivers.get(i);
            if (isCopyRcv && recInfo.isIsCopyReceiver()) {
                receivers.remove(recInfo);
                --size;
                --i;
                continue;
            }
            if (isCopyRcv || recInfo.isIsCopyReceiver()) continue;
            receivers.remove(recInfo);
            --size;
            --i;
        }
    }

    private void initStaticData(ForewarnReceiverInfo recInfo, String name) {
        OrgUserInfo orgInfo = new OrgUserInfo();
        DefaultKingdeeTreeNode staticData = new DefaultKingdeeTreeNode((Object)orgInfo);
        if (ReceiverType.STATIC_USER == recInfo.getReceiverType()) {
            orgInfo.setUserOrOrg("1");
            staticData.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        } else {
            staticData.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        }
        orgInfo.setOrgUserID(recInfo.getValue());
        orgInfo.setDisplayName(name);
        staticData.setText(name);
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        this.treeSltedReceivers.addNodeInto((MutableTreeNode)staticData, (MutableTreeNode)tmpNode);
        this.sltedNodeMap.put(recInfo.getValue(), tmpNode.clone());
    }

    private void initDynamicData(ForewarnReceiverInfo recInfo, String name) {
        ReceiverObject recObj = new ReceiverObject();
        recObj.setType(recInfo.getReceiverType());
        recObj.setValue(recInfo.getValue());
        recObj.setAlias(name);
        DefaultKingdeeTreeNode dynamicData = new DefaultKingdeeTreeNode((Object)recObj);
        dynamicData.setText(name);
        dynamicData.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(1);
        this.treeSltedReceivers.addNodeInto((MutableTreeNode)dynamicData, (MutableTreeNode)tmpNode);
    }

    private void initRoleData(ForewarnReceiverInfo recInfo, String name) {
        ReceiverObject recObj = new ReceiverObject();
        recObj.setType(recInfo.getReceiverType());
        recObj.setValue(recInfo.getValue());
        recObj.setAlias(name);
        DefaultKingdeeTreeNode dynamicData = new DefaultKingdeeTreeNode((Object)recObj);
        dynamicData.setText(name);
        dynamicData.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(2);
        this.treeSltedReceivers.addNodeInto((MutableTreeNode)dynamicData, (MutableTreeNode)tmpNode);
    }

    private void initPositionData(ForewarnReceiverInfo recInfo, String name) {
        ReceiverObject recObj = new ReceiverObject();
        recObj.setType(recInfo.getReceiverType());
        recObj.setValue(recInfo.getValue());
        recObj.setAlias(name);
        DefaultKingdeeTreeNode positionData = new DefaultKingdeeTreeNode((Object)recObj);
        positionData.setText(name);
        positionData.setCustomIcon(EASResource.getIcon((String)"imgTree_position"));
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(3);
        this.treeSltedReceivers.addNodeInto((MutableTreeNode)positionData, (MutableTreeNode)tmpNode);
    }

    private void initOther() {
        this.setUITitle(EASResource.getString((String)forewarnRes, (String)"receiverList"));
        this.kDWorkButtonAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.kDWorkButtonRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.kDScrollPaneSelectedReceivers.setBorder((Border)new LineBorder(Color.gray));
    }

    public void initDynamicReceivers() {
        this.initDyTreeReceivers();
        ForewarnObjectCollection objects = this.forewarnItemInfo.getObjects();
        ArrayList dynamicReceivers = ForewarnUtil.getDynamicReceiverObjects(this.getReceiver(this.forewarnItemInfo, this.isCopyReceiver), this.forewarnItemInfo.getObjects());
        int size = dynamicReceivers.size();
        for (int i = 0; i < size; ++i) {
        }
    }

    private void initRoleReceivers() throws Exception {
        this.isHasMainOrgProp = this.isHasMainOrgProp();
        if (!this.isHasMainOrgProp) {
            this.kDScrollPane1.setVisible(false);
            this.kDTabbedPaneReceivers.removeTabAt(2);
        } else {
            RoleCollection coll = RoleUtil.getRoleCollection();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                this.listRole.addElement((Object)coll.get(i));
            }
        }
    }

    private boolean isHasMainOrgProp() throws BOSException {
        String mainObjName = this.getMainObjectEntityPKStr();
        IForewarnRunTime fr = ForewarnRunTimeFactory.getRemoteInstance();
        return fr.isHasMainOrgProp(mainObjName);
    }

    private String getMainObjectEntityPKStr() {
        int size = this.curFWObjs.size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo objectInfo = this.curFWObjs.get(i);
            if (!objectInfo.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT)) continue;
            return objectInfo.getName();
        }
        return "";
    }

    private void initPositionReceiversTree() {
        this.treePosition.setModel(null);
        DefaultKingdeeTreeNode rootNode = null;
        try {
            AdminPositionTreeBuilder treeBuilder = new AdminPositionTreeBuilder(2, 1);
            treeBuilder.buildTree((JTree)this.treePosition);
        }
        catch (Exception e) {
            logger.error((Object)("initPositionReceiversTree error:" + e));
        }
        if (this.treePosition.getModel() != null) {
            rootNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treePosition.getModel()).getRoot();
        }
        if (rootNode == null) {
            this.treePosition.setModel(null);
        }
    }

    private void initSltedReceivers() {
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)forewarnRes, (String)"MsgReceiver"));
        DefaultKingdeeTreeNode staticNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)forewarnRes, (String)"PeopleList"));
        DefaultKingdeeTreeNode dyNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)forewarnRes, (String)"RelationPeople"));
        DefaultKingdeeTreeNode roleNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)forewarnRes, (String)"RolePeople"));
        DefaultKingdeeTreeNode positionNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)forewarnRes, (String)"position"));
        rootNode.add((MutableTreeNode)staticNode);
        rootNode.add((MutableTreeNode)dyNode);
        rootNode.add((MutableTreeNode)roleNode);
        rootNode.add((MutableTreeNode)positionNode);
        DefaultTreeModel sltedModel = new DefaultTreeModel((TreeNode)rootNode);
        this.treeSltedReceivers.setModel((TreeModel)sltedModel);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)staticNode);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)dyNode);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)roleNode);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)positionNode);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(EASResource.getString((String)forewarnRes, (String)"LookPeople"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversListUI.this.userListShow();
            }
        });
        menu.add(item);
        this.treeSltedReceivers.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && ReceiversListUI.this.isSltOrg()) {
                    menu.show((JComponent)e.getSource(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
    }

    private boolean isSltOrg() {
        OrgUserInfo info;
        TreePath path = this.treeSltedReceivers.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object userObj = node.getUserObject();
        if (userObj instanceof OrgUserInfo && (info = (OrgUserInfo)userObj) != null && "0".equals(info.getUserOrOrg())) {
            this.sltedReceiverid = info.getOrgUserID();
            return true;
        }
        return false;
    }

    private void userListShow() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.sltedNodeMap.get(this.sltedReceiverid);
        StringBuffer userBuffer = new StringBuffer();
        this.searchUserName(node, userBuffer);
        if (userBuffer.length() > 0) {
            this.getUIContext().put("Owner", this.getUIWindow());
            this.getUIContext().put("users", userBuffer.toString());
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create(UserListDlg.class.getName(), this.getUIContext(), null, this.getOprtState());
                window.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void searchUserName(DefaultKingdeeTreeNode node, StringBuffer names) {
        if (node == null) {
            return;
        }
        int childCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i <= childCount - 1; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            OrgUserInfo info = (OrgUserInfo)tmpNode.getUserObject();
            if ("1".equals(info.getUserOrOrg())) {
                names.append(info.getDisplayName() + ";");
                continue;
            }
            this.searchUserName(tmpNode, names);
        }
    }

    public void initStaticReceiversTree() throws Exception {
        this.treeStaticReceivers.setModel(null);
        OrgUserInfo[] infoArray = ForewarnItemFactory.getRemoteInstance().getOrgUserCollection();
        this.buildReceiversTree(infoArray);
        DefaultTreeSelectionModel sltModel = new DefaultTreeSelectionModel();
        sltModel.setSelectionMode(4);
        this.treeStaticReceivers.setSelectionModel((TreeSelectionModel)sltModel);
        this.treeStaticReceivers.setExpandsSelectedPaths(true);
        if (this.treeStaticReceivers.getModel() != null) {
            this.setNodeIcon((DefaultKingdeeTreeNode)this.treeStaticReceivers.getModel().getRoot());
        }
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    private void setNodeIcon(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        OrgUserInfo info = (OrgUserInfo)node.getUserObject();
        this.setNodeIconByInfo(node, info);
        int rowCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i < rowCount; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (tmpNode.isLeaf()) {
                info = (OrgUserInfo)tmpNode.getUserObject();
                this.setNodeIconByInfo(tmpNode, info);
                continue;
            }
            this.setNodeIcon(tmpNode);
        }
    }

    private void setNodeIconByInfo(DefaultKingdeeTreeNode node, OrgUserInfo info) {
        if (info.getUserOrOrg().equals("0")) {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        } else {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        }
    }

    private void buildReceiversTree(OrgUserInfo[] infoArray) {
        if (infoArray == null || infoArray.length <= 0) {
            return;
        }
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        ArrayList preLevelNodes = new ArrayList();
        ArrayList<DefaultKingdeeTreeNode> curLevelNodes = new ArrayList<DefaultKingdeeTreeNode>();
        int preLevel = -1;
        int curLevel = 0;
        DefaultKingdeeTreeNode curNode = rootNode;
        DefaultKingdeeTreeNode tmpNode = null;
        HashMap<String, DefaultKingdeeTreeNode> allOrgNodesMap = new HashMap<String, DefaultKingdeeTreeNode>();
        OrgUserInfo tmpInfo = null;
        DefaultKingdeeTreeNode tmpNode1 = null;
        for (int i = 0; i < infoArray.length; ++i) {
            tmpNode = new DefaultKingdeeTreeNode((Object)infoArray[i]);
            if (i == 0) {
                curNode = rootNode = tmpNode;
                preLevel = curLevel = Integer.parseInt(infoArray[i].getOrgUserLevel());
                curLevelNodes.add(curNode);
                allOrgNodesMap.put(infoArray[i].getOrgUserID(), rootNode);
                continue;
            }
            curLevel = Integer.parseInt(infoArray[i].getOrgUserLevel());
            if (curLevel > preLevel) {
                preLevelNodes.clear();
                preLevelNodes = curLevelNodes;
                curLevelNodes = new ArrayList();
                preLevel = curLevel;
            } else if (curLevel == preLevel) {
                // empty if block
            }
            if (infoArray[i].getUserOrOrg().equals("1")) {
                DefaultKingdeeTreeNode tmp1;
                if (infoArray[i].getParentID() == null || (tmp1 = (DefaultKingdeeTreeNode)allOrgNodesMap.get(infoArray[i].getParentID())) == null) continue;
                tmp1.add((MutableTreeNode)tmpNode);
                continue;
            }
            curLevelNodes.add(tmpNode);
            for (int j = 0; j < preLevelNodes.size(); ++j) {
                tmpNode1 = (DefaultKingdeeTreeNode)preLevelNodes.get(j);
                tmpInfo = (OrgUserInfo)tmpNode1.getUserObject();
                if (!infoArray[i].getParentID().equals(tmpInfo.getOrgUserID())) continue;
                tmpNode1.add((MutableTreeNode)tmpNode);
                allOrgNodesMap.put(infoArray[i].getOrgUserID(), tmpNode);
            }
        }
        this.treeStaticReceivers.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ForewarnReceiverInfo receiverInfo;
        int i;
        super.actionConfirm_actionPerformed(e);
        ForewarnReceiverCollection receivers = new ForewarnReceiverCollection();
        DefaultKingdeeTreeNode staticRecNode = this.getChildOfSltedRecRoot(0);
        DefaultKingdeeTreeNode dyRecNode = this.getChildOfSltedRecRoot(1);
        DefaultKingdeeTreeNode roleNode = this.getChildOfSltedRecRoot(2);
        DefaultKingdeeTreeNode positionNode = this.getChildOfSltedRecRoot(3);
        int staticRecSize = staticRecNode.getChildCount();
        int dyRecSize = dyRecNode.getChildCount();
        int roleSize = roleNode.getChildCount();
        int positionSize = positionNode.getChildCount();
        ForewarnUserDefineReceiversCollection fdrColl = this.forewarnItemInfo.getDynReceivers();
        int size = staticRecSize + dyRecSize + fdrColl.size() + roleSize + positionSize;
        Object needReceiver = this.getUIContext().get("NEED_RECEVIER");
        if (needReceiver != null && !needReceiver.equals("") && size == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseReceiverWarning"));
            return;
        }
        StringBuffer sbReceivers = new StringBuffer();
        DefaultKingdeeTreeNode tmpNode = null;
        OrgUserInfo tmpInfo = null;
        for (i = 0; i < staticRecSize; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)staticRecNode.getChildAt(i);
            tmpInfo = (OrgUserInfo)tmpNode.getUserObject();
            ForewarnReceiverInfo receiverInfo2 = new ForewarnReceiverInfo();
            if ("1".equals(tmpInfo.getUserOrOrg())) {
                receiverInfo2.setReceiverType(ReceiverType.STATIC_USER);
            } else {
                receiverInfo2.setReceiverType(ReceiverType.STATIC_ORG);
            }
            receiverInfo2.setValue(tmpInfo.getOrgUserID());
            receiverInfo2.setIsCopyReceiver(this.isCopyReceiver);
            sbReceivers.append(tmpInfo.getDisplayName()).append(";");
            receivers.add(receiverInfo2);
        }
        for (i = 0; i < dyRecSize; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)dyRecNode.getChildAt(i);
            ReceiverObject receiverObject = (ReceiverObject)tmpNode.getUserObject();
            receiverInfo = new ForewarnReceiverInfo();
            receiverInfo.setReceiverType(receiverObject.getType());
            receiverInfo.setValue(receiverObject.getValue());
            receiverInfo.setIsCopyReceiver(this.isCopyReceiver);
            sbReceivers.append(receiverObject.getAlias()).append(";");
            receivers.add(receiverInfo);
        }
        if (fdrColl != null && fdrColl.size() > 0) {
            int fdrSize = fdrColl.size();
            for (int i2 = 0; i2 < fdrSize; ++i2) {
                ForewarnUserDefineReceiversInfo tmp = fdrColl.get(i2);
                if (tmp.getName() == null) continue;
                sbReceivers.append(tmp.getName()).append(";");
            }
        }
        for (i = 0; i < roleSize; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)roleNode.getChildAt(i);
            ReceiverObject receiverObject = (ReceiverObject)tmpNode.getUserObject();
            receiverInfo = new ForewarnReceiverInfo();
            receiverInfo.setReceiverType(receiverObject.getType());
            receiverInfo.setValue(receiverObject.getValue());
            receiverInfo.setIsCopyReceiver(this.isCopyReceiver);
            sbReceivers.append(receiverObject.getAlias()).append(";");
            receivers.add(receiverInfo);
        }
        for (i = 0; i < positionSize; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)positionNode.getChildAt(i);
            ReceiverObject receiverObject = (ReceiverObject)tmpNode.getUserObject();
            receiverInfo = new ForewarnReceiverInfo();
            receiverInfo.setReceiverType(receiverObject.getType());
            receiverInfo.setValue(receiverObject.getValue());
            receiverInfo.setIsCopyReceiver(this.isCopyReceiver);
            sbReceivers.append(receiverObject.getAlias()).append(";");
            receivers.add(receiverInfo);
        }
        String strReceivers = sbReceivers.toString().trim();
        String receiverAlias = "";
        if (strReceivers.length() > 0) {
            receiverAlias = strReceivers.substring(0, strReceivers.length() - 1);
        }
        this.clearReceiver(this.forewarnItemInfo, this.isCopyReceiver);
        this.forewarnItemInfo.getReceivers().addCollection(receivers);
        if (this.tfReceivers != null) {
            this.tfReceivers.setText(receiverAlias);
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionAddReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddReceiver_actionPerformed(e);
        if (this.kDTabbedPaneReceivers.getSelectedIndex() == 0) {
            this.addStaticReceiver();
        } else if (this.kDTabbedPaneReceivers.getSelectedIndex() == 1) {
            this.addDynamicReceiver();
        } else if (this.kDTabbedPaneReceivers.getSelectedIndex() == 2) {
            if (this.isHasMainOrgProp) {
                this.addRoleReceiver();
            } else {
                this.addPositionReceiver();
            }
        } else if (this.kDTabbedPaneReceivers.getSelectedIndex() == 3) {
            this.addPositionReceiver();
        }
    }

    @Override
    public void actionRemoveReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveReceiver_actionPerformed(e);
        this.removeReceiver();
    }

    private DefaultKingdeeTreeNode getChildOfSltedRecRoot(int index) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeSltedReceivers.getModel().getRoot();
        return (DefaultKingdeeTreeNode)node.getChildAt(index);
    }

    private void addStaticReceiver() {
        TreePath[] selectedPath = this.treeStaticReceivers.getSelectionPaths();
        if (selectedPath == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"choosenReceiverWarning"));
            return;
        }
        DefaultKingdeeTreeNode tmp = null;
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        TreeNode[] nodes = null;
        StringBuffer name = new StringBuffer();
        int nodeLength = 0;
        for (int i = 0; i < selectedPath.length; ++i) {
            name.setLength(0);
            tmp = (DefaultKingdeeTreeNode)selectedPath[i].getLastPathComponent();
            if (tmp == null || this.isStaticNodeExist(tmpNode, tmp)) continue;
            nodes = tmp.getPath();
            if (nodes != null) {
                nodeLength = nodes.length;
                for (int j = 1; j < nodeLength; ++j) {
                    name.append(((DefaultKingdeeTreeNode)nodes[j]).getText()).append(".");
                }
            }
            DefaultKingdeeTreeNode nodeClone = (DefaultKingdeeTreeNode)tmp.clone();
            if (name.length() > 0) {
                name.deleteCharAt(name.length() - 1);
                nodeClone.setText(name.toString());
            }
            this.treeSltedReceivers.addNodeInto((MutableTreeNode)nodeClone, (MutableTreeNode)tmpNode);
            String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
            this.sltedNodeMap.put(id, tmp);
        }
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
    }

    private String getOrgUserAlias(OrgUserInfo info) {
        return info == null ? "" : info.getOrgUserName() + "(" + info.getNumber() + ")";
    }

    private boolean isStaticNodeExist(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        if (parentNode == null || parentNode.getChildCount() <= 0 || childNode == null) {
            return false;
        }
        int count = parentNode.getChildCount();
        OrgUserInfo tmp = null;
        DefaultKingdeeTreeNode tmpNode = null;
        tmp = (OrgUserInfo)childNode.getUserObject();
        String childOrgID = tmp.getOrgUserID();
        for (int i = 0; i < count; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode == null) continue;
            tmp = (OrgUserInfo)tmpNode.getUserObject();
            if (childOrgID == null || !childOrgID.equals(tmp.getOrgUserID())) continue;
            return true;
        }
        return false;
    }

    private boolean isDynamicNodeExist(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        if (parentNode == null || parentNode.getChildCount() <= 0 || childNode == null) {
            return false;
        }
        int count = parentNode.getChildCount();
        ReceiverObject tmp = null;
        DefaultKingdeeTreeNode tmpNode = null;
        tmp = (ReceiverObject)childNode.getUserObject();
        String childID = tmp.getValue();
        for (int i = 0; i < count; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode == null) continue;
            tmp = (ReceiverObject)tmpNode.getUserObject();
            if (childID == null || !childID.equals(tmp.getValue())) continue;
            return true;
        }
        return false;
    }

    private void addRoleReceiver() {
        RoleInfo roleInfo = (RoleInfo)this.listRole.getSelectedValue();
        if (roleInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"choosenReceiverWarning"));
            return;
        }
        ReceiverObject recObj = new ReceiverObject();
        recObj.setType(ReceiverType.Role);
        recObj.setValue(roleInfo.getId().toString());
        recObj.setAlias(roleInfo.getName());
        DefaultKingdeeTreeNode roleData = new DefaultKingdeeTreeNode((Object)recObj);
        roleData.setText(roleInfo.getName());
        roleData.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(2);
        if (this.isDynamicNodeExist(tmpNode, roleData)) {
            return;
        }
        this.treeSltedReceivers.addNodeInto((MutableTreeNode)roleData, (MutableTreeNode)tmpNode);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
    }

    private void addDynamicReceiver() {
        Object object = this.treeDyReceivers.getLastSelectedPathComponent();
        if (object != null) {
            if (object instanceof DefaultKingdeeTreeNode) {
                if (((DefaultKingdeeTreeNode)object).getUserObject() != null) {
                    ReceiverObject receiverObject = (ReceiverObject)((DefaultKingdeeTreeNode)object).getUserObject();
                    LinkPropertyInfo linkPropertyInfo = receiverObject.getLinkPropertyInfo();
                    DefaultKingdeeTreeNode dyRecNode = this.getChildOfSltedRecRoot(1);
                    if (linkPropertyInfo != null) {
                        if (ForewarnUtil.isAdminOrgProperty(receiverObject.getMainEntity(), receiverObject.getLinkPropertyInfo())) {
                            receiverObject.setType(ReceiverType.DYNAMIC_ORG);
                            receiverObject.setValue(receiverObject.getValue() + ".id");
                            DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                            if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                                tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                                this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                            }
                        } else if ("com.kingdee.eas.base.permission.app.User".equals(receiverObject.getMainEntity().getFullName())) {
                            EntityObjectInfo entity = Util.getEntity((String)receiverObject.getMainEntity().getFullName(), (LinkPropertyInfo)receiverObject.getLinkPropertyInfo());
                            if (ForewarnUtil.isUserProperty(entity, receiverObject.getLinkPropertyInfo())) {
                                receiverObject.setType(ReceiverType.DYNAMIC_USER);
                                receiverObject.setValue(receiverObject.getValue() + ".id");
                                DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                                if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                                    tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                                    this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                                }
                            } else {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseDynamicReceiverWarning"));
                            }
                        } else if (ForewarnUtil.isUserProperty(receiverObject.getMainEntity(), receiverObject.getLinkPropertyInfo())) {
                            receiverObject.setType(ReceiverType.DYNAMIC_USER);
                            receiverObject.setValue(receiverObject.getValue() + ".id");
                            DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                            if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                                tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                                this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                            }
                        } else if ("com.kingdee.eas.basedata.person.app.Person".equals(receiverObject.getMainEntity().getFullName())) {
                            EntityObjectInfo entity = Util.getEntity((String)receiverObject.getMainEntity().getFullName(), (LinkPropertyInfo)receiverObject.getLinkPropertyInfo());
                            if (ForewarnUtil.isPersonProperty(entity, receiverObject.getLinkPropertyInfo())) {
                                receiverObject.setType(ReceiverType.DYNAMIC_PEOPLE);
                                receiverObject.setValue(receiverObject.getValue() + ".id");
                                DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                                if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                                    tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                                    this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                                }
                            } else {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseDynamicReceiverWarning"));
                            }
                        } else if (ForewarnUtil.isPersonProperty(receiverObject.getMainEntity(), receiverObject.getLinkPropertyInfo())) {
                            receiverObject.setType(ReceiverType.DYNAMIC_PEOPLE);
                            receiverObject.setValue(receiverObject.getValue() + ".id");
                            DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                            if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                                tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                                this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                            }
                        } else {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseDynamicReceiverWarning"));
                        }
                    } else if (ForewarnUtil.isUserEntity(receiverObject.getMainEntity())) {
                        receiverObject.setType(ReceiverType.DYNAMIC_ORG);
                        DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                        if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                            tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                            this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                        }
                    } else if (ForewarnUtil.isUserEntity(receiverObject.getMainEntity())) {
                        receiverObject.setType(ReceiverType.DYNAMIC_USER);
                        DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode((Object)receiverObject);
                        if (!this.isDynamicNodeExist(dyRecNode, tmp)) {
                            tmp.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
                            this.treeSltedReceivers.addNodeInto((MutableTreeNode)tmp, (MutableTreeNode)dyRecNode);
                        }
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseDynamicReceiverWarning"));
                    }
                    this.treeSltedReceivers.expandAllNodes(true, (TreeNode)dyRecNode);
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"chooseDynamicReceiverWarning"));
            }
        }
    }

    private void addPositionReceiver() {
        TreePath[] selectedPath = this.treePosition.getSelectionPaths();
        if (selectedPath == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"choosenReceiverWarning"));
            return;
        }
        DefaultKingdeeTreeNode tmp = null;
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(3);
        TreeNode[] nodes = null;
        StringBuffer name = new StringBuffer();
        int nodeLength = 0;
        for (int i = 0; i < selectedPath.length; ++i) {
            name.setLength(0);
            tmp = (DefaultKingdeeTreeNode)selectedPath[i].getLastPathComponent();
            if (tmp == null) continue;
            nodes = tmp.getPath();
            if (nodes != null) {
                nodeLength = nodes.length;
                for (int j = 1; j < nodeLength; ++j) {
                    name.append(((DefaultKingdeeTreeNode)nodes[j]).getText()).append(".");
                }
            }
            DefaultKingdeeTreeNode nodeClone = (DefaultKingdeeTreeNode)tmp.clone();
            if (name.length() > 0) {
                name.deleteCharAt(name.length() - 1);
                nodeClone.setText(name.toString());
            }
            ReceiverObject recObj = new ReceiverObject();
            PositionInfo positionInfo = null;
            boolean isPositionInfo = false;
            isPositionInfo = nodeClone.getUserObject() instanceof PositionInfo;
            if (!isPositionInfo) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"choosePositionWarning"));
                return;
            }
            positionInfo = (PositionInfo)nodeClone.getUserObject();
            recObj.setType(ReceiverType.POSITION);
            recObj.setValue(positionInfo.getId().toString());
            recObj.setAlias(positionInfo.getName());
            DefaultKingdeeTreeNode positionData = new DefaultKingdeeTreeNode((Object)recObj);
            positionData.setText(positionInfo.getName());
            positionData.setCustomIcon(EASResource.getIcon((String)"imgTree_position"));
            this.treeSltedReceivers.addNodeInto((MutableTreeNode)positionData, (MutableTreeNode)tmpNode);
        }
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
    }

    private void removeReceiver() {
        TreePath[] treePath = this.treeSltedReceivers.getSelectionPaths();
        if (treePath == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)forewarnRes, (String)"choosenReceiverWarning"));
            return;
        }
        DefaultKingdeeTreeNode tmp = null;
        for (int i = 0; i < treePath.length; ++i) {
            tmp = (DefaultKingdeeTreeNode)treePath[i].getLastPathComponent();
            if (tmp.isRoot() || tmp.getLevel() == 1) continue;
            this.treeSltedReceivers.removeNodeFromParent((MutableTreeNode)tmp);
            if (!(tmp.getUserObject() instanceof OrgUserInfo)) continue;
            String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
            this.sltedNodeMap.remove(id);
        }
    }

    private EntityObjectInfo[] getEntites() {
        Object object = this.getUIContext().get("ENTITIES");
        if (object != null) {
            return (EntityObjectInfo[])object;
        }
        return null;
    }

    private Set getReceiverPKs() {
        HashSet<String> receiverPKs = new HashSet<String>();
        ForewarnReceiverCollection receivers = this.getReceiver(this.forewarnItemInfo, this.isCopyReceiver);
        if (receivers != null) {
            int receiversSize = receivers.size();
            for (int i = 0; i < receiversSize; ++i) {
                ForewarnReceiverInfo receiver = receivers.get(i);
                if (!receiver.getReceiverType().equals((Object)ReceiverType.STATIC_USER) && !receiver.getReceiverType().equals((Object)ReceiverType.STATIC_ORG)) continue;
                receiverPKs.add(receiver.getValue());
            }
        }
        return receiverPKs;
    }

    private void initDyTreeReceivers() {
        DefaultKingdeeTreeNode root = this.createRoot();
        this.treeDyReceivers = new KDTree((ITreeNode)root, false);
        this.tvDynamicReceivers.setTree(this.treeDyReceivers);
        ((KingdeeTreeModel)this.treeDyReceivers.getModel()).setAsksAllowsChildren(true);
        this.treeDyReceivers.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                ReceiversListUI.this.tree_treeWillExpand(event);
            }
        });
    }

    private DefaultKingdeeTreeNode createRoot() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EASResource.getString((String)forewarnRes, (String)"dynamicReceivers"));
        EntityObjectInfo[] object = this.getEntites();
        if (object != null && object instanceof EntityObjectInfo[]) {
            for (EntityObjectInfo entity : object) {
                DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
                child.setText(Util.getEntityAlias((EntityObjectInfo)entity));
                ReceiverObject receiverObject = new ReceiverObject();
                receiverObject.setAlias(Util.getEntityAlias((EntityObjectInfo)entity));
                String value = "{" + entity.getFullName() + "," + entity.getAlias() + "}";
                receiverObject.setValue(value);
                receiverObject.setExtendValue(entity.getFullName());
                receiverObject.setType(null);
                receiverObject.setMainEntity(entity);
                receiverObject.setLinkPropertyInfo(null);
                child.setUserObject((Object)receiverObject);
                root.add((MutableTreeNode)child);
            }
        }
        return root;
    }

    private void tree_treeWillExpand(TreeExpansionEvent e) {
        Object userObject;
        DefaultKingdeeTreeNode node;
        Object object = e.getPath().getLastPathComponent();
        if (object instanceof DefaultKingdeeTreeNode && (node = (DefaultKingdeeTreeNode)object) != null && (userObject = node.getUserObject()) != null && node.getChildCount() == 0) {
            this.createChildNode(node);
            ((KingdeeTreeModel)this.treeDyReceivers.getModel()).reload((TreeNode)node);
        }
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode) {
        ReceiverObject parentObject = (ReceiverObject)parentNode.getUserObject();
        PropertyCollection properties = ForewarnUtil.getEntityProperties(this.getEntity(parentObject.getExtendValue()));
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            ReceiverObject childObject = new ReceiverObject();
            childObject.setAlias(this.getAlias(parentObject, Util.getPropertyAlias((PropertyInfo)propertyInfo)));
            childObject.setValue(this.getValue(parentObject, propertyInfo.getName()));
            childObject.setExtendValue(this.getExtendValue(parentObject, propertyInfo));
            childObject.setMainEntity(parentObject.getMainEntity());
            childObject.setLinkPropertyInfo((LinkPropertyInfo)propertyInfo);
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childObject);
            childNode.setText(Util.getPropertyAlias((PropertyInfo)propertyInfo));
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private String getExtendValue(ReceiverObject parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = Util.getEntity((String)parentExtendValue, (LinkPropertyInfo)linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? "" : refEntityName;
        return extendValue;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String field = StringUtils.cnulls((String)this.kDTextFieldName.getText());
        if (StringUtils.isEmpty((String)field)) {
            return;
        }
        this.inputText = field.trim();
        this.treePaths.clear();
        if (this.treeStaticReceivers.getModel() == null) {
            return;
        }
        String longNumber = this.getNodeLongNumber(this.getSearchUserOrg());
        if (StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        this.searchNode((DefaultKingdeeTreeNode)this.treeStaticReceivers.getModel().getRoot(), longNumber);
    }

    private List<String> getSearchUserOrg() throws BaseForewarnAppException, BOSException {
        if (this.searchOrgUser.size() == 0) {
            this.searchOrgUser = ForewarnItemFactory.getRemoteInstance().searchOrgUser(this.inputText);
        }
        return this.searchOrgUser;
    }

    private String getNodeLongNumber(List<String> result) {
        if (result == null || result.size() == 0) {
            return "";
        }
        ++this.searchCount;
        int index = 0;
        index = result.size() < this.searchCount ? (this.searchCount % result.size() == 0 ? result.size() - 1 : this.searchCount % result.size() - 1) : this.searchCount - 1;
        return result.get(index);
    }

    private boolean searchNode(DefaultKingdeeTreeNode node, String longNumber) {
        if (node == null) {
            return false;
        }
        if (this.checkLongNumber(node, longNumber)) {
            this.treeStaticReceivers.setSelectionNode(node);
            this.treeStaticReceivers.scrollPathToVisible(this.treeStaticReceivers.getSelectionPath());
            return true;
        }
        if (this.isAncestor(node, longNumber)) {
            if (node.getChildCount() == 0) {
                try {
                    OrgUserInfo info = (OrgUserInfo)node.getUserObject();
                    if (info != null && !"1".equals(info.getIsLeaf())) {
                        this.loadNode(node);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                if (this.checkLongNumber(childNode, longNumber)) {
                    this.treeStaticReceivers.setSelectionNode(childNode);
                    this.treeStaticReceivers.scrollPathToVisible(this.treeStaticReceivers.getSelectionPath());
                    return true;
                }
                if (!this.searchNode(childNode, longNumber)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkLongNumber(DefaultKingdeeTreeNode node, String longNumber) {
        OrgUserInfo orgUserInfo;
        Object o = node.getUserObject();
        return o instanceof OrgUserInfo && StringUtils.equals((String)(orgUserInfo = (OrgUserInfo)o).getLongNumber(), (String)longNumber);
    }

    private boolean isAncestor(DefaultKingdeeTreeNode node, String longNumber) {
        OrgUserInfo orgUserInfo;
        Object o = node.getUserObject();
        return o instanceof OrgUserInfo && !StringUtils.equals((String)(orgUserInfo = (OrgUserInfo)o).getLongNumber(), (String)longNumber) && longNumber.indexOf(orgUserInfo.getLongNumber() + "!") > -1;
    }

    private String getAlias(ReceiverObject parent, String propertyAlias) {
        String name = "";
        String parentName = parent.getAlias();
        name = parentName.length() == 0 ? propertyAlias : parentName + "." + propertyAlias;
        return name;
    }

    private String getValue(ReceiverObject parent, String propertyName) {
        String value = "";
        String parentValue = parent.getValue();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private EntityObjectInfo getEntity(String entityName) {
        EntityObjectInfo objectInfo = null;
        if (!this.entities.containsKey(entityName)) {
            objectInfo = Util.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    public void setTextFieldReceivers(KDTextField field) {
        this.tfReceivers = field;
    }

    @Override
    protected void kDTabbedPaneReceivers_stateChanged(ChangeEvent e) throws Exception {
        super.kDTabbedPaneReceivers_stateChanged(e);
        if (this.kDTabbedPaneReceivers.getSelectedIndex() == 0) {
            this.kDTextFieldName.setEnabled(true);
        } else {
            this.kDTextFieldName.setText("");
            this.kDTextFieldName.setEnabled(false);
        }
    }

    protected JButton getDefaultButton() {
        return this.kDButtonConfirm;
    }

    @Override
    protected void btnDynReceivers_actionPerformed(ActionEvent e) throws Exception {
        UIContext a = new UIContext();
        a.put("forewarnInfo", this.forewarnItemInfo);
        a.put("BUSINESS_OBJS", this.busObjs);
        a.put("CUR_FW_OBJS", this.curFWObjs);
        a.put("CUR_FW_THRESHOLDS", this.curFWThresholds);
        this.showDialog(UserDefineReceiversEditUI.class.getName(), (Map)a, OprtState.EDIT);
    }

    private IUIWindow showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
            return curDialog;
        }
        catch (UIException ex1) {
            MsgBox.showInfo((Component)((Object)this), (String)ex1.getMessage());
            return null;
        }
    }
}

