/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.forewarn.DataCenterFacadeFactory;
import com.kingdee.eas.base.forewarn.ExportDataTypeEnum;
import com.kingdee.eas.base.forewarn.IDataCenterFacade;
import com.kingdee.eas.base.forewarn.client.AbstractTestForewarnUI;
import com.kingdee.eas.base.forewarn.client.TestDataCenterConnUI;
import com.kingdee.eas.base.forewarn.dataDeal.DataBaseInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TestForewarnUI
extends AbstractTestForewarnUI {
    private static final Logger logger = CoreUIObject.getLogger(TestForewarnUI.class);
    private DataBaseInfo dataBaseInfo = new DataBaseInfo();

    public TestForewarnUI() throws Exception {
        this.comboBusinessType.addItem((Object)ExportDataTypeEnum.FOREWARN);
        this.comboBusinessType.addItem((Object)ExportDataTypeEnum.DIE);
        this.comboBusinessType.addItem((Object)ExportDataTypeEnum.PARAM);
        this.comboBusinessType.addItem((Object)ExportDataTypeEnum.CODINGRULE);
        this.comboBusinessType.addItem((Object)ExportDataTypeEnum.OTHER);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Object o = this.getUIContext().get("busType");
        if (o != null && (o.equals((Object)ExportDataTypeEnum.DIE) || o.equals(new Integer(2)))) {
            this.comboBusinessType.setSelectedItem((Object)ExportDataTypeEnum.DIE);
        } else if (o != null && o.equals((Object)ExportDataTypeEnum.FOREWARN) || o.equals(new Integer(1))) {
            this.comboBusinessType.setSelectedItem((Object)ExportDataTypeEnum.FOREWARN);
        } else if (o != null && o.equals((Object)ExportDataTypeEnum.PARAM) || o.equals(new Integer(3))) {
            this.comboBusinessType.setSelectedItem((Object)ExportDataTypeEnum.PARAM);
        } else {
            this.comboBusinessType.setSelectedItem((Object)ExportDataTypeEnum.FOREWARN);
        }
    }

    public void actionExportSql_actionPerformed(ActionEvent e) throws Exception {
    }

    private String addSeperator(String numberStr) {
        if (StringUtils.isEmpty((String)numberStr)) {
            return "";
        }
        String[] aryStr = StringUtils.split((String)numberStr, (String)",");
        String retStr = "";
        for (int i = 0; i < aryStr.length; ++i) {
            retStr = retStr + "'" + aryStr[i] + "',";
        }
        if (retStr.endsWith(",")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        return retStr;
    }

    private List str2Ary(String tableStr) {
        ArrayList<String> tableList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)tableStr)) {
            return tableList;
        }
        String[] tableAry = StringUtils.split((String)tableStr, (String)",");
        for (int i = 0; i < tableAry.length; ++i) {
            tableList.add(tableAry[i]);
        }
        return tableList;
    }

    @Override
    protected void rdDbTypeDb2_actionPerformed(ActionEvent e) throws Exception {
        this.dataBaseInfo.CUR_DBTYPE = "DB2";
    }

    @Override
    protected void rdDbTypeKsql_actionPerformed(ActionEvent e) throws Exception {
        this.dataBaseInfo.CUR_DBTYPE = "KSQL";
    }

    @Override
    protected void rdDbTypeOracle_actionPerformed(ActionEvent e) throws Exception {
        this.dataBaseInfo.CUR_DBTYPE = "ORACLE";
    }

    @Override
    protected void rdDbTypeSqlServer_actionPerformed(ActionEvent e) throws Exception {
        this.dataBaseInfo.CUR_DBTYPE = "SQLSERVER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        File tempFile;
        logger.info((Object)"............ begin export sql");
        if (this.dataBaseInfo == null) {
            this.dataBaseInfo = new DataBaseInfo();
        }
        this.dataBaseInfo.CUR_CHAR_SEPERATOR = this.txtSperator.getText();
        if (!StringUtils.isEmpty((String)this.txtNumberStr.getText())) {
            this.dataBaseInfo.numberStr = this.addSeperator(this.txtNumberStr.getText());
        }
        if ((tempFile = new File(this.dataBaseInfo.FILE_NAME_CLIENT)).exists()) {
            tempFile.delete();
        }
        this.dataBaseInfo.ExportDataType = this.getExportDataType();
        IDataCenterFacade dataCenterFacade = DataCenterFacadeFactory.getRemoteInstance();
        dataCenterFacade.exportData(this.str2Ary(this.txtTableStr.getText()), this.dataBaseInfo);
        try (BufferedWriter outClient = null;){
            outClient = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
            String sql = dataCenterFacade.getSqlFromServerFile();
            String[] sqlLine = sql.split("\n");
            for (int i = 0; i < sqlLine.length; ++i) {
                outClient.write(sqlLine[i]);
                outClient.newLine();
                outClient.flush();
            }
            MsgBox.showInfo((Component)((Object)this), (String)(" file create success, save to " + this.dataBaseInfo.FILE_NAME_CLIENT));
            this.dataBaseInfo = new DataBaseInfo();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.dataBaseInfo == null) {
            this.dataBaseInfo = new DataBaseInfo();
        }
    }

    @Override
    protected void btnAdvanceSet_actionPerformed(ActionEvent e) throws Exception {
        UIContext uictx = new UIContext((Object)this);
        if (this.dataBaseInfo != null) {
            uictx.put((Object)DataBaseInfo.class.getName(), (Object)this.dataBaseInfo);
        }
        String uiname = TestDataCenterConnUI.class.getName();
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIFactory uif = UIFactory.createUIFactory((String)uimode);
        IUIWindow uiw = uif.create(uiname, (Map)uictx);
        uiw.show();
        Map dataInfoMap = uiw.getUIObject().getUIContext();
        this.dataBaseInfo = (DataBaseInfo)dataInfoMap.get(DataBaseInfo.class.getName());
    }

    @Override
    protected void kDComboBox1_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        Object o = e.getItem();
        if (o.equals((Object)ExportDataTypeEnum.FOREWARN)) {
            this.txtTableStr.setText(this.getForewarnTableList());
            this.txtSperator.setText("%");
        } else if (o.equals((Object)ExportDataTypeEnum.DIE)) {
            this.txtTableStr.setText(this.getDIETableList());
            this.txtSperator.setText(";");
        } else if (o.equals((Object)ExportDataTypeEnum.PARAM)) {
            this.txtTableStr.setText(this.getParamTableList());
            this.txtSperator.setText(";");
        } else if (o.equals((Object)ExportDataTypeEnum.CODINGRULE)) {
            this.txtTableStr.setText(this.getCodingRuleTableList());
            this.txtSperator.setText(";");
        } else {
            this.txtTableStr.setText("");
            this.txtSperator.setText(";");
        }
    }

    private ExportDataTypeEnum getExportDataType() {
        Object o = this.comboBusinessType.getSelectedItem();
        return (ExportDataTypeEnum)((Object)o);
    }

    private String getForewarnTableList() {
        StringBuffer sb = new StringBuffer();
        sb.append("T_FW_RightnowAction,T_FW_ForewarnMsg,T_FW_Condition,").append("T_FW_Threshold,T_FW_schedule,T_FW_ForewarnItem,T_FW_Receiver,").append("T_FW_DynReceivers,T_FW_ForewarnObject");
        return sb.toString();
    }

    private String getDIETableList() {
        StringBuffer sb = new StringBuffer();
        sb.append("T_DIE_Template,T_DIE_TemplateFieldEntry");
        return sb.toString();
    }

    private String getParamTableList() {
        StringBuffer sb = new StringBuffer();
        sb.append("T_BAS_Param,T_BAS_ParamValueRange,T_BAS_EgoExhibitParam");
        return sb.toString();
    }

    private String getCodingRuleTableList() {
        StringBuffer sb = new StringBuffer();
        sb.append("T_BAS_CodingRule,T_BAS_CodingRuleEntry,T_BAS_BindingProperty");
        return sb.toString();
    }

    @Override
    protected void kDWorkButton1_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

