/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class TestValue {
    public static boolean objectValueEquals(AbstractObjectValue source, AbstractObjectValue target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getClass().getName().equals(target.getClass().getName())) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (TestValue.ownPropertyEquals(source, target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = TestValue.isComposite(entity, (LinkPropertyInfo)property);
            if (TestValue.isAggregation(entity, (LinkPropertyInfo)property, source)) {
                AbstractObjectCollection sourceChildCollection = (AbstractObjectCollection)source.get(property.getName());
                AbstractObjectCollection targetChildCollection = (AbstractObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    AbstractObjectValue sourceChildObject = (AbstractObjectValue)sourceChildCollection.getObject(i);
                    AbstractObjectValue targetChildObject = (AbstractObjectValue)targetChildCollection.getObject(i);
                    if (!(composite ? !TestValue.objectValueEquals(sourceChildObject, targetChildObject) : !TestValue.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            AbstractObjectValue sourceChildObject = (AbstractObjectValue)source.get(property.getName());
            AbstractObjectValue targetChildObject = (AbstractObjectValue)target.get(property.getName());
            if (!(composite ? !TestValue.objectValueEquals(sourceChildObject, targetChildObject) : !TestValue.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    public static boolean objectValueEquals(Context ctx, AbstractObjectValue source, AbstractObjectValue target) {
        if (ctx == null) {
            return false;
        }
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getClass().getName().equals(target.getClass().getName())) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (TestValue.ownPropertyEquals(source, target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = TestValue.isComposite(entity, (LinkPropertyInfo)property);
            if (TestValue.isAggregation(entity, (LinkPropertyInfo)property, source)) {
                AbstractObjectCollection sourceChildCollection = (AbstractObjectCollection)source.get(property.getName());
                AbstractObjectCollection targetChildCollection = (AbstractObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    AbstractObjectValue sourceChildObject = (AbstractObjectValue)sourceChildCollection.getObject(i);
                    AbstractObjectValue targetChildObject = (AbstractObjectValue)targetChildCollection.getObject(i);
                    if (!(composite ? !TestValue.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !TestValue.objectValueEqualsPk(ctx, sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            AbstractObjectValue sourceChildObject = (AbstractObjectValue)source.get(property.getName());
            AbstractObjectValue targetChildObject = (AbstractObjectValue)target.get(property.getName());
            if (!(composite ? !TestValue.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !TestValue.objectValueEqualsPk(ctx, sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    private static boolean objectValueEqualsPk(Context ctx, AbstractObjectValue source, AbstractObjectValue target) {
        if (ctx == null) {
            return false;
        }
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Object sourceId = source.get(source.getPKField());
            Object targetId = target.get(target.getPKField());
            if (sourceId == null && targetId == null) {
                return true;
            }
            if (sourceId != null && targetId != null) {
                return sourceId.toString().equals(targetId.toString());
            }
            return false;
        }
        return false;
    }

    private static boolean objectValueEqualsPk(AbstractObjectValue source, AbstractObjectValue target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Object sourceId = source.get(source.getPKField());
            Object targetId = target.get(target.getPKField());
            if (sourceId == null && targetId == null) {
                return true;
            }
            if (sourceId != null && targetId != null) {
                return sourceId.toString().equals(targetId.toString());
            }
            return false;
        }
        return false;
    }

    private static boolean isAggregation(EntityObjectInfo entity, LinkPropertyInfo property, AbstractObjectValue source) {
        return source.get(property.getName()) instanceof AbstractObjectCollection;
    }

    private static boolean isComposite(EntityObjectInfo entity, LinkPropertyInfo property) {
        return property.getRelationship().getType().equals((Object)RelationshipType.COMPOSITION) && property.getRelationship().getClientObject().getType().equals((Object)entity.getType());
    }

    private static boolean ownPropertyEquals(AbstractObjectValue source, AbstractObjectValue target, OwnPropertyInfo property) {
        if (property.getDataType().equals((Object)DataType.SHORT)) {
            short targetProperty;
            short sourceProperty = source.getShort(property.getName());
            return sourceProperty == (targetProperty = target.getShort(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.INTEGER)) {
            int targetProperty;
            int sourceProperty = source.getInt(property.getName());
            return sourceProperty == (targetProperty = target.getInt(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.LONG)) {
            long targetProperty;
            long sourceProperty = source.getLong(property.getName());
            return sourceProperty == (targetProperty = target.getLong(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.FLOAT)) {
            float targetProperty;
            float sourceProperty = source.getFloat(property.getName());
            return sourceProperty == (targetProperty = target.getFloat(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DOUBLE)) {
            double targetProperty;
            double sourceProperty = source.getDouble(property.getName());
            return sourceProperty == (targetProperty = target.getDouble(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.ENUM)) {
            Object sourceobj = source.get(property.getName());
            Object targetObj = target.get(property.getName());
            if (sourceobj != null) {
                return sourceobj.equals(targetObj);
            }
            if (targetObj != null) {
                return targetObj.equals(sourceobj);
            }
            return true;
        }
        if (property.getDataType().equals((Object)DataType.BOOLEAN)) {
            boolean targetProperty;
            boolean sourceProperty = source.getBoolean(property.getName());
            return sourceProperty == (targetProperty = target.getBoolean(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.BYTE)) {
            byte targetProperty;
            byte sourceProperty = source.getByte(property.getName());
            return sourceProperty == (targetProperty = target.getByte(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DECIMAL)) {
            BigDecimal sourceProperty = source.getBigDecimal(property.getName());
            BigDecimal targetProperty = target.getBigDecimal(property.getName());
            return TestValue.bigDecimalEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.STRING)) {
            String sourceProperty = source.getString(property.getName());
            String targetProperty = target.getString(property.getName());
            return TestValue.stringEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BYTEARRAY)) {
            byte[] sourceProperty = source.getBytes(property.getName());
            byte[] targetProperty = target.getBytes(property.getName());
            return TestValue.byteArrayEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.DATE)) {
            Date sourceProperty = source.getDate(property.getName());
            Date targetProperty = target.getDate(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIME)) {
            Time sourceProperty = source.getTime(property.getName());
            Time targetProperty = target.getTime(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIMESTAMP)) {
            Timestamp sourceProperty = source.getTimestamp(property.getName());
            Timestamp targetProperty = target.getTimestamp(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.CHAR)) {
            Character sourceProperty = (Character)source.get(property.getName());
            Character targetProperty = (Character)target.get(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BOSUUID)) {
            BOSUuid sourceProperty = source.getBOSUuid(property.getName());
            BOSUuid targetProperty = target.getBOSUuid(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.UUID)) {
            Uuid sourceProperty = source.getUuid(property.getName());
            Uuid targetProperty = target.getUuid(property.getName());
            return TestValue.objectEquals(sourceProperty, targetProperty);
        }
        Object sourceProperty = source.get(property.getName());
        Object targetProperty = target.get(property.getName());
        return TestValue.objectEquals(sourceProperty, targetProperty);
    }

    private static boolean stringEquals(String source, String target) {
        return StringUtils.equals((String)source, (String)target);
    }

    private static boolean bigDecimalEquals(BigDecimal source, BigDecimal target) {
        if (source == null) {
            source = SysConstant.BIGZERO;
        }
        if (target == null) {
            target = SysConstant.BIGZERO;
        }
        return source.compareTo(target) == 0;
    }

    private static boolean byteArrayEquals(byte[] source, byte[] target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        String tempSource = new String(source);
        String tempTarget = new String(target);
        return TestValue.objectEquals(tempSource, tempTarget);
    }

    private static boolean objectEquals(Object source, Object target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }

    public static void copy(AbstractObjectValue dataObject) {
        BOSObjectType bosType = dataObject.getBOSType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(bosType);
        TestValue.removePKField(dataObject, entity);
    }

    private static void removePKField(AbstractObjectValue dataObject, EntityObjectInfo entity) {
        if (dataObject == null) {
            return;
        }
        dataObject.remove(dataObject.getPKField());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo childProperty : pc) {
            RelationshipInfo relation;
            if (!(childProperty instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)childProperty).getRelationship()).getType() != RelationshipType.COMPOSITION) continue;
            if ((relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED) && entity.equals((Object)relation.getClientObject())) {
                Object colData = dataObject.get(childProperty.getName());
                if (colData instanceof AbstractObjectCollection) {
                    AbstractObjectCollection col = (AbstractObjectCollection)colData;
                    for (AbstractObjectValue childObject : col) {
                        TestValue.removePKField(childObject, relation.getSupplierObject());
                    }
                    continue;
                }
                System.out.println("dataObject type in copy:" + colData.getClass());
                continue;
            }
            if (!(relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED || entity.equals((Object)relation.getClientObject()))) {
                dataObject.remove(childProperty.getName());
                continue;
            }
            if (relation.getSupplierCardinality() != CardinalityType.ONE && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE || !entity.equals((Object)relation.getClientObject())) continue;
            AbstractObjectValue childObject = (AbstractObjectValue)dataObject.get(childProperty.getName());
            TestValue.removePKField(childObject, relation.getSupplierObject());
        }
    }
}

