/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversInfo;
import com.kingdee.eas.base.forewarn.client.AbstractUserDefineReceiversEditUI;
import com.kingdee.eas.base.forewarn.client.ForewarnUtil;
import com.kingdee.eas.base.forewarn.client.FormulaDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class UserDefineReceiversEditUI
extends AbstractUserDefineReceiversEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDefineReceiversEditUI.class);
    private ForewarnItemInfo forewarnItemInfo = null;
    private BusinessObjectInfo[] busObjs = null;
    private ForewarnObjectCollection fwObjColl = null;
    private ForewarnThresholdCollection fwThdColl = null;
    private ForewarnUserDefineReceiversInfo dynReceiverInfo = null;

    public UserDefineReceiversEditUI() throws Exception {
        this.initBtn();
        this.disvisibleBtn();
    }

    private void initBtn() {
        this.actionEditFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_conditionedit"));
        JButton btnEditFormula = this.kDContainer1.add((Action)((Object)this.actionEditFormula));
        btnEditFormula.setSize(new Dimension(22, 19));
        this.actionCheckFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        JButton btnCheckFormula = this.kDContainer1.add((Action)((Object)this.actionCheckFormula));
        btnCheckFormula.setSize(new Dimension(22, 19));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.forewarnItemInfo != null && this.forewarnItemInfo.getDynReceivers() != null && this.forewarnItemInfo.getDynReceivers().size() > 0) {
            this.dynReceiverInfo = this.forewarnItemInfo.getDynReceivers().get(0);
            this.txtNumber.setText(this.dynReceiverInfo.getNumber());
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.dynReceiverInfo, (String)"name");
            this.areaReceivers.setSelectedItemData((Object)this.getFormulaDialog(new FormulaDialog()).getFormulaAliasNoResultStr());
        } else {
            this.txtNumber.setText("");
            List langList = KDBizMultiLangBox.getLanguageList();
            Iterator iter = langList.iterator();
            LanguageInfo defaultLang = null;
            while (iter.hasNext()) {
                LanguageInfo currentLang = (LanguageInfo)iter.next();
                this.txtName.addItem(currentLang, null);
                if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
                defaultLang = currentLang;
            }
            if (defaultLang != null) {
                this.txtName.setSelectedLanguage(defaultLang);
            }
            this.txtName.setSelectedItemData(null);
            this.areaReceivers.setSelectedItemData(null);
            langList = KDBizMultiLangBox.getLanguageList();
            for (LanguageInfo currentLang : langList) {
                this.areaReceivers.addItem(currentLang, null);
                if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
                defaultLang = currentLang;
            }
            if (defaultLang != null) {
                this.areaReceivers.setSelectedLanguage(defaultLang);
            }
        }
    }

    private void getLastUIContext() {
        this.forewarnItemInfo = (ForewarnItemInfo)this.getUIContext().get("forewarnInfo");
        this.busObjs = (BusinessObjectInfo[])this.getUIContext().get("BUSINESS_OBJS");
        this.fwObjColl = (ForewarnObjectCollection)((Object)this.getUIContext().get("CUR_FW_OBJS"));
        this.fwThdColl = (ForewarnThresholdCollection)((Object)this.getUIContext().get("CUR_FW_THRESHOLDS"));
    }

    protected void inOnload() throws Exception {
        this.loadFields();
    }

    public void onLoad() throws Exception {
        this.getLastUIContext();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                this.btnRemove.setEnabled(false);
            } else if (OprtState.EDIT.equals(this.getOprtState()) && this.forewarnItemInfo.getDynReceivers().size() > 0) {
                this.btnRemove.setEnabled(true);
            }
        }
        super.onLoad();
    }

    private void disvisibleBtn() {
        KDWorkButton[] btns = new KDWorkButton[]{this.btnAddNew, this.btnAttachment, this.btnCancel, this.btnCancelCancel, this.btnCopy, this.btnEdit, this.btnSave, this.btnFirst, this.btnLast, this.btnPre, this.btnPageSetup, this.btnPrint, this.btnPrintPreview, this.btnNext};
        for (int i = 0; i < btns.length; ++i) {
            btns[i].setVisible(false);
        }
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.dynReceiverInfo == null) {
            this.dynReceiverInfo = new ForewarnUserDefineReceiversInfo();
        }
        this.dynReceiverInfo.setNumber(this.txtNumber.getText());
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.dynReceiverInfo, (String)"name");
        this.forewarnItemInfo.getDynReceivers().clear();
        if (this.isDel(this.dynReceiverInfo)) {
            this.forewarnItemInfo.getDynReceivers().remove(this.dynReceiverInfo);
        } else {
            this.forewarnItemInfo.getDynReceivers().add(this.dynReceiverInfo);
        }
        this.disposeUIWindow();
    }

    private boolean isDel(ForewarnUserDefineReceiversInfo info) {
        return this.isNull(info.getName()) && this.isNull(info.getNumber()) && this.isNull(info.getContentScript());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.forewarnItemInfo.getDynReceivers().clear();
        this.dynReceiverInfo.setContentScript("");
        this.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isNull(this.dynReceiverInfo.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"25_UserDefineReceiversEditUI"));
            SysUtil.abort();
        }
        if (this.isNull(this.dynReceiverInfo.getName())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"26_UserDefineReceiversEditUI"));
            SysUtil.abort();
        }
        if (this.isNull(this.dynReceiverInfo.getContent()) || this.isNull(this.dynReceiverInfo.getContentScript())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"27_UserDefineReceiversEditUI"));
            SysUtil.abort();
        }
    }

    private boolean isNull(String str) {
        return str == null || str.equals("");
    }

    @Override
    public void actionEditFormula_actionPerformed(ActionEvent e) throws Exception {
        FormulaDialog formulaDialog = new FormulaDialog((Dialog)((KDDialog)this.getUIWindow()), EASResource.getString((String)"com.kingdee.eas.base.forewarn.client.Forewarn", (String)"formulaSysTitle"), true);
        formulaDialog = this.getFormulaDialog(formulaDialog);
        formulaDialog.show();
        if (formulaDialog.isConfirm()) {
            String formula = formulaDialog.getFormula();
            String formulaAlias = formulaDialog.getFormulaAliasNoResultStr();
            if (this.dynReceiverInfo == null) {
                this.dynReceiverInfo = new ForewarnUserDefineReceiversInfo();
            }
            this.dynReceiverInfo.setContentScript(formula);
            this.areaReceivers.setSelectedItemData((Object)formulaAlias);
        }
    }

    private FormulaDialog getFormulaDialog(FormulaDialog formulaDialog) {
        if (this.forewarnItemInfo.getDynReceivers() != null && this.forewarnItemInfo.getDynReceivers().get(0) != null && this.forewarnItemInfo.getDynReceivers().get(0).getContentScript() != null) {
            String script = ForewarnUtil.processScript(this.fwObjColl, this.fwThdColl, this.forewarnItemInfo.getDynReceivers().get(0).getContentScript());
            formulaDialog.setFormula(script);
        } else {
            String script = ForewarnUtil.processScript(this.fwObjColl, this.fwThdColl, "");
            formulaDialog.setFormula(script);
        }
        formulaDialog.setMetaDataObjs(this.busObjs);
        formulaDialog.getAddButton().setVisible(false);
        formulaDialog.getDelButton().setVisible(false);
        return formulaDialog;
    }

    @Override
    public void actionCheckFormula_actionPerformed(ActionEvent e) throws Exception {
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

