/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.forewarn.ForewarnRunTimeFactory;
import com.kingdee.eas.base.forewarn.IForewarnRunTime;
import com.kingdee.eas.base.message.util.MCManagerModel;
import com.kingdee.eas.base.message.util.MessageCenterManager;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ForewarnService
implements IBindService {
    private static Logger logger = Logger.getLogger(ForewarnService.class);

    public void beforeActionPerformed(Map serviceContext) {
    }

    public void afterActionPerformed(Map serviceContext) {
        int exIndex;
        EditUI tmp;
        IItemAction action = (IItemAction)serviceContext.get("ACTION");
        String objID = null;
        if (action == null) {
            return;
        }
        IUIObject uiObj = action.getUIObject();
        if (uiObj == null) {
            return;
        }
        if (uiObj instanceof EditUI) {
            tmp = (EditUI)uiObj;
            objID = tmp.getIDListForAll().getCurrentID();
        } else if (uiObj instanceof ListUI) {
            tmp = (ListUI)uiObj;
            objID = tmp.getSelectedKeyForAll();
        }
        if (objID == null) {
            return;
        }
        String className = action.getClass().getName();
        if (className == null || className.indexOf(36) == -1) {
            return;
        }
        String uiName = uiObj.getClass().getName();
        int index = uiName.indexOf("$$EnhancerByCGLIB");
        if (index > 0) {
            uiName = uiName.substring(0, index);
        }
        if ((exIndex = uiName.indexOf("CTEx")) > 0) {
            uiName = uiName.substring(0, exIndex);
        }
        String actionName = className.substring(className.lastIndexOf("$") + 1);
        action = null;
        uiObj = null;
        InnerThread t = new InnerThread(uiName, actionName, objID);
        t.start();
    }

    public void finalActionPerformed(Map serviceContext) {
    }

    class RefreashMsgRunnable
    implements Runnable {
        RefreashMsgRunnable() {
        }

        @Override
        public void run() {
            MCManagerModel model = new MCManagerModel();
            model.setRefreshTime(2);
            MessageCenterManager.getInstance().setModel(model);
            MessageCenterManager.getInstance().freshMessageCenter();
        }
    }

    class InnerThread
    extends Thread {
        private String actionName;
        private String uiName;
        private String objID;

        public InnerThread(String uiName, String actionName, String objID) {
            this.uiName = uiName;
            this.actionName = actionName;
            this.objID = objID;
        }

        @Override
        public void run() {
            this.forewarnCheck();
        }

        private synchronized void forewarnCheck() {
            try {
                IForewarnRunTime forewarnInfo = ForewarnRunTimeFactory.getRemoteInstance();
                boolean isResult = forewarnInfo.execRightnowForewarn(this.uiName, this.actionName, this.objID);
                if (isResult) {
                    SwingUtilities.invokeLater(new RefreashMsgRunnable());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }
}

