/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.flow.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.extend.flow.IRelatedForm;
import com.kingdee.eas.base.form.extend.flow.RelatedFormFactory;
import com.kingdee.eas.base.form.extend.flow.RelatedFormInfo;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.form.model.list.OpenListParameter;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class RelateBillList
extends ListPlugin {
    public boolean onInitialize(OpenListParameter param) throws EASBizException, BOSException {
        this.checkPermission();
        return super.onInitialize(param);
    }

    private void checkPermission() {
        String formID = (String)this.application.getCustomParameter("thisFormId");
        String nodeId = (String)this.application.getCustomParameter("nodeId");
        String layoutId = (String)this.application.getCustomParameter("layoutId");
        String billId = (String)this.application.getCustomParameter("thisBillId");
        String templateId = null;
        if (formID == null || nodeId == null || layoutId == null) {
            return;
        }
        try {
            String sql = "Select FTemplateID from t_bas_documentInfo where FFormID='" + formID + "' and FSourcePk = '" + billId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)this.application.getContext(), (String)sql);
            if (rowSet != null && rowSet.size() > 0) {
                rowSet.first();
                templateId = rowSet.getString("FTemplateID");
            }
            int isAddRelatedForm = 0;
            int isDeleteRelatedForm = 0;
            sql = "Select FIsAddRelatedForm,FIsViewRelatedForm,FIsDeleteRelatedForm from T_BAS_FlowNodeCtrl where FTemplateID='" + templateId + "' and FFormId='" + formID + "' and FLayoutId='" + layoutId + "' and FFlowNodeId='" + nodeId + "'";
            IRowSet rowSetRela = DbUtil.executeQuery((Context)this.application.getContext(), (String)sql);
            if (rowSetRela != null && rowSetRela.size() > 0) {
                rowSetRela.first();
                isAddRelatedForm = rowSetRela.getInt("FIsAddRelatedForm");
                isDeleteRelatedForm = rowSetRela.getInt("FIsDeleteRelatedForm");
            }
            this.application.getListView().setBarItemDisabled("mnuNew", isAddRelatedForm == 0);
            this.application.getListView().setBarItemDisabled("mnuDelete", isDeleteRelatedForm == 0);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void doCustomOperation(String operation) throws BOSException, EASBizException {
        if ("NewRelateBill".equalsIgnoreCase(operation)) {
            String fromId = (String)this.application.getCustomParameter("thisFormId");
            String billId = (String)this.application.getCustomParameter("thisBillId");
            String panelKey = (String)this.application.getCustomParameter("thisPanelKey");
            String nodeId = (String)this.application.getCustomParameter("nodeId");
            String layoutId = (String)this.application.getCustomParameter("layoutId");
            this.newRelateBill(fromId, billId, panelKey, layoutId);
        } else if ("ViewRelateBill".equalsIgnoreCase(operation)) {
            String pk = this.getSelectedPK();
            if (pk == null) {
                return;
            }
            this.showSourceForm(new ObjectUuidPK(pk));
        }
    }

    private String getSelectedPK() throws BOSException {
        String[] pk = this.application.getListView().getSelectedBillIds();
        if (pk.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            return null;
        }
        return pk[0];
    }

    private void newRelateBill(String formId, String billId, String panelKey, String layoutId) throws BOSException {
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)formId);
            para.put("layoutId", (Object)layoutId);
            para.put("billId", (Object)billId);
            para.put("panelKey", (Object)panelKey);
        }
        catch (JSONException e) {
            // empty catch block
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"/easweb/cp/wfm/documentInfoListFlowQuery.jsp", (String)para.toString());
        this.application.popupWindow(url, "openDialog", " ", " ", 800, 560);
    }

    private void showSourceForm(ObjectUuidPK pk) throws BOSException {
        RelatedFormInfo rela = null;
        IRelatedForm relaService = RelatedFormFactory.getLocalInstance(this.application.getContext());
        try {
            rela = relaService.getRelatedFormInfo((IObjectPK)pk);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (rela != null) {
            String sourceFormID = rela.getSourceFormID();
            String sourceFormPk = rela.getSourceFormPk();
            JSONObject para = new JSONObject();
            try {
                para.put("formID", (Object)sourceFormID);
                para.put("pk", (Object)sourceFormPk);
            }
            catch (JSONException e) {
                // empty catch block
            }
            String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", (String)para.toString());
            this.application.popupWindow(url, "openDialog", sourceFormID);
        }
    }
}

