/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.flow.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BeforeUpdateValueArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.DynamicEnum;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SignValidationControlPlugin
extends AbstractBillPlugin {
    private String formId;
    private String layoutId;
    private String signCtrlSelected;
    private String newSignCtrlSelected;
    private BusinessInfo businessInfo;
    private LayoutInfo layoutInfo;
    private String templateId;
    private DynamicEnum signCtrlEnum;
    private Map signFieldData;
    private List fields = new ArrayList();
    private boolean isAfterConfirming = false;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        super.onInitialize(param);
        this.formId = (String)this.application.getCustomParameter("tempformID");
        this.layoutId = (String)this.application.getCustomParameter("tempLayoutID");
        this.templateId = (String)this.application.getCustomParameter("templateId");
        FormMetaData formMeta = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)this.formId, null);
        if (formMeta == null) {
            this.application.showMessage("\u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u5931\u8d25\uff0cFormID=" + this.formId);
            return false;
        }
        this.businessInfo = formMeta.getBusinessInfo();
        if (this.layoutId == null) {
            this.layoutId = formMeta.getLayoutInfo().getId();
        }
        this.layoutInfo = formMeta.getLayoutInfobyID(this.layoutId);
        this.bindDynControl();
        param.billPk = this.getPk(null);
        return true;
    }

    private void bindDynControl() throws EASBizException, BOSException {
        this.traverseMeta2CreateSignEnumAndFieldList(this.layoutInfo);
        this.application.bindDynamicField("FEntityName", "entityName");
        this.application.bindDynamicField("FFieldName", "fieldName");
        this.application.getView().setComboItems("FElecSign", this.signCtrlEnum.getEnumList());
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        IObjectValue objValue = this.application.getBillModel().getBillValue();
        objValue.setString("templateId", this.templateId);
        objValue.setString("layoutId", this.layoutId);
        objValue.setString("flowId", " ");
        if (this.signCtrlSelected == null) {
            this.signCtrlSelected = this.signCtrlEnum.getInnerValue(0);
        }
        this.buildData(true);
    }

    private boolean hasSignControl() {
        return this.signCtrlEnum != null;
    }

    public void afterLoadData() throws EASBizException, BOSException {
        if (!this.isAfterConfirming) {
            super.afterLoadData();
            this.buildData(false);
        } else {
            this.isAfterConfirming = false;
        }
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        this.application.lockElement("FElecSign", false);
    }

    private void buildData(boolean isNewData) throws EASBizException, BOSException {
        IObjectValue billData = this.application.getBillModel().getBillValue();
        this.createFieldsFromMetaData((IObjectCollection)billData.get("fields"));
        if (this.hasSignControl()) {
            if (isNewData) {
                this.setDefaultBillHeadValue();
            }
            this.signCtrlSelected = (String)this.application.getValue("FElecSign", 0);
            this.createEntry();
        } else {
            this.disableSaveButton();
        }
    }

    private void setDefaultBillHeadValue() throws EASBizException, BOSException {
        this.application.setValue("FElecSign", (Object)this.signCtrlSelected, 0);
        this.application.setValue("FPasswordRequired", (Object)Boolean.FALSE, 0);
    }

    private void disableSaveButton() {
        this.application.getBillView().setEnabled("FBtnSave1", false);
        this.application.getBillView().setEnabled("FBtnSave2", false);
    }

    private void traverseMeta2CreateSignEnumAndFieldList(LayoutInfo layout) throws EASBizException, BOSException {
        for (Appearance ctl : layout.getControls()) {
            if (!(ctl instanceof EntityAppearance)) continue;
            EntityAppearance entity = (EntityAppearance)ctl;
            ArrayList entityCtls = entity.getLayoutinfo().getControls();
            for (Appearance ctlAp : entityCtls) {
                if (ctlAp instanceof FieldAppearance) {
                    this.fields.add(ctlAp);
                    continue;
                }
                if (!(ctlAp instanceof ControlAppearance) || ((ControlAppearance)ctlAp).getControlType() != 1023) continue;
                this.createSignEnumItem(ctlAp);
            }
            if (entity.getControlType() != -1) continue;
            this.traverseMeta2CreateSignEnumAndFieldList(entity.getLayoutinfo());
        }
    }

    private void createSignEnumItem(Appearance signCtrl) {
        if (this.signCtrlEnum == null) {
            this.signCtrlEnum = new DynamicEnum();
        }
        this.signCtrlEnum.addItem(signCtrl.getKey(), signCtrl.getCaption());
    }

    private void createFieldsFromMetaData(IObjectCollection entryCollection) throws EASBizException, BOSException {
        this.signFieldData = this.getControlFromObject(entryCollection);
        for (int j = entryCollection.size() - 1; j >= 0; --j) {
            entryCollection.removeObject(j);
        }
    }

    private Map getControlFromObject(IObjectCollection entryCollection) {
        Hashtable<String, SignField> map = new Hashtable<String, SignField>();
        for (IObjectValue rowData : entryCollection) {
            Object key = rowData.get("key");
            if (key == null) continue;
            SignField sf = new SignField(key.toString());
            sf.setSelected(rowData.getBoolean("selected"));
            map.put(sf.getKey(), sf);
        }
        return map;
    }

    private void createEntry() throws EASBizException, BOSException {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldAppearance field = (FieldAppearance)this.fields.get(i);
            this.createField(i, this.layoutInfo.getEntityAppearance(field.getEntityKey()), field);
        }
    }

    private void createField(int seq, EntityAppearance entity, FieldAppearance fldAp) throws BOSException, EASBizException {
        this.application.getBillModel().createNewEntryRow("FFields");
        this.application.setValue("FFieldkey", (Object)fldAp.getKey(), seq);
        this.application.setValue("FFieldName", (Object)fldAp.getCaption(), seq);
        this.application.setValue("FEntityName", (Object)entity.getCaption(), seq);
        SignField sf = (SignField)this.signFieldData.get(fldAp.getKey());
        if (sf != null) {
            this.application.setValue("FIsSelected", (Object)sf.isSelected(), seq);
        } else {
            this.application.setValue("FIsSelected", (Object)new Boolean(false), seq);
        }
    }

    private String getPk(String key) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("templateId", (Object)this.templateId);
        if (key != null) {
            filter.appendFilterItem("elecSign", (Object)key);
        }
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("elecSign"));
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)this.application.getBillModel().getBusinessInfo().getForm().getBosType()), filter, sic);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public void beforeUpdateValue(BeforeUpdateValueArg arg) throws EASBizException, BOSException {
        super.beforeUpdateValue(arg);
        if (arg.getKey().equalsIgnoreCase("FElecSign") && this.signCtrlSelected != null && !this.signCtrlSelected.equalsIgnoreCase(arg.getValue().toString())) {
            arg.setCancel(true);
            this.newSignCtrlSelected = arg.getValue().toString();
            if (this.application.getBillModel().isChanged()) {
                this.application.showConfirm("dataChandedConfirm", "\u4fe1\u606f\u63d0\u793a", "\u5f53\u524d\u8282\u70b9\u914d\u7f6e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58", 8189);
                return;
            }
            this.changeNodeData();
        }
    }

    public void afterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if (id.equalsIgnoreCase("dataChandedConfirm")) {
            if (returnOption == 0) {
                this.isAfterConfirming = true;
                this.application.getBillModel().save();
            }
            this.changeNodeData();
        } else {
            super.afterConfirm(id, returnOption);
        }
    }

    private void changeNodeData() {
        try {
            this.signCtrlSelected = this.newSignCtrlSelected;
            String pk = this.getPk(this.signCtrlSelected);
            if (pk == null) {
                if (this.application.getBillView().getOperationStatus() == OperationStatus.VIEW) {
                    this.application.getBillModel().createNewData();
                    this.application.getBillView().bindData((IDynamicFormModel)this.application.getBillModel());
                } else {
                    this.application.getBillView().createNewData();
                }
            } else {
                this.application.load(pk);
            }
        }
        catch (Exception e) {
            this.application.showMessage(e.getLocalizedMessage());
        }
    }

    class SignField {
        String key;
        boolean selected;

        public SignField(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

