/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.handler.AbstractAssignmentEventHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.workflow.LightAppAssignmentHandler;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.sns.task.util.DingtalkMessageDeal;
import com.kingdee.sns.task.util.WeLinkMessageDeal;
import com.kingdee.sns.task.util.YZJFlowCenterDeal;
import com.kingdee.sns.task.util.YZJMessageDeal;
import com.kingdee.sns.task.util.utils;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class AssignmentHandler
extends AbstractAssignmentEventHandler {
    private Logger logger = Logger.getLogger(AssignmentHandler.class);

    public void execute(AssignmentEvent assignmentEvent, IWfAssignment assignment) {
        try {
            Class.forName("com.kingdee.lightapp.workflow.LightAppAssignmentHandler");
            LightAppAssignmentHandler.execute((AssignmentEvent)assignmentEvent, (IWfAssignment)assignment);
            return;
        }
        catch (Exception e) {
            this.logger.error((Object)"class LightAppAssignmentHandler do not exist");
            if (AssignmentEvent.OnAssignmentComplete.equals((Object)assignmentEvent) || AssignmentEvent.OnAssignmentAborted.equals((Object)assignmentEvent)) {
                try {
                    this.assignmentCompleted(assignment);
                }
                catch (Exception e2) {
                    this.logger.error((Object)"AssignmentHandler  assignmentCompleted error", (Throwable)e2);
                }
            }
            return;
        }
    }

    private boolean checkAssignIsSendToFlowCenter(Context ctx, String assignId) {
        boolean isSendFlowCenter = false;
        String version = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        if ("flowcenter".equals(version)) {
            String sql = "select msgid,pushtype from t_assign_xtmsg where fassignid = ? ";
            try {
                String pushtype;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignId});
                if (rowSet.next() && !StringUtils.isEmpty((String)(pushtype = rowSet.getString("pushtype"))) && "1".equals(pushtype)) {
                    isSendFlowCenter = true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("AssignmentHandler  checkAssignIsSendToFlowCenter error1" + e.getMessage()));
            }
        }
        return isSendFlowCenter;
    }

    private void deleteTodo(IWfAssignment assignment) {
        WfAssignment assign = (WfAssignment)assignment;
        Context ctx = assign.getContext();
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        YZJFlowCenterDeal.deleteTodo(ctx, assignId);
    }

    private void changeTodo2Done(IWfAssignment assignment) {
        WfAssignment assign = (WfAssignment)assignment;
        Context ctx = assign.getContext();
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        YZJFlowCenterDeal.change2Done(ctx, assignId);
    }

    private void assignmentCompleted(IWfAssignment assignment) throws IOException {
        WfAssignment assign = (WfAssignment)assignment;
        Context ctx = assign.getContext();
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        if (!this.checkShouldHandle(ctx)) {
            return;
        }
        XTServiceConfig configInstance = XTServiceConfig.getInstance();
        boolean isDingtalkApp = configInstance.checkIsDingtalkApp();
        boolean isWeLink = configInstance.checkIsWeLink();
        boolean isMultiApp = configInstance.checkIsMultiApp();
        String re = "";
        if (isMultiApp) {
            this.handleWithMultiAppAssign(ctx, assign);
        } else {
            re = isDingtalkApp ? DingtalkMessageDeal.Deal(ctx, assignId) : (isWeLink ? WeLinkMessageDeal.Deal(ctx, assignId) : this.handleWithYZJAssign(ctx, assign));
        }
        this.logger.error((Object)("xtchangge   result msg is :" + re));
    }

    private String handleWithYZJAssign(Context ctx, WfAssignment assign) {
        String re = null;
        String version = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        AssignmentInfo assignmentInfo = assign.getAssignmentInfo();
        String userId = assignmentInfo.getUserId();
        String assignId = assignmentInfo.getAssignmentId();
        if (this.checkAssignIsSendToFlowCenter(ctx, assignId)) {
            this.changeTodo2Done((IWfAssignment)assign);
        } else {
            re = "old".equalsIgnoreCase(version) ? utils.changgebyassign(ctx, assignId) : YZJMessageDeal.Deal(userId, assignId, ctx);
        }
        return re;
    }

    private void handleWithMultiAppAssign(Context ctx, WfAssignment assign) {
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        List multiAppNames = instance.getMultiAppConfNamesListByEid(eid);
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        for (String appName : multiAppNames) {
            String re;
            if ("YZJ".equals(appName)) {
                re = this.handleWithYZJAssign(ctx, assign);
                this.logger.error((Object)("MultiAppAssign YZJchangge result msg is :" + re));
                continue;
            }
            if ("Dingtalk".equals(appName)) {
                re = DingtalkMessageDeal.Deal(ctx, assignId);
                this.logger.error((Object)("MultiAppAssign Dingtalkchangge result msg is :" + re));
                continue;
            }
            if (!"WeLink".equals(appName)) continue;
            re = WeLinkMessageDeal.Deal(ctx, assignId);
            this.logger.error((Object)("MultiAppAssign WeLinkchangge result msg is :" + re));
        }
    }

    private boolean checkShouldHandle(Context ctx) {
        XTServiceConfig configInstance = XTServiceConfig.getInstance();
        ConfigurationItem wxItem = configInstance.getConfigurationItem("WX");
        ConfigurationItem otherAppItem = configInstance.getConfigurationItem("OtherApp");
        boolean isMultiApp = configInstance.checkIsMultiApp();
        String eid = null;
        String host = null;
        try {
            eid = configInstance.getEidByDbCode(ctx.getAIS());
            host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isMultiApp && !StringUtils.isEmpty((String)eid) && !StringUtils.isEmpty(host)) {
            return true;
        }
        return !StringUtils.isEmpty((String)eid) && !StringUtils.isEmpty(host) && wxItem == null && otherAppItem == null;
    }
}

