/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MessageViewConfig {
    private static Logger logger = Logger.getLogger((String)MessageViewConfig.class.getName());
    private static final String CONFIGFILE = "messageViewConfig.xml";
    private static final String ROOTTAG = "sourceIds";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_MODEL = "model";
    public static final String ELEMENT_WEB = "web";
    public static final String ELEMENT_GUI = "gui";
    public static final String ATTR_VIEW_WEB = "viewweb";
    public static final String ATTR_VIEW_GUI = "viewgui";
    public static final String ELEMENT_BILL_WEB = "billweb";
    public static final String ELEMENT_BILL_GUI = "billgui";
    public static final String ATTR_WEB_SUPPORT = "websupport";
    public static final String ATTR_PAGE_PARAMS = "pageparams";
    public static final String ATTR_EAS_APP_NAME = "easappname";
    private static MessageViewConfig instance = null;
    private static Document doc;
    private static Map map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageViewConfig(boolean isServerCall) {
        File configFile;
        map = new HashMap();
        if (isServerCall) {
            String fileName = System.getProperty("portal.config");
            if (StringUtils.isEmpty((String)fileName)) {
                logger.error((Object)"cann't find portal.config property!");
                return;
            }
            configFile = new File(fileName);
            if (!configFile.exists()) {
                logger.error((Object)"portal config file not exist!");
                return;
            }
            fileName = configFile.getParentFile().getAbsolutePath() + "/" + CONFIGFILE;
            configFile = new File(fileName);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("easclient.root")).append(File.separator).append(CONFIGFILE);
            String sysFilePath = sb.toString();
            configFile = new File(sysFilePath);
        }
        if (!configFile.exists()) {
            logger.error((Object)"messageviewconfig file not exist!");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile);
            doc = XMLParser.parseXML((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"cann't find the config file!");
            return;
        }
        catch (JDOMException e) {
            logger.error((Object)"parse config file error!");
            return;
        }
        catch (IOException e) {
            logger.error((Object)"config file read error!");
            return;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        Element rootelement = doc.getRootElement();
        List childlist = rootelement.getChildren(ROOTTAG);
        int i = 0;
        while (i < childlist.size()) {
            HashMap<String, String> rowMap2;
            Element grandchild;
            Element child = (Element)childlist.get(i);
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            rowMap.put(ATTR_PREFIX, child.getAttributeValue(ATTR_PREFIX));
            rowMap.put(ATTR_WIDTH, child.getAttributeValue(ATTR_WIDTH));
            rowMap.put(ATTR_HEIGHT, child.getAttributeValue(ATTR_HEIGHT));
            rowMap.put(ATTR_MODEL, child.getAttributeValue(ATTR_MODEL));
            if (child.getChild(ELEMENT_WEB) != null) {
                grandchild = child.getChild(ELEMENT_WEB);
                rowMap.put(ELEMENT_WEB, grandchild.getText());
                rowMap2 = new HashMap<String, String>();
                if (!StringUtils.isEmpty((String)grandchild.getAttributeValue(ATTR_PAGE_PARAMS))) {
                    rowMap2.put(ATTR_PAGE_PARAMS, grandchild.getAttributeValue(ATTR_PAGE_PARAMS));
                }
                if (!StringUtils.isEmpty((String)grandchild.getAttributeValue(ATTR_MODEL))) {
                    rowMap2.put(ATTR_MODEL, grandchild.getAttributeValue(ATTR_MODEL));
                }
                if (rowMap2.isEmpty()) {
                    rowMap.put(ATTR_VIEW_WEB, null);
                } else {
                    rowMap.put(ATTR_VIEW_WEB, rowMap2);
                }
            }
            if (child.getChild(ELEMENT_GUI) != null) {
                grandchild = child.getChild(ELEMENT_GUI);
                rowMap.put(ELEMENT_GUI, grandchild.getText());
                rowMap2 = new HashMap();
                if (!StringUtils.isEmpty((String)grandchild.getAttributeValue(ATTR_WEB_SUPPORT)) && grandchild.getAttributeValue(ATTR_WEB_SUPPORT).toString().equalsIgnoreCase("true")) {
                    rowMap2.put(ATTR_WEB_SUPPORT, grandchild.getAttributeValue(ATTR_WEB_SUPPORT));
                    rowMap2.put(ATTR_EAS_APP_NAME, grandchild.getAttributeValue(ATTR_EAS_APP_NAME));
                } else if (!StringUtils.isEmpty((String)grandchild.getAttributeValue(ATTR_MODEL))) {
                    rowMap2.put(ATTR_MODEL, grandchild.getAttributeValue(ATTR_MODEL));
                }
                if (rowMap2.isEmpty()) {
                    rowMap.put(ATTR_VIEW_GUI, null);
                } else {
                    rowMap.put(ATTR_VIEW_GUI, rowMap2);
                }
            }
            if (child.getChild(ELEMENT_BILL_WEB) != null) {
                grandchild = child.getChild(ELEMENT_BILL_WEB);
                rowMap2 = new HashMap();
                rowMap2.put(ELEMENT_BILL_WEB, grandchild.getText());
                rowMap2.put(ATTR_PAGE_PARAMS, grandchild.getAttributeValue(ATTR_PAGE_PARAMS));
                rowMap2.put(ATTR_MODEL, grandchild.getAttributeValue(ATTR_MODEL));
                if (rowMap2.isEmpty()) {
                    rowMap.put(ELEMENT_BILL_WEB, null);
                } else {
                    rowMap.put(ELEMENT_BILL_WEB, rowMap2);
                }
            }
            if (child.getChild(ELEMENT_BILL_GUI) != null) {
                grandchild = child.getChild(ELEMENT_BILL_GUI);
                rowMap2 = new HashMap();
                rowMap2.put(ELEMENT_BILL_GUI, grandchild.getText());
                rowMap2.put(ATTR_MODEL, grandchild.getAttributeValue(ATTR_MODEL));
                if (!StringUtils.isEmpty((String)grandchild.getAttributeValue(ATTR_WEB_SUPPORT))) {
                    rowMap2.put(ATTR_WEB_SUPPORT, grandchild.getAttributeValue(ATTR_WEB_SUPPORT));
                    rowMap2.put(ATTR_EAS_APP_NAME, grandchild.getAttributeValue(ATTR_EAS_APP_NAME));
                }
                if (rowMap2.isEmpty()) {
                    rowMap.put(ELEMENT_BILL_GUI, null);
                } else {
                    rowMap.put(ELEMENT_BILL_GUI, rowMap2);
                }
            }
            logger.info((Object)("rowMap:" + rowMap));
            map.put(child.getAttributeValue(ATTR_PREFIX), rowMap);
            ++i;
        }
    }

    public static synchronized MessageViewConfig getInstance(boolean isServerCall) {
        if (instance == null) {
            instance = new MessageViewConfig(isServerCall);
        }
        return instance;
    }

    public Object getConfigByPrefix(String prefix) {
        return map.get(prefix);
    }
}

