/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.IMsgSendRecord;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.client.AbstractHandSendMessageUI;
import com.kingdee.eas.base.message.util.MessageInputUtils;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.util.receiver.ReceiverMessageUtils;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class HandSendMessageUI
extends AbstractHandSendMessageUI {
    private static final long serialVersionUID = 4747425212084440069L;
    private static final Logger logger = CoreUIObject.getLogger(HandSendMessageUI.class);
    private String resName = "com.kingdee.eas.base.message.client.MessageCenter";
    private BasReleaseInfo receiverInfo = null;
    private MessageInputUtils miu = new MessageInputUtils();
    BMCMessageInfo msgInfo = null;
    MsgSendRecordInfo msgSendInfo = null;
    AttachmentClientManager aManager = new AttachmentClientManager();
    private boolean isTransmitMsg = false;
    private boolean isReplyMsg = false;
    private boolean isSendView = false;

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.message.app.HandSendMessageUIHandler");
            if (this.getOprtState() == OprtState.VIEW) {
                String id = this.getUIContext().get("ID").toString();
                request.put("id", (Object)id);
                request.put("view", (Object)Boolean.valueOf("true"));
                request.put("isHst", (Object)((Boolean)this.getUIContext().get("enableHistory")));
            } else {
                request.put("view", (Object)Boolean.valueOf("false"));
                String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                String orgid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
                request.put("userid", (Object)userid);
                request.put("orgid", (Object)orgid);
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIData();
        this.initAttachment();
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
        }
        this.receiversText.setEnabled(true);
        this.receiversText.setEditable(true);
        this.miu.initData(this.receiversText, this.receiverInfo);
    }

    private void initUIData() {
        Locale local;
        LanguageInfo languageInfo;
        Iterator iter;
        List langList;
        this.msgTitle.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.msgContent.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if (this.getOprtState() == OprtState.VIEW) {
            String id = this.getUIContext().get("ID").toString();
            IBMCMessage iBMCMessage = null;
            try {
                boolean isHst = (Boolean)this.getUIContext().get("enableHistory");
                if (isHst) {
                    IBMCMessageHistory iBMCMessageHst = BMCMessageHistoryFactory.getRemoteInstance();
                    BMCMessageHistoryInfo hmsgInfo = iBMCMessageHst.getBMCMessageHistoryInfo((IObjectPK)new ObjectUuidPK(id));
                    this.receiversText.setText(hmsgInfo.getNreceivers());
                    this.priorityComboBox.setSelectedItem((Object)hmsgInfo.getPriority());
                    langList = KDBizMultiLangBox.getLanguageList();
                    iter = langList.iterator();
                    languageInfo = null;
                    local = null;
                    while (iter.hasNext()) {
                        languageInfo = (LanguageInfo)iter.next();
                        local = languageInfo.getLocale();
                        this.msgTitle.setItemData(languageInfo, (Object)hmsgInfo.getTitle(local));
                        this.msgContent.setItemData(languageInfo, (Object)hmsgInfo.getBody(local));
                    }
                    this.msgInfo = new BMCMessageInfo();
                    this.msgInfo.setId(hmsgInfo.getId());
                    if (hmsgInfo.getStatus().equals((Object)MsgStatus.UNREADED)) {
                        hmsgInfo.setStatus(MsgStatus.READED);
                        ObjectUuidPK messagePK = new ObjectUuidPK(hmsgInfo.getId());
                        BMCMessageHistoryFactory.getRemoteInstance().update((IObjectPK)messagePK, hmsgInfo);
                    }
                } else {
                    iBMCMessage = BMCMessageFactory.getRemoteInstance();
                    this.msgInfo = iBMCMessage.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(id));
                    this.receiversText.setText(this.msgInfo.getNreceivers());
                    this.priorityComboBox.setSelectedItem((Object)this.msgInfo.getPriority());
                    List langList2 = KDBizMultiLangBox.getLanguageList();
                    Iterator iter2 = langList2.iterator();
                    LanguageInfo languageInfo2 = null;
                    Locale local2 = null;
                    while (iter2.hasNext()) {
                        languageInfo2 = (LanguageInfo)iter2.next();
                        local2 = languageInfo2.getLocale();
                        this.msgTitle.setItemData(languageInfo2, (Object)this.msgInfo.getTitle(local2));
                        this.msgContent.setItemData(languageInfo2, (Object)this.msgInfo.getBody(local2));
                    }
                    if (this.msgInfo.getStatus().equals((Object)MsgStatus.UNREADED)) {
                        this.msgInfo.setStatus(MsgStatus.READED);
                        ObjectUuidPK messagePK = new ObjectUuidPK(this.msgInfo.getId());
                        ((IBMCMessage)this.getBizInterface()).update((IObjectPK)messagePK, this.msgInfo);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.receiverButton.setEnabled(false);
            this.priorityComboBox.setEnabled(false);
            this.msgTitle.setEditable(false);
            this.msgContent.setEditable(false);
        } else {
            this.msgInfo = new BMCMessageInfo();
            this.msgInfo.setId(BOSUuid.create((BOSObjectType)this.msgInfo.getBOSType()));
        }
        if (this.getOprtState() == OprtState.EDIT) {
            IBMCMessage iBMCMessage;
            String id;
            Object transmitMsg = this.getUIContext().get("ISTRANSMITMSG");
            Object issendView = this.getUIContext().get("ISSENDVIEW");
            Object replyMsg = this.getUIContext().get("ISREPLYMSG");
            if (transmitMsg != null) {
                this.isTransmitMsg = (Boolean)transmitMsg;
            }
            if (issendView != null) {
                this.isSendView = (Boolean)issendView;
            }
            if (replyMsg != null) {
                this.isReplyMsg = (Boolean)replyMsg;
            }
            if (this.isReplyMsg) {
                try {
                    String receiverId;
                    id = this.getUIContext().get("ID").toString();
                    iBMCMessage = BMCMessageFactory.getRemoteInstance();
                    this.msgInfo = iBMCMessage.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(id));
                    this.priorityComboBox.setSelectedItem((Object)this.msgInfo.getPriority());
                    String string = receiverId = this.msgInfo.getSenderId() != null ? this.msgInfo.getSenderId() : "";
                    if (!StringUtils.isEmpty((String)receiverId)) {
                        this.receiverInfo = this.getReceiver(receiverId);
                        this.receiversText.setText(this.msgInfo.getSender());
                    }
                    List langList3 = KDBizMultiLangBox.getLanguageList();
                    Iterator iter3 = langList3.iterator();
                    LanguageInfo languageInfo3 = null;
                    Locale local3 = null;
                    while (iter3.hasNext()) {
                        languageInfo3 = (LanguageInfo)iter3.next();
                        local3 = languageInfo3.getLocale();
                        String title = EASResource.getString((String)this.resName, (String)"reply") + ": " + this.msgInfo.getTitle(local3);
                        this.msgTitle.setItemData(languageInfo3, (Object)title);
                        StringBuffer content = new StringBuffer("\n---------------------").append("---------------------\n").append(EASResource.getString((String)this.resName, (String)"sender")).append(this.msgInfo.getSender()).append("\n").append(EASResource.getString((String)this.resName, (String)"sendTime")).append(this.msgInfo.getReceiveTime()).append("\n").append(EASResource.getString((String)this.resName, (String)"reseiver")).append(this.msgInfo.getNreceivers()).append("\n").append(EASResource.getString((String)this.resName, (String)"title")).append(this.msgInfo.getTitle(local3)).append("\n").append("\n").append(this.msgInfo.getBody(local3));
                        this.msgContent.setItemData(languageInfo3, (Object)content.toString());
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (this.isTransmitMsg) {
                id = this.getUIContext().get("ID").toString();
                try {
                    if (this.isSendView) {
                        IMsgSendRecord iMsgSendRecord = MsgSendRecordFactory.getRemoteInstance();
                        this.msgSendInfo = iMsgSendRecord.getMsgSendRecordInfo((IObjectPK)new ObjectUuidPK(id));
                        this.priorityComboBox.setSelectedItem((Object)this.msgSendInfo.getPriority());
                        langList = KDBizMultiLangBox.getLanguageList();
                        iter = langList.iterator();
                        languageInfo = null;
                        local = null;
                        while (iter.hasNext()) {
                            UserInfo userInfo = null;
                            IUser iUser = UserFactory.getRemoteInstance();
                            BOSUuid senderBOSUuid = this.msgSendInfo.getSenderID();
                            userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(senderBOSUuid.toString()));
                            String senderName = userInfo.getName();
                            languageInfo = (LanguageInfo)iter.next();
                            local = languageInfo.getLocale();
                            String title = EASResource.getString((String)this.resName, (String)"transmit") + ": " + this.msgSendInfo.getTitle(local);
                            this.msgTitle.setItemData(languageInfo, (Object)title);
                            StringBuffer content = new StringBuffer("\n---------------------").append("---------------------\n").append(EASResource.getString((String)this.resName, (String)"sender")).append(senderName).append("\n").append(EASResource.getString((String)this.resName, (String)"sendTime")).append(this.msgSendInfo.getSendTime()).append("\n").append(EASResource.getString((String)this.resName, (String)"reseiver")).append(this.msgSendInfo.getReciever()).append("\n").append(EASResource.getString((String)this.resName, (String)"title")).append(this.msgSendInfo.getTitle(local)).append("\n").append("\n").append(this.msgSendInfo.getBody(local));
                            this.msgContent.setItemData(languageInfo, (Object)content.toString());
                        }
                    } else {
                        iBMCMessage = BMCMessageFactory.getRemoteInstance();
                        this.msgInfo = iBMCMessage.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(id));
                        this.priorityComboBox.setSelectedItem((Object)this.msgInfo.getPriority());
                        langList = KDBizMultiLangBox.getLanguageList();
                        iter = langList.iterator();
                        languageInfo = null;
                        local = null;
                        while (iter.hasNext()) {
                            languageInfo = (LanguageInfo)iter.next();
                            local = languageInfo.getLocale();
                            String title = EASResource.getString((String)this.resName, (String)"transmit") + ": " + this.msgInfo.getTitle(local);
                            this.msgTitle.setItemData(languageInfo, (Object)title);
                            StringBuffer content = new StringBuffer("\n---------------------").append("---------------------\n").append(EASResource.getString((String)this.resName, (String)"sender")).append(this.msgInfo.getSender()).append("\n").append(EASResource.getString((String)this.resName, (String)"sendTime")).append(this.msgInfo.getReceiveTime()).append("\n").append(EASResource.getString((String)this.resName, (String)"reseiver")).append(this.msgInfo.getNreceivers()).append("\n").append(EASResource.getString((String)this.resName, (String)"title")).append(this.msgInfo.getTitle(local)).append("\n").append("\n").append(this.msgInfo.getBody(local));
                            this.msgContent.setItemData(languageInfo, (Object)content.toString());
                        }
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    private void initAttachment() {
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(this.msgInfo.getId().toString());
        if (this.getOprtState() == OprtState.VIEW) {
            info.setEdit(false);
            int attachCount = 0;
            try {
                attachCount = BoAttchAssoFactory.getRemoteInstance().getAttchCountByBoID(this.msgInfo.getId().toString());
            }
            catch (BOSException e1) {
                logger.error((Object)"\u83b7\u5f97\u9644\u4ef6\u6570\u91cf\u62a5\u9519", (Throwable)e1);
            }
            if (attachCount > 0) {
                this.aManager = new AttachmentClientManager();
                try {
                    this.aManager.showAttachInContainter(this.attContainer, info);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                this.confirm.setBounds(new Rectangle(434, 224, 73, 21));
                this.add((Component)this.confirm, new KDLayout.Constraints(434, 224, 73, 21, 0));
                this.cancel.setBounds(new Rectangle(516, 224, 73, 21));
                this.add((Component)this.cancel, new KDLayout.Constraints(516, 224, 73, 21, 0));
                this.kDSeparator2.setBounds(new Rectangle(5, 212, 590, 11));
                this.add((Component)this.kDSeparator2, new KDLayout.Constraints(5, 212, 590, 11, 0));
                this.setPreferredSize(new Dimension(600, 250));
                this.attContainer.setVisible(false);
            }
        } else {
            info.setEdit(true);
            boolean hasAttachPerm = true;
            if (hasAttachPerm) {
                this.aManager = new AttachmentClientManager();
                try {
                    if (this.isTransmitMsg) {
                        String[] attchIDs = BoAttchAssoFactory.getRemoteInstance().getAttchIDsByBoID(this.msgInfo.getId().toString());
                        this.msgInfo.setId(BOSUuid.create((BOSObjectType)this.msgInfo.getBOSType()));
                        info.setBoID(this.msgInfo.getId().toString());
                        if (attchIDs != null) {
                            for (int i = 0; i < attchIDs.length; ++i) {
                                String fileName = this.aManager.downloadAttachment(attchIDs[i]);
                                this.aManager.addNewAttachment(this.msgInfo.getId().toString(), new File(fileName));
                            }
                        }
                    } else if (this.isReplyMsg) {
                        this.msgInfo.setId(BOSUuid.create((BOSObjectType)this.msgInfo.getBOSType()));
                        info.setBoID(this.msgInfo.getId().toString());
                    }
                    this.aManager.showAttachInContainter(this.attContainer, info);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                this.confirm.setBounds(new Rectangle(434, 224, 73, 21));
                this.add((Component)this.confirm, new KDLayout.Constraints(434, 224, 73, 21, 0));
                this.cancel.setBounds(new Rectangle(516, 224, 73, 21));
                this.add((Component)this.cancel, new KDLayout.Constraints(516, 224, 73, 21, 0));
                this.kDSeparator2.setBounds(new Rectangle(5, 212, 590, 11));
                this.add((Component)this.kDSeparator2, new KDLayout.Constraints(5, 212, 590, 11, 0));
                this.setPreferredSize(new Dimension(600, 250));
                this.attContainer.setVisible(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        super.cancel_actionPerformed(e);
        if (this.getOprtState() != OprtState.VIEW) {
            this.aManager.deleteAttachemtsByBoID(this.msgInfo.getId().toString());
        }
        this.getUIWindow().close();
    }

    public boolean isPrepareConfirm() {
        return false;
    }

    public IUIActionPostman prepareConfirm(RequestContext request) {
        if (request == null) {
            request = new RequestContext();
        }
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        String tempUserId = "";
        request.setClassName("com.kingdee.eas.base.message.app.HandSendMessageUIHandler");
        request.setMethodName("handleConfirm");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        request.put("userId", (Object)userId);
        request.put("msgId", (Object)this.msgInfo.getId().toString());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareCancel() {
        return false;
    }

    public IUIActionPostman prepareCancel(RequestContext request) {
        if (request == null) {
            request = new RequestContext();
        }
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        String tempUserId = "";
        request.setClassName("com.kingdee.eas.base.message.app.HandSendMessageUIHandler");
        request.setMethodName("handleCancel");
        request.put("msgId", (Object)this.msgInfo.getId().toString());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    protected void confirm_actionPerformed(ActionEvent e) throws Exception {
        super.confirm_actionPerformed(e);
        if (this.getOprtState() == OprtState.VIEW) {
            this.getUIWindow().close();
        } else {
            if (this.receiverInfo == null || this.receiverInfo.getReceiver().size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"please.select.person"));
                return;
            }
            boolean isAlert = true;
            for (int i = 0; i < this.receiverInfo.getReceiver().size(); ++i) {
                BasReceiverInfo info = this.receiverInfo.getReceiver().get(i);
                if (info.getType().toString().equals("7") || info.getType().toString().equals("6")) continue;
                isAlert = false;
                break;
            }
            if (isAlert) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"please.select.person"));
                return;
            }
            MultiLangItem name = this.msgTitle.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale()));
            if (StringUtils.isEmpty((String)((String)name.getData()))) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"title.requied"));
                return;
            }
            if (this.isLegal((String)name.getData())) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"has.special.char"));
                return;
            }
            MultiLangItem content = this.msgContent.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale()));
            if (StringUtils.isEmpty((String)((String)content.getData()))) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"contentnonull"));
                return;
            }
            int contentLengthLimit = 500;
            try {
                IParamControl iParam = ParamControlFactory.getRemoteInstance();
                String value = iParam.getParamValue(null, "MsgContentLengthLimit");
                contentLengthLimit = Integer.parseInt(value);
            }
            catch (Exception e1) {
                logger.error((Object)("\u53d6\u5f97\u6d88\u606f\u5185\u5bb9\u5b57\u7b26\u6570\u9650\u5236\u53c2\u6570MsgContentLengthLimit\u9519\u8bef\uff1a" + e1.getMessage()));
            }
            int contentLength = content.getData().toString().length();
            if (contentLength > contentLengthLimit) {
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)this.resName, (String)"contentLengthExceedLimit"), contentLengthLimit));
                return;
            }
            try {
                this.setMsgInfo();
                this.saveMsg();
            }
            catch (Exception ex) {
                this.aManager.deleteAttachemtsByBoID(this.msgInfo.getId().toString());
                this.handUIException(ex);
            }
            this.getUIWindow().close();
        }
    }

    @Override
    protected void receiverButton_actionPerformed(ActionEvent e) throws Exception {
        this.miu.showReceiverUI((Object)this);
        BasReceiverCollection receivers = this.receiverInfo.getReceiver();
        IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
        HashSet<String> msg = new HashSet<String>();
        for (int i = 0; i < receivers.size(); ++i) {
            Person[] persons;
            BasReceiverInfo info = receivers.get(i);
            if (!"8".equals(info.getType()) || (persons = svc.getPersonByPersonID(info.getValue())) != null && persons.length >= 1) continue;
            msg.add(info.getDesc());
        }
        if (msg.size() > 0) {
            if (new Locale("L1").equals(this.getLocale())) {
                MsgBox.showWarning((String)(msg + " has no accounts!"));
            } else {
                MsgBox.showWarning((String)(msg + " \u6ca1\u6709\u7528\u6237\u5e10\u53f7\u6216\u5e10\u53f7\u5f02\u5e38\uff0c\u53ef\u80fd\u65e0\u6cd5\u63a5\u6536\u5230\u6d88\u606f\uff01"));
            }
        }
    }

    private void setMsgInfo() {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        Locale local = null;
        String nameData = null;
        String contentData = null;
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getRemoteInstance();
            userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u5f97\u7528\u6237\u4fe1\u606f\u62a5\u9519");
        }
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            local = languageInfo.getLocale();
            MultiLangItem name = this.msgTitle.getItemBy(languageInfo);
            nameData = (String)name.getData();
            this.msgInfo.setTitle(nameData, local);
            MultiLangItem nameContent = this.msgContent.getItemBy(languageInfo);
            contentData = (String)nameContent.getData();
            this.msgInfo.setBody(contentData, local);
            if (userInfo == null) continue;
            this.msgInfo.setSender(userInfo.getName(local), local);
        }
        this.msgInfo.setPriority((MsgPriority)((Object)this.priorityComboBox.getSelectedItem()));
        this.msgInfo.setNreceivers(this.receiversText.getText());
        this.msgInfo.setType(MsgType.ONLINE);
        this.msgInfo.setStatus(MsgStatus.UNREADED);
    }

    private void saveMsg() throws Exception {
        LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
                iBMCMessage.addHandMsg(HandSendMessageUI.this.msgInfo, (IObjectCollection)HandSendMessageUI.this.receiverInfo.getReceiver());
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)HandSendMessageUI.this), (String)EASResource.getString((String)HandSendMessageUI.this.resName, (String)"send_success"));
            }
        });
        dialog.show();
    }

    private void readMessage() {
        try {
            boolean isHst = (Boolean)this.getUIContext().get("enableHistory");
            if (this.msgInfo.getStatus().equals((Object)MsgStatus.UNREADED)) {
                this.msgInfo.setStatus(MsgStatus.READED);
                ObjectUuidPK messagePK = new ObjectUuidPK(this.msgInfo.getId());
                if (!isHst) {
                    ((IBMCMessage)this.getBizInterface()).update((IObjectPK)messagePK, this.msgInfo);
                } else {
                    BMCMessageHistoryFactory.getRemoteInstance().update((IObjectPK)messagePK, this.msgInfo);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"getMessageFail"), (Throwable)e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BMCMessageFactory.getRemoteInstance();
    }

    private boolean isLegal(String str) {
        String regor = "^.*[|~|<|>|'|\\\\|].*$";
        Pattern p = Pattern.compile(regor);
        Matcher m = p.matcher(str);
        boolean result = m.find();
        return result;
    }

    private BasReleaseInfo getReceiver(String receiver) throws EASBizException, BOSException, UuidException {
        BasReceiverCollection receivers = new BasReceiverCollection();
        ReceiverMessageUtils mu = new ReceiverMessageUtils();
        BasReleaseInfo brInfo = new BasReleaseInfo();
        if (!StringUtils.isEmpty((String)receiver)) {
            String[] args = receiver.split(",");
            int length = args.length;
            IPerson iPerson = PersonFactory.getRemoteInstance();
            IUser iUser = UserFactory.getRemoteInstance();
            for (int i = 0; i < length; ++i) {
                BasReceiverInfo info = null;
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)args[i]));
                try {
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)pk);
                    info = mu.getRptReceiverInfo((Object)personInfo);
                }
                catch (Exception e) {
                    try {
                        UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
                        info = mu.getRptReceiverInfo((Object)userInfo);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                brInfo.getReceiver().add(info);
            }
        }
        return brInfo;
    }
}

