/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.MessageClassTreeInfo;
import com.kingdee.eas.base.message.client.AbstractMessageClassSetUI;
import com.kingdee.eas.base.message.util.MessageUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MessageClassSetUI
extends AbstractMessageClassSetUI {
    private static MetaDataPK noticeQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
    private static final MetaDataPK undisposeTaskQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "WFAssignQuery");
    private static final MetaDataPK disposedTaskQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "AssignDetailQuery");
    private static final Logger logger = CoreUIObject.getLogger(MessageClassSetUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.message.client.MessageCenter";
    private String[][] msgClassName = null;
    private boolean isShare = false;
    private boolean isCuFilter = false;
    private int msgType = 1;
    private String classFilter = "";

    public MessageClassSetUI() throws Exception {
        if (MessageUtil.isFD(null)) {
            noticeQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "FdMsgQuery");
            this.rdbUndisposedTask.setText("\u5f85\u529e\u5de5\u4f5c");
            this.rdbDisposedTask.setText("\u529e\u6bd5\u5de5\u4f5c");
        }
    }

    public void onLoad() throws Exception {
        MessageClassTreeInfo info;
        super.onLoad();
        if (!SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            this.rdbAllUser.setEnabled(false);
            this.ifCuFilter.setEnabled(false);
        }
        if ((info = (MessageClassTreeInfo)this.getUIContext().get("MessageClassTreeInfo")) != null) {
            List langList = KDBizMultiLangBox.getLanguageList();
            Iterator iter = langList.iterator();
            LanguageInfo languageInfo = null;
            Locale local = null;
            while (iter.hasNext()) {
                languageInfo = (LanguageInfo)iter.next();
                local = languageInfo.getLocale();
                this.msgClassNameTxt.setItemData(languageInfo, (Object)info.getName(local));
            }
            this.isShare = info.isShare();
            this.isCuFilter = info.isCuFilter();
            this.ifCuFilter.setSelected(info.isCuFilter());
            this.rdbAllUser.setSelected(info.isShare());
            this.rdbCurrentUser.setSelected(!info.isShare());
            this.msgType = info.getMsgType();
            if (info.getMsgType() == 1) {
                this.rdbUndisposedTask.setSelected(true);
            } else if (info.getMsgType() == 2) {
                this.rdbDisposedTask.setSelected(true);
            } else if (info.getMsgType() == 3) {
                this.rdbNotice.setSelected(true);
            }
            this.classFilter = info.getFilter();
        }
        this.msgClassNameTxt.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if (this.rdbCurrentUser.isSelected()) {
            this.ifCuFilter.setEnabled(false);
            this.ifCuFilter.setSelected(false);
        }
        if (this.rdbAllUser.isSelected()) {
            this.ifCuFilter.setEnabled(true);
        }
        if (this.oprtState == OprtState.EDIT) {
            this.rdbUndisposedTask.setEnabled(false);
            this.rdbDisposedTask.setEnabled(false);
            this.rdbNotice.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btConfirm_actionPerformed(ActionEvent e) throws Exception {
        MultiLangItem name = this.msgClassNameTxt.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if (StringUtils.isEmpty((String)((String)name.getData()))) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.input.class.name"));
            return;
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        this.msgClassName = new String[langList.size()][2];
        int i = 0;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            this.msgClassName[i][0] = languageInfo.getLocale().toString();
            this.msgClassName[i][1] = (String)this.msgClassNameTxt.getItemDataByLang(languageInfo);
            ++i;
        }
        for (int j = 0; j < this.msgClassName.length; ++j) {
            if (this.msgClassName[j][1] == null || this.msgClassName[j][1].indexOf(")") <= -1 && this.msgClassName[j][1].indexOf("(") <= -1) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"msg.class.canot.include.char"));
            return;
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btCancel_actionPerformed(ActionEvent e) throws Exception {
        this.msgClassName = null;
        this.getUIWindow().close();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    protected void ifCuFilter_actionPerformed(ActionEvent e) throws Exception {
        super.ifCuFilter_actionPerformed(e);
    }

    @Override
    protected void rdbAllUser_actionPerformed(ActionEvent e) throws Exception {
        super.rdbAllUser_actionPerformed(e);
        if (this.rdbAllUser.isSelected()) {
            this.ifCuFilter.setEnabled(true);
        }
    }

    @Override
    protected void rdbCurrentUser_actionPerformed(ActionEvent e) throws Exception {
        super.rdbCurrentUser_actionPerformed(e);
        if (this.rdbCurrentUser.isSelected()) {
            this.ifCuFilter.setEnabled(false);
            this.ifCuFilter.setSelected(false);
        }
    }

    @Override
    protected void rdbDisposedTask_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdbDisposedTask.isSelected()) {
            this.msgType = 2;
        }
    }

    @Override
    protected void rdbNotice_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdbNotice.isSelected()) {
            this.msgType = 3;
        }
    }

    @Override
    protected void rdbUndisposedTask_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdbUndisposedTask.isSelected()) {
            this.msgType = 1;
        }
    }

    public String[][] getMsgClassName() {
        return this.msgClassName;
    }

    public boolean isShare() {
        return !this.rdbCurrentUser.isSelected();
    }

    public boolean isCuFilter() {
        return this.ifCuFilter.isSelected();
    }

    public int getMsgType() {
        return this.msgType;
    }

    @Override
    protected void btnSetFilter_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo result;
        super.btnSetFilter_actionPerformed(e);
        CommonQueryDialog classSetdlg = new CommonQueryDialog();
        classSetdlg.setOwner((Component)((Object)this));
        classSetdlg.setShowSorter(false);
        classSetdlg.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        if (this.msgType == 1) {
            classSetdlg.setQueryObjectPK((IMetaDataPK)undisposeTaskQueryPK);
        } else if (this.msgType == 2) {
            classSetdlg.setQueryObjectPK((IMetaDataPK)disposedTaskQueryPK);
        } else {
            classSetdlg.setQueryObjectPK((IMetaDataPK)noticeQueryPK);
        }
        classSetdlg.setTitle(EASResource.getString((String)RESOURCE, (String)"queryDialogTitle"));
        classSetdlg.setShowToolbar(false);
        this.classFilter = this.transFilterStr(this.classFilter);
        if (!StringUtils.isEmpty((String)this.classFilter)) {
            classSetdlg.setEntityViewInfo(new EntityViewInfo(" WHERE " + this.classFilter));
        }
        if (classSetdlg.show() && (result = classSetdlg.getEntityViewInfoResult()) != null) {
            this.classFilter = result.getFilter().toString();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String transFilterStr(String classFilter) {
        if (classFilter == null) {
            return "";
        }
        int timeIndex = classFilter.indexOf("receiveTime");
        if (timeIndex != -1) {
            String timeStr2;
            String timeHead2;
            String head = classFilter.substring(0, timeIndex);
            String tempStr = classFilter.substring(timeIndex);
            int subIndex = tempStr.indexOf("OR");
            if (subIndex == -1) {
                subIndex = tempStr.indexOf("AND");
            }
            if (subIndex == -1) {
                subIndex = tempStr.indexOf(")");
            } else if (tempStr.indexOf(")") != -1 && tempStr.indexOf(")") < subIndex) {
                subIndex = tempStr.indexOf(")");
            }
            if (subIndex != -1) {
                String timeStr = tempStr.substring(0, subIndex);
                String endStr = tempStr.substring(subIndex);
                if (timeStr.indexOf("TS") == -1) {
                    String timeHead = "";
                    if (timeStr.indexOf("NULL") < 0 && timeStr.indexOf("'") != -1) {
                        timeHead = timeStr.substring(0, timeStr.indexOf("'"));
                        timeStr = timeStr.substring(timeStr.indexOf("'"));
                        timeStr = "{TS " + timeStr + "} ";
                    }
                    if (endStr.indexOf("receiveTime") > 0) {
                        endStr = this.transFilterStr(endStr);
                    }
                    classFilter = head + timeHead + timeStr + endStr;
                }
            } else if (tempStr.indexOf("'") != -1 && (timeHead2 = (timeStr2 = tempStr).substring(0, timeStr2.indexOf("'"))).indexOf("TS") == -1) {
                timeStr2 = timeStr2.substring(timeStr2.indexOf("'"));
                timeStr2 = "{TS " + timeStr2 + "} ";
                classFilter = head + timeHead2 + timeStr2;
            }
        }
        return classFilter;
    }

    public String getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(String classFilter) {
        this.classFilter = classFilter;
    }
}

