/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.MsgPlayAwokeSound;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MsgAwokeManager {
    private KDDialog msgPopDialog = null;
    private JLabel msgLabel = new JLabel();
    protected javax.swing.Timer centerTimer;
    private ActionListener actionRefresh;
    private static MsgAwokeManager msgAwokeManager;
    private int unreadTaskCount = 0;
    private int unreadAwokeNoticeCount = 0;
    private int unreadMessageCount = 0;
    private int unDisposeTaskCount = 0;
    private int unReadOnlineNoticeCount = 0;
    private int total = 0;
    private int oldUnreadMessageCount = 0;
    private int oldUndisposeTaskCount = 0;
    private boolean hasUnreadTask = false;
    private int oldUnreadTaskCount = 0;
    private int oldUnReadOnlineNoticeCount = 0;
    private static final String RESOURCE = "com.kingdee.eas.base.message.MessageCenter";
    private boolean isMsgAwoke = false;
    boolean isSoundAwake = false;

    private MsgAwokeManager() {
    }

    public static MsgAwokeManager getInstance() {
        if (msgAwokeManager == null) {
            msgAwokeManager = new MsgAwokeManager();
        }
        return msgAwokeManager;
    }

    private void initMsgOptionInfo() {
        try {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String sql = "select FisSoundAwake from T_BAS_MessageOption where FUserId = '" + userID + "'";
            SQLExecutor sqlExecutor = new SQLExecutor(sql);
            IRowSet rowset = sqlExecutor.executeSQL();
            if (rowset == null || rowset.size() == 0) {
                userID = "00000000-0000-0000-0000-00000000000013B7DE7F";
                sql = "select FisSoundAwake from T_BAS_MessageOption where FUserId = '" + userID + "'";
                sqlExecutor = new SQLExecutor(sql);
                rowset = sqlExecutor.executeSQL();
            }
            while (rowset.next()) {
                String fisSoundAwake = rowset.getString("FisSoundAwake");
                if (!"1".equals(fisSoundAwake)) continue;
                this.isSoundAwake = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void init() {
        this.isMsgAwoke = (Boolean)UIFrameContext.getInstance().getProperty((Object)"msgawoke");
        if (this.isMsgAwoke) {
            this.initMsgOptionInfo();
            this.initMsgPopDialog();
            this.actionRefresh = new actionRefresh();
            this.initTimer();
        }
        this.checkAwokeMsg();
    }

    public void stop() {
        if (this.centerTimer != null) {
            if (this.msgPopDialog != null) {
                this.msgPopDialog.setVisible(false);
                this.msgPopDialog.dispose();
            }
            this.centerTimer.stop();
            this.centerTimer = null;
        }
        msgAwokeManager = null;
    }

    private void initTimer() {
        int DEFAULT_REFRESH_MINUTE = 10;
        Object refreshTime = UIFrameContext.getInstance().getProperty((Object)"MsgRefreshInfo");
        int msgRefreshTime = 10;
        if (refreshTime != null) {
            msgRefreshTime = (Integer)refreshTime;
        }
        int time = msgRefreshTime * 60 * 1000;
        this.centerTimer = new javax.swing.Timer(time, this.actionRefresh);
        this.centerTimer.setInitialDelay(time);
        this.centerTimer.start();
    }

    public void dealWithMsgCount(int unreadTask, int unreadMessage, int unDisposeTask, int unReadOnlineNotice) {
        this.oldUnreadTaskCount = this.unreadTaskCount;
        this.oldUnreadMessageCount = this.unreadMessageCount;
        this.oldUndisposeTaskCount = this.unDisposeTaskCount;
        this.oldUnReadOnlineNoticeCount = this.unReadOnlineNoticeCount;
        this.unreadTaskCount = unreadTask;
        this.unreadMessageCount = unreadMessage;
        this.unDisposeTaskCount = unDisposeTask;
        this.unReadOnlineNoticeCount = unReadOnlineNotice;
        this.notifyOtherSystem();
    }

    private void dealWithAwokeMsgCount(int awokeMsgCount) {
        this.unreadAwokeNoticeCount = awokeMsgCount;
        this.total = this.unDisposeTaskCount + this.unReadOnlineNoticeCount + this.unreadAwokeNoticeCount;
        this.msgLabel.setText(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"nowYouHaveUnreadMessage"), String.valueOf(this.total)));
    }

    private void checkAwokeMsg() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                int[] re = null;
                try {
                    IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
                    if (messageCenter != null) {
                        re = messageCenter.getNewMessageCenterCounts(messageCenter.isOrg(), false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return re;
            }

            public void finished() {
                int[] counts = (int[])this.getValue();
                if (MsgAwokeManager.this.isMsgAwoke) {
                    if (counts == null) {
                        MsgAwokeManager.this.total = 0;
                    } else {
                        MsgAwokeManager.this.dealWithMsgCount(counts[0], counts[1] + counts[3], counts[2], counts[3]);
                        MsgAwokeManager.this.dealWithAwokeMsgCount(counts[4]);
                    }
                    if (MsgAwokeManager.this.total > 0) {
                        NewMainFrame mainFram = (NewMainFrame)SystemEntry.instance.getCurrenContainer();
                        if (mainFram != null) {
                            mainFram.setFocusCycleRoot(true);
                        }
                        MsgAwokeManager.this.msgPopDialog.setVisible(true);
                        MsgAwokeManager.this.msgPopDialog.show();
                        if (MsgAwokeManager.this.isSoundAwake) {
                            MsgPlayAwokeSound.soundAwoke();
                        }
                        DelayDoTask delayDoTask = new DelayDoTask();
                        Timer myTimer = new Timer();
                        myTimer.schedule((TimerTask)delayDoTask, 15000L);
                    } else {
                        MsgAwokeManager.this.msgPopDialog.setVisible(false);
                    }
                } else if (counts != null) {
                    MsgAwokeManager.this.dealWithMsgCount(counts[0], counts[1] + counts[3], counts[2], counts[3]);
                }
            }
        };
        worker.start();
    }

    private void notifyOtherSystem() {
        if (this.unreadMessageCount != this.oldUnreadMessageCount) {
            MainFrameCallBack.firePropertyChange((String)"MCNewMessage", (Object)"old", (Object)"new");
        }
        if (this.unDisposeTaskCount != this.oldUndisposeTaskCount) {
            MainFrameCallBack.firePropertyChange((String)"MCNewTask", (Object)"old", (Object)"new");
        }
        if (this.unreadMessageCount == 0 && this.unreadTaskCount == 0) {
            if (this.hasUnreadTask) {
                MainFrameCallBack.firePropertyChange((String)"MCUnReadTask", (Object)"old", (Object)Boolean.FALSE);
                this.hasUnreadTask = false;
            }
        } else if (!(this.unreadMessageCount <= this.oldUnreadMessageCount && this.unreadTaskCount <= this.oldUnreadTaskCount || this.hasUnreadTask)) {
            MainFrameCallBack.firePropertyChange((String)"MCUnReadTask", (Object)"old", (Object)Boolean.TRUE);
            this.hasUnreadTask = true;
        }
        if (this.unReadOnlineNoticeCount != this.oldUnReadOnlineNoticeCount) {
            MainFrameCallBack.firePropertyChange((String)"MCNewMessage", (Object)"old", (Object)"new");
        }
    }

    private void initMsgPopDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.msgPopDialog = new KDDialog();
        this.msgPopDialog.setModal(false);
        this.msgPopDialog.setAlwaysOnTop(true);
        this.msgPopDialog.setFocusableWindowState(false);
        this.msgPopDialog.setSize(new Dimension(180, 80));
        this.msgPopDialog.setUndecorated(true);
        this.msgPopDialog.setLocation(screenSize.width - 190, screenSize.height - 150);
        this.msgLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IUIObject[] arrayUI;
                NewMainFrame mainFram = (NewMainFrame)SystemEntry.instance.getCurrenContainer();
                if (mainFram != null) {
                    mainFram.setExtendedState(6);
                    mainFram.show();
                }
                if ((arrayUI = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName())) != null && arrayUI.length > 0) {
                    MessageCenterUI messageCenterUI = (MessageCenterUI)arrayUI[0];
                    messageCenterUI.queryUnreadTasks();
                    messageCenterUI.getUIWindow().show();
                } else {
                    UIFrameUtil.setCurTabToMessageCenter();
                }
                MsgAwokeManager.this.msgPopDialog.setVisible(false);
            }
        });
        this.msgPopDialog.getContentPane().add(this.getMsgPanel());
        this.msgPopDialog.setVisible(false);
    }

    private JPanel getMsgPanel() {
        JPanel pnlInfo = new JPanel();
        pnlInfo.setBorder(BorderFactory.createLineBorder(Color.decode("#4279AD")));
        pnlInfo.setPreferredSize(new Dimension(180, 80));
        pnlInfo.setBackground(UIManager.getColor("eas.infopane.border"));
        pnlInfo.setFocusable(false);
        pnlInfo.setLayout(new FlowLayout(1, 0, 0));
        KDPanel pnlTitle = new KDPanel();
        pnlTitle.setLayout(null);
        pnlTitle.setPreferredSize(new Dimension(178, 21));
        JLabel lblDCTitle = new JLabel(" " + SysContext.getSysContext().getUserName());
        lblDCTitle.setBounds(0, 0, 150, 21);
        pnlTitle.add(lblDCTitle);
        KDWorkButton btnClose = new KDWorkButton();
        btnClose.setRolloverEnabled(true);
        btnClose.setFocusable(false);
        Icon iconClose = MsgAwokeManager.getIcon("imgState_iconclose_1");
        btnClose.setIcon(iconClose);
        btnClose.setRolloverIcon(MsgAwokeManager.getIcon("imgState_iconclose_2"));
        btnClose.setPressedIcon(MsgAwokeManager.getIcon("imgState_iconclose_3"));
        btnClose.setBounds(160, 2, 18, 17);
        btnClose.setOpaque(false);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgAwokeManager.this.msgPopDialog.setVisible(false);
            }
        });
        pnlTitle.add((Component)btnClose);
        pnlTitle.setBackground(UIManager.getColor("eas.infopanel.title.bg"));
        KDPanel pnlText = new KDPanel();
        pnlText.setPreferredSize(new Dimension(178, 57));
        pnlText.setBackground(UIManager.getColor("eas.infopanel.content.bg"));
        pnlInfo.setLayout(new FlowLayout(1, 0, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(8, 8, 0, 0);
        pnlText.add((Component)this.msgLabel, constraints);
        pnlInfo.add((Component)pnlTitle);
        pnlInfo.add((Component)pnlText);
        return pnlInfo;
    }

    private static Icon getIcon(String strKey) {
        return UIFrameResource.getCommonIcon((String)strKey);
    }

    private class DelayDoTask
    extends TimerTask {
        private DelayDoTask() {
        }

        @Override
        public void run() {
            MsgAwokeManager.this.msgPopDialog.setVisible(false);
        }
    }

    private class actionRefresh
    implements ActionListener {
        private actionRefresh() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MsgAwokeManager.this.checkAwokeMsg();
        }
    }
}

