/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.log4j.Logger;

public class MsgPlayAwokeSound {
    private static final Logger logger = Logger.getLogger(MsgPlayAwokeSound.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void soundAwoke() {
        InputStream wavInputStream = null;
        try {
            SourceDataLine line;
            wavInputStream = MsgPlayAwokeSound.class.getResourceAsStream("msgAvoke.wav");
            if (wavInputStream == null) {
                logger.info((Object)"-the sound file error-!");
                return;
            }
            AudioInputStream audioStream = null;
            try {
                audioStream = AudioSystem.getAudioInputStream(wavInputStream);
            }
            catch (UnsupportedAudioFileException e1) {
                logger.error((Object)("--UnsupportedAudioFileException--" + e1));
            }
            catch (IOException e1) {
                logger.error((Object)("--IOException--" + e1));
            }
            if (audioStream == null) {
                return;
            }
            AudioFormat format = audioStream.getFormat();
            int length = (int)(audioStream.getFrameLength() * (long)format.getFrameSize());
            byte[] samples = new byte[length];
            DataInputStream is = new DataInputStream(audioStream);
            try {
                is.readFully(samples);
            }
            catch (IOException e) {
                logger.error((Object)("--IOException--" + e));
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(samples);
            int bufferSize = format.getFrameSize() * Math.round(format.getSampleRate() / 10.0f);
            byte[] buffer = new byte[bufferSize];
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format, bufferSize);
            }
            catch (LineUnavailableException ex) {
                logger.error((Object)("--LineUnavailableException--" + ex));
                if (wavInputStream != null) {
                    try {
                        wavInputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return;
            }
            line.start();
            try {
                int numBytesRead = 0;
                while (numBytesRead != -1) {
                    numBytesRead = ((InputStream)stream).read(buffer, 0, buffer.length);
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException ex) {
                logger.error((Object)("--IOException--" + ex));
            }
            line.drain();
            line.close();
        }
        finally {
            if (wavInputStream != null) {
                try {
                    wavInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

